/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.groovy.actions;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionDispatcher;
import org.apache.unomi.groovy.actions.services.GroovyActionsService;
import org.apache.unomi.metrics.MetricAdapter;
import org.apache.unomi.metrics.MetricsService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ActionDispatcher.class})
public class GroovyActionDispatcher
implements ActionDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GroovyActionDispatcher.class.getName());
    private static final String GROOVY_PREFIX = "groovy";
    private MetricsService metricsService;
    private GroovyActionsService groovyActionsService;

    @Reference
    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    @Reference
    public void setGroovyActionsService(GroovyActionsService groovyActionsService) {
        this.groovyActionsService = groovyActionsService;
    }

    public String getPrefix() {
        return GROOVY_PREFIX;
    }

    public Integer execute(Action action, Event event, String actionName) {
        GroovyCodeSource groovyCodeSource = this.groovyActionsService.getGroovyCodeSource(actionName);
        if (groovyCodeSource == null) {
            LOGGER.warn("Couldn't find a Groovy action with name {}, action will not execute !", (Object)actionName);
        } else {
            GroovyShell groovyShell = this.groovyActionsService.getGroovyShell();
            groovyShell.setVariable("action", (Object)action);
            groovyShell.setVariable("event", (Object)event);
            final Script script = groovyShell.parse(groovyCodeSource);
            try {
                return (Integer)new MetricAdapter<Integer>(this.metricsService, this.getClass().getName() + ".action.groovy." + actionName){

                    public Integer execute(Object ... args) throws Exception {
                        return (Integer)script.invokeMethod("execute", null);
                    }
                }.runWithTimer(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error executing Groovy action with key={}", (Object)actionName, (Object)e);
            }
        }
        return 0;
    }
}

