/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.command;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.Result;
import org.apache.karaf.cellar.core.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command<R extends Result>
extends Event {
    protected static final transient Logger LOGGER = LoggerFactory.getLogger(Command.class);
    protected static final long DEFAULT_TIMEOUT = 30000L;
    protected long timeout;
    protected final BlockingQueue<Map<Node, R>> resultQueue = new LinkedBlockingQueue<Map<Node, R>>();
    protected final Map<Node, R> nodeResults = new HashMap<Node, R>();

    public Command(String id) {
        super(id);
        this.force = true;
        if (System.getProperty("cellar.timeout") != null) {
            try {
                this.timeout = Long.parseLong(System.getProperty("cellar.timeout"));
            }
            catch (Exception e) {
                this.timeout = 30000L;
            }
        } else {
            this.timeout = 30000L;
        }
    }

    @Override
    public Boolean getForce() {
        return true;
    }

    public void onTimeout() {
        try {
            this.resultQueue.put(this.nodeResults);
        }
        catch (InterruptedException e) {
            LOGGER.error("Error adding result to result queue", (Throwable)e);
        }
    }

    public void addResults(R ... results) {
        if (results != null && results.length > 0) {
            for (R result : results) {
                this.nodeResults.put(((Event)result).getSourceNode(), result);
            }
            if (this.getDestination() == null || this.nodeResults.size() == this.getDestination().size()) {
                try {
                    this.resultQueue.put(this.nodeResults);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Error adding result to result queue", (Throwable)e);
                }
            }
        }
    }

    public Map<Node, R> getResult() throws InterruptedException {
        Map<Node, R> nodeResults = null;
        if (this.resultQueue != null) {
            nodeResults = this.resultQueue.poll(this.timeout, TimeUnit.MILLISECONDS);
        }
        return nodeResults;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

