/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.nio.charset.Charset;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IUrlRenderer;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class UrlResourceReference
extends ResourceReference {
    private final Url url;
    private boolean contextRelative = false;

    public UrlResourceReference(Url url) {
        super(UrlResourceReference.asName(url));
        this.url = url;
    }

    private static String asName(Url externalUrl) {
        Args.notNull((Object)externalUrl, (String)"url");
        return externalUrl.toString();
    }

    public final Url getUrl() {
        CalculatedUrl _url;
        if (this.contextRelative) {
            String contextRelative = UrlUtils.rewriteToContextRelative((String)this.url.toString(), (IRequestCycle)RequestCycle.get());
            _url = new CalculatedUrl(Url.parse((CharSequence)contextRelative, (Charset)this.url.getCharset()));
        } else {
            _url = new CalculatedUrl(this.url);
        }
        return _url;
    }

    @Override
    public final IResource getResource() {
        return null;
    }

    public UrlResourceReference setContextRelative(boolean contextRelative) {
        if (contextRelative && (this.url.isFull() || this.url.isContextAbsolute())) {
            throw new IllegalStateException(String.format("An absolute url '%s' cannot be rendered as context relative", this.url));
        }
        this.contextRelative = contextRelative;
        return this;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    @Override
    public String toString() {
        return "UrlResourceReference{url=" + this.url.toString(UrlResourceReference.getStringMode(this.url)) + ", contextRelative=" + this.contextRelative + '}';
    }

    private static Url.StringMode getStringMode(Url url) {
        Url.StringMode mode = url.isFull() ? Url.StringMode.FULL : Url.StringMode.LOCAL;
        return mode;
    }

    private static class CalculatedUrl
    extends Url
    implements IUrlRenderer {
        private CalculatedUrl(Url original) {
            super(original);
        }

        public String renderFullUrl(Url url, Url baseUrl) {
            Url.StringMode mode = UrlResourceReference.getStringMode(url);
            return url.toString(mode);
        }

        public String renderRelativeUrl(Url url, Url baseUrl) {
            return url.toString();
        }
    }
}

