/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.axiom.c14n.impl.NameSpaceSymbEntry;
import org.apache.axiom.c14n.impl.SymbMap;
import org.apache.axiom.c14n.omwrapper.interfaces.Attr;
import org.apache.axiom.c14n.omwrapper.interfaces.Node;

public class NameSpaceSymbTable {
    SymbMap symb;
    int nameSpaces = 0;
    List level = new ArrayList(10);
    boolean cloned = true;
    static final String XMLNS = "xmlns";
    static final SymbMap initialMap = new SymbMap();

    public NameSpaceSymbTable() {
        this.symb = (SymbMap)initialMap.clone();
    }

    public void getUnrenderedNodes(Collection result) {
        for (NameSpaceSymbEntry n : this.symb.entrySet()) {
            if (n.rendered || n.n == null) continue;
            n = (NameSpaceSymbEntry)n.clone();
            this.needsClone();
            this.symb.put(n.prefix, n);
            n.lastrendered = n.uri;
            n.rendered = true;
            result.add(n.n);
        }
    }

    public void outputNodePush() {
        ++this.nameSpaces;
        this.push();
    }

    public void outputNodePop() {
        --this.nameSpaces;
        this.pop();
    }

    public void push() {
        this.level.add(null);
        this.cloned = false;
    }

    public void pop() {
        int size = this.level.size() - 1;
        Object ob = this.level.remove(size);
        if (ob != null) {
            this.symb = (SymbMap)ob;
            this.cloned = size == 0 ? false : this.level.get(size - 1) != this.symb;
        } else {
            this.cloned = false;
        }
    }

    final void needsClone() {
        if (!this.cloned) {
            this.level.set(this.level.size() - 1, this.symb);
            this.symb = (SymbMap)this.symb.clone();
            this.cloned = true;
        }
    }

    public Attr getMapping(String prefix) {
        NameSpaceSymbEntry entry = this.symb.get(prefix);
        if (entry == null) {
            return null;
        }
        if (entry.rendered) {
            return null;
        }
        entry = (NameSpaceSymbEntry)entry.clone();
        this.needsClone();
        this.symb.put(prefix, entry);
        entry.rendered = true;
        entry.level = this.nameSpaces;
        entry.lastrendered = entry.uri;
        return entry.n;
    }

    public Attr getMappingWithoutRendered(String prefix) {
        NameSpaceSymbEntry entry = this.symb.get(prefix);
        if (entry == null) {
            return null;
        }
        if (entry.rendered) {
            return null;
        }
        return entry.n;
    }

    public boolean addMapping(String prefix, String uri, Attr n) {
        NameSpaceSymbEntry ob = this.symb.get(prefix);
        if (ob != null && uri.equals(ob.uri)) {
            return false;
        }
        NameSpaceSymbEntry ne = new NameSpaceSymbEntry(uri, n, false, prefix);
        this.needsClone();
        this.symb.put(prefix, ne);
        if (ob != null) {
            ne.lastrendered = ob.lastrendered;
            if (ob.lastrendered != null && ob.lastrendered.equals(uri)) {
                ne.rendered = true;
            }
        }
        return true;
    }

    public Node addMappingAndRender(String prefix, String uri, Attr n) {
        NameSpaceSymbEntry ob = this.symb.get(prefix);
        if (ob != null && uri.equals(ob.uri)) {
            if (!ob.rendered) {
                ob = (NameSpaceSymbEntry)ob.clone();
                this.needsClone();
                this.symb.put(prefix, ob);
                ob.lastrendered = uri;
                ob.rendered = true;
                return ob.n;
            }
            return null;
        }
        NameSpaceSymbEntry ne = new NameSpaceSymbEntry(uri, n, true, prefix);
        ne.lastrendered = uri;
        this.needsClone();
        this.symb.put(prefix, ne);
        if (ob != null && ob.lastrendered != null && ob.lastrendered.equals(uri)) {
            ne.rendered = true;
            return null;
        }
        return ne.n;
    }

    public int getLevel() {
        return this.level.size();
    }

    public void removeMapping(String prefix) {
        NameSpaceSymbEntry ob = this.symb.get(prefix);
        if (ob != null) {
            this.needsClone();
            this.symb.put(prefix, null);
        }
    }

    public void removeMappingIfNotRender(String prefix) {
        NameSpaceSymbEntry ob = this.symb.get(prefix);
        if (ob != null && !ob.rendered) {
            this.needsClone();
            this.symb.put(prefix, null);
        }
    }

    public boolean removeMappingIfRender(String prefix) {
        NameSpaceSymbEntry ob = this.symb.get(prefix);
        if (ob != null && ob.rendered) {
            this.needsClone();
            this.symb.put(prefix, null);
        }
        return false;
    }

    static {
        NameSpaceSymbEntry ne = new NameSpaceSymbEntry("", null, true, XMLNS);
        ne.lastrendered = "";
        initialMap.put(XMLNS, ne);
    }
}

