/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom;

import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.util.xml.XMLChar;
import org.w3c.dom.DOMException;

public final class NSUtil {
    private NSUtil() {
    }

    public static void validateName(String name) throws DOMException {
        if (name.length() == 0) {
            throw DOMExceptionUtil.newDOMException((short)5);
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (i == 0 && !XMLChar.isNameStartChar(c) || i > 0 && !XMLChar.isNameChar(c)) {
                throw DOMExceptionUtil.newDOMException((short)5);
            }
            ++i;
        }
    }

    public static void validatePrefix(String prefix) throws DOMException {
        int i = 0;
        while (i < prefix.length()) {
            char c = prefix.charAt(i);
            if (c == ':') {
                throw DOMExceptionUtil.newDOMException((short)14);
            }
            if (i == 0 && !XMLChar.isNameStartChar(c) || i > 0 && !XMLChar.isNameChar(c)) {
                throw DOMExceptionUtil.newDOMException((short)5);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int validateQualifiedName(String qualifiedName) throws DOMException {
        if (qualifiedName.length() == 0) {
            throw DOMExceptionUtil.newDOMException((short)5);
        }
        int colonPosition = -1;
        boolean checkNameStart = true;
        int i = 0;
        while (i < qualifiedName.length()) {
            char c = qualifiedName.charAt(i);
            if (c == ':') {
                if (colonPosition != -1 || i <= 0) throw DOMExceptionUtil.newDOMException((short)14);
                colonPosition = i;
                checkNameStart = true;
            } else if (checkNameStart) {
                if (!XMLChar.isNameStartChar(c)) {
                    throw DOMExceptionUtil.newDOMException(XMLChar.isNameChar(c) ? (short)14 : 5);
                }
                checkNameStart = false;
            } else if (!XMLChar.isNameChar(c)) {
                throw DOMExceptionUtil.newDOMException((short)5);
            }
            ++i;
        }
        if (!checkNameStart) return colonPosition;
        throw DOMExceptionUtil.newDOMException((short)14);
    }

    public static String normalizeNamespaceURI(String namespaceURI) {
        return namespaceURI == null ? "" : namespaceURI;
    }

    public static void validateNamespace(String namespaceURI, String prefix) {
        if (prefix.length() != 0 && namespaceURI.length() == 0) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
        if ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
    }

    public static void validateAttributeName(String namespaceURI, String localName, String prefix) {
        NSUtil.validateNamespace(namespaceURI, prefix);
        if (prefix.length() == 0 && localName.equals("xmlns") && !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
        if ("xmlns".equals(prefix)) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
    }

    public static String getDeclaredPrefix(String localName, String prefix) {
        if (prefix.equals("xmlns")) {
            return localName;
        }
        if (prefix.length() == 0 && localName.equals("xmlns")) {
            return "";
        }
        throw DOMExceptionUtil.newDOMException((short)14);
    }
}

