#include "MaxReader.h"
#include <string.h>

/**
 * Implementations of MaxReader member functions.
 *
 * @author Tao Ju
 */


MaxReader::MaxReader( char* name, float scl )
{
	this->fname = name ;

	minc[0] = minc[1] = minc[2] = 100000;
	maxc[0] = maxc[1] = maxc[2] = -100000;

	// printf("Reading file...\n");
	this->num_objects = this->getBoundingBox( minc, maxc ) ;
	// printf( "Objects scanned: %d \n", num_objects);
	this->cur_object = 0 ;
	this->cur_poly = 0 ;
	this->object = NULL ;

	maxsize = maxc[0] - minc[0] ;
	for ( int i = 0 ; i < 3 ; i ++ )
	{
		if ( maxc[i] - minc[i] > maxsize )
		{
			maxsize = maxc[i] - minc[i] ;
		}
	}

		for ( i = 0 ; i < 3 ; i ++ )
		{
			minc[i] = ( maxc[i] + minc[i] ) / 2 - maxsize / 2 ;
			maxc[i] = ( maxc[i] + minc[i] ) / 2 + maxsize / 2 ;
		}

	// printf( "Low corner: %f %f %f   High corner %f %f %f \n", minc[0], minc[1], minc[2], maxc[0], maxc[1], maxc[2] );
	// printf( "Maxdif: %f \n", maxsize );

	for ( i = 0 ; i < 3 ; i ++ )
	{
		minc[i] -= maxsize * ( 1 / scl - 1 ) / 2 ;
	}
	maxsize *= ( 1 / scl ) ;

	
	// this->fin = fopen( fname, "r" );
	reset( ) ;
}

void MaxReader::reset( )
{
	rewind( fin ) ;
	this->cur_object = 0 ;
	this->cur_poly = 0 ;
	this->object = NULL ;
	this->cur_vert = 0 ;
}

float MaxReader::getBoundingBox( float origin[3] ) 
{
	for ( int i = 0 ; i < 3 ; i ++ )
	{
		origin[i] = minc[i] ;
	}

	return maxsize ;
}

int MaxReader::getNumVertices()
{
	return this->tot_vert ;
}

void MaxReader::getNextVertex( float v[3] )
{
	if ( this->object == NULL )
	{
		this->object = getNextObject() ;
		cur_vert = 0 ;
	}
	else if ( cur_vert >= object->num_vertices )
	{
		this->cur_vert = 0 ;
		this->cur_object ++ ;

		if ( this->cur_object >= this->num_objects )
		{
			return ;
		}

		delete object->trianArray ;
		delete object->vertexArray ;
		delete this->object ;

		this->object = getNextObject() ;
	}

	v[0] = object->vertexArray[cur_vert].cord[0] ;
	v[1] = object->vertexArray[cur_vert].cord[1] ;
	v[2] = object->vertexArray[cur_vert].cord[2] ;

	cur_vert ++ ;
}

int MaxReader::getNextTriangle( int t[3] )
{
	if ( this->object == NULL )
	{
		this->object = getNextObject() ;
	}

	if ( this->cur_poly >= object->num_triangles )
	{
		this->cur_poly = 0 ;
		this->cur_object ++ ;

		if ( this->cur_object >= this->num_objects )
		{
			return 0 ;
		}

		delete object->trianArray ;
		delete object->vertexArray ;
		delete this->object ;

		this->object = getNextObject() ;
	}

	for ( int i = 0 ; i < 3 ; i ++ )
	{
		t[i] = object->trianArray[cur_poly].vert[i] ;
	}

	cur_poly ++ ;

	return 1 ;
}

Triangle* MaxReader::getNextTriangle( )
{
	if ( this->object == NULL )
	{
		this->object = getNextObject() ;
	}

	if ( this->cur_poly >= object->num_triangles )
	{
		this->cur_poly = 0 ;
		this->cur_object ++ ;

		if ( this->cur_object >= this->num_objects )
		{
			return NULL ;
		}

		delete object->trianArray ;
		delete object->vertexArray ;
		delete this->object ;

		this->object = getNextObject() ;
	}

	Triangle* tri = new Triangle( ) ;
	for ( int i = 0 ; i < 3 ; i ++ )
		for ( int j = 0 ; j < 3 ; j ++ )
		{
			tri->vt[i][j] = object->vertexArray[ object->trianArray[cur_poly].vert[i] ].cord[j] ;
		}

	cur_poly ++ ;

	return tri ;
}

int MaxReader::getMemory( )
{
	int size_this = sizeof( class MaxReader ) ;
	int size_maxobject = sizeof ( struct MaxObject ) ;
	size_maxobject += object->num_triangles * sizeof ( struct TriangleArrayElement ) ;
	size_maxobject += object->num_vertices * sizeof ( struct PolygonVertex ) ; 

	// printf("tris: %d " , object->num_triangles) ;
	// printf("vts: %d \n" , object->num_vertices);

	return size_this + size_maxobject ;
}

void MaxReader::printInfo( )
{
	printf("Objects in file: %d Vertices: %d Polygons: %d\n", num_objects, tot_poly, tot_vert ) ;
}


MaxReader::~MaxReader()
{
	fclose(this->fin);

	if ( this->object != NULL )
	{
		delete object->trianArray ;
		delete object->vertexArray ;
		delete object ;
	}

	// printf("Reader removed.\n") ;
}

int MaxReader::getNumberObjects()
{
	return this->num_objects ;
}


MaxObject* MaxReader::getNextObject()
{
	MaxObject* obj = new MaxObject;
	this->cur_object ++ ;
	obj->trianArray = NULL ;
	obj->vertexArray = NULL ;
	int realVertices, realTriangles;


	// printf("Reading object %d ... ", this->cur_object);
	// Readin vertex/face count
	int type, ind[3], cur_vert = 0, cur_trian = 0, i ;
	float cord[3];

	type = this->parseNextLine( ind, cord );
	while ( type != END_OF_FILE )
	{
		if ( type == VERTEX_FACE_COUNT )
		{
			realVertices = ind[0];
			realTriangles = ind[1];
			obj->num_vertices = realVertices;
			obj->num_triangles = realTriangles ;
			obj->vertexArray = new PolygonVertex[obj->num_vertices];
			obj->trianArray = new TriangleArrayElement[obj->num_triangles];
			break;
		}
		type = this->parseNextLine( ind, cord );
	}

	if ( type == END_OF_FILE )
	{
		delete obj;
		return NULL;
	}

	// Reading each vertex
	type = this->parseNextLine( ind, cord );
	while ( type != END_OF_FILE )
	{
		if ( type == NEW_VERTEX )
		{
			for ( i = 0 ; i < 3 ; i ++ )
			{
				obj->vertexArray[cur_vert].cord[i] = cord[i] ;
			}
			cur_vert ++ ;
			if ( cur_vert == realVertices )
			{
				break;
			}
		}
		type = this->parseNextLine( ind, cord );
	}

	// Reading each face
	type = this->parseNextLine( ind, cord );
	while ( type != END_OF_FILE )
	{
		if ( type == NEW_FACE )
		{
			for ( i = 0 ; i < 3 ; i ++ )
			{
				obj->trianArray[cur_trian].vert[i] = ind[i];
			}

			cur_trian ++ ;
			if ( cur_trian == realTriangles )
			{
				printf(" Vertices: %d  Triangles: %d ", obj->num_vertices, obj->num_triangles );
				printf(" Done.\n");
				return obj;
			}
		}

		type = this->parseNextLine( ind, cord );
	}

	delete obj;
	return NULL;
}

int MaxReader::getBoundingBox( float minc[3], float maxc[3] )
{
	this->tot_poly = 0 ;
	this->tot_vert = 0 ;
	if ( (this->fin = fopen( fname, "r" )) == NULL )
	{
		printf("Can't open file.\n");
		exit(0);
	}
	
	int ind[3], type, num = 0, i;
	float cord[3];

	type = this->parseNextLine( ind, cord );
	while ( type != END_OF_FILE )
	{
		if ( type == NEW_OBJECT )
		{
			num ++ ;
		}
		else if ( type == NEW_VERTEX )
		{
			this->tot_vert ++ ;
			for ( i = 0 ; i < 3 ; i ++ )
			{
				if ( cord[i] > maxc[i] )
				{
					maxc[i] = cord[i];
				}
				if ( cord[i] < minc[i] )
				{
					minc[i] = cord[i];
				}
			}
		} else if ( type == NEW_FACE )
		{
			this->tot_poly ++ ;
		}

		type = this->parseNextLine( ind, cord );
	}

	// fclose(this->fin);
	return num;
}
/*
int MaxReader::parseNextLine( int ind[3], float cord[3] )
{
	if ( feof( fin ) )
	{
		return END_OF_FILE;
	}

	char line[500];
	char seps[] = " ,:";
	char *tok;
	fgets( line, 500, fin);

	tok = strtok( line, seps );
	if (tok != NULL )
	{
		if ( strcmp( tok, "Vertices" ) == 0 )
		{
			// Vertex/face count
			tok = strtok( NULL, seps );
			sscanf( tok, "%d", &(ind[0]));
			tok = strtok( NULL, seps );
			tok = strtok( NULL, seps );
			sscanf( tok, "%d", &(ind[1]));

			return VERTEX_FACE_COUNT ;
		}
		else if ( strcmp( tok, "Vertex" ) == 0 )
		{
			tok = strtok( NULL, seps );
			if ( strcmp( tok, "List" ) == 0 )
			{
				// Starting of vertex list
				return NEW_VERTEX_LIST;
			}
			else
			{
				// A new vertex
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%f", &(cord[0]));
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%f", &(cord[1]));
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%f", &(cord[2]));

				
				float tmp = cord[1];
				cord[1] = cord[2] ;
				cord[2] = - tmp;
				
				return NEW_VERTEX ;
			}
		}
		else if ( strcmp( tok, "Face" ) == 0 )
		{
			tok = strtok( NULL, seps );
			if ( strcmp( tok, "List" ) == 0 )
			{
				// Starting of face list
				return NEW_FACE_LIST;
			}
			else
			{
				// A new face
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%d", &(ind[0]));
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%d", &(ind[1]));
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%d", &(ind[2]));

				return NEW_FACE ;
			}
		}
		else if ( strcmp( tok, "Named" ) == 0 )
		{
			// A new object
			return NEW_OBJECT;
		}
		else
		{
			// Redundant info
			return REDUNDANT_INFO;
		}
	}

	// Empty line
	return REDUNDANT_INFO ;
}
*/


int MaxReader::parseNextLine( int ind[3], float cord[3] )
{
	if ( feof( fin ) )
	{
		return END_OF_FILE;
	}

	char line[500];
	char seps[] = " ,:\t";
	char *tok;
	fgets( line, 500, fin);

	tok = strtok( line, seps );
	if (tok != NULL )
	{
		if ( strcmp( tok, "Tri-mesh" ) == 0 )
		{
			// Vertex/face count
			tok = strtok( NULL, seps );
			tok = strtok( NULL, seps );
			sscanf( tok, "%d", &(ind[0]));
			tok = strtok( NULL, seps );
			tok = strtok( NULL, seps );
			sscanf( tok, "%d", &(ind[1]));

			return VERTEX_FACE_COUNT ;
		}
		else if ( strcmp( tok, "Vertex" ) == 0 )
		{
			tok = strtok( NULL, seps );
			if ( strcmp( tok, "list" ) == 0 )
			{
				// Starting of vertex list
				return NEW_VERTEX_LIST;
			}
			else
			{
				// A new vertex
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%f", &(cord[0]));
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%f", &(cord[1]));
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%f", &(cord[2]));

				
				// float tmp = cord[1];
				// cord[1] = cord[2] ;
				// cord[2] = - tmp;
				
				return NEW_VERTEX ;
			}
		}
		else if ( strcmp( tok, "Face" ) == 0 )
		{
			tok = strtok( NULL, seps );
			if ( strcmp( tok, "list" ) == 0 )
			{
				// Starting of face list
				return NEW_FACE_LIST;
			}
			else
			{
				// A new face
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%d", &(ind[0]));
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%d", &(ind[1]));
				tok = strtok( NULL, seps );
				tok = strtok( NULL, seps );
				sscanf( tok, "%d", &(ind[2]));

				return NEW_FACE ;
			}
		}
		else if ( strcmp( tok, "Named" ) == 0 )
		{
			// A new object
			return NEW_OBJECT;
		}
		else
		{
			// Redundant info
			return REDUNDANT_INFO;
		}
	}

	// Empty line
	return REDUNDANT_INFO ;
}
