#!BPY
"""
Name: 'Circular Stairway'
Blender: 248
Group: 'AddMesh'
Tooltip: 'Add a circular stairway mesh'
"""


__author__ = "Alejandro Sierra"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Circular_Stairway")
__version__ = "1.0"

__bpydoc__ = """\
This script adds a circular stair for architectural sceneries, a wedding
cake for food scenes, etc.
"""


# --------------------------------------------------------------------------
# Copyright (C) 2008 Alejandro Sierra (AKA naturalpainter)
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------


from Blender import Mesh, Window, Draw
import BPyMessages
import bpy
import BPyAddMesh
from math import sqrt, pi, sin, cos

def create_mesh(VERTICES, radius_max, radius_min, height, nsteps):
	
	# Compute increment values
	step_inc = height/nsteps
	radius_inc = (radius_min - radius_max)/(nsteps-1)
	
	# Create base circles
	v = []
	v.append([0, 0, 0])
	z_prev = 0
	for s in range(nsteps):
		radius = radius_max + radius_inc*s
		v_up = []
		for i in xrange(VERTICES):
			angle = 2*pi*i/VERTICES
			x = cos(angle)*radius
			y = sin(angle)*radius
			z = step_inc*s
			z_up = step_inc*(s+1)
			v.append([x, y, z])
			v_up.append([x, y, z_up])
		v.extend(v_up)

	v.append([0, 0, height])
	
	# Fill faces
	f = []
	n = 1+nsteps*2*VERTICES
	f.append([0,1,VERTICES])
	f.append([n,n-1, n-VERTICES])
	for i in xrange(VERTICES-1):
		f.append([0,i+2,i+1])
		f.append([n,n-i-2,n-i-1])



	for i in xrange(1,VERTICES):
		for s in range(2*nsteps-1):
			i1 = i+VERTICES*s
			i2 = i+VERTICES*(s+1)
			f.append([i1, i1+1, i2+1, i2])

	for s in range(2*nsteps-1):		
		i1 = VERTICES*(s+1)
		i2 = 1+VERTICES*s
		f.append([i1, i2, i2+VERTICES, i1+VERTICES])
		
	BPyAddMesh.add_mesh_simple('Circular_stair', v, [], f)


def main():

        VERTICES = Draw.Create(32)
        RADIUSMIN = Draw.Create(1.0)
        RADIUSMAX = Draw.Create(2.0)
        HEIGHT = Draw.Create(1.0)
	NSTEPS = Draw.Create(3)

        if not Draw.PupBlock('Add Circular stair', [\
        ('Segments:', VERTICES, 3, 100, 'Number of vertices per ring'),\
        ('Minor radius:', RADIUSMIN, .001, 100.0, 'Minor radius'),\
        ('Major radius:', RADIUSMAX, .001, 100.0, 'Major radius'),\
        ('Height:', HEIGHT, .001, 100.0, 'Total height'),\
        ('Steps:', NSTEPS, 2, 100, 'Number of steps'),\

        ]):
                return
	
	Window.WaitCursor(1)
	create_mesh(VERTICES.val, RADIUSMAX.val, RADIUSMIN.val, HEIGHT.val, NSTEPS.val) 
	
	Window.WaitCursor(0)
	
	
# This lets you can import the script without running it
if __name__ == '__main__':
	main()
