#!BPY

""" Registration info for Blender menus:
Name: '.blend info'
Blender: 248
Group: 'System'
Tooltip: 'Shows some info and statistics about the opened .blend'
"""
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2006 Mariano Hidalgo
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

__author__ = "Mariano Hidalgo a.k.a. uselessdreamer"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/System/blend_information")
__version__ = "1.0"

__bpydoc__ = """\
This script shows information about the currently openned .blend.

In the first block you can see the objects on the current scene,

and at the bottom the shared datablocks the .blend holds.
"""

import Blender
from Blender import *

def event(evt, val):
	if evt == Draw.ESCKEY or evt == Draw.QKEY:
 		Draw.Exit()             
   		return	
   	if evt == Draw.RIGHTMOUSE:
		c = Draw.PupMenu("Quit?%t|Yes|No")	
		if c == 1:
			Draw.Exit()             
			return	
   	Draw.Redraw()	

def button_event(evt):	
	global SHOW_HELP
	if evt == 1:
		SHOW_HELP = 1 - SHOW_HELP
	Draw.Redraw()	

def INTtoFLOAT(rgba):
	r = float(rgba[0] *10 /255) /10
	g = float(rgba[1] *10 /255) /10
	b = float(rgba[2] *10 /255) /10
	a = float(rgba[3] *10 /255) /10
	return [r,g,b,a]

def gui():
	global SHOW_HELP
	theme = Window.Theme.Get()[0]
	buts = theme.get('buts')
	# Background
	r,g,b,a = INTtoFLOAT(buts.back)
	BGL.glClearColor(r+0.05,g+0.05,b+0.05,a)
	BGL.glClear(BGL.GL_COLOR_BUFFER_BIT)
	# Header
	r,g,b,a = INTtoFLOAT(buts.header)	
	draw_square(10,255,160,16,r-0.1,g-0.1,b-0.1,a)
	# Panel
	r,g,b,a = INTtoFLOAT(buts.panel)
	draw_square(10,5,160,250,r,g,b,a+0.1)
	# Text Hilite	
	r,g,b,a = INTtoFLOAT(buts.text_hi)	
	BGL.glColor3f(r,g,b)
	BGL.glRasterPos2i(15,259)
	Draw.Text(".blend Info","small")
	# Text
	r,g,b,a = INTtoFLOAT(buts.text)	
	BGL.glColor3f(r,g,b)	
	begin = 240
	BGL.glRasterPos2i(15,begin)	
	Draw.Toggle("?", 1,146,253, 15,15,SHOW_HELP , "Show Help")				
	scn = Scene.GetCurrent()
	obs = scn.getChildren() 	
	Draw.Text("Scene Name: " + scn.getName(),"small")
	begin -= 5	
	obTypes = ["Mesh object","Curve object","Camera","Lamp","Empty","Armature","Lattice"]
	obTotals = [0,0,0,0,0,0,0]
	for ob in obs:
		if ob.getType() == "Mesh": obTotals[0] += 1
		elif ob.getType() == "Curve": obTotals[1] += 1
		elif ob.getType() == "Camera": obTotals[2] += 1
		elif ob.getType() == "Lamp": obTotals[3] += 1		
		elif ob.getType() == "Empty": obTotals[4] += 1
		elif ob.getType() == "Armature": obTotals[5] += 1	
	count = 0	
	begin = 240
	for t in obTypes:
		begin -= 15
		BGL.glRasterPos2i(35,begin)
		tot = obTotals[count]		
		if count == 1: begin -= 5
		Draw.Text(str(tot) + " " + str(t) + ".","small")
		count += 1
	begin -= 20
	BGL.glRasterPos2i(15,begin)	
	Draw.Text("Total: " + str(len(obs)) + " Objects on Scene.","small")
	begin -= 30
	# Text Hilite	
	r,g,b,a = INTtoFLOAT(buts.text_hi)	
	BGL.glColor3f(r,g,b)			
	#BGL.glEnable(BGL.GL_POINT_SMOOTH)	
	BGL.glPointSize(5)
	BGL.glBegin(BGL.GL_POINTS)
	for i in range(5):
		BGL.glVertex2i(24,begin + 4 -(15*i))
	BGL.glEnd()	
	begin2 = 190
	BGL.glBegin(BGL.GL_POINTS)
	BGL.glVertex2i(24,230)
	BGL.glVertex2i(24,215)
	for i in range(5):
		BGL.glVertex2i(24,begin2 + 4 -(15*i))
	BGL.glEnd()	
	#BGL.glDisable(BGL.GL_POINT_SMOOTH)	
	# Text
	r,g,b,a = INTtoFLOAT(buts.text)	
	
	p = 0
	BGL.glColor3f(r,g,b)	
	BGL.glRasterPos2i(35,begin)		
	mats = Material.Get()
	p = ""
	if len(mats) > 1: p = "s"
	Draw.Text(str(len(mats)) + " Material" + p,"small")
	begin -= 15
	
	BGL.glRasterPos2i(35,begin)		
	texs = Texture.Get()
	p = ""
	if len(texs) > 1: p = "s"
	Draw.Text(str(len(texs)) + " Texture"+ p,"small")
	begin -= 15
	
	BGL.glRasterPos2i(35,begin)	
	imgs = Image.Get()
	p = ""
	if len(imgs) > 1: p = "s"
	Draw.Text(str(len(imgs)) + " Image"+ p,"small")
	begin -= 15
	
	BGL.glRasterPos2i(35,begin)	
	wrlds = World.Get()
	p = ""
	if len(wrlds) > 1: p = "s"
	Draw.Text(str(len(wrlds)) + " World"+ p,"small")
	begin -= 15
	
	BGL.glRasterPos2i(35,begin)	
	txts = Text.Get()
	p = ""
	if len(txts) > 1: p = "s"
	Draw.Text(str(len(txts)) + " Text"+ p,"small")
	
	mats,texs,imgs,txts,wrlds = [None,None,None,None,None]
	
	if SHOW_HELP:
		text = "This script shows information about the currently opened .blend file.|In the first block you can see the objects on the current scene, and at the bottom the shared datablocks the .blend holds."
		paragraph([r,g,b],text,140,"small",20,236,14,1)		
	
def draw_square(x,y,w,h,r,g,b,a):
	BGL.glEnable(BGL.GL_BLEND)
	BGL.glBlendFunc(BGL.GL_SRC_ALPHA, BGL.GL_ONE_MINUS_SRC_ALPHA)
	BGL.glColor4f(r,g,b,a)
	BGL.glBegin(BGL.GL_POLYGON)
	BGL.glVertex2i(x, y)
	BGL.glVertex2i(x, y + h)
	BGL.glVertex2i(x + w, y + h)
	BGL.glVertex2i(x + w, y)
	BGL.glEnd()	
	BGL.glDisable( BGL.GL_BLEND )

def paragraph(color,text,width,size,staX,staY,spacing,square):	
	lines = []
	i = 0
	while i <= 1000:		
		if i >= len(text):
			lines.append(text)
			break
		i += 1	
		length = Draw.GetStringWidth(text[:i],size)		
		if text[i:i+1] == "|":			
			lines.append(text[:i].lstrip(" ").rstrip("|"))
			if 	text[i+1:i+2] == "|":	
				lines.append("")	
			text = text[i:].lstrip("|")						
		elif length > width:			
			c = 0
			while 1:
				if text[i-c-1:i-c] == " ":
					lines.append(text[:i-c].lstrip(" "))
					text = text[i-c:]
					break			
				else:
					c += 1
			i = 0		
	h = len(lines)*spacing
	if square: draw_square(staX-10,staY - h+5,width+20,h+15,1,0.6,0,1)
	BGL.glColor3f(color[0],color[1],color[2])
	c = 0
	for l in lines:
		BGL.glRasterPos2i(staX,staY - (c*spacing))
		Draw.Text(l,"small")
		c+= 1
			
SHOW_HELP = 0
Draw.Register(gui, event, button_event)	

