/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class TextInfoPanel
extends JPanel {
    private TextDescriptor.Position initialPos;
    private TextDescriptor.Size initialSize;
    private TextDescriptor.Rotation initialRotation;
    private boolean initialItalic;
    private boolean initialBold;
    private boolean initialUnderline;
    private boolean initialInvisibleOutsideCell;
    private int initialFont;
    private double initialXOffset;
    private double initialYOffset;
    private double initialBoxedWidth;
    private double initialBoxedHeight;
    private int initialColorIndex;
    private TextDescriptor td;
    private String futureVarName;
    private ElectricObject owner;
    private NodeInst unTransformNi;
    private JCheckBox bold;
    private JTextField boxedHeight;
    private JTextField boxedWidth;
    private JComboBox font;
    private JCheckBox invisibleOutsideCell;
    private JCheckBox italic;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelX;
    private JPanel jPanel1;
    private JRadioButton pointsButton;
    private JTextField pointsSize;
    private JComboBox rotation;
    private JButton seeNode;
    private ButtonGroup sizes;
    private JComboBox textAnchor;
    private JComboBox textColorComboBox;
    private JCheckBox underline;
    private JRadioButton unitsButton;
    private JTextField unitsSize;
    private JTextField xOffset;
    private JTextField yOffset;

    public TextInfoPanel() {
        int i;
        this.initComponents();
        this.font.addItem("DEFAULT FONT");
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (i = 0; i < fonts.length; ++i) {
            this.font.addItem(fonts[i].getFontName());
        }
        for (i = 0; i < TextDescriptor.Rotation.getNumRotations(); ++i) {
            TextDescriptor.Rotation rot = TextDescriptor.Rotation.getRotationAt(i);
            this.rotation.addItem(new Integer(rot.getAngle()));
        }
        Iterator it = TextDescriptor.Position.getPositions();
        while (it.hasNext()) {
            TextDescriptor.Position pos = (TextDescriptor.Position)it.next();
            this.textAnchor.addItem(pos);
        }
        int[] colorIndices = EGraphics.getColorIndices();
        this.textColorComboBox.addItem("");
        for (int i2 = 0; i2 < colorIndices.length; ++i2) {
            String str = EGraphics.getColorIndexName(colorIndices[i2]);
            this.textColorComboBox.addItem(str);
        }
        this.initialYOffset = 0.0;
        this.initialXOffset = 0.0;
        this.xOffset.setText("0");
        this.yOffset.setText("0");
        this.initialInvisibleOutsideCell = false;
        this.invisibleOutsideCell.setSelected(this.initialInvisibleOutsideCell);
        this.initialSize = TextDescriptor.Size.newRelSize(1.0);
        this.unitsButton.setSelected(true);
        this.unitsSize.setText("1.0");
        this.initialPos = TextDescriptor.Position.CENT;
        this.textAnchor.setSelectedItem(this.initialPos);
        this.initialFont = 0;
        this.font.setSelectedIndex(this.initialFont);
        this.initialItalic = false;
        this.italic.setEnabled(false);
        this.initialBold = false;
        this.bold.setEnabled(false);
        this.initialUnderline = false;
        this.underline.setEnabled(false);
        this.initialRotation = TextDescriptor.Rotation.ROT0;
        this.rotation.setSelectedItem(this.initialRotation);
        this.initialColorIndex = 0;
        this.setTextDescriptor(null, null, null);
    }

    public synchronized void setTextDescriptor(TextDescriptor td, String futureVarName, ElectricObject owner) {
        if (futureVarName != null && (futureVarName = futureVarName.trim()).equals("")) {
            futureVarName = null;
        }
        this.td = td;
        this.futureVarName = futureVarName;
        this.owner = owner;
        boolean enabled = td != null || futureVarName != null;
        this.pointsSize.setEnabled(enabled);
        this.unitsSize.setEnabled(enabled);
        this.pointsButton.setEnabled(enabled);
        this.unitsButton.setEnabled(enabled);
        this.xOffset.setEnabled(enabled);
        this.yOffset.setEnabled(enabled);
        this.font.setEnabled(enabled);
        this.textAnchor.setEnabled(enabled);
        this.rotation.setEnabled(enabled);
        this.bold.setEnabled(enabled);
        this.italic.setEnabled(enabled);
        this.underline.setEnabled(enabled);
        this.invisibleOutsideCell.setEnabled(enabled);
        this.seeNode.setEnabled(enabled);
        this.boxedWidth.setEnabled(false);
        this.boxedHeight.setEnabled(false);
        this.textColorComboBox.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        if (td == null && futureVarName != null) {
            return;
        }
        NodeInst ni = null;
        if (owner != null && owner instanceof NodeInst && (ni = (NodeInst)owner).getProto() != Generic.tech.invisiblePinNode) {
            ni = null;
        }
        this.unTransformNi = null;
        if (owner != null) {
            if (owner instanceof NodeInst) {
                this.unTransformNi = (NodeInst)owner;
            } else if (owner instanceof Export) {
                this.unTransformNi = ((Export)owner).getOriginalPort().getNodeInst();
            }
        }
        if (ni != null) {
            this.initialXOffset = ni.getAnchorCenterX();
            this.initialYOffset = ni.getAnchorCenterY();
        } else {
            this.initialXOffset = td.getXOff();
            this.initialYOffset = td.getYOff();
            if (this.unTransformNi != null) {
                Point2D.Double off = new Point2D.Double(this.initialXOffset, this.initialYOffset);
                AffineTransform trans = this.unTransformNi.pureRotateOut();
                trans.transform(off, off);
                this.initialXOffset = ((Point2D)off).getX();
                this.initialYOffset = ((Point2D)off).getY();
            }
        }
        this.xOffset.setText(TextUtils.formatDouble(this.initialXOffset));
        this.yOffset.setText(TextUtils.formatDouble(this.initialYOffset));
        this.initialInvisibleOutsideCell = td.isInterior();
        this.invisibleOutsideCell.setSelected(this.initialInvisibleOutsideCell);
        this.initialSize = td.getSize();
        EditWindow wnd = EditWindow.getCurrent();
        if (this.initialSize.isAbsolute()) {
            this.pointsButton.setSelected(true);
            this.pointsSize.setText(TextUtils.formatDouble(this.initialSize.getSize()));
            this.unitsSize.setText("");
            if (wnd != null) {
                double unitSize = wnd.getTextUnitSize((int)this.initialSize.getSize());
                this.unitsSize.setText(TextUtils.formatDouble(unitSize));
            }
        } else {
            this.unitsButton.setSelected(true);
            this.unitsSize.setText(TextUtils.formatDouble(this.initialSize.getSize()));
            this.pointsSize.setText("");
            if (wnd != null) {
                double pointSize = wnd.getTextScreenSize(this.initialSize.getSize());
                this.pointsSize.setText(TextUtils.formatDouble(pointSize));
            }
        }
        this.initialPos = td.getPos();
        this.boxedWidth.setText("");
        this.boxedHeight.setText("");
        this.initialBoxedWidth = -1.0;
        this.initialBoxedHeight = -1.0;
        boolean ownerIsNodeInst = false;
        if (owner instanceof NodeInst) {
            ownerIsNodeInst = true;
        }
        if (ownerIsNodeInst) {
            boolean found = false;
            for (int i = 0; i < this.textAnchor.getModel().getSize(); ++i) {
                TextDescriptor.Position pos = (TextDescriptor.Position)this.textAnchor.getModel().getElementAt(i);
                if (pos != TextDescriptor.Position.BOXED) continue;
                found = true;
                break;
            }
            if (!found) {
                this.textAnchor.addItem(TextDescriptor.Position.BOXED);
            }
            NodeInst ni2 = (NodeInst)owner;
            this.initialBoxedWidth = ni2.getXSize();
            this.initialBoxedHeight = ni2.getYSize();
            this.boxedWidth.setText(TextUtils.formatDouble(ni2.getXSize()));
            this.boxedHeight.setText(TextUtils.formatDouble(ni2.getYSize()));
        }
        if (!ownerIsNodeInst) {
            this.textAnchor.removeItem(TextDescriptor.Position.BOXED);
        }
        Poly.Type type = td.getPos().getPolyType();
        type = Poly.rotateType(type, owner);
        TextDescriptor.Position pos = TextDescriptor.Position.getPosition(type);
        this.textAnchor.setSelectedItem(pos);
        this.textAnchorItemStateChanged(null);
        this.initialFont = td.getFace();
        if (this.initialFont == 0) {
            this.font.setSelectedIndex(0);
        } else {
            TextDescriptor.ActiveFont af = TextDescriptor.ActiveFont.findActiveFont(this.initialFont);
            if (af != null) {
                this.font.setSelectedItem(af.getName());
            }
        }
        this.initialItalic = td.isItalic();
        this.italic.setSelected(this.initialItalic);
        this.initialBold = td.isBold();
        this.bold.setSelected(this.initialBold);
        this.initialUnderline = td.isUnderline();
        this.underline.setSelected(this.initialUnderline);
        this.initialRotation = td.getRotation();
        this.rotation.setSelectedIndex(td.getRotation().getIndex());
        this.initialColorIndex = td.getColorIndex();
        int colorComboIndex = 0;
        int[] colorIndices = EGraphics.getColorIndices();
        for (int i = 0; i < colorIndices.length; ++i) {
            if (colorIndices[i] != this.initialColorIndex) continue;
            colorComboIndex = i + 1;
        }
        this.textColorComboBox.setSelectedIndex(colorComboIndex);
    }

    public synchronized boolean applyChanges() {
        boolean newInvis;
        boolean newUnderlined;
        boolean newBold;
        boolean newItalic;
        int newFont;
        int index;
        TextDescriptor.Rotation newRotation;
        if (this.td == null && this.futureVarName == null) {
            return false;
        }
        boolean changed = false;
        TextDescriptor.Size newSize = null;
        if (this.pointsButton.isSelected()) {
            int size = TextUtils.atoi(this.pointsSize.getText());
            newSize = TextDescriptor.Size.newAbsSize(size);
        } else {
            double size = TextUtils.atof(this.unitsSize.getText());
            newSize = TextDescriptor.Size.newRelSize(size);
        }
        if (newSize == null) {
            newSize = TextDescriptor.Size.newRelSize(1.0);
        }
        if (!newSize.equals(this.initialSize)) {
            changed = true;
        }
        double currentXOffset = TextUtils.atof(this.xOffset.getText());
        double currentYOffset = TextUtils.atof(this.yOffset.getText());
        if (!DBMath.doublesEqual(currentXOffset, this.initialXOffset) || !DBMath.doublesEqual(currentYOffset, this.initialYOffset)) {
            changed = true;
        }
        TextDescriptor.Position newPosition = (TextDescriptor.Position)this.textAnchor.getSelectedItem();
        Poly.Type type = newPosition.getPolyType();
        newPosition = TextDescriptor.Position.getPosition(type = Poly.unRotateType(type, this.owner));
        if (newPosition != this.initialPos) {
            changed = true;
        }
        double newBoxedWidth = 10.0;
        double newBoxedHeight = 10.0;
        if (newPosition == TextDescriptor.Position.BOXED) {
            block24: {
                try {
                    Double width = new Double(this.boxedWidth.getText());
                    Double height = new Double(this.boxedHeight.getText());
                    newBoxedWidth = width;
                    newBoxedHeight = height;
                }
                catch (NumberFormatException e) {
                    if (!(this.owner instanceof NodeInst)) break block24;
                    NodeInst ni = (NodeInst)this.owner;
                    newBoxedWidth = ni.getXSize();
                    newBoxedHeight = ni.getYSize();
                }
            }
            if (newBoxedWidth != this.initialBoxedWidth) {
                changed = true;
            }
            if (newBoxedHeight != this.initialBoxedHeight) {
                changed = true;
            }
        }
        if ((newRotation = TextDescriptor.Rotation.getRotationAt(index = this.rotation.getSelectedIndex())) != this.initialRotation) {
            changed = true;
        }
        if ((newFont = this.font.getSelectedIndex()) != this.initialFont) {
            changed = true;
        }
        if ((newItalic = this.italic.isSelected()) != this.initialItalic) {
            changed = true;
        }
        if ((newBold = this.bold.isSelected()) != this.initialBold) {
            changed = true;
        }
        if ((newUnderlined = this.underline.isSelected()) != this.initialUnderline) {
            changed = true;
        }
        if ((newInvis = this.invisibleOutsideCell.isSelected()) != this.initialInvisibleOutsideCell) {
            changed = true;
        }
        int newColorIndex = 0;
        int[] colorIndices = EGraphics.getColorIndices();
        int newColorComboIndex = this.textColorComboBox.getSelectedIndex();
        if (newColorComboIndex > 0) {
            newColorIndex = colorIndices[newColorComboIndex - 1];
        }
        if (newColorIndex != this.initialColorIndex) {
            changed = true;
        }
        if (this.futureVarName == null) {
            if (!changed) {
                return false;
            }
        } else if (this.owner instanceof Cell) {
            currentYOffset -= 2.0;
        }
        ChangeText job = new ChangeText(this.td, this.owner, this.unTransformNi, this.futureVarName, newSize, newPosition, newBoxedWidth, newBoxedHeight, newRotation, (String)this.font.getSelectedItem(), currentXOffset, currentYOffset, newItalic, newBold, newUnderlined, newInvis, newColorIndex);
        this.initialSize = newSize;
        this.initialXOffset = currentXOffset;
        this.initialYOffset = currentYOffset;
        this.initialPos = newPosition;
        this.initialRotation = newRotation;
        this.initialFont = newFont;
        this.initialItalic = newItalic;
        this.initialUnderline = newUnderlined;
        this.initialBold = newBold;
        this.initialInvisibleOutsideCell = newInvis;
        this.initialBoxedWidth = newBoxedWidth;
        this.initialBoxedHeight = newBoxedHeight;
        this.initialColorIndex = newColorIndex;
        return true;
    }

    private void initComponents() {
        this.sizes = new ButtonGroup();
        this.jLabel4 = new JLabel();
        this.pointsSize = new JTextField();
        this.unitsSize = new JTextField();
        this.pointsButton = new JRadioButton();
        this.unitsButton = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.font = new JComboBox();
        this.italic = new JCheckBox();
        this.bold = new JCheckBox();
        this.underline = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.rotation = new JComboBox();
        this.jLabel8 = new JLabel();
        this.xOffset = new JTextField();
        this.jLabel9 = new JLabel();
        this.yOffset = new JTextField();
        this.invisibleOutsideCell = new JCheckBox();
        this.seeNode = new JButton();
        this.textAnchor = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.boxedWidth = new JTextField();
        this.boxedHeight = new JTextField();
        this.jLabelX = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel3 = new JLabel();
        this.textColorComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        this.setName("");
        this.jLabel4.setText("Text Size:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.pointsSize.setColumns(8);
        this.pointsSize.setMinimumSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 2, 1, 4);
        this.add((Component)this.pointsSize, gridBagConstraints);
        this.unitsSize.setColumns(8);
        this.unitsSize.setMinimumSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(1, 2, 4, 4);
        this.add((Component)this.unitsSize, gridBagConstraints);
        this.pointsButton.setText("Points (max 63)");
        this.sizes.add(this.pointsButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.pointsButton, gridBagConstraints);
        this.unitsButton.setText("Units (max 127.75)");
        this.sizes.add(this.unitsButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.unitsButton, gridBagConstraints);
        this.jLabel5.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.font, gridBagConstraints);
        this.italic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.italic, gridBagConstraints);
        this.bold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.bold, gridBagConstraints);
        this.underline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.underline, gridBagConstraints);
        this.jLabel6.setText("Rotation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.rotation, gridBagConstraints);
        this.jLabel8.setText("X offset:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 3, 0);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.xOffset.setColumns(8);
        this.xOffset.setMinimumSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 2, 1, 4);
        this.add((Component)this.xOffset, gridBagConstraints);
        this.jLabel9.setText("Y offset:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 4, 0, 0);
        this.add((Component)this.jLabel9, gridBagConstraints);
        this.yOffset.setColumns(8);
        this.yOffset.setMinimumSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(1, 2, 0, 4);
        this.add((Component)this.yOffset, gridBagConstraints);
        this.invisibleOutsideCell.setText("Invisible outside cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 2, 0);
        this.add((Component)this.invisibleOutsideCell, gridBagConstraints);
        this.seeNode.setText("Highlight Owner");
        this.seeNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextInfoPanel.this.seeNodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.seeNode, gridBagConstraints);
        this.textAnchor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextInfoPanel.this.textAnchorItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.textAnchor, gridBagConstraints);
        this.jLabel1.setText("Anchor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setText("Boxed width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.boxedWidth.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.boxedWidth, gridBagConstraints);
        this.boxedHeight.setColumns(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.boxedHeight, gridBagConstraints);
        this.jLabelX.setText("height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelX, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel7.setText("(0.25 increments)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel3.setText("Color:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.textColorComboBox, gridBagConstraints);
    }

    private void textAnchorItemStateChanged(ItemEvent evt) {
        TextDescriptor.Position pos = (TextDescriptor.Position)this.textAnchor.getSelectedItem();
        if (pos == TextDescriptor.Position.BOXED) {
            NodeInst ni;
            this.boxedWidth.setEnabled(true);
            this.boxedWidth.setBackground(Color.WHITE);
            this.boxedHeight.setEnabled(true);
            this.boxedHeight.setBackground(Color.WHITE);
            this.xOffset.setEnabled(false);
            this.yOffset.setEnabled(false);
            if (this.owner instanceof NodeInst && (ni = (NodeInst)this.owner).getProto() == Generic.tech.invisiblePinNode) {
                this.xOffset.setEnabled(true);
                this.yOffset.setEnabled(true);
            }
        } else {
            this.boxedWidth.setEnabled(false);
            this.boxedWidth.setBackground(this.getBackground());
            this.boxedHeight.setEnabled(false);
            this.boxedHeight.setBackground(this.getBackground());
            this.xOffset.setEnabled(true);
            this.yOffset.setEnabled(true);
        }
    }

    private void seeNodeActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        Cell cell = wf.getContent().getCell();
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        if (this.owner instanceof Export) {
            wnd.getHighlighter().addElectricObject(((Export)this.owner).getOriginalPort(), cell);
        } else {
            wnd.getHighlighter().addElectricObject(this.owner, cell);
        }
        wnd.getHighlighter().finished();
    }

    private static class ChangeText
    extends Job {
        private TextDescriptor td;
        private ElectricObject owner;
        private NodeInst unTransformNi;
        private String futureVar;
        private TextDescriptor.Size size;
        private TextDescriptor.Position position;
        private double boxedWidth;
        private double boxedHeight;
        private TextDescriptor.Rotation rotation;
        private String font;
        private double xoffset;
        private double yoffset;
        private boolean italic;
        private boolean bold;
        private boolean underline;
        private boolean invis;
        private int newColorIndex;

        private ChangeText(TextDescriptor td, ElectricObject owner, NodeInst unTransformNi, String futureVar, TextDescriptor.Size size, TextDescriptor.Position position, double boxedWidth, double boxedHeight, TextDescriptor.Rotation rotation, String font, double xoffset, double yoffset, boolean italic, boolean bold, boolean underline, boolean invis, int newColorIndex) {
            super("Modify Text", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.td = td;
            this.owner = owner;
            this.unTransformNi = unTransformNi;
            this.futureVar = futureVar;
            this.size = size;
            this.position = position;
            this.boxedWidth = boxedWidth;
            this.boxedHeight = boxedHeight;
            this.rotation = rotation;
            this.font = font;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
            this.italic = italic;
            this.bold = bold;
            this.underline = underline;
            this.invis = invis;
            this.newColorIndex = newColorIndex;
            this.startJob();
        }

        public boolean doIt() {
            NodeInst ni;
            if (this.td == null) {
                Variable var = this.owner.getVar(this.futureVar);
                if (var == null) {
                    return false;
                }
                this.td = var.getTextDescriptor();
            }
            if (this.size.isAbsolute()) {
                this.td.setAbsSize((int)this.size.getSize());
            } else {
                this.td.setRelSize(this.size.getSize());
            }
            this.td.setPos(this.position);
            if (this.owner instanceof NodeInst) {
                ni = (NodeInst)this.owner;
                if (this.position == TextDescriptor.Position.BOXED) {
                    ni.modifyInstance(0.0, 0.0, this.boxedWidth - ni.getXSize(), this.boxedHeight - ni.getYSize(), 0);
                } else if (ni.getProto() == Generic.tech.invisiblePinNode && (ni.getXSize() != 0.0 || ni.getYSize() != 0.0)) {
                    ni.modifyInstance(0.0, 0.0, -ni.getXSize(), -ni.getYSize(), 0);
                }
            }
            this.td.setRotation(this.rotation);
            if (this.owner instanceof NodeInst) {
                ni = (NodeInst)this.owner;
                if (ni.getProto() == Generic.tech.invisiblePinNode) {
                    double dX = this.xoffset - ni.getAnchorCenterX();
                    double dY = this.yoffset - ni.getAnchorCenterY();
                    ni.modifyInstance(dX, dY, 0.0, 0.0, 0);
                } else {
                    this.td.setOff(this.xoffset, this.yoffset);
                }
            } else {
                if (this.unTransformNi != null) {
                    Point2D.Double off = new Point2D.Double(this.xoffset, this.yoffset);
                    AffineTransform trans = this.unTransformNi.pureRotateIn();
                    trans.transform(off, off);
                    this.xoffset = ((Point2D)off).getX();
                    this.yoffset = ((Point2D)off).getY();
                }
                this.td.setOff(this.xoffset, this.yoffset);
            }
            this.td.setInterior(this.invis);
            if (this.font.equals("DEFAULT FONT")) {
                this.td.setFace(0);
            } else {
                TextDescriptor.ActiveFont newFont = TextDescriptor.ActiveFont.findActiveFont(this.font);
                int newFontIndex = newFont.getIndex();
                this.td.setFace(newFontIndex);
            }
            this.td.setItalic(this.italic);
            this.td.setBold(this.bold);
            this.td.setUnderline(this.underline);
            this.td.setColorIndex(this.newColorIndex);
            return true;
        }
    }
}

