/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.utils;

import com.sun.electric.plugins.j3d.ui.J3DViewDialog;
import com.sun.electric.tool.Job;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class J3DClientApp
extends Job {
    private J3DViewDialog dialog;
    private String hostname;

    public J3DClientApp(J3DViewDialog dialog, String hostname) {
        super("Socket Connection", null, Job.Type.EXAMINE, null, null, Job.Priority.ANALYSIS);
        this.dialog = dialog;
        this.hostname = hostname;
    }

    public void killJob() {
        this.abort();
        this.checkAbort();
        this.remove();
    }

    public boolean doIt() {
        try {
            DatagramSocket socket = new DatagramSocket();
            InetAddress address = InetAddress.getByName(this.hostname);
            String localHost = address.getHostName();
            int bufferLenght = 256;
            byte[] inBuffer = new byte[bufferLenght];
            DatagramPacket inDatagram = new DatagramPacket(inBuffer, inBuffer.length);
            boolean finished = false;
            while (!finished) {
                byte[] outBuffer = new byte[bufferLenght];
                outBuffer = this.dialog.getToggleInfo().getBytes();
                DatagramPacket outDatagram = new DatagramPacket(outBuffer, outBuffer.length, address, 2345);
                socket.send(outDatagram);
                System.out.println("Sent request to " + localHost + " at port 2345");
                socket.receive(inDatagram);
                InetAddress destAddress = inDatagram.getAddress();
                String destHost = destAddress.getHostName().trim();
                int destPort = inDatagram.getPort();
                System.out.println("Received a datagram from " + destHost + " at port" + destPort);
                String inData = new String(inDatagram.getData()).trim();
                System.out.println("It contained inData '" + inData);
                if (inData.equalsIgnoreCase("quit")) {
                    finished = true;
                    continue;
                }
                this.dialog.socketAction(inData);
                finished = this.checkAbort();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return true;
    }
}

