/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.generator.layout.GateLayGenSettings;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GateLayGenTab
extends ProjSettingsPanel {
    public static final long serialVersionUID = 0L;
    Frame parent;
    private Setting foundrySetting = GateLayGenSettings.getFoundrySetting();
    private Setting enableNCCSetting = GateLayGenSettings.getEnableNCCSetting();
    private Setting sizeQuantizationErrorSetting = GateLayGenSettings.getSizeQuantizationErrorSetting();
    private Setting maxMosWidthSetting = GateLayGenSettings.getMaxMosWidthSetting();
    private Setting vddYSetting = GateLayGenSettings.getVddYSetting();
    private Setting gndYSetting = GateLayGenSettings.getGndYSetting();
    private Setting nmosWellHeightSetting = GateLayGenSettings.getNmosWellHeightSetting();
    private Setting pmosWellHeightSetting = GateLayGenSettings.getPmosWellHeightSetting();
    private Setting simpleNameSetting = GateLayGenSettings.getSimpleNameSetting();
    private JLabel gndyLabel;
    private JTextField gndyText;
    private JButton help1;
    private JButton help2;
    private JButton help3;
    private JButton help4;
    private JButton help5;
    private JButton help6;
    private JButton help7;
    private JButton help8;
    private JComboBox libCombo;
    private JLabel libLabel;
    private JLabel maxMosLabel;
    private JTextField mosWidthText;
    private JCheckBox nccCheck;
    private JLabel nmoswellLabel;
    private JTextField nmoswellText;
    private JLabel pmoswellLabel;
    private JTextField pmoswellText;
    private JLabel quantLabel;
    private JTextField quantText;
    private JButton reset;
    private JCheckBox simpleNameCheck;
    private JComboBox techCombo;
    private JLabel techLabel;
    private JLabel vddyLabel;
    private JTextField vddyText;

    public GateLayGenTab(ProjectSettingsFrame parent, boolean modal) {
        super(parent, modal);
        this.parent = (Frame)parent.getOwner();
        this.initComponents();
        this.initializeFields();
    }

    void initializeFields() {
        this.techCombo.setSelectedItem(this.getString(this.foundrySetting));
        this.libCombo.setSelectedItem(this.getString(this.enableNCCSetting));
        this.quantText.setText(String.valueOf(this.getInt(this.sizeQuantizationErrorSetting)));
        this.mosWidthText.setText(String.valueOf(this.getInt(this.maxMosWidthSetting)));
        this.vddyText.setText(String.valueOf(this.getInt(this.vddYSetting)));
        this.gndyText.setText(String.valueOf(this.getInt(this.gndYSetting)));
        this.nmoswellText.setText(String.valueOf(this.getInt(this.nmosWellHeightSetting)));
        this.pmoswellText.setText(String.valueOf(this.getInt(this.pmosWellHeightSetting)));
        this.simpleNameCheck.setSelected(this.getBoolean(this.simpleNameSetting));
    }

    @Override
    public JPanel getPanel() {
        return (JPanel)this.getContentPane();
    }

    @Override
    public String getName() {
        return "Gate Layout Generator";
    }

    private void initComponents() {
        this.techLabel = new JLabel();
        this.techCombo = new JComboBox();
        this.nccCheck = new JCheckBox();
        this.nccCheck.setSelected(true);
        this.libLabel = new JLabel();
        this.libCombo = new JComboBox();
        this.help1 = new JButton();
        this.quantLabel = new JLabel();
        this.quantText = new JTextField();
        this.maxMosLabel = new JLabel();
        this.help2 = new JButton();
        this.mosWidthText = new JTextField();
        this.help3 = new JButton();
        this.vddyLabel = new JLabel();
        this.vddyText = new JTextField();
        this.help4 = new JButton();
        this.gndyLabel = new JLabel();
        this.gndyText = new JTextField();
        this.help5 = new JButton();
        this.nmoswellLabel = new JLabel();
        this.nmoswellText = new JTextField();
        this.help6 = new JButton();
        this.pmoswellLabel = new JLabel();
        this.pmoswellText = new JTextField();
        this.help7 = new JButton();
        this.simpleNameCheck = new JCheckBox();
        this.help8 = new JButton();
        this.reset = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setForeground(Color.white);
        this.techLabel.setText("Technology");
        this.techLabel.setHorizontalTextPosition(10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.techLabel, gridBagConstraints);
        this.techCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"MOCMOS", "CMOS90", "TSMC180"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.techCombo, gridBagConstraints);
        this.nccCheck.setText("Enable NCC");
        this.nccCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.nccCheck.setHorizontalTextPosition(10);
        this.nccCheck.setMargin(new Insets(0, 0, 0, 0));
        this.nccCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.nccCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.nccCheck, gridBagConstraints);
        this.libLabel.setText("Reference Library");
        this.libLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.libLabel, gridBagConstraints);
        this.libCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"PurpleFour", "RedFour"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.libCombo, gridBagConstraints);
        this.help1.setText("?");
        this.help1.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.help1.setHorizontalAlignment(2);
        this.help1.setMargin(new Insets(0, 0, 0, 0));
        this.help1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.help1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 10);
        this.getContentPane().add((Component)this.help1, gridBagConstraints);
        this.quantLabel.setText("Quantization Error");
        this.quantLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.quantLabel, gridBagConstraints);
        this.quantText.setHorizontalAlignment(0);
        this.quantText.setMinimumSize(new Dimension(5, 19));
        this.quantText.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.quantText, gridBagConstraints);
        this.maxMosLabel.setText("Maximum MOS Width");
        this.maxMosLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.maxMosLabel, gridBagConstraints);
        this.help2.setText("?");
        this.help2.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.help2.setHorizontalAlignment(2);
        this.help2.setMargin(new Insets(0, 0, 0, 0));
        this.help2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.help2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.help2, gridBagConstraints);
        this.mosWidthText.setHorizontalAlignment(0);
        this.mosWidthText.setMinimumSize(new Dimension(5, 19));
        this.mosWidthText.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.mosWidthText, gridBagConstraints);
        this.help3.setText("?");
        this.help3.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.help3.setHorizontalAlignment(2);
        this.help3.setMargin(new Insets(0, 0, 0, 0));
        this.help3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.help3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.help3, gridBagConstraints);
        this.vddyLabel.setText("Vdd Y Coordinate");
        this.vddyLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.vddyLabel, gridBagConstraints);
        this.vddyText.setHorizontalAlignment(0);
        this.vddyText.setMinimumSize(new Dimension(5, 5));
        this.vddyText.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.vddyText, gridBagConstraints);
        this.help4.setText("?");
        this.help4.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.help4.setHorizontalAlignment(2);
        this.help4.setMargin(new Insets(0, 0, 0, 0));
        this.help4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.help4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.help4, gridBagConstraints);
        this.gndyLabel.setText("Gnd Y Corodinate");
        this.gndyLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.gndyLabel, gridBagConstraints);
        this.gndyText.setHorizontalAlignment(0);
        this.gndyText.setMinimumSize(new Dimension(5, 19));
        this.gndyText.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.gndyText, gridBagConstraints);
        this.help5.setText("?");
        this.help5.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.help5.setHorizontalAlignment(2);
        this.help5.setMargin(new Insets(0, 0, 0, 0));
        this.help5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.help5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.help5, gridBagConstraints);
        this.nmoswellLabel.setText("NMOS Well Height");
        this.nmoswellLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.nmoswellLabel, gridBagConstraints);
        this.nmoswellText.setHorizontalAlignment(0);
        this.nmoswellText.setMinimumSize(new Dimension(5, 19));
        this.nmoswellText.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.nmoswellText, gridBagConstraints);
        this.help6.setText("?");
        this.help6.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.help6.setHorizontalAlignment(2);
        this.help6.setMargin(new Insets(0, 0, 0, 0));
        this.help6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.help6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.help6, gridBagConstraints);
        this.pmoswellLabel.setText("PMOS Well Height");
        this.pmoswellLabel.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.pmoswellLabel, gridBagConstraints);
        this.pmoswellText.setHorizontalAlignment(0);
        this.pmoswellText.setMinimumSize(new Dimension(5, 19));
        this.pmoswellText.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.pmoswellText, gridBagConstraints);
        this.help7.setText("?");
        this.help7.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.help7.setHorizontalAlignment(2);
        this.help7.setMargin(new Insets(0, 0, 0, 0));
        this.help7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.help7ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.help7, gridBagConstraints);
        this.simpleNameCheck.setText("Simple Name");
        this.simpleNameCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.simpleNameCheck.setHorizontalTextPosition(10);
        this.simpleNameCheck.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 50);
        this.getContentPane().add((Component)this.simpleNameCheck, gridBagConstraints);
        this.help8.setText("?");
        this.help8.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.help8.setHorizontalAlignment(2);
        this.help8.setMargin(new Insets(0, 0, 0, 0));
        this.help8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.help8ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.help8, gridBagConstraints);
        this.reset.setText("Reset");
        this.reset.setToolTipText("Updates global Auto. Layout Gen. settings");
        this.reset.setHorizontalAlignment(2);
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GateLayGenTab.this.resetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.getContentPane().add((Component)this.reset, gridBagConstraints);
        this.pack();
    }

    private void help8ActionPerformed(ActionEvent evt) {
    }

    private void help7ActionPerformed(ActionEvent evt) {
    }

    private void help6ActionPerformed(ActionEvent evt) {
    }

    private void help5ActionPerformed(ActionEvent evt) {
    }

    private void help1ActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this.parent, "check Enable NCC and select a library. After generating layout, NCC uses this library as a reference");
    }

    private void help2ActionPerformed(ActionEvent evt) {
    }

    private void help3ActionPerformed(ActionEvent evt) {
    }

    private void help4ActionPerformed(ActionEvent evt) {
    }

    private void resetActionPerformed(ActionEvent evt) {
        this.initializeFields();
    }

    @Override
    public void term() {
        if (!this.fieldsAreValid()) {
            return;
        }
        this.setString(this.foundrySetting, (String)this.techCombo.getSelectedItem());
        String newNccCheck = this.nccCheck.isSelected() ? (String)this.libCombo.getSelectedItem() : "";
        this.setString(this.enableNCCSetting, newNccCheck);
        this.setInt(this.sizeQuantizationErrorSetting, Integer.parseInt(this.quantText.getText()));
        this.setInt(this.maxMosWidthSetting, Integer.parseInt(this.mosWidthText.getText()));
        this.setInt(this.vddYSetting, Integer.parseInt(this.vddyText.getText()));
        this.setInt(this.gndYSetting, Integer.parseInt(this.gndyText.getText()));
        this.setInt(this.nmosWellHeightSetting, Integer.parseInt(this.nmoswellText.getText()));
        this.setInt(this.pmosWellHeightSetting, Integer.parseInt(this.pmoswellText.getText()));
        this.setBoolean(this.simpleNameSetting, this.simpleNameCheck.isSelected());
    }

    private boolean fieldsAreValid() {
        String param = new String();
        try {
            if (this.nccCheck.isSelected() && (param = (String)this.libCombo.getSelectedItem()).equals("")) {
                throw new EmptyFieldException("Library Reference");
            }
            param = this.quantText.getText();
            if (param.equals("")) {
                throw new EmptyFieldException("Quantization Error");
            }
            param = this.mosWidthText.getText();
            if (param.equals("")) {
                throw new EmptyFieldException("Maximum MOS Width");
            }
            param = this.vddyText.getText();
            if (param.equals("")) {
                throw new EmptyFieldException("VDD Y Coordinate");
            }
            param = this.gndyText.getText();
            if (param.equals("")) {
                throw new EmptyFieldException("Gnd Y Coordinate");
            }
            param = this.nmoswellText.getText();
            if (param.equals("")) {
                throw new EmptyFieldException("NMOS Well Height");
            }
            param = this.pmoswellText.getText();
            if (param.equals("")) {
                throw new EmptyFieldException("PMOS Well Height");
            }
        }
        catch (EmptyFieldException e) {
            JOptionPane.showMessageDialog(this.parent, "Cannot leave " + e.error + " blank!");
            return false;
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this.parent, "Non-numeric value entered in a numeric field!");
            return false;
        }
        return true;
    }

    private void nccCheckActionPerformed(ActionEvent evt) {
        boolean check = this.nccCheck.isSelected();
        this.libLabel.setEnabled(check);
        this.libCombo.setEnabled(check);
    }

    private class EmptyFieldException
    extends Exception {
        public static final long serialVersionUID = 0L;
        String error = new String();

        EmptyFieldException(String error) {
            this.error = error;
        }
    }
}

