/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LEFDEF;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LEF
extends LEFDEF {
    protected static final boolean PLACEGEOMETRY = true;
    protected static final boolean PLACEEXPORTS = true;
    protected static final boolean PLACEONLYMETAL = false;
    private LEFPreferences localPrefs;

    LEF(EditingPreferences ep, LEFPreferences ap) {
        super(ep);
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.initializeLEFDEF(tech);
        widthsFromLEF = new HashMap();
        this.initKeywordParsing();
        try {
            if (this.readFile(lib)) {
                return null;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR reading LEF libraries");
        }
        return lib;
    }

    @Override
    protected String preprocessLine(String line) {
        int sharpPos = line.indexOf(35);
        if (sharpPos >= 0) {
            return line.substring(0, sharpPos);
        }
        return line;
    }

    private boolean readFile(Library lib) throws IOException {
        String key;
        while ((key = this.getAKeyword()) != null) {
            if (key.equalsIgnoreCase("LAYER") && this.readLayer()) {
                return true;
            }
            if (key.equalsIgnoreCase("MACRO") && this.readMacro(lib)) {
                return true;
            }
            if (key.equalsIgnoreCase("VIA") && this.readVia(lib)) {
                return true;
            }
            if (key.equalsIgnoreCase("VIARULE") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("ARRAY")) {
                String name = this.getAKeyword();
                this.ignoreToEnd(name);
                continue;
            }
            if (key.equalsIgnoreCase("SPACING") || key.equalsIgnoreCase("PROPERTYDEFINITIONS")) {
                this.ignoreToEnd(key);
                continue;
            }
            if (!key.equalsIgnoreCase("MINFEATURE")) continue;
            this.ignoreToSemicolon(key);
        }
        return false;
    }

    private boolean readVia(Library lib) throws IOException {
        String key;
        Cell cell;
        LEFDEF.ViaDef vd;
        block24: {
            String viaName = this.getAKeyword();
            if (viaName == null) {
                return true;
            }
            vd = new LEFDEF.ViaDef(viaName, null);
            viaDefsFromLEF.put(viaName.toLowerCase(), vd);
            cell = null;
            String cellName = viaName + "{lay}";
            cell = Cell.makeInstance(this.ep, lib, cellName);
            if (cell == null) {
                System.out.println("Cannot create via cell '" + cellName + "'");
                return true;
            }
            boolean ignoreDefault = true;
            LEFDEF.GetLayerInformation li = null;
            while (true) {
                if ((key = this.getAKeyword()) == null) {
                    return true;
                }
                if (ignoreDefault) {
                    ignoreDefault = false;
                    if (key.equalsIgnoreCase("DEFAULT")) continue;
                }
                if (key.equalsIgnoreCase("END")) break block24;
                if (key.equalsIgnoreCase("RESISTANCE")) {
                    if (!this.ignoreToSemicolon(key)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    li = this.getLayerInformation(key);
                    if (li.arc != null) {
                        if (vd.gLay1 == null) {
                            vd.gLay1 = li;
                        } else {
                            vd.gLay2 = li;
                        }
                    }
                    if (!this.ignoreToSemicolon("LAYER")) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double lX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double lY = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double hX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double hY = this.convertLEFString(key);
                if (hX - lX > vd.sX) {
                    vd.sX = hX - lX;
                }
                if (hY - lY > vd.sY) {
                    vd.sY = hY - lY;
                }
                if (cell != null) {
                    double sY;
                    NodeProto np = li.pure;
                    if (np == null) {
                        System.out.println("Line " + this.lineReader.getLineNumber() + ": No layer '" + li.name + "' defined for RECT");
                        return true;
                    }
                    Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                    double sX = Math.abs(hX - lX);
                    NodeInst ni = NodeInst.makeInstance(np, this.ep, ctr, sX, sY = Math.abs(hY - lY), cell);
                    if (ni == null) {
                        System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create node for RECT");
                        return true;
                    }
                }
                if (this.ignoreToSemicolon("RECT")) break;
            }
            return true;
        }
        key = this.getAKeyword();
        if (cell != null) {
            Point2D.Double ctr = new Point2D.Double(0.0, 0.0);
            PrimitiveNode pnp = Generic.tech().universalPinNode;
            NodeInst ni = NodeInst.makeInstance(pnp, this.ep, ctr, pnp.getDefWidth(this.ep), pnp.getDefHeight(this.ep), cell);
            PortInst pi = ni.getOnlyPortInst();
            Export e = Export.newInstance(cell, pi, "viaPort", this.ep);
            if (vd.gLay1 != null && vd.gLay2 != null) {
                String[] preferredArcs = new String[]{vd.gLay1.arc.getFullName(), vd.gLay2.arc.getFullName()};
                e.newVar(Export.EXPORT_PREFERRED_ARCS, (Object)preferredArcs, this.ep);
            }
        }
        if (vd.gLay1 != null && vd.gLay2 != null) {
            Iterator<PrimitiveNode> it = this.curTech.getNodes();
            while (it.hasNext()) {
                PrimitivePort pp;
                PrimitiveNode np = it.next();
                if (!np.getFunction().isContact() || !(pp = np.getPort(0)).connectsTo(vd.gLay1.arc) || !pp.connectsTo(vd.gLay2.arc)) continue;
                vd.via = np;
                break;
            }
        }
        return false;
    }

    private boolean readMacro(Library lib) throws IOException {
        String key;
        block18: {
            block19: {
                String cellName = this.getAKeyword();
                if (cellName == null) {
                    System.out.println("EOF parsing MACRO header");
                    return true;
                }
                Cell cell = Cell.makeInstance(this.ep, lib, cellName = cellName + "{lay}");
                if (cell == null) {
                    System.out.println("Cannot create cell '" + cellName + "'");
                    return true;
                }
                while (true) {
                    if ((key = this.getAKeyword()) == null) {
                        System.out.println("EOF parsing MACRO");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block18;
                    if (key.equalsIgnoreCase("SOURCE") || key.equalsIgnoreCase("FOREIGN") || key.equalsIgnoreCase("SYMMETRY") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("CLASS") || key.equalsIgnoreCase("LEQ") || key.equalsIgnoreCase("POWER") || key.equalsIgnoreCase("PROPERTY")) {
                        if (!this.ignoreToSemicolon(key)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("ORIGIN")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading ORIGIN X");
                            return true;
                        }
                        double oX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading ORIGIN Y");
                            return true;
                        }
                        double oY = this.convertLEFString(key);
                        if (this.ignoreToSemicolon("ORIGIN")) {
                            return true;
                        }
                        Geometric ccNi = null;
                        Iterator<NodeInst> it = cell.getNodes();
                        while (it.hasNext()) {
                            NodeInst ni = it.next();
                            if (!Generic.isCellCenter(ni)) continue;
                            ccNi = ni;
                            break;
                        }
                        if (ccNi == null) {
                            double sY;
                            double sX = Generic.tech().cellCenterNode.getDefWidth(this.ep);
                            ccNi = NodeInst.makeInstance(Generic.tech().cellCenterNode, this.ep, new Point2D.Double(oX, oY), sX, sY = Generic.tech().cellCenterNode.getDefHeight(this.ep), cell);
                            if (ccNi == null) {
                                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create cell center node");
                                return true;
                            }
                            ((NodeInst)ccNi).setHardSelect();
                            ((NodeInst)ccNi).setVisInside();
                            continue;
                        }
                        double dX = oX - ccNi.getTrueCenterX();
                        double dY = oY - ccNi.getTrueCenterY();
                        ((NodeInst)ccNi).move(dX, dY);
                        continue;
                    }
                    if (key.equalsIgnoreCase("SIZE")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE X");
                            return true;
                        }
                        double wid = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE 'BY'");
                            return true;
                        }
                        if (!key.equalsIgnoreCase("BY")) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Expected 'by' in SIZE");
                            return true;
                        }
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading SIZE Y");
                            return true;
                        }
                        double hei = this.convertLEFString(key);
                        cell.newVar(prXkey, (Object)new Double(wid), this.ep);
                        cell.newVar(prYkey, (Object)new Double(hei), this.ep);
                        if (!this.ignoreToSemicolon("SIZE")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("PIN")) {
                        if (!this.readPin(cell)) continue;
                        return true;
                    }
                    if (!key.equalsIgnoreCase("OBS")) break block19;
                    if (this.readObs(cell)) break;
                }
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown MACRO keyword (" + key + ")");
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readObs(Cell cell) throws IOException {
        NodeProto np = null;
        LEFDEF.GetLayerInformation li = null;
        while (true) {
            double sY;
            String key;
            if ((key = this.getAKeyword()) == null) {
                System.out.println("EOF parsing OBS");
                return true;
            }
            if (key.equalsIgnoreCase("END")) break;
            if (key.equalsIgnoreCase("LAYER")) {
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading LAYER clause");
                    return true;
                }
                li = this.getLayerInformation(key);
                np = li.pure;
                if (li.layerFun == Layer.Function.UNKNOWN || np == null) {
                    System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown layer name (" + key + ")");
                    return true;
                }
                if (!this.ignoreToSemicolon("LAYER")) continue;
                return true;
            }
            if (key.equalsIgnoreCase("RECT")) {
                double sY2;
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT low X");
                    return true;
                }
                double lX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT low Y");
                    return true;
                }
                double lY = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT high X");
                    return true;
                }
                double hX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF reading RECT high Y");
                    return true;
                }
                double hY = this.convertLEFString(key);
                if (this.ignoreToSemicolon("RECT")) {
                    return true;
                }
                if (np == null) {
                    System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for RECT");
                    return true;
                }
                Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                double sX = Math.abs(hX - lX);
                NodeInst ni = NodeInst.makeInstance(np, this.ep, ctr, sX, sY2 = Math.abs(hY - lY), cell);
                if (ni != null) continue;
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create node for RECT");
                return true;
            }
            if (!key.equalsIgnoreCase("POLYGON")) continue;
            List<Point2D> points = this.readPolygon();
            if (points == null) {
                return true;
            }
            if (np == null) {
                System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for POLYGON");
                return true;
            }
            double lX = 0.0;
            double lY = 0.0;
            double hX = 0.0;
            double hY = 0.0;
            for (int i = 0; i < points.size(); ++i) {
                Point2D pt = points.get(i);
                if (i == 0) {
                    lX = hX = pt.getX();
                    lY = hY = pt.getY();
                    continue;
                }
                if (pt.getX() < lX) {
                    lX = pt.getX();
                }
                if (pt.getX() > hX) {
                    hX = pt.getX();
                }
                if (pt.getY() < lY) {
                    lY = pt.getY();
                }
                if (!(pt.getY() > hY)) continue;
                hY = pt.getY();
            }
            Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
            double sX = Math.abs(hX - lX);
            NodeInst ni = NodeInst.makeInstance(np, this.ep, ctr, sX, sY = Math.abs(hY - lY), cell);
            if (ni == null) {
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for POLYGON");
                return true;
            }
            Point2D[] outline = new Point2D[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                outline[i] = EPoint.fromLambda(points.get(i).getX() - ((Point2D)ctr).getX(), points.get(i).getY() - ((Point2D)ctr).getY());
            }
            ni.setTrace(outline);
        }
        return false;
    }

    private boolean readPin(Cell cell) throws IOException {
        String key;
        block22: {
            block23: {
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF parsing PIN name");
                    return true;
                }
                String pinName = key.replace('<', '[').replace('>', ']');
                PortCharacteristic useCharacteristics = PortCharacteristic.UNKNOWN;
                PortCharacteristic portCharacteristics = PortCharacteristic.UNKNOWN;
                while (true) {
                    if ((key = this.getAKeyword()) == null) {
                        System.out.println("EOF parsing PIN");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block22;
                    if (key.equalsIgnoreCase("SHAPE") || key.equalsIgnoreCase("CAPACITANCE") || key.equalsIgnoreCase("ANTENNASIZE") || key.equalsIgnoreCase("ANTENNADIFFAREA") || key.equalsIgnoreCase("ANTENNAMODEL") || key.equalsIgnoreCase("ANTENNAGATEAREA") || key.equalsIgnoreCase("ANTENNAPARTIALCUTAREA") || key.equalsIgnoreCase("ANTENNAMAXAREACAR") || key.equalsIgnoreCase("ANTENNAMAXCUTCAR") || key.equalsIgnoreCase("PROPERTY")) {
                        if (!this.ignoreToSemicolon(key)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("USE")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading USE clause");
                            return true;
                        }
                        if (key.equalsIgnoreCase("POWER")) {
                            useCharacteristics = PortCharacteristic.PWR;
                        } else if (key.equalsIgnoreCase("GROUND")) {
                            useCharacteristics = PortCharacteristic.GND;
                        } else if (key.equalsIgnoreCase("CLOCK")) {
                            useCharacteristics = PortCharacteristic.CLK;
                        } else if (!key.equalsIgnoreCase("SIGNAL") && !key.equalsIgnoreCase("DATA")) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown USE keyword (" + key + ")");
                        }
                        if (!this.ignoreToSemicolon("USE")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("DIRECTION")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading DIRECTION clause");
                            return true;
                        }
                        if (key.equalsIgnoreCase("INPUT")) {
                            portCharacteristics = PortCharacteristic.IN;
                        } else if (key.equalsIgnoreCase("OUTPUT")) {
                            portCharacteristics = PortCharacteristic.OUT;
                        } else if (key.equalsIgnoreCase("INOUT")) {
                            portCharacteristics = PortCharacteristic.BIDIR;
                        } else {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown DIRECTION keyword (" + key + ")");
                        }
                        if (!this.ignoreToSemicolon("DIRECTION")) continue;
                        return true;
                    }
                    if (!key.equalsIgnoreCase("PORT")) break block23;
                    if (useCharacteristics != PortCharacteristic.UNKNOWN) {
                        portCharacteristics = useCharacteristics;
                    }
                    if (this.readPort(cell, pinName, portCharacteristics)) break;
                }
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown PIN keyword (" + key + ")");
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readPort(Cell cell, String portname, PortCharacteristic portCharacteristics) throws IOException {
        PrimitiveNode pin;
        Point2D.Double singlePathPoint;
        boolean first;
        LEFPath lefPaths;
        ArcProto ap;
        block53: {
            String key;
            block54: {
                ap = null;
                NodeProto pureNp = null;
                lefPaths = null;
                first = true;
                double intWidth = 0.0;
                double lastIntX = 0.0;
                double lastIntY = 0.0;
                singlePathPoint = null;
                LEFDEF.GetLayerInformation li = null;
                block0: while (true) {
                    double sY;
                    if ((key = this.getAKeyword()) == null) {
                        System.out.println("EOF parsing PORT");
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block53;
                    if (key.equalsIgnoreCase("CLASS")) {
                        if (!this.ignoreToSemicolon("LAYER")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("LAYER")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading LAYER clause");
                            return true;
                        }
                        li = this.getLayerInformation(key);
                        ap = li.arc;
                        pureNp = li.pure;
                        if (!this.ignoreToSemicolon("LAYER")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("WIDTH")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading WIDTH clause");
                            return true;
                        }
                        intWidth = this.convertLEFString(key);
                        if (!this.ignoreToSemicolon("WIDTH")) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("POLYGON")) {
                        double sY2;
                        List<Point2D> points = this.readPolygon();
                        if (points == null) {
                            return true;
                        }
                        if (pureNp == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for POLYGON");
                            return true;
                        }
                        double lX = 0.0;
                        double lY = 0.0;
                        double hX = 0.0;
                        double hY = 0.0;
                        for (int i = 0; i < points.size(); ++i) {
                            Point2D pt = points.get(i);
                            if (i == 0) {
                                lX = hX = pt.getX();
                                lY = hY = pt.getY();
                                continue;
                            }
                            if (pt.getX() < lX) {
                                lX = pt.getX();
                            }
                            if (pt.getX() > hX) {
                                hX = pt.getX();
                            }
                            if (pt.getY() < lY) {
                                lY = pt.getY();
                            }
                            if (!(pt.getY() > hY)) continue;
                            hY = pt.getY();
                        }
                        Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                        double sX = Math.abs(hX - lX);
                        NodeInst ni = NodeInst.makeInstance(pureNp, this.ep, ctr, sX, sY2 = Math.abs(hY - lY), cell);
                        if (ni == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for POLYGON");
                            return true;
                        }
                        Point2D[] outline = new Point2D[points.size()];
                        for (int i = 0; i < points.size(); ++i) {
                            outline[i] = EPoint.fromLambda(points.get(i).getX() - ((Point2D)ctr).getX(), points.get(i).getY() - ((Point2D)ctr).getY());
                        }
                        ni.setTrace(outline);
                        if (!first) continue;
                        first = false;
                        Export pp = this.newPort(cell, ni, pureNp.getPort(0), portname);
                        if (pp == null) continue;
                        pp.setCharacteristic(portCharacteristics);
                        continue;
                    }
                    if (key.equalsIgnoreCase("RECT")) {
                        double sY3;
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT low X");
                            return true;
                        }
                        double lX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT low Y");
                            return true;
                        }
                        double lY = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT high X");
                            return true;
                        }
                        double hX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            System.out.println("EOF reading RECT high Y");
                            return true;
                        }
                        double hY = this.convertLEFString(key);
                        if (this.ignoreToSemicolon("RECT")) {
                            return true;
                        }
                        if (pureNp == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": No layers for RECT");
                            return true;
                        }
                        Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                        double sX = Math.abs(hX - lX);
                        NodeInst ni = NodeInst.makeInstance(pureNp, this.ep, ctr, sX, sY3 = Math.abs(hY - lY), cell);
                        if (ni == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for RECT");
                            return true;
                        }
                        if (!first) continue;
                        first = false;
                        Export pp = this.newPort(cell, ni, pureNp.getPort(0), portname);
                        if (pp == null) continue;
                        pp.setCharacteristic(portCharacteristics);
                        continue;
                    }
                    if (key.equalsIgnoreCase("PATH")) {
                        if (ap == null) {
                            System.out.println("Line " + this.lineReader.getLineNumber() + ": No arc associated to layer '" + li.name + "' for PATH definition");
                            return true;
                        }
                        int i = 0;
                        while (true) {
                            if ((key = this.getAKeyword()) == null) {
                                System.out.println("EOF reading PATH clause");
                                return true;
                            }
                            if (key.equals(";")) continue block0;
                            double intx = this.convertLEFString(key);
                            key = this.getAKeyword();
                            if (key == null) {
                                System.out.println("EOF reading PATH clause");
                                return true;
                            }
                            double inty = this.convertLEFString(key);
                            if (i == 0) {
                                singlePathPoint = new Point2D.Double(intx, inty);
                            } else {
                                LEFPath lp = new LEFPath();
                                ((LEFPath)lp).pt[0] = new Point2D.Double(lastIntX, lastIntY);
                                ((LEFPath)lp).pt[1] = new Point2D.Double(intx, inty);
                                ((LEFPath)lp).ni[0] = null;
                                ((LEFPath)lp).ni[1] = null;
                                lp.width = intWidth;
                                lp.arc = ap;
                                lp.nextLEFPath = lefPaths;
                                lefPaths = lp;
                            }
                            lastIntX = intx;
                            lastIntY = inty;
                            ++i;
                        }
                    }
                    if (!key.equalsIgnoreCase("VIA")) break block54;
                    key = this.getAKeyword();
                    if (key == null) {
                        System.out.println("EOF reading VIA clause");
                        return true;
                    }
                    double intX = this.convertLEFString(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        System.out.println("EOF reading VIA clause");
                        return true;
                    }
                    double intY = this.convertLEFString(key);
                    key = this.getAKeyword();
                    li = this.getLayerInformation(key);
                    if (li.pin == null) {
                        System.out.println("Line " + this.lineReader.getLineNumber() + ": No Via in current technology for '" + key + "'");
                        return true;
                    }
                    if (this.ignoreToSemicolon("VIA")) {
                        return true;
                    }
                    double sX = li.pin.getDefWidth(this.ep);
                    NodeInst ni = NodeInst.makeInstance(li.pin, this.ep, new Point2D.Double(intX, intY), sX, sY = li.pin.getDefHeight(this.ep), cell);
                    if (ni == null) break;
                }
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create VIA for PATH");
                return true;
            }
            System.out.println("Line " + this.lineReader.getLineNumber() + ": Unknown PORT keyword (" + key + ")");
            return true;
        }
        LEFPath lp = lefPaths;
        while (lp != null) {
            for (int i = 0; i < 2; ++i) {
                if (lp.ni[i] != null) continue;
                Rectangle2D.Double bounds = new Rectangle2D.Double(lp.pt[i].getX(), lp.pt[i].getY(), 0.0, 0.0);
                Iterator<Geometric> sea = cell.searchIterator(bounds);
                while (sea.hasNext()) {
                    NodeInst ni;
                    Geometric geom = sea.next();
                    if (!(geom instanceof NodeInst) || !DBMath.areEquals((ni = (NodeInst)geom).getTrueCenter(), lp.pt[i])) continue;
                    ((LEFPath)lp).ni[i] = ni;
                    break;
                }
                if (lp.ni[i] == null) continue;
                LEFPath oLp = lefPaths;
                while (oLp != null) {
                    for (int j = 0; j < 2; ++j) {
                        if (oLp.ni[j] != null || !DBMath.areEquals(oLp.pt[j], lp.pt[i])) continue;
                        ((LEFPath)oLp).ni[j] = lp.ni[i];
                    }
                    oLp = oLp.nextLEFPath;
                }
            }
            lp = lp.nextLEFPath;
        }
        lp = lefPaths;
        while (lp != null) {
            for (int i = 0; i < 2; ++i) {
                PrimitiveNode pin2;
                if (lp.ni[i] != null || (pin2 = lp.arc.findPinProto()) == null) continue;
                double sX = pin2.getDefWidth(this.ep);
                double sY = pin2.getDefHeight(this.ep);
                ((LEFPath)lp).ni[i] = NodeInst.makeInstance(pin2, this.ep, lp.pt[i], sX, sY, cell);
                if (lp.ni[i] == null) {
                    System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for PATH");
                    return true;
                }
                if (first) {
                    first = false;
                    Export pp = this.newPort(cell, lp.ni[i], pin2.getPort(0), portname);
                    if (pp != null) {
                        pp.setCharacteristic(portCharacteristics);
                    }
                }
                LEFPath oLp = lefPaths;
                while (oLp != null) {
                    for (int j = 0; j < 2; ++j) {
                        if (oLp.ni[j] != null || !DBMath.areEquals(oLp.pt[j], lp.pt[i])) continue;
                        ((LEFPath)oLp).ni[j] = lp.ni[i];
                    }
                    oLp = oLp.nextLEFPath;
                }
            }
            lp = lp.nextLEFPath;
        }
        lp = lefPaths;
        while (lp != null) {
            PortInst head2 = lp.ni[0].getPortInst(0);
            PortInst tail = lp.ni[1].getPortInst(0);
            Point2D headPt = lp.pt[0];
            Point2D tailPt = lp.pt[1];
            ArcInst ai = ArcInst.makeInstanceBase(lp.arc, this.ep, lp.width, head2, tail, headPt, tailPt, null);
            if (ai == null) {
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create arc for PATH");
                return true;
            }
            lp = lp.nextLEFPath;
        }
        if (lefPaths == null && singlePathPoint != null && ap != null && first && (pin = ap.findPinProto()) != null) {
            double sY;
            double sX = pin.getDefWidth(this.ep);
            NodeInst ni = NodeInst.makeInstance(pin, this.ep, singlePathPoint, sX, sY = pin.getDefHeight(this.ep), cell);
            if (ni == null) {
                System.out.println("Line " + this.lineReader.getLineNumber() + ": Cannot create pin for PATH");
                return true;
            }
            Export pp = this.newPort(cell, ni, pin.getPort(0), portname);
            if (pp != null) {
                pp.setCharacteristic(portCharacteristics);
            }
        }
        return false;
    }

    private Export newPort(Cell cell, NodeInst ni, PortProto pp, String thename) {
        String portName = thename;
        String newName = null;
        int i = 0;
        while (true) {
            Export e;
            if ((e = (Export)cell.findPortProto(portName)) == null) {
                PortInst pi = ni.findPortInstFromProto(pp);
                Export ex = Export.newInstance(cell, pi, portName, this.ep);
                return ex;
            }
            int sqPos = thename.indexOf(91);
            newName = sqPos < 0 ? thename + "-" + i : thename.substring(0, sqPos) + "-" + i + thename.substring(sqPos);
            portName = newName;
            ++i;
        }
    }

    private boolean readLayer() throws IOException {
        String key;
        double defWidth;
        String layerType;
        String layerName;
        block9: {
            layerName = this.getAKeyword();
            if (layerName == null) {
                System.out.println("EOF parsing LAYER header");
                return true;
            }
            layerType = null;
            defWidth = -1.0;
            while (true) {
                if ((key = this.getAKeyword()) == null) {
                    System.out.println("EOF parsing LAYER");
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block9;
                if (key.equalsIgnoreCase("WIDTH")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        System.out.println("EOF reading WIDTH");
                        return true;
                    }
                    defWidth = this.convertLEFString(key);
                    if (!this.ignoreToSemicolon("WIDTH")) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("TYPE")) {
                    layerType = this.getAKeyword();
                    if (!this.ignoreToSemicolon("TYPE")) continue;
                    return true;
                }
                if ((key.equalsIgnoreCase("SPACING") || key.equalsIgnoreCase("PITCH") || key.equalsIgnoreCase("DIRECTION") || key.equalsIgnoreCase("CAPACITANCE") || key.equalsIgnoreCase("RESISTANCE")) && this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(this, layerName, layerType);
        knownLayers.put(layerName, li);
        ArcProto ap = li.arc;
        if (defWidth > 0.0) {
            if (ap != null) {
                widthsFromLEF.put(ap, new Double(defWidth));
            } else {
                layerWidthsFromLEF.put(layerName, new Double(defWidth));
            }
        }
        return false;
    }

    private List<Point2D> readPolygon() throws IOException {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        while (true) {
            String key;
            if ((key = this.getAKeyword()) == null) {
                System.out.println("EOF reading POLYGON X coordinate");
                return null;
            }
            if (key.equals(";")) break;
            if (points.size() == 0 && key.equalsIgnoreCase("ITERATE")) continue;
            double x2 = this.convertLEFString(key);
            key = this.getAKeyword();
            if (key == null) {
                System.out.println("EOF reading POLYGON Y coordinate");
                return null;
            }
            if (key.equals(";")) break;
            double y = this.convertLEFString(key);
            points.add(new Point2D.Double(x2, y));
        }
        return points;
    }

    private boolean ignoreToSemicolon(String command) throws IOException {
        String key;
        do {
            if ((key = this.getAKeyword()) != null) continue;
            System.out.println("EOF parsing " + command);
            return true;
        } while (!key.equals(";"));
        return false;
    }

    private boolean ignoreToEnd(String endName) throws IOException {
        boolean findEnd = true;
        while (true) {
            String key;
            if ((key = this.getAKeyword()) == null) {
                System.out.println("EOF parsing " + endName);
                return true;
            }
            if (findEnd && key.equalsIgnoreCase("END")) {
                key = this.getAKeyword();
                if (key == null) {
                    System.out.println("EOF parsing " + endName);
                    return true;
                }
                if (!key.equals(endName)) continue;
                break;
            }
            if (key.equals(";")) {
                findEnd = true;
                continue;
            }
            findEnd = false;
        }
        return false;
    }

    private double convertLEFString(String key) {
        double v = TextUtils.atof(key) * 1.0;
        return TextUtils.convertFromDistance(v, this.curTech, TextUtils.UnitScale.MICRO);
    }

    protected boolean importTechFile() {
        this.initializeLEFDEF(null);
        layerWidthsFromLEF = new HashMap();
        this.initKeywordParsing();
        try {
            if (this.readTechnologyFile()) {
                return false;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR reading LEF tech file");
            return false;
        }
        return true;
    }

    private boolean readTechnologyFile() throws IOException {
        String key;
        while ((key = this.getAKeyword()) != null) {
            if (key.equalsIgnoreCase("LAYER")) {
                if (!this.readLayer()) continue;
                return true;
            }
            if (key.equalsIgnoreCase("VIA")) {
                this.ignoreToEnd(key);
                continue;
            }
            if (key.equalsIgnoreCase("VIARULE") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("ARRAY")) {
                String name = this.getAKeyword();
                this.ignoreToEnd(name);
                continue;
            }
            if (key.equalsIgnoreCase("VERSION") || key.equalsIgnoreCase("NAMESCASESENSITIVE") || key.equalsIgnoreCase("BUSBITCHARS") || key.equalsIgnoreCase("DIVIDERCHAR") || key.equalsIgnoreCase("MANUFACTURINGGRID")) {
                this.ignoreToSemicolon(key);
                continue;
            }
            if (!key.equalsIgnoreCase("UNITS")) continue;
            this.ignoreToEnd(key);
        }
        return false;
    }

    public static class LEFPreferences
    extends Input.InputPreferences {
        public LEFPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            LEF in = new LEF(ep, this);
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }

        public boolean doTechInput(URL fileURL, EditingPreferences ep) {
            LEF in = new LEF(ep, this);
            if (in.openTextInput(fileURL)) {
                return false;
            }
            boolean result2 = in.importTechFile();
            in.closeInput();
            return result2;
        }
    }

    private static class LEFPath {
        private Point2D[] pt = new Point2D[2];
        private NodeInst[] ni = new NodeInst[2];
        private double width;
        private ArcProto arc;
        private LEFPath nextLEFPath;

        private LEFPath() {
        }
    }
}

