/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.ExecProcess;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.SimulationData;
import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.ncc.NccCrossProbing;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.HorizRuler;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.SweepSignal;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.print.attribute.standard.ColorSupported;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WaveformWindow
implements WindowContent,
PropertyChangeListener {
    private static final int MINPANELHEIGHT = 24;
    private WindowFrame wf;
    private Stimuli sd;
    private Signal<?> xAxisSignalAll;
    private JPanel overall;
    private JButton xAxisLockButton;
    private JButton refresh;
    private JButton showPoints;
    private JButton growPanel;
    private JButton shrinkPanel;
    private JComboBox signalNameList;
    private Map<Signal<?>, TreePath> treePathFromSignal = new HashMap();
    private boolean rebuildingSignalNameList = false;
    private JScrollPane scrollAll;
    private JPanel left;
    private JPanel right;
    private WaveTable table;
    private WaveCellEditor leftSideColumn;
    private WaveCellEditor rightSideColumn;
    private TableModel tableModel;
    private JLabel mainPos;
    private JLabel extPos;
    private JLabel delta;
    private JLabel diskLabel;
    private JButton centerMain;
    private JButton centerExt;
    private List<Panel> wavePanels;
    private Map<String, SweepSignal[]> sweepSignals;
    private HorizRuler mainHorizRulerPanel;
    private boolean mainHorizRulerPanelLogarithmic;
    private Timer vcrTimer;
    private boolean vcrPlayingBackwards = false;
    private long vcrLastAdvance;
    private int vcrAdvanceSpeed = 3;
    private double mainXPosition;
    private double extXPosition;
    private double minXPosition;
    private double maxXPosition;
    private boolean xAxisLocked;
    private int highlightedSweep = -1;
    private int linePointMode;
    private boolean showGrid;
    private int screenLowX;
    private int screenHighX;
    private WaveComponentListener wcl;
    private Highlighter highlighter;
    private int nowPrinting;
    private boolean freezeWaveformHighlighting = false;
    private boolean freezeEditWindowHighlighting = false;
    private WaveformWindowHighlightListener waveHighlighter = new WaveformWindowHighlightListener();
    private Font waveWindowFont;
    private FontRenderContext waveWindowFRC;
    private Color offStrengthColor;
    private Color nodeStrengthColor;
    private Color gateStrengthColor;
    private Color powerStrengthColor;
    private Color backgroundColor;
    public WaveFormDropTarget waveformDropTarget = new WaveFormDropTarget();
    private static final ImageIcon iconAddPanel = Resources.getResource(WaveformWindow.class, "ButtonSimAddPanel.gif");
    private static final ImageIcon iconLockXAxes = Resources.getResource(WaveformWindow.class, "ButtonSimLockTime.gif");
    private static final ImageIcon iconUnLockXAxes = Resources.getResource(WaveformWindow.class, "ButtonSimUnLockTime.gif");
    private static final ImageIcon iconRefresh = Resources.getResource(WaveformWindow.class, "ButtonSimRefresh.gif");
    private static final ImageIcon iconLineOnPointOn = Resources.getResource(WaveformWindow.class, "ButtonSimLineOnPointOn.gif");
    private static final ImageIcon iconLineOnPointOff = Resources.getResource(WaveformWindow.class, "ButtonSimLineOnPointOff.gif");
    private static final ImageIcon iconLineOffPointOn = Resources.getResource(WaveformWindow.class, "ButtonSimLineOffPointOn.gif");
    private static final ImageIcon iconToggleGrid = Resources.getResource(WaveformWindow.class, "ButtonSimGrid.gif");
    private static final ImageIcon iconGrowPanel = Resources.getResource(WaveformWindow.class, "ButtonSimGrow.gif");
    private static final ImageIcon iconShrinkPanel = Resources.getResource(WaveformWindow.class, "ButtonSimShrink.gif");
    private static final ImageIcon iconVCRRewind = Resources.getResource(WaveformWindow.class, "ButtonVCRRewind.gif");
    private static final ImageIcon iconVCRPlayBackward = Resources.getResource(WaveformWindow.class, "ButtonVCRPlayBackward.gif");
    private static final ImageIcon iconVCRStop = Resources.getResource(WaveformWindow.class, "ButtonVCRStop.gif");
    private static final ImageIcon iconVCRPlay = Resources.getResource(WaveformWindow.class, "ButtonVCRPlay.gif");
    private static final ImageIcon iconVCRToEnd = Resources.getResource(WaveformWindow.class, "ButtonVCRToEnd.gif");
    private static final ImageIcon iconVCRFaster = Resources.getResource(WaveformWindow.class, "ButtonVCRFaster.gif");
    private static final ImageIcon iconVCRSlower = Resources.getResource(WaveformWindow.class, "ButtonVCRSlower.gif");
    private static final Cursor resizeRowCursor = Cursor.getPredefinedCursor(8);
    private static final Cursor resizeColumnCursor = Cursor.getPredefinedCursor(11);
    private int oldBackground;
    private int oldForeground;
    private boolean changedColors = false;
    private Map<Network, Integer> netValues;
    private static Map<CellId, String> savedSignalOrder = new HashMap<CellId, String>();

    public WaveformWindow(Stimuli sd, WindowFrame wf) {
        this.wf = wf;
        this.sd = sd;
        sd.setWaveformWindow(this);
        this.resetSweeps();
        this.wavePanels = new ArrayList<Panel>();
        this.xAxisLocked = true;
        this.linePointMode = 0;
        this.nowPrinting = 0;
        this.showGrid = false;
        this.xAxisSignalAll = null;
        this.mainHorizRulerPanelLogarithmic = false;
        this.waveWindowFont = new Font(User.getDefaultFont(), 0, 12);
        this.waveWindowFRC = new FontRenderContext(null, false, false);
        this.offStrengthColor = new Color(User.getColor(User.ColorPrefType.WAVE_OFF_STRENGTH));
        this.nodeStrengthColor = new Color(User.getColor(User.ColorPrefType.WAVE_NODE_STRENGTH));
        this.gateStrengthColor = new Color(User.getColor(User.ColorPrefType.WAVE_GATE_STRENGTH));
        this.powerStrengthColor = new Color(User.getColor(User.ColorPrefType.WAVE_POWER_STRENGTH));
        this.highlighter = new Highlighter(0, wf);
        Highlighter.addHighlightListener(this.waveHighlighter);
        this.overall = new OnePanel(null, this);
        this.overall.setLayout(new GridBagLayout());
        this.wcl = new WaveComponentListener(this.overall);
        this.overall.addComponentListener(this.wcl);
        new DropTarget(this.overall, 0x40000000, this.waveformDropTarget, true);
        this.tableModel = new WaveTableModel();
        this.table = new WaveTable(this.tableModel, this);
        new TableMouseListener(this.table);
        this.table.getTableHeader().setPreferredSize(new Dimension(1, 1));
        TableColumn column1 = this.table.getColumnModel().getColumn(0);
        column1.setPreferredWidth(100);
        TableColumn column2 = this.table.getColumnModel().getColumn(1);
        column2.setPreferredWidth(500);
        this.leftSideColumn = new WaveCellEditor(this.table, 0);
        this.rightSideColumn = new WaveCellEditor(this.table, 1);
        int height = User.getWaveformDigitalPanelHeight();
        if (sd.isAnalog()) {
            height = User.getWaveformAnalogPanelHeight();
        }
        this.table.setRowHeight(height);
        this.scrollAll = new JScrollPane(this.table);
        new DropTarget(this.table, 0x40000000, this.waveformDropTarget, true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 11;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.overall.add((Component)this.scrollAll, gbc);
        JButton addPanel = new JButton(iconAddPanel);
        addPanel.setBorderPainted(false);
        addPanel.setDefaultCapable(false);
        addPanel.setToolTipText("Create new waveform panel");
        Dimension minWid = new Dimension(iconAddPanel.getIconWidth() + 4, iconAddPanel.getIconHeight() + 4);
        addPanel.setMinimumSize(minWid);
        addPanel.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.overall.add((Component)addPanel, gbc);
        addPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.makeNewPanel(-1);
            }
        });
        this.showPoints = new JButton(iconLineOnPointOff);
        this.showPoints.setBorderPainted(false);
        this.showPoints.setDefaultCapable(false);
        this.showPoints.setToolTipText("Toggle display of vertex points and lines");
        minWid = new Dimension(iconLineOnPointOff.getIconWidth() + 4, iconLineOnPointOff.getIconHeight() + 4);
        this.showPoints.setMinimumSize(minWid);
        this.showPoints.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.overall.add((Component)this.showPoints, gbc);
        this.showPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.toggleShowPoints();
            }
        });
        JButton toggleGrid = new JButton(iconToggleGrid);
        toggleGrid.setBorderPainted(false);
        toggleGrid.setDefaultCapable(false);
        toggleGrid.setToolTipText("Toggle display of a grid");
        minWid = new Dimension(iconToggleGrid.getIconWidth() + 4, iconToggleGrid.getIconHeight() + 4);
        toggleGrid.setMinimumSize(minWid);
        toggleGrid.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)toggleGrid, gbc);
        toggleGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.toggleGridPoints();
            }
        });
        this.refresh = new JButton(iconRefresh);
        this.refresh.setBorderPainted(false);
        this.refresh.setDefaultCapable(false);
        this.refresh.setToolTipText("Reread stimuli data file and update waveforms");
        minWid = new Dimension(iconRefresh.getIconWidth() + 4, iconRefresh.getIconHeight() + 4);
        this.refresh.setMinimumSize(minWid);
        this.refresh.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)this.refresh, gbc);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.refreshData();
            }
        });
        this.xAxisLockButton = new JButton(iconLockXAxes);
        this.xAxisLockButton.setBorderPainted(false);
        this.xAxisLockButton.setDefaultCapable(false);
        this.xAxisLockButton.setToolTipText("Lock all panels horizontally");
        minWid = new Dimension(iconLockXAxes.getIconWidth() + 4, iconLockXAxes.getIconHeight() + 4);
        this.xAxisLockButton.setMinimumSize(minWid);
        this.xAxisLockButton.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.overall.add((Component)this.xAxisLockButton, gbc);
        this.xAxisLockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.togglePanelXAxisLock();
            }
        });
        this.signalNameList = new JComboBox();
        this.signalNameList.setToolTipText("Show or hide waveform panels");
        this.signalNameList.setLightWeightPopupEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.overall.add((Component)this.signalNameList, gbc);
        this.signalNameList.addItem("Panel 1");
        this.signalNameList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.togglePanelName();
            }
        });
        this.growPanel = new JButton(iconGrowPanel);
        this.growPanel.setBorderPainted(false);
        this.growPanel.setDefaultCapable(false);
        this.growPanel.setToolTipText("Increase minimum panel height");
        minWid = new Dimension(iconGrowPanel.getIconWidth() + 4, iconGrowPanel.getIconHeight() + 4);
        this.growPanel.setMinimumSize(minWid);
        this.growPanel.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.overall.add((Component)this.growPanel, gbc);
        this.growPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.growPanels(1.25);
            }
        });
        this.shrinkPanel = new JButton(iconShrinkPanel);
        this.shrinkPanel.setBorderPainted(false);
        this.shrinkPanel.setDefaultCapable(false);
        this.shrinkPanel.setToolTipText("Decrease minimum panel height");
        minWid = new Dimension(iconShrinkPanel.getIconWidth() + 4, iconShrinkPanel.getIconHeight() + 4);
        this.shrinkPanel.setMinimumSize(minWid);
        this.shrinkPanel.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 0;
        gbc.anchor = 10;
        this.overall.add((Component)this.shrinkPanel, gbc);
        this.shrinkPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.growPanels(0.8);
            }
        });
        JPanel xAxisLabelPanel = new JPanel();
        xAxisLabelPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 4, 0, 4);
        this.overall.add((Component)xAxisLabelPanel, gbc);
        this.mainPos = new JLabel("Main:", 4);
        this.mainPos.setToolTipText("The main (dashed) X axis cursor");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        xAxisLabelPanel.add((Component)this.mainPos, gbc);
        this.centerMain = new JButton("Center");
        this.centerMain.setToolTipText("Center the main (dashed) X axis cursor");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 2, 0);
        xAxisLabelPanel.add((Component)this.centerMain, gbc);
        this.centerMain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.centerCursor(true);
            }
        });
        this.extPos = new JLabel("Ext:", 4);
        this.extPos.setToolTipText("The extension (dotted) X axis cursor");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        xAxisLabelPanel.add((Component)this.extPos, gbc);
        this.centerExt = new JButton("Center");
        this.centerExt.setToolTipText("Center the extension (dotted) X axis cursor");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 2, 0);
        xAxisLabelPanel.add((Component)this.centerExt, gbc);
        this.centerExt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.centerCursor(false);
            }
        });
        this.delta = new JLabel("Delta:", 0);
        this.delta.setToolTipText("X distance between cursors");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        xAxisLabelPanel.add((Component)this.delta, gbc);
        if (sd.getFileURL() != null) {
            String fileName = TextUtils.getFileNameWithoutExtension(sd.getFileURL());
            String ext = TextUtils.getExtension(sd.getFileURL());
            if (ext.length() > 0) {
                fileName = fileName + "." + ext;
            }
            this.diskLabel = new JLabel("File: " + fileName, 0);
            this.diskLabel.setToolTipText("The disk file that is being displayed");
            gbc = new GridBagConstraints();
            gbc.gridx = 5;
            gbc.gridy = 0;
            gbc.weightx = 0.4;
            gbc.weighty = 0.0;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 10, 0, 0);
            xAxisLabelPanel.add((Component)this.diskLabel, gbc);
        }
        JButton vcrButtonRewind = new JButton(iconVCRRewind);
        vcrButtonRewind.setBorderPainted(false);
        vcrButtonRewind.setDefaultCapable(false);
        vcrButtonRewind.setToolTipText("Rewind main X axis cursor to start");
        minWid = new Dimension(iconVCRRewind.getIconWidth() + 4, iconVCRRewind.getIconHeight() + 4);
        vcrButtonRewind.setMinimumSize(minWid);
        vcrButtonRewind.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonRewind, gbc);
        vcrButtonRewind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickRewind();
            }
        });
        JButton vcrButtonPlayBackwards = new JButton(iconVCRPlayBackward);
        vcrButtonPlayBackwards.setBorderPainted(false);
        vcrButtonPlayBackwards.setDefaultCapable(false);
        vcrButtonPlayBackwards.setToolTipText("Play main X axis cursor backwards");
        minWid = new Dimension(iconVCRPlayBackward.getIconWidth() + 4, iconVCRPlayBackward.getIconHeight() + 4);
        vcrButtonPlayBackwards.setMinimumSize(minWid);
        vcrButtonPlayBackwards.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonPlayBackwards, gbc);
        vcrButtonPlayBackwards.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickPlayBackwards();
            }
        });
        JButton vcrButtonStop = new JButton(iconVCRStop);
        vcrButtonStop.setBorderPainted(false);
        vcrButtonStop.setDefaultCapable(false);
        vcrButtonStop.setToolTipText("Stop moving main X axis cursor");
        minWid = new Dimension(iconVCRStop.getIconWidth() + 4, iconVCRStop.getIconHeight() + 4);
        vcrButtonStop.setMinimumSize(minWid);
        vcrButtonStop.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonStop, gbc);
        vcrButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickStop();
            }
        });
        JButton vcrButtonPlay = new JButton(iconVCRPlay);
        vcrButtonPlay.setBorderPainted(false);
        vcrButtonPlay.setDefaultCapable(false);
        vcrButtonPlay.setToolTipText("Play main X axis cursor");
        minWid = new Dimension(iconVCRPlay.getIconWidth() + 4, iconVCRPlay.getIconHeight() + 4);
        vcrButtonPlay.setMinimumSize(minWid);
        vcrButtonPlay.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonPlay, gbc);
        vcrButtonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickPlay();
            }
        });
        JButton vcrButtonToEnd = new JButton(iconVCRToEnd);
        vcrButtonToEnd.setBorderPainted(false);
        vcrButtonToEnd.setDefaultCapable(false);
        vcrButtonToEnd.setToolTipText("Move main X axis cursor to end");
        minWid = new Dimension(iconVCRToEnd.getIconWidth() + 4, iconVCRToEnd.getIconHeight() + 4);
        vcrButtonToEnd.setMinimumSize(minWid);
        vcrButtonToEnd.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonToEnd, gbc);
        vcrButtonToEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickToEnd();
            }
        });
        JButton vcrButtonFaster = new JButton(iconVCRFaster);
        vcrButtonFaster.setBorderPainted(false);
        vcrButtonFaster.setDefaultCapable(false);
        vcrButtonFaster.setToolTipText("Move main X axis cursor faster");
        minWid = new Dimension(iconVCRFaster.getIconWidth() + 4, iconVCRFaster.getIconHeight() + 4);
        vcrButtonFaster.setMinimumSize(minWid);
        vcrButtonFaster.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonFaster, gbc);
        vcrButtonFaster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickFaster();
            }
        });
        JButton vcrButtonSlower = new JButton(iconVCRSlower);
        vcrButtonSlower.setBorderPainted(false);
        vcrButtonSlower.setDefaultCapable(false);
        vcrButtonSlower.setToolTipText("Move main X axis cursor slower");
        minWid = new Dimension(iconVCRSlower.getIconWidth() + 4, iconVCRSlower.getIconHeight() + 4);
        vcrButtonSlower.setMinimumSize(minWid);
        vcrButtonSlower.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.overall.add((Component)vcrButtonSlower, gbc);
        vcrButtonSlower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickSlower();
            }
        });
        this.backgroundColor = vcrButtonSlower.getBackground();
        if (this.xAxisLocked) {
            this.addMainHorizRulerPanel();
        }
        double lowTime = sd.getMinTime();
        double highTime = sd.getMaxTime();
        double timeRange = highTime - lowTime;
        this.setMainXPositionCursor(timeRange * 0.2 + lowTime);
        this.setExtensionXPositionCursor(timeRange * 0.8 + lowTime);
        this.setDefaultHorizontalRange(lowTime, highTime);
    }

    public void stopEditing() {
        this.leftSideColumn.stopCellEditing();
        this.rightSideColumn.stopCellEditing();
    }

    public void reloadTable() {
        this.table.tableChanged(new TableModelEvent(this.tableModel));
    }

    @Override
    public void finished() {
        for (Panel wp : this.wavePanels) {
            wp.finished();
        }
        Highlighter.removeHighlightListener(this.waveHighlighter);
        this.overall.removeComponentListener(this.wcl);
        this.highlighter.delete();
        if (this.sd != null) {
            this.sd.finished();
        }
    }

    @Override
    public void fullRepaint() {
        this.repaint();
    }

    @Override
    public void repaint() {
        for (Panel wp : this.wavePanels) {
            wp.repaintContents();
        }
        if (this.mainHorizRulerPanel != null) {
            this.mainHorizRulerPanel.repaint();
        }
    }

    public static void exportSimulationDataAsCSV(String file) {
        if (file == null) {
            return;
        }
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Must select a Waveform window first");
            return;
        }
        WaveformWindow ww = (WaveformWindow)content;
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (Panel wp : ww.wavePanels) {
                wp.dumpDataCSV(pw);
            }
            pw.close();
            System.out.println("Exported Waveform in CSV format file '" + file + "'");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void plotSimulationData(String file, String format2) {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Must select a Waveform window first");
            return;
        }
        WaveformWindow ww = (WaveformWindow)content;
        try {
            String commands = "";
            double min2 = Double.MAX_VALUE;
            double max2 = -1.7976931348623157E308;
            int numPanels = 0;
            int maxWidth = 0;
            int height = 0;
            for (Panel wp : ww.wavePanels) {
                ++numPanels;
                min2 = Math.min(min2, wp.convertXScreenToData(0));
                max2 = Math.max(max2, wp.convertXScreenToData(wp.getSz().width));
                maxWidth = Math.max(wp.getSz().width, maxWidth);
                height += wp.getSz().height;
            }
            System.out.println("plotting: maxWidth=" + maxWidth + ", height=" + height);
            if (file != null) {
                commands = commands + "set terminal " + format2 + " size 9 , " + (double)height * 9.0 / (double)maxWidth + "; ";
                commands = commands + "set output \"" + file + "\"; ";
            } else {
                commands = commands + "set terminal aqua size " + (maxWidth + 100) + " " + (height + 100) + "; ";
            }
            commands = commands + "unset colorbox; ";
            commands = commands + "set multiplot; ";
            commands = commands + "set xrange [\"" + min2 + "\":\"" + max2 + "\"]; ";
            commands = commands + "set format x \"\"; ";
            System.out.println("Running: gnuplot for " + numPanels + " panels");
            ExecProcess ep = new ExecProcess(new String[]{"gnuplot"}, null);
            ep.redirectStdout(System.out);
            ep.redirectStderr(System.out);
            ep.start();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new ExecProcess.MultiOutputStream(new OutputStream[]{System.out, ep.getStdin()})));
            pw.println(commands);
            pw.println("set label 1 \"Voltage (Volts)\" at 1,1 left");
            pw.println();
            int whichPanel = 0;
            double ypos = 1.0;
            for (Panel wp : ww.wavePanels) {
                if (whichPanel == numPanels - 1) {
                    pw.println("set xlabel \"time (in seconds)\"; ");
                    pw.println("unset format; ");
                }
                pw.println("set size " + (double)wp.getSz().width / (double)maxWidth + "," + (double)wp.getSz().height / (double)height + "; ");
                pw.println("set origin 0, " + (ypos -= (double)wp.getSz().height / (double)height));
                pw.flush();
                pw.print("plot ");
                wp.dumpDataForGnuplot(pw, min2, max2, ",");
                pw.println();
                pw.flush();
                ++whichPanel;
            }
            pw.println("unset multiplot; ");
            pw.println("quit;");
            pw.flush();
            pw.close();
            System.out.println("gnuplot finished.");
        }
        catch (Exception e) {
            System.out.println("ERROR: Unable to run 'gnuplot': " + e);
        }
    }

    @Override
    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set<TextUtils.WhatToSearch> whatToSearch, CodeExpression.Code codeRestr, AbstractTextDescriptor.Unit unitRestr, boolean highlightedOnly) {
        System.out.println("Text search not implemented for waveform windows");
    }

    @Override
    public boolean findNextText(boolean reverse2) {
        return false;
    }

    @Override
    public void replaceText(String replace) {
    }

    @Override
    public void replaceAllText(String replace) {
    }

    @Override
    public void writeImage(ElectricPrinter ep, String filePath) {
        BufferedImage img = this.getPrintImage(ep);
        PNG.writeImage(img, filePath);
    }

    @Override
    public boolean initializePrinting(ElectricPrinter ep, PageFormat pageFormat) {
        this.oldForeground = User.getColor(User.ColorPrefType.WAVE_FOREGROUND);
        this.oldBackground = User.getColor(User.ColorPrefType.WAVE_BACKGROUND);
        User.setColor(User.ColorPrefType.WAVE_FOREGROUND, 0);
        User.setColor(User.ColorPrefType.WAVE_BACKGROUND, 0xFFFFFF);
        this.changedColors = true;
        PrinterJob pj = ep.getPrintJob();
        if (pj == null) {
            return false;
        }
        ColorSupported cs = pj.getPrintService().getAttribute(ColorSupported.class);
        if (cs == null) {
            return false;
        }
        this.nowPrinting = 1;
        if (cs.getValue() == 0) {
            this.nowPrinting = 2;
        }
        Dimension oldSize = ep.getOldSize();
        int pageWid = (int)pageFormat.getImageableWidth() * ep.getDesiredDPI() / 72;
        int pageHei = (int)pageFormat.getImageableHeight() * ep.getDesiredDPI() / 72;
        double scaleX = (double)pageWid / (double)oldSize.width;
        double scaleY = (double)pageHei / (double)oldSize.height;
        double scale = Math.min(scaleX, scaleY);
        pageWid = (int)((double)oldSize.width * scale);
        pageHei = (int)((double)oldSize.height * scale);
        this.overall.setSize(pageWid, pageHei);
        this.overall.validate();
        this.redrawAllPanels();
        this.overall.repaint();
        return true;
    }

    @Override
    public BufferedImage getPrintImage(ElectricPrinter ep) {
        Dimension szOld;
        Graphics2D g2d;
        BufferedImage bImage = ep.getBufferedImage();
        Dimension sz = this.getPanel().getSize();
        if (bImage == null) {
            bImage = (BufferedImage)this.overall.createImage(sz.width, sz.height);
            ep.setBufferedImage(bImage);
        }
        if ((g2d = (Graphics2D)ep.getGraphics()) == null) {
            g2d = bImage.createGraphics();
        }
        if ((szOld = ep.getOldSize()) != null) {
            double scaleX = (double)sz.width / (double)szOld.width;
            double scaleY = (double)sz.height / (double)szOld.height;
            double gSX = (double)szOld.width / (double)szOld.height;
            double gSY = gSX * scaleY / scaleX;
            g2d.translate(ep.getPageFormat().getImageableX(), ep.getPageFormat().getImageableY());
            g2d.scale(72.0 / (double)ep.getDesiredDPI() / gSX, 72.0 / (double)ep.getDesiredDPI() / gSY);
        }
        this.overall.paint(g2d);
        if (this.changedColors) {
            User.setColor(User.ColorPrefType.WAVE_FOREGROUND, this.oldForeground);
            User.setColor(User.ColorPrefType.WAVE_BACKGROUND, this.oldBackground);
            this.changedColors = false;
        }
        this.nowPrinting = 0;
        return bImage;
    }

    @Override
    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
        double hRange = this.maxXPosition - this.minXPosition;
        double vRange = -1.0;
        double vRangeAny = -1.0;
        for (Panel wp : this.wavePanels) {
            vRangeAny = wp.getYAxisRange();
            if (!wp.isSelected()) continue;
            hRange = wp.getMaxXAxis() - wp.getMinXAxis();
            vRange = wp.getYAxisRange();
            break;
        }
        if (vRange < 0.0) {
            vRange = vRangeAny;
        }
        double distance = (double)ticks * panningAmounts[User.getPanningDistance()];
        for (Panel wp : this.wavePanels) {
            double high;
            double low;
            if (direction == 0) {
                if (!this.xAxisLocked && !wp.isSelected()) continue;
                low = wp.getMinXAxis() - hRange * distance;
                high = wp.getMaxXAxis() - hRange * distance;
                wp.setXAxisRange(low, high);
            } else {
                if (!wp.isSelected()) continue;
                low = wp.getYAxisLowValue() - vRange * distance;
                high = wp.getYAxisHighValue() - vRange * distance;
                wp.setYAxisRange(low, high);
            }
            wp.repaintWithRulers();
        }
    }

    @Override
    public void centerCursor() {
        double center = this.getMainXPositionCursor();
        Iterator<Panel> it = this.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            double half = (wp.getMaxXAxis() - wp.getMinXAxis()) / 2.0;
            wp.setXAxisRange(center - half, center + half);
            wp.repaintWithRulers();
        }
    }

    @Override
    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        String title = "";
        title = this.sd.getEngine() != null ? "Simulation of " : "Waveforms of ";
        this.wf.setTitle(this.wf.composeTitle(this.sd.getCell(), title, 0));
    }

    @Override
    public JPanel getPanel() {
        return this.overall;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.overall.setCursor(cursor);
        this.table.setCursor(cursor);
        for (JPanel jPanel : this.wavePanels) {
            jPanel.setCursor(cursor);
        }
    }

    @Override
    public void setCell(Cell cell, VarContext context, WindowFrame.DisplayAttributes displayAttributes) {
        this.sd.setCell(cell);
        this.setWindowTitle();
    }

    @Override
    public Cell getCell() {
        return this.sd.getCell();
    }

    public Stimuli getSimData() {
        return this.sd;
    }

    @Override
    public void bottomScrollChanged(int e) {
    }

    @Override
    public void rightScrollChanged(int e) {
    }

    private WindowFrame findSchematicsWindow() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            if (wf.getContent().getCell() != cell || !(wf.getContent() instanceof EditWindow)) continue;
            return wf;
        }
        return null;
    }

    public static WaveformWindow findWaveformWindow(Cell cell) {
        WaveformWindow found = null;
        int bestClock = 0;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            if (wf.getContent().getCell() != cell || !(wf.getContent() instanceof WaveformWindow)) continue;
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            if (found != null && wf.getUsageClock() <= bestClock) continue;
            found = ww;
            bestClock = wf.getUsageClock();
        }
        return found;
    }

    public WindowFrame getWindowFrame() {
        return this.wf;
    }

    public int getScreenLowX() {
        return this.screenLowX;
    }

    public int getScreenHighX() {
        return this.screenHighX;
    }

    public void setScreenXSize(int lowX, int highX) {
        this.screenLowX = lowX;
        this.screenHighX = highX;
    }

    public JPanel getSignalNamesPanel() {
        return this.left;
    }

    public JPanel getSignalTracesPanel() {
        return this.right;
    }

    public JTable getWaveformTable() {
        return this.table;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getNewPanelNumber() {
        int highestPanelNumber = 1;
        for (Panel wp : this.wavePanels) {
            if (wp.getPanelNumber() < highestPanelNumber) continue;
            highestPanelNumber = wp.getPanelNumber() + 1;
        }
        return highestPanelNumber;
    }

    public Panel makeNewPanel(int panelSize) {
        if (panelSize < 0) {
            panelSize = this.sd.isAnalog() ? User.getWaveformAnalogPanelHeight() : User.getWaveformDigitalPanelHeight();
        }
        double leftEdge = this.sd.getMinTime();
        double rightEdge = this.sd.getMaxTime();
        int vertAxisPos = -1;
        if (this.xAxisLocked && this.wavePanels.size() > 0) {
            Panel aPanel = this.wavePanels.get(0);
            leftEdge = aPanel.getMinXAxis();
            rightEdge = aPanel.getMaxXAxis();
            vertAxisPos = aPanel.getVertAxisPos();
        }
        int[] rowHeights = null;
        int rows = this.table.getRowCount();
        rowHeights = new int[rows + 1];
        for (int i = 0; i < rows; ++i) {
            rowHeights[i] = this.table.getRowHeight(i);
        }
        rowHeights[rows] = panelSize;
        Panel panel = new Panel(this, panelSize);
        panel.setXAxisRange(leftEdge, rightEdge);
        if (vertAxisPos > 0) {
            panel.setVertAxisPos(vertAxisPos);
        }
        panel.makeSelectedPanel(-1, -1);
        this.getPanel().validate();
        if (this.getMainHorizRuler() != null) {
            this.getMainHorizRuler().repaint();
        }
        this.table.tableChanged(new TableModelEvent(this.tableModel));
        for (int i = 0; i < rowHeights.length; ++i) {
            this.table.setRowHeight(i, rowHeights[i]);
        }
        this.table.setRowHeight(rowHeights[0]);
        return panel;
    }

    public int getNumPanels() {
        return this.wavePanels.size();
    }

    public Panel getPanel(int index) {
        return this.wavePanels.get(index);
    }

    public int getPanelIndex(Panel panel) {
        return this.wavePanels.indexOf(panel);
    }

    public void addPanel(Panel panel) {
        this.wavePanels.add(panel);
    }

    public void addPanel(Panel panel, int index) {
        this.wavePanels.add(index, panel);
    }

    public void removePanel(Panel panel) {
        this.wavePanels.remove(panel);
    }

    public Iterator<Panel> getPanels() {
        return this.wavePanels.iterator();
    }

    public int getPrintingMode() {
        return this.nowPrinting;
    }

    private Panel getPanelFromNumber(int panelNumber) {
        for (Panel wp : this.wavePanels) {
            if (wp.getPanelNumber() != panelNumber) continue;
            return wp;
        }
        return null;
    }

    private void togglePanelName() {
        if (this.rebuildingSignalNameList) {
            return;
        }
        String panelName = (String)this.signalNameList.getSelectedItem();
        int spacePos = panelName.indexOf(32);
        if (spacePos >= 0) {
            panelName = panelName.substring(spacePos + 1);
        }
        int index = TextUtils.atoi(panelName);
        for (Panel wp : this.wavePanels) {
            if (wp.getPanelNumber() != index) continue;
            if (wp.isHidden()) {
                this.showPanel(wp);
                break;
            }
            this.hidePanel(wp);
            break;
        }
    }

    public void validatePanel() {
        this.overall.validate();
    }

    public void rebuildPanelList() {
        this.rebuildingSignalNameList = true;
        this.signalNameList.removeAllItems();
        boolean hasSignals = false;
        for (Panel wp : this.wavePanels) {
            this.signalNameList.addItem("Panel " + Integer.toString(wp.getPanelNumber()) + (wp.isHidden() ? " (HIDDEN)" : ""));
            hasSignals = true;
        }
        if (hasSignals) {
            this.signalNameList.setSelectedIndex(0);
        }
        this.rebuildingSignalNameList = false;
    }

    public void redrawAllPanels() {
        if (this.mainHorizRulerPanel != null) {
            this.mainHorizRulerPanel.repaint();
        }
        for (Panel wp : this.wavePanels) {
            wp.repaintContents();
        }
        this.table.repaint();
    }

    public void repaintAllPanels() {
        this.table.repaint();
    }

    public void closePanel(Panel wp) {
        int i;
        int rows = this.wavePanels.size();
        int[] rowHeights = new int[rows];
        int closedPanelIndex = this.wavePanels.indexOf(wp);
        int validPanels = 0;
        int visRow = 0;
        for (i = 0; i < rows; ++i) {
            if (this.wavePanels.get(i).isHidden()) continue;
            int rowHeight = this.table.getRowHeight(visRow++);
            if (i == closedPanelIndex) continue;
            rowHeights[validPanels++] = rowHeight;
        }
        this.stopEditing();
        this.reloadTable();
        this.wavePanels.remove(wp);
        for (i = 0; i < validPanels; ++i) {
            this.table.setRowHeight(i, rowHeights[i]);
        }
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void hidePanel(Panel wp) {
        int i;
        if (wp.isHidden()) {
            return;
        }
        int rows = this.wavePanels.size();
        int[] rowHeights = new int[rows];
        int hiddenPanelIndex = this.wavePanels.indexOf(wp);
        int validPanels = 0;
        int visRow = 0;
        for (i = 0; i < rows; ++i) {
            if (this.wavePanels.get(i).isHidden()) continue;
            int rowHeight = this.table.getRowHeight(visRow++);
            if (i == hiddenPanelIndex) continue;
            rowHeights[validPanels++] = rowHeight;
        }
        wp.setHidden(true);
        this.stopEditing();
        this.reloadTable();
        for (i = 0; i < validPanels; ++i) {
            this.table.setRowHeight(i, rowHeights[i]);
        }
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void showPanel(Panel wp) {
        int i;
        if (!wp.isHidden()) {
            return;
        }
        int rows = this.wavePanels.size();
        int[] rowHeights = new int[rows];
        int openedPanelIndex = this.wavePanels.indexOf(wp);
        int validPanels = 0;
        int visRow = 0;
        int openedPanelHeightIndex = -1;
        int averageHeight = 0;
        int numAverages = 0;
        for (i = 0; i < rows; ++i) {
            if (i == openedPanelIndex) {
                openedPanelHeightIndex = validPanels;
                int height = User.getWaveformDigitalPanelHeight();
                if (this.sd.isAnalog()) {
                    height = User.getWaveformAnalogPanelHeight();
                }
                rowHeights[validPanels++] = height;
                continue;
            }
            if (this.wavePanels.get(i).isHidden()) continue;
            int rowHeight = this.table.getRowHeight(visRow++);
            rowHeights[validPanels++] = rowHeight;
            averageHeight += rowHeight;
            ++numAverages;
        }
        wp.setHidden(false);
        this.stopEditing();
        this.reloadTable();
        if (numAverages != 0) {
            rowHeights[openedPanelHeightIndex] = averageHeight / numAverages;
        }
        for (i = 0; i < validPanels; ++i) {
            this.table.setRowHeight(i, rowHeights[i]);
        }
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void growPanels(double scale) {
        int origPanelSize = User.getWaveformAnalogPanelHeight();
        int newPanelSize = (int)((double)origPanelSize * scale);
        if (newPanelSize < 24) {
            newPanelSize = 24;
        }
        if (origPanelSize != newPanelSize) {
            User.setWaveformAnalogPanelHeight(newPanelSize);
        }
        if ((newPanelSize = (int)((double)(origPanelSize = User.getWaveformDigitalPanelHeight()) * scale)) < 24) {
            newPanelSize = 24;
        }
        if (origPanelSize != newPanelSize) {
            User.setWaveformDigitalPanelHeight(newPanelSize);
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int rowHeight = this.table.getRowHeight(i);
            int newRowHeight = (int)((double)rowHeight * scale);
            Panel wp = this.wavePanels.get(i);
            if (wp.isAnalog()) {
                if (newRowHeight < 24) {
                    newRowHeight = 24;
                }
            } else if (newRowHeight < 24) {
                newRowHeight = 24;
            }
            this.table.setRowHeight(i, newRowHeight);
            wp.updatePanelTitle();
        }
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void deleteSignalFromPanel(Panel wp) {
        boolean found = true;
        block0: while (found) {
            found = false;
            for (WaveSignal ws : wp.getSignals()) {
                if (!ws.isHighlighted()) continue;
                wp.removeHighlightedSignal(ws, true);
                wp.removeSignal(ws.getButton());
                found = true;
                continue block0;
            }
        }
        if (wp.getSignalButtons() != null) {
            wp.getSignalButtons().validate();
            wp.getSignalButtons().repaint();
        }
        wp.repaintContents();
        this.saveSignalOrder();
    }

    public void deleteAllSignalsFromPanel(Panel wp) {
        wp.clearHighlightedSignals();
        wp.getSignalButtons().removeAll();
        wp.getSignalButtons().validate();
        wp.getSignalButtons().repaint();
        wp.removeAllSignals();
        wp.repaintContents();
        this.saveSignalOrder();
    }

    public HorizRuler getMainHorizRuler() {
        return this.mainHorizRulerPanel;
    }

    public Signal<?> getXAxisSignalAll() {
        return this.xAxisSignalAll;
    }

    public void setXAxisSignalAll(Signal<?> sig) {
        this.xAxisSignalAll = sig;
    }

    private void addMainHorizRulerPanel() {
        this.mainHorizRulerPanel = new HorizRuler(null, this);
        this.mainHorizRulerPanel.setToolTipText("One X axis ruler applies to all signals when the X axes are locked");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.overall.add((Component)this.mainHorizRulerPanel, gbc);
    }

    private void removeMainHorizRulerPanel() {
        this.overall.remove(this.mainHorizRulerPanel);
        this.mainHorizRulerPanel = null;
    }

    private void resetSweeps() {
        this.sweepSignals = new HashMap<String, SweepSignal[]>();
        Iterator<SignalCollection> it = this.sd.getSignalCollections();
        while (it.hasNext()) {
            String[] sweeps;
            SignalCollection sc = it.next();
            String scName = sc.getName();
            SweepSignal[] signalArray = this.sweepSignals.get(scName);
            if (signalArray != null || (sweeps = sc.getSweepNames()) == null) continue;
            signalArray = new SweepSignal[sweeps.length];
            for (int i = 0; i < sweeps.length; ++i) {
                signalArray[i] = new SweepSignal(sweeps[i], this);
            }
            this.sweepSignals.put(scName, signalArray);
        }
    }

    public void setIncludeInAllSweeps(List<SweepSignal> sweeps, boolean include) {
        for (int i = 0; i < sweeps.size(); ++i) {
            SweepSignal ss = sweeps.get(i);
            boolean update2 = i == sweeps.size() - 1;
            ss.setIncluded(include, update2);
        }
    }

    public boolean isSweepSignalIncluded(String scName, int index) {
        SweepSignal ss;
        SweepSignal[] signalArray = this.sweepSignals.get(scName);
        if (signalArray != null && (ss = signalArray[index]) != null) {
            return ss.isIncluded();
        }
        return true;
    }

    public int getHighlightedSweep() {
        return this.highlightedSweep;
    }

    public void setHighlightedSweep(int sweep) {
        this.highlightedSweep = sweep;
    }

    private void tick() {
        long curtime = System.currentTimeMillis();
        if (curtime - this.vcrLastAdvance < 100L) {
            return;
        }
        this.vcrLastAdvance = curtime;
        if (this.wavePanels.size() == 0) {
            return;
        }
        Panel wp = this.wavePanels.iterator().next();
        int xValueScreen = wp.convertXDataToScreen(this.mainXPosition);
        if (this.vcrPlayingBackwards) {
            double lowXValue;
            int newXValueScreen = xValueScreen - this.vcrAdvanceSpeed;
            double newXValue = wp.convertXScreenToData(newXValueScreen);
            if (newXValue <= (lowXValue = this.sd.getMinTime())) {
                newXValue = lowXValue;
                this.vcrClickStop();
            }
            this.setMainXPositionCursor(newXValue);
        } else {
            double highXValue;
            int newXValueScreen = xValueScreen + this.vcrAdvanceSpeed;
            double newXValue = wp.convertXScreenToData(newXValueScreen);
            if (newXValue >= (highXValue = this.sd.getMaxTime())) {
                newXValue = highXValue;
                this.vcrClickStop();
            }
            this.setMainXPositionCursor(newXValue);
        }
        this.redrawAllPanels();
    }

    public void vcrClickRewind() {
        this.vcrClickStop();
        double lowXValue = this.sd.getMinTime();
        this.setMainXPositionCursor(lowXValue);
        this.redrawAllPanels();
    }

    public void vcrClickPlayBackwards() {
        if (this.vcrTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.tick();
                }
            };
            this.vcrTimer = new Timer(100, taskPerformer);
            this.vcrLastAdvance = System.currentTimeMillis();
            this.vcrTimer.start();
        }
        this.vcrPlayingBackwards = true;
    }

    public void vcrClickStop() {
        if (this.vcrTimer == null) {
            return;
        }
        this.vcrTimer.stop();
        this.vcrTimer = null;
    }

    public void vcrClickPlay() {
        if (this.vcrTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.tick();
                }
            };
            this.vcrTimer = new Timer(100, taskPerformer);
            this.vcrLastAdvance = System.currentTimeMillis();
            this.vcrTimer.start();
        }
        this.vcrPlayingBackwards = false;
    }

    public void vcrClickToEnd() {
        this.vcrClickStop();
        double highXValue = this.sd.getMaxTime();
        this.setMainXPositionCursor(highXValue);
        this.redrawAllPanels();
    }

    public void vcrClickFaster() {
        int j = this.vcrAdvanceSpeed / 4;
        if (j <= 0) {
            j = 1;
        }
        this.vcrAdvanceSpeed += j;
    }

    public void vcrClickSlower() {
        int j = this.vcrAdvanceSpeed / 4;
        if (j <= 0) {
            j = 1;
        }
        this.vcrAdvanceSpeed -= j;
        if (this.vcrAdvanceSpeed <= 0) {
            this.vcrAdvanceSpeed = 1;
        }
    }

    public void clearHighlighting() {
        for (Panel wp : this.wavePanels) {
            boolean changed = false;
            for (WaveSignal ws : wp.getSignals()) {
                if (ws.isHighlighted()) {
                    changed = true;
                }
                ws.setHighlighted(false);
            }
            if (!changed) continue;
            wp.repaintContents();
        }
    }

    public List<Signal<?>> getHighlightedNetworkNames() {
        ArrayList highlightedSignals = new ArrayList();
        for (Panel wp : this.wavePanels) {
            for (WaveSignal ws : wp.getSignals()) {
                if (!ws.isHighlighted()) continue;
                highlightedSignals.add(ws.getSignal());
            }
        }
        ExplorerTree sigTree = this.wf.getExplorerTab();
        Object nodeInfo = sigTree.getCurrentlySelectedObject(0);
        if (nodeInfo != null && nodeInfo instanceof Signal) {
            Signal sig = (Signal)nodeInfo;
            highlightedSignals.add(sig);
        }
        return highlightedSignals;
    }

    public Set<Network> getHighlightedNetworks() {
        Signal sig;
        Network net;
        HashSet<Network> nets = new HashSet<Network>();
        Cell cell = this.sd.getCell();
        if (cell == null) {
            return nets;
        }
        Netlist netlist = cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return nets;
        }
        for (Panel wp : this.wavePanels) {
            for (WaveSignal ws : wp.getSignals()) {
                Network net2 = WaveformWindow.findNetwork(netlist, ws.getSignal().getSignalName());
                if (net2 == null) continue;
                nets.add(net2);
            }
        }
        ExplorerTree sigTree = this.wf.getExplorerTab();
        Object nodeInfo = sigTree.getCurrentlySelectedObject(0);
        if (nodeInfo != null && nodeInfo instanceof Signal && (net = WaveformWindow.findNetwork(netlist, (sig = (Signal)nodeInfo).getSignalName())) != null) {
            nets.add(net);
        }
        return nets;
    }

    @Override
    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public List<PolyBase> getPolysForPrinting() {
        int offY = 0;
        ArrayList<PolyBase> override = new ArrayList<PolyBase>();
        HorizRuler mainHR = this.getMainHorizRuler();
        if (mainHR != null) {
            List<PolyBase> horizPolys = mainHR.getPolysForPrinting(this.getPanels().next());
            for (PolyBase poly : horizPolys) {
                PolyBase.Point[] pts = poly.getPoints();
                for (int i = 0; i < pts.length; ++i) {
                    poly.setPoint(i, ((Point2D)pts[i]).getX(), ((Point2D)pts[i]).getY() + (double)offY);
                }
                override.add(poly);
            }
            offY += mainHR.getHeight();
        }
        Iterator<Panel> it = this.getPanels();
        while (it.hasNext()) {
            int i;
            PolyBase.Point[] pts;
            Panel panel = it.next();
            HorizRuler hr = panel.getHorizRuler();
            if (hr != null) {
                offY += hr.getHeight();
                List<PolyBase> horizPolys = hr.getPolysForPrinting(panel);
                for (PolyBase poly : horizPolys) {
                    pts = poly.getPoints();
                    for (i = 0; i < pts.length; ++i) {
                        poly.setPoint(i, ((Point2D)pts[i]).getX(), ((Point2D)pts[i]).getY() + (double)offY);
                    }
                    override.add(poly);
                }
                offY += hr.getHeight();
            }
            List<PolyBase> panelList = panel.getPolysForPrinting();
            for (PolyBase poly : panelList) {
                pts = poly.getPoints();
                for (i = 0; i < pts.length; ++i) {
                    poly.setPoint(i, ((Point2D)pts[i]).getX(), ((Point2D)pts[i]).getY() + (double)offY);
                }
                override.add(poly);
            }
            offY += panel.getHeight();
            if (hr != null) continue;
            offY += 20;
        }
        return override;
    }

    @Override
    public List<MutableTreeNode> loadExplorerTrees() {
        TreePath rootPath = new TreePath("Explorer");
        ArrayList<MutableTreeNode> nodes = new ArrayList<MutableTreeNode>();
        this.treePathFromSignal.clear();
        Iterator<SignalCollection> it = this.sd.getSignalCollections();
        while (it.hasNext()) {
            SignalCollection sc = it.next();
            nodes.add(this.getSignalsForExplorer(sc, rootPath, sc.getName()));
            DefaultMutableTreeNode sweepTree = this.getSweepsForExplorer(sc, sc.getName());
            if (sweepTree == null) continue;
            nodes.add(sweepTree);
        }
        while (nodes.remove(null)) {
        }
        return nodes;
    }

    @Override
    public void loadTechnologies() {
    }

    private DefaultMutableTreeNode getSignalsForExplorer(SignalCollection sc, TreePath parentPath, String collectionName) {
        Collection<Signal<?>> signalsi = sc.getSignals();
        ArrayList<Signal> signals = new ArrayList<Signal>();
        HashSet busMembers = new HashSet();
        for (Signal signal : signalsi) {
            Signal<?>[] members = signal.getBusMembers();
            if (members == null) continue;
            for (int i = 0; i < members.length; ++i) {
                busMembers.add(members[i]);
            }
        }
        for (Signal signal : signalsi) {
            if (busMembers.contains(signal)) continue;
            signals.add(signal);
        }
        if (signals.size() == 0) {
            return null;
        }
        DefaultMutableTreeNode signalsExplorerTree = new DefaultMutableTreeNode(collectionName);
        TreePath treePath = parentPath.pathByAddingChild(signalsExplorerTree);
        for (Signal<?> s3 : sc.getSignals()) {
            this.treePathFromSignal.put(s3, treePath);
        }
        HashMap<String, TreePath> contextMap = new HashMap<String, TreePath>();
        contextMap.put("", treePath);
        Collections.sort(signals, new SignalsByName());
        char separatorChar = this.sd.getSeparatorChar();
        for (Signal sSig : signals) {
            if (sSig.getSignalContext() == null) continue;
            this.makeContext(sSig.getSignalContext(), contextMap, separatorChar);
        }
        String delim = this.sd.getNetDelimiter();
        HashSet<String> sharpSet = new HashSet<String>();
        for (Signal sSig : signals) {
            String sigName = sSig.getSignalName();
            int hashPos = sigName.indexOf(delim);
            if (hashPos <= 0) continue;
            String nodeName = sSig.getSignalContext();
            nodeName = nodeName == null ? "" : nodeName + separatorChar;
            nodeName = nodeName + sigName.substring(0, hashPos);
            sharpSet.add(nodeName);
        }
        for (Signal sSig : signals) {
            TreePath thisTree = treePath;
            String nodeName = sSig.getSignalContext();
            String nodeNameStr = nodeName;
            nodeNameStr = nodeNameStr == null ? "" : nodeNameStr + separatorChar;
            String sigName = sSig.getSignalName();
            int hashPos = sigName.indexOf(delim);
            if (hashPos > 0) {
                nodeName = nodeNameStr + sigName.substring(0, hashPos + 1);
            } else {
                String pureSharpName = nodeNameStr + sigName;
                if (sharpSet.contains(pureSharpName)) {
                    nodeName = pureSharpName + delim;
                }
            }
            if (nodeName != null) {
                thisTree = this.makeContext(nodeName, contextMap, separatorChar);
            }
            DefaultMutableTreeNode sigLeaf = new DefaultMutableTreeNode(sSig);
            ((DefaultMutableTreeNode)thisTree.getLastPathComponent()).add(sigLeaf);
        }
        return signalsExplorerTree;
    }

    private TreePath makeContext(String branchName, Map<String, TreePath> contextMap, char separatorChar) {
        TreePath branchTree = contextMap.get(branchName);
        if (branchTree != null) {
            return branchTree;
        }
        String parent = "";
        String leaf = branchName;
        int dotPos = leaf.lastIndexOf(separatorChar);
        if (dotPos >= 0) {
            parent = leaf.substring(0, dotPos);
            leaf = leaf.substring(dotPos + 1);
        }
        TreePath parentBranch = this.makeContext(parent, contextMap, separatorChar);
        DefaultMutableTreeNode thisTree = new DefaultMutableTreeNode(leaf);
        ((DefaultMutableTreeNode)parentBranch.getLastPathComponent()).add(thisTree);
        TreePath thisPath = parentBranch.pathByAddingChild(thisTree);
        contextMap.put(branchName, thisPath);
        return thisPath;
    }

    private DefaultMutableTreeNode getSweepsForExplorer(SignalCollection sc, String collectionName) {
        DefaultMutableTreeNode sweepsExplorerTree = null;
        boolean first = true;
        SweepSignal[] signalArray = this.sweepSignals.get(sc.getName());
        if (signalArray != null) {
            for (SweepSignal ss : signalArray) {
                if (first) {
                    first = false;
                    int spacePos = collectionName.indexOf(32);
                    collectionName = spacePos >= 0 ? collectionName.substring(0, spacePos) + " SWEEPS" : collectionName + " SWEEPS";
                    sweepsExplorerTree = new DefaultMutableTreeNode(collectionName);
                }
                sweepsExplorerTree.add(new DefaultMutableTreeNode(ss));
            }
        }
        return sweepsExplorerTree;
    }

    private Signal<?> findSignal(String name, SignalCollection sc) {
        for (Signal<?> sSig : sc.getSignals()) {
            String sigName = sSig.getFullName();
            if (!sigName.equals(name)) continue;
            return sSig;
        }
        return null;
    }

    public void showSignals(Highlighter h, VarContext context, boolean newPanel) {
        List<Signal<?>> found = this.findSelectedSignals(h, context);
        this.showSignals(found, newPanel);
    }

    public void showSignals(List<Signal<?>> found, boolean newPanel) {
        Panel wp = null;
        for (Panel oWp : this.wavePanels) {
            if (!oWp.isSelected()) continue;
            wp = oWp;
            break;
        }
        if (!newPanel && wp == null) {
            System.out.println("No current waveform panel to add signals");
            return;
        }
        boolean added = false;
        for (Signal<?> sSig : found) {
            if (newPanel) {
                wp = this.makeNewPanel(-1);
                wp.fitToSignal(sSig);
                newPanel = false;
                if (!this.xAxisLocked) {
                    wp.setXAxisRange(sSig.getMinTime(), sSig.getMaxTime());
                }
            }
            boolean alreadyPlotted = false;
            for (WaveSignal ws : wp.getSignals()) {
                String name = ws.getSignal().getFullName();
                if (!name.equals(sSig.getFullName())) continue;
                alreadyPlotted = true;
                WaveSignal.addSignalToPanel(ws.getSignal(), wp, null);
            }
            if (!alreadyPlotted) {
                new WaveSignal(wp, sSig);
            }
            added = true;
            wp.repaintContents();
        }
        if (added) {
            this.overall.validate();
            this.saveSignalOrder();
        }
    }

    public void removeSignals(Set<Network> nets, VarContext context) {
        for (Network net : nets) {
            String netName = WaveformWindow.getSpiceNetName(context, net);
            Iterator<SignalCollection> aIt = this.sd.getSignalCollections();
            while (aIt.hasNext()) {
                SignalCollection sc = aIt.next();
                Signal<?> sSig = WaveformWindow.findSignalForNetwork(sc, netName);
                if (sSig == null) continue;
                boolean found = true;
                block2: while (found) {
                    found = false;
                    Iterator<Panel> pIt = this.getPanels();
                    while (pIt.hasNext()) {
                        Panel wp = pIt.next();
                        for (WaveSignal ws : wp.getSignals()) {
                            if (ws.getSignal() != sSig) continue;
                            wp.removeHighlightedSignal(ws, true);
                            wp.removeSignal(ws.getButton());
                            wp.getSignalButtons().validate();
                            wp.getSignalButtons().repaint();
                            wp.repaintContents();
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        continue block2;
                    }
                }
            }
        }
    }

    public static String getSpiceNetName(Network net) {
        return Spice.getSafeNetName(net.getName(), SimulationTool.getSpiceEngine());
    }

    public static String getSpiceNetName(VarContext context, Network net) {
        return WaveformWindow.getSpiceNetName(context, net, false, false);
    }

    public static String getSpiceNetName(VarContext context, Network net, boolean assuraRCXFormat, boolean starRCXTFormat) {
        boolean isGlobal = false;
        if (net != null) {
            Network tempnet;
            Netlist netlist = net.getNetlist();
            while (net.isExported() && context != VarContext.globalContext && (tempnet = WaveformWindow.getNetworkInParent(net, context.getNodable())) != null) {
                net = tempnet;
                context = context.pop();
            }
            netlist = net.getNetlist();
            Global.Set globNets = netlist.getGlobals();
            for (int i = 0; i < globNets.size(); ++i) {
                Global g = globNets.get(i);
                Network netG = netlist.getNetwork(g);
                if (netG != net) continue;
                isGlobal = true;
                break;
            }
        }
        String contextStr = context.getInstPath(".");
        if (assuraRCXFormat) {
            contextStr = "x" + context.getInstPath("/x");
        }
        if (starRCXTFormat) {
            contextStr = context.getInstPath("/");
        }
        contextStr = TextUtils.canonicString(contextStr);
        if (net == null) {
            return contextStr;
        }
        if (context == VarContext.globalContext || isGlobal) {
            return WaveformWindow.getSpiceNetName(net);
        }
        if (assuraRCXFormat) {
            return contextStr + "/" + WaveformWindow.getSpiceNetName(net);
        }
        if (starRCXTFormat) {
            return contextStr + "/" + WaveformWindow.getSpiceNetName(net);
        }
        return contextStr + "." + WaveformWindow.getSpiceNetName(net);
    }

    public static Network getNetworkInParent(Network childNetwork, Nodable childNodable) {
        if (childNodable == null || childNetwork == null) {
            return null;
        }
        if (!childNodable.isCellInstance()) {
            return null;
        }
        Cell childCell = (Cell)childNodable.getProto();
        if (childCell.contentsView() != null) {
            childCell = childCell.contentsView();
        }
        boolean found = false;
        Export export = null;
        int i = 0;
        Iterator<PortProto> it = childCell.getPorts();
        while (it.hasNext()) {
            export = (Export)it.next();
            for (i = 0; i < export.getNameKey().busWidth(); ++i) {
                Netlist netlist = childCell.getNetlist();
                if (netlist == null) {
                    System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
                    return null;
                }
                Network net = netlist.getNetwork(export, i);
                if (net != childNetwork) continue;
                found = true;
                break;
            }
            if (!found) continue;
        }
        if (!found) {
            return null;
        }
        Export pp = (Export)childNodable.getProto().findPortProto(export.getNameKey());
        Cell parentCell = childNodable.getParent();
        Netlist netlist = parentCell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return null;
        }
        Network parentNet = netlist.getNetwork(childNodable, pp, i);
        return parentNet;
    }

    public WaveSignal findDisplayedSignal(Signal<?> sSig) {
        for (Panel wp : this.wavePanels) {
            WaveSignal ws = wp.findWaveSignal(sSig);
            if (ws == null) continue;
            return ws;
        }
        return null;
    }

    public double getMainXPositionCursor() {
        return this.mainXPosition;
    }

    public void setMainXPositionCursor(double value) {
        this.mainXPosition = value;
        String amount = TextUtils.convertToEngineeringNotation(this.mainXPosition, "s");
        this.mainPos.setText("Main: " + amount);
        String diff2 = TextUtils.convertToEngineeringNotation(Math.abs(this.mainXPosition - this.extXPosition), "s");
        this.delta.setText("Delta: " + diff2);
        this.updateAssociatedLayoutWindow();
    }

    public double getExtensionXPositionCursor() {
        return this.extXPosition;
    }

    public void setExtensionXPositionCursor(double value) {
        this.extXPosition = value;
        String amount = TextUtils.convertToEngineeringNotation(this.extXPosition, "s");
        this.extPos.setText("Ext: " + amount);
        String diff2 = TextUtils.convertToEngineeringNotation(Math.abs(this.mainXPosition - this.extXPosition), "s");
        this.delta.setText("Delta: " + diff2);
    }

    public void setDefaultHorizontalRange(double minXPosition, double maxXPosition) {
        this.minXPosition = minXPosition;
        this.maxXPosition = maxXPosition;
    }

    public double getLowDefaultHorizontalRange() {
        return this.minXPosition;
    }

    public double getHighDefaultHorizontalRange() {
        return this.maxXPosition;
    }

    public void setZoomExtents(double lowVert, double highVert, double lowHoriz, double highHoriz, Panel thePanel) {
        for (Panel wp : this.wavePanels) {
            boolean changed = false;
            if (wp == thePanel) {
                wp.setYAxisRange(lowVert, highVert);
                changed = true;
            }
            if (this.xAxisLocked || wp == thePanel) {
                if (wp.getMinXAxis() < wp.getMaxXAxis()) {
                    wp.setXAxisRange(Math.min(lowHoriz, highHoriz), Math.max(lowHoriz, highHoriz));
                } else {
                    wp.setXAxisRange(Math.max(lowHoriz, highHoriz), Math.min(lowHoriz, highHoriz));
                }
                changed = true;
            }
            if (!changed) continue;
            wp.repaintWithRulers();
        }
    }

    public void togglePanelXAxisLock() {
        boolean bl = this.xAxisLocked = !this.xAxisLocked;
        if (this.xAxisLocked) {
            this.xAxisLockButton.setIcon(iconLockXAxes);
            this.addMainHorizRulerPanel();
            double minXPosition = 0.0;
            double maxXPosition = 0.0;
            int vertAxis = 0;
            boolean first = true;
            for (Panel wp : this.wavePanels) {
                wp.removeHorizRulerPanel();
                if (first) {
                    first = false;
                    minXPosition = wp.getMinXAxis();
                    maxXPosition = wp.getMaxXAxis();
                    vertAxis = wp.getVertAxisPos();
                    continue;
                }
                if (minXPosition < maxXPosition) {
                    minXPosition = Math.min(minXPosition, wp.getMinXAxis());
                    maxXPosition = Math.max(maxXPosition, wp.getMaxXAxis());
                } else {
                    minXPosition = Math.max(minXPosition, wp.getMinXAxis());
                    maxXPosition = Math.min(maxXPosition, wp.getMaxXAxis());
                }
                wp.setVertAxisPos(vertAxis);
            }
            for (Panel wp : this.wavePanels) {
                wp.setXAxisRange(minXPosition, maxXPosition);
            }
        } else {
            this.xAxisLockButton.setIcon(iconUnLockXAxes);
            for (Panel wp : this.wavePanels) {
                wp.addHorizRulerPanel();
            }
            this.removeMainHorizRulerPanel();
        }
        this.overall.validate();
        this.overall.repaint();
    }

    public boolean isXAxisLocked() {
        return this.xAxisLocked;
    }

    private void crossProbeEditWindowToWaveform(EditWindow wnd, Highlighter which) {
        Locator loc = new Locator(wnd, this);
        if (loc.getWaveformWindow() != this) {
            return;
        }
        this.freezeEditWindowHighlighting = true;
        for (Panel wp : this.wavePanels) {
            wp.clearHighlightedSignals();
        }
        ExplorerTree tree = this.wf.getExplorerTab();
        tree.setSelectionPath(null);
        tree.clearCurrentlySelectedObjects();
        List<Signal<?>> found = this.findSelectedSignals(which, loc.getContext());
        boolean foundSignal = false;
        for (Panel panel : this.wavePanels) {
            for (WaveSignal ws : panel.getSignals()) {
                for (Signal<?> sSig : found) {
                    if (ws.getSignal() != sSig) continue;
                    panel.addHighlightedSignal(ws, false);
                    foundSignal = true;
                }
            }
        }
        if (foundSignal) {
            this.repaint();
        }
        Collections.sort(found, new SignalsByName());
        for (Signal signal : found) {
            TreePath treePath = this.treePathFromSignal(signal);
            if (treePath == null) continue;
            tree.setSelectionPath(treePath);
            break;
        }
        this.freezeEditWindowHighlighting = false;
    }

    private TreePath treePathFromSignal(Signal<?> sig) {
        TreePath treePath = this.treePathFromSignal.get(sig);
        if (treePath == null) {
            return null;
        }
        String fullName = sig.getFullName();
        char separator = this.sd.getSeparatorChar();
        int sBeg = 0;
        while (sBeg < fullName.length()) {
            int sEnd = fullName.indexOf(separator, sBeg);
            if (sEnd < 0) {
                sEnd = fullName.length();
            }
            String s2 = fullName.substring(sBeg, sEnd);
            TreeNode parentNode = (TreeNode)treePath.getLastPathComponent();
            TreeNode child = WaveformWindow.findChild(parentNode, s2);
            if (child == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(child);
            sBeg = sEnd + 1;
        }
        return sBeg == fullName.length() + 1 ? treePath : null;
    }

    private static TreeNode findChild(TreeNode parent, String name) {
        int numChilds = parent.getChildCount();
        for (int i = 0; i < numChilds; ++i) {
            DefaultMutableTreeNode node;
            Object o;
            TreeNode child = parent.getChildAt(i);
            String s2 = child instanceof DefaultMutableTreeNode ? ((o = (node = (DefaultMutableTreeNode)child).getUserObject()) instanceof Signal ? ((Signal)o).getSignalName() : o.toString()) : child.toString();
            if (!name.equals(s2)) continue;
            return child;
        }
        return null;
    }

    private List<Signal<?>> findSelectedSignals(Highlighter h, VarContext context) {
        Geometric geom;
        ArrayList found = new ArrayList();
        List<Geometric> highlightedObjects = h.getHighlightedEObjs(true, true);
        if (highlightedObjects.size() == 1 && (geom = highlightedObjects.get(0)) instanceof NodeInst) {
            NodeInst ni = (NodeInst)geom;
            String nodeName = "I(v" + ni.getName();
            Iterator<SignalCollection> it = this.sd.getSignalCollections();
            while (it.hasNext()) {
                SignalCollection sc = it.next();
                Signal<?> sSig = sc.findSignal(TextUtils.canonicString(nodeName));
                if (sSig == null) continue;
                found.add(sSig);
                return found;
            }
        }
        Set<Network> nets = h.getHighlightedNetworks();
        found.addAll(this.findSelectedSignals(nets, context, false));
        Collections.sort(found, new CompSignals());
        return found;
    }

    private List<Signal<?>> findSelectedSignals(Set<Network> nets, VarContext context, boolean sort) {
        Cell topContext = this.sd.getCell();
        ArrayList found = new ArrayList();
        for (Network net : nets) {
            String netName = WaveformWindow.getSpiceNetName(context, net);
            Iterator<SignalCollection> aIt = this.sd.getSignalCollections();
            while (aIt.hasNext()) {
                String temp;
                SignalCollection sc = aIt.next();
                Signal<?> sSig = sc.findSignal(TextUtils.canonicString(netName));
                if (sSig == null) {
                    if (topContext == null) {
                        topContext = net.getParent();
                    }
                    String nameWithCell = topContext.getName() + "." + netName;
                    sSig = sc.findSignal(TextUtils.canonicString(nameWithCell));
                }
                if (sSig == null) {
                    temp = WaveformWindow.getSpiceNetName(context, net, true, false);
                    sSig = sc.findSignal(TextUtils.canonicString(temp));
                }
                if (sSig == null) {
                    temp = WaveformWindow.getSpiceNetName(context, net, false, true);
                    sSig = sc.findSignal(TextUtils.canonicString(temp));
                }
                if (sSig == null) {
                    if (topContext == null) {
                        topContext = net.getParent();
                    }
                    temp = WaveformWindow.getSpiceNetName(context, net, false, true);
                    String nameWithCell = topContext.getName() + "." + temp;
                    sSig = sc.findSignal(TextUtils.canonicString(nameWithCell));
                }
                if (sSig == null) {
                    HierarchyEnumerator.NetNameProxy proxy;
                    Cell cell = net.getParent();
                    NccResult result2 = NccCrossProbing.getResults(cell);
                    if (result2 == null) {
                        for (VarContext checkContext = context; checkContext != VarContext.globalContext && (result2 = NccCrossProbing.getResults(cell = checkContext.getNodable().getParent())) == null; checkContext = checkContext.pop()) {
                        }
                    }
                    if (result2 != null && (proxy = result2.getEquivalence().findEquivalentNet(context, net)) != null) {
                        String otherName = WaveformWindow.getSpiceNetName(proxy.getContext(), proxy.getNet());
                        System.out.println("Mapped " + netName + " to " + otherName);
                        sSig = sc.findSignal(TextUtils.canonicString(otherName));
                    }
                }
                if (sSig == null) continue;
                List<Signal<?>> signalGroup = WaveformWindow.getSignalsFromExtractedNet(sc, sSig);
                for (Signal<?> s2 : signalGroup) {
                    found.add(s2);
                }
            }
        }
        if (sort) {
            Collections.sort(found, new CompSignals());
        }
        return found;
    }

    public List<Signal<?>> findAllSignals(Cell cell, VarContext context, boolean sort, boolean recurse) {
        HashSet<Network> nets = new HashSet<Network>();
        ArrayList found = new ArrayList();
        Iterator<Object> it = cell.getNetlist().getNetworks();
        while (it.hasNext()) {
            nets.add(it.next());
        }
        found.addAll(this.findSelectedSignals(nets, context, false));
        if (recurse) {
            it = cell.getNetlist().getNodables();
            while (it.hasNext()) {
                Nodable no = (Nodable)it.next();
                if (!(no.getProto() instanceof Cell)) continue;
                Cell subCell = (Cell)no.getProto();
                VarContext subContext = context.push(no);
                found.addAll(this.findAllSignals(subCell, subContext, false, true));
            }
        }
        if (sort) {
            Collections.sort(found, new CompSignals());
        }
        return found;
    }

    private static Network findNetwork(Netlist netlist, String name) {
        Network net;
        Iterator<Network> nIt = netlist.getNetworks();
        while (nIt.hasNext()) {
            net = nIt.next();
            if (!WaveformWindow.getSpiceNetName(net).equalsIgnoreCase(name)) continue;
            return net;
        }
        nIt = netlist.getNetworks();
        while (nIt.hasNext()) {
            net = nIt.next();
            String convertedName = WaveformWindow.getSpiceNetName(net).replace('@', '_');
            if (!convertedName.equalsIgnoreCase(name)) continue;
            return net;
        }
        nIt = netlist.getNetworks();
        while (nIt.hasNext()) {
            net = nIt.next();
            String netName = WaveformWindow.getSpiceNetName(net);
            if (netName.length() != name.length()) continue;
            boolean matches = true;
            for (int i = 0; i < netName.length(); ++i) {
                char netChar = netName.charAt(i);
                char nameChar = name.charAt(i);
                if (nameChar == '_') {
                    if (!TextUtils.isLetterOrDigit(netChar)) continue;
                    matches = false;
                    break;
                }
                if (TextUtils.canonicChar(nameChar) == TextUtils.canonicChar(netChar)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return net;
        }
        return null;
    }

    public void crossProbeWaveformToEditWindow() {
        if (this.freezeEditWindowHighlighting) {
            return;
        }
        this.freezeWaveformHighlighting = true;
        Iterator<WindowFrame> wIt = WindowFrame.getWindows();
        while (wIt.hasNext()) {
            Signal sig;
            ExplorerTree sigTree;
            Object nodeInfo;
            EditWindow wnd;
            Locator loc;
            WindowFrame wfr = wIt.next();
            if (!(wfr.getContent() instanceof EditWindow) || (loc = new Locator(wnd = (EditWindow)wfr.getContent(), this)).getWaveformWindow() != this) continue;
            VarContext context = loc.getContext();
            Cell cell = wnd.getCell();
            if (cell == null) continue;
            Highlighter hl = wnd.getHighlighter();
            Netlist netlist = cell.getNetlist();
            assert (netlist != null);
            hl.clear();
            for (Panel wp : this.wavePanels) {
                block2: for (WaveSignal ws : wp.getSignals()) {
                    if (!ws.isHighlighted()) continue;
                    String want = ws.getSignal().getFullName();
                    Stack<Nodable> upNodables = new Stack<Nodable>();
                    Network net = null;
                    Cell subCell = cell;
                    VarContext subContext = context;
                    while (true) {
                        NodeInst ni;
                        String desired;
                        String contextStr;
                        if ((contextStr = WaveformWindow.getSpiceNetName(subContext, null)).length() > 0) {
                            boolean matches = false;
                            String altContextStr = contextStr = contextStr + ".";
                            if (this.sd.getCell() != null) {
                                altContextStr = this.sd.getCell().getName().toLowerCase() + "." + contextStr;
                            }
                            if (want.startsWith(contextStr)) {
                                matches = true;
                            } else if (want.startsWith(contextStr = contextStr.replace('@', '_'))) {
                                matches = true;
                            }
                            if (!matches) {
                                if (want.startsWith(altContextStr)) {
                                    matches = true;
                                } else if (want.startsWith(altContextStr = altContextStr.replace('@', '_'))) {
                                    matches = true;
                                }
                                if (matches) {
                                    contextStr = altContextStr;
                                }
                            }
                            if (!matches) {
                                if (subContext == VarContext.globalContext) continue block2;
                                subCell = subContext.getNodable().getParent();
                                upNodables.push(subContext.getNodable());
                                subContext = subContext.pop();
                                continue;
                            }
                        }
                        if ((net = WaveformWindow.findNetwork(netlist, desired = want.substring(contextStr.length()))) != null) {
                            Nodable no;
                            while (!upNodables.isEmpty() && (net = HierarchyEnumerator.getNetworkInChild(net, no = (Nodable)upNodables.pop())) != null) {
                            }
                            if (net == null) continue block2;
                            hl.addNetwork(net, subCell);
                            continue block2;
                        }
                        if (desired.startsWith("I(v") && (ni = subCell.findNode(desired.substring(3))) != null) {
                            hl.addElectricObject(ni, subCell);
                        }
                        if (subContext == VarContext.globalContext) continue block2;
                        subCell = subContext.getNodable().getParent();
                        upNodables.push(subContext.getNodable());
                        subContext = subContext.pop();
                    }
                }
            }
            String contextStr = context.getInstPath(".");
            Cell topContext = this.sd.getCell();
            String altContextStr = contextStr;
            if (topContext != null) {
                altContextStr = topContext.getName().toLowerCase();
                if (contextStr.length() > 0) {
                    altContextStr = altContextStr + "." + contextStr;
                }
            }
            if ((nodeInfo = (sigTree = this.wf.getExplorerTab()).getCurrentlySelectedObject(0)) != null && nodeInfo instanceof Signal && ((sig = (Signal)nodeInfo).getSignalContext() == null || sig.getSignalContext().equals(contextStr) || sig.getSignalContext().equals(altContextStr))) {
                NodeInst ni;
                String desired = sig.getSignalName();
                Network net = WaveformWindow.findNetwork(netlist, desired);
                if (net != null) {
                    if (net.getParent() == cell) {
                        hl.addNetwork(net, cell);
                    }
                } else if (desired.startsWith("I(v") && (ni = cell.findNode(desired.substring(3))) != null) {
                    hl.addElectricObject(ni, cell);
                }
            }
            hl.finished();
        }
        this.freezeWaveformHighlighting = false;
    }

    private void updateAssociatedLayoutWindow() {
        WindowFrame oWf = this.findSchematicsWindow();
        if (oWf == null) {
            return;
        }
        EditWindow schemWnd = (EditWindow)oWf.getContent();
        boolean crossProbeChanged = schemWnd.hasCrossProbeData();
        schemWnd.clearCrossProbeLevels();
        Cell cell = this.getCell();
        Netlist netlist = cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return;
        }
        this.netValues = new HashMap<Network, Integer>();
        for (Panel wp : this.wavePanels) {
            if (wp.isHidden()) continue;
            for (WaveSignal ws : wp.getSignals()) {
                Signal<?> sig = ws.getSignal();
                Signal<?>[] bussedSignals = sig.getBusMembers();
                if (bussedSignals != null) {
                    for (Signal<?> subSig : bussedSignals) {
                        this.putValueOnTrace(subSig, this.netValues, netlist);
                    }
                    continue;
                }
                this.putValueOnTrace(sig, this.netValues, netlist);
            }
        }
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            Integer state;
            NodeInst ni = it.next();
            if (ni.getProto() != Generic.tech().simProbeNode) continue;
            Network net = null;
            Iterator<Connection> cIt = ni.getConnections();
            if (cIt.hasNext()) {
                Connection con = cIt.next();
                net = netlist.getNetwork(con.getArc(), 0);
            }
            if (net == null || (state = this.netValues.get(net)) == null) continue;
            Color col = this.getHighlightColor(state);
            schemWnd.addCrossProbeBox(ni.getBounds(), col);
            crossProbeChanged = true;
            this.netValues.remove(net);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            int width = netlist.getBusWidth(ai);
            for (int i = 0; i < width; ++i) {
                Network net = netlist.getNetwork(ai, i);
                Integer state = this.netValues.get(net);
                if (state == null) continue;
                Color col = this.getHighlightColor(state);
                schemWnd.addCrossProbeLine(ai.getHeadLocation(), ai.getTailLocation(), col);
                crossProbeChanged = true;
            }
        }
        if (crossProbeChanged) {
            schemWnd.repaint();
        }
    }

    private Color getHighlightColor(int state) {
        switch (state & 3) {
            case 0: {
                return new Color(User.getColor(User.ColorPrefType.WAVE_CROSS_LOW));
            }
            case 2: {
                return new Color(User.getColor(User.ColorPrefType.WAVE_CROSS_HIGH));
            }
            case 1: {
                return new Color(User.getColor(User.ColorPrefType.WAVE_CROSS_UNDEF));
            }
            case 3: {
                return new Color(User.getColor(User.ColorPrefType.WAVE_CROSS_FLOAT));
            }
        }
        return Color.RED;
    }

    private void putValueOnTrace(Signal<?> sig, Map<Network, Integer> netValues, Netlist netlist) {
        Network net = WaveformWindow.findNetwork(netlist, sig.getSignalName());
        if (net == null) {
            return;
        }
        Signal.View<?> view = sig.getExactView();
        int numEvents = view.getNumEvents();
        int state = 1;
        for (int i = numEvents - 1; i >= 0; --i) {
            double xValue = view.getTime(i);
            if (!(xValue <= this.mainXPosition)) continue;
            Object samp = view.getSample(i);
            if (!(samp instanceof DigitalSample)) {
                return;
            }
            DigitalSample ds = (DigitalSample)samp;
            if (ds.isLogic0()) {
                state = 0;
                break;
            }
            if (ds.isLogic1()) {
                state = 2;
                break;
            }
            if (!ds.isLogicZ()) break;
            state = 3;
            break;
        }
        netValues.put(net, new Integer(state));
    }

    public void centerCursor(boolean main2) {
        boolean havePanel = false;
        double lowXValue = 0.0;
        double highXValue = 0.0;
        for (Panel wp : this.wavePanels) {
            double low = wp.getMinXAxis();
            double high = wp.getMaxXAxis();
            if (havePanel) {
                lowXValue = Math.max(lowXValue, low);
                highXValue = Math.min(highXValue, high);
                continue;
            }
            lowXValue = low;
            highXValue = high;
            havePanel = true;
        }
        if (!havePanel) {
            return;
        }
        double center = (lowXValue + highXValue) / 2.0;
        if (main2) {
            this.setMainXPositionCursor(center);
        } else {
            this.setExtensionXPositionCursor(center);
        }
        for (Panel wp : this.wavePanels) {
            wp.repaintWithRulers();
        }
    }

    public void setSimData(Stimuli sd) {
        if (this.sd != null) {
            this.sd.finished();
        }
        this.sd = sd;
        this.resetSweeps();
        Signal<?> oldXAxisSignalAll = null;
        if (this.xAxisSignalAll != null) {
            oldXAxisSignalAll = this.xAxisSignalAll;
            this.xAxisSignalAll = null;
            SignalCollection sc = oldXAxisSignalAll.getSignalCollection();
            for (Signal signal : sc.getSignals()) {
                String newSigName = signal.getFullName();
                if (!newSigName.equals(oldXAxisSignalAll.getFullName())) continue;
                this.xAxisSignalAll = signal;
                break;
            }
            if (this.xAxisSignalAll == null) {
                System.out.println("Could not find main X axis signal " + oldXAxisSignalAll.getFullName() + " in the new data");
            }
        }
        ArrayList<Panel> panelList = new ArrayList<Panel>();
        for (Panel panel : this.wavePanels) {
            panelList.add(panel);
        }
        for (Panel panel : panelList) {
            boolean redoPanel = false;
            if (panel.getXAxisSignal() != null) {
                Signal<?> oldSig = panel.getXAxisSignal();
                panel.setXAxisSignal(null);
                String oldSigName = oldSig.getFullName();
                SignalCollection sc = oldSig.getSignalCollection();
                for (Signal<?> newSs : sc.getSignals()) {
                    String newSigName = newSs.getFullName();
                    if (!newSigName.equals(oldSigName)) continue;
                    panel.setXAxisSignal(newSs);
                    break;
                }
                if (panel.getXAxisSignal() == null) {
                    System.out.println("Could not find X axis signal " + oldSigName + " in the new data");
                    redoPanel = true;
                }
            }
            for (WaveSignal ws : panel.getSignals()) {
                Signal<?> ss = ws.getSignal();
                String oldSigName = ss.getFullName();
                ws.setSignal(null);
                SignalCollection sc = ss.getSignalCollection();
                for (Signal<?> newSs : sc.getSignals()) {
                    String newSigName = newSs.getFullName();
                    if (!newSigName.equals(oldSigName)) continue;
                    ws.setSignal(newSs);
                    break;
                }
                if (ws.getSignal() != null) continue;
                System.out.println("Could not find signal " + oldSigName + " in the new data");
                redoPanel = true;
            }
            block6: while (redoPanel) {
                redoPanel = false;
                for (WaveSignal ws : panel.getSignals()) {
                    Signal<?> s2 = ws.getSignal();
                    if (s2 != null) continue;
                    redoPanel = true;
                    if (panel.getSignalButtons() == null) continue block6;
                    panel.removeSignal(ws.getButton());
                    continue block6;
                }
            }
            if (panel.getNumSignals() == 0) {
                panel.getWaveWindow().closePanel(panel);
                continue;
            }
            if (panel.getSignalButtons() != null) {
                panel.getSignalButtons().validate();
                panel.getSignalButtons().repaint();
            }
            panel.repaintContents();
        }
        this.wf.wantToRedoSignalTree();
        if (sd.getEngine() != null) {
            System.out.println("Simulation data reloaded from circuit");
        } else {
            System.out.println("Simulation data reloaded from disk");
        }
    }

    public static WaveformWindow getCurrentWaveformWindow() {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Must select a Waveform window first");
            return null;
        }
        return (WaveformWindow)content;
    }

    public static void exportSimulationData() {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Must select a Waveform window first");
            return;
        }
        WaveformWindow ww = (WaveformWindow)content;
        String configurationFileName = OpenFile.chooseOutputFile(FileType.TEXT, "Waveform Export File", "wavedata.txt");
        if (configurationFileName == null) {
            return;
        }
        try {
            int i;
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(configurationFileName)));
            ArrayList dumpSignals = new ArrayList();
            ArrayList<Integer> dumpSweeps = new ArrayList<Integer>();
            ArrayList dumpWaveforms = new ArrayList();
            for (Panel wp : ww.wavePanels) {
                if (wp.isHidden()) continue;
                Signal<?> signalInX = ww.xAxisSignalAll;
                if (!ww.xAxisLocked) {
                    signalInX = wp.getXAxisSignal();
                }
                if (signalInX != null) {
                    WaveformWindow.addSignalSweep(signalInX, -1, dumpSignals, dumpSweeps, dumpWaveforms);
                }
                for (WaveSignal ws : wp.getSignals()) {
                    WaveformWindow.addSignalSweep(ws.getSignal(), -1, dumpSignals, dumpSweeps, dumpWaveforms);
                }
            }
            int numEntries = dumpSignals.size() + 1;
            String[] entries = new String[numEntries];
            entries[0] = "TIME";
            for (i = 1; i < numEntries; ++i) {
                Signal sig = (Signal)dumpSignals.get(i - 1);
                entries[i] = sig.getFullName();
                int s2 = (Integer)dumpSweeps.get(i - 1);
                if (s2 < 0) continue;
                int n = i;
                entries[n] = entries[n] + "/S=" + s2;
            }
            for (i = 0; i < numEntries; ++i) {
                if (i > 0) {
                    printWriter.print("\t");
                }
                printWriter.print(entries[i]);
            }
            printWriter.println();
            int j = 0;
            while (true) {
                int i2;
                boolean haveData = false;
                entries[0] = null;
                for (i2 = 1; i2 < numEntries; ++i2) {
                    Object sample;
                    entries[i2] = "";
                    Signal sig = (Signal)dumpSignals.get(i2 - 1);
                    Signal.View<DigitalSample> view = sig.getExactView();
                    if (j >= view.getNumEvents() || (sample = view.getSample(j)) == null) continue;
                    if (sample instanceof ScalarSample) {
                        double t = view.getTime(j);
                        double v = ((ScalarSample)sample).getValue();
                        if (entries[0] == null) {
                            entries[0] = "" + t;
                        }
                        entries[i2] = "" + v;
                        haveData = true;
                        continue;
                    }
                    if (!(sample instanceof DigitalSample)) continue;
                    if (entries[0] == null) {
                        entries[0] = "" + view.getTime(j);
                    }
                    entries[i2] = "" + DigitalSample.getState(view, j);
                    haveData = true;
                }
                if (!haveData) break;
                if (entries[0] == null) {
                    entries[0] = "";
                }
                for (i2 = 0; i2 < numEntries; ++i2) {
                    if (i2 > 0) {
                        printWriter.print("\t");
                    }
                    printWriter.print(entries[i2]);
                }
                printWriter.println();
                ++j;
            }
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error writing configuration");
            return;
        }
        System.out.println("Wrote " + configurationFileName);
    }

    private static void addSignalSweep(Signal<?> sig, int s2, List<Signal<?>> dumpSignals, List<Integer> dumpSweeps, List<Signal<?>> waveforms) {
        for (int i = 0; i < dumpSignals.size(); ++i) {
            if (dumpSignals.get(i) != sig || dumpSweeps.get(i) != s2) continue;
            return;
        }
        dumpSignals.add(sig);
        dumpSweeps.add(new Integer(s2));
        waveforms.add(sig);
    }

    public static void refreshSimulationData() {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Nothing to refresh in non Waveform window");
            return;
        }
        ((WaveformWindow)content).refreshData();
    }

    public static void clearSimulationData() {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Nothing to refresh in non Waveform window");
            return;
        }
        WaveformWindow ww = (WaveformWindow)content;
        ww.clearAllPanels();
        ww.saveSignalOrder();
    }

    public void clearAllPanels() {
        ArrayList<Panel> closeList = new ArrayList<Panel>();
        for (Panel wp : this.wavePanels) {
            closeList.add(wp);
        }
        for (Panel wp : closeList) {
            this.closePanel(wp);
        }
    }

    private void refreshData() {
        if (this.sd.getEngine() != null) {
            this.sd.getEngine().refresh();
            return;
        }
        SimulationData.plot(this.sd.getCell(), this.sd.getFileURL(), this);
    }

    public static void saveConfiguration() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        WaveformWindow ww = WaveformWindow.findWaveformWindow(cell);
        if (ww == null) {
            System.out.println("There is no waveform window to save");
            return;
        }
        String configurationFileName = OpenFile.chooseOutputFile(FileType.TEXT, "Waveform Configuration File", "waveform.txt");
        if (configurationFileName == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(configurationFileName)));
            for (int i = 0; i < ww.wavePanels.size(); ++i) {
                Panel wp = ww.wavePanels.get(i);
                if (wp.isHidden()) continue;
                boolean first = true;
                for (WaveSignal ws : wp.getSignals()) {
                    String sigName = ws.getSignal().getFullName();
                    if (first) {
                        first = false;
                        String collectionName = "";
                        String log = "";
                        if (wp.isPanelLogarithmicHorizontally()) {
                            log = " xlog";
                        }
                        if (wp.isPanelLogarithmicVertically()) {
                            log = log + " ylog";
                        }
                        if (i > 0) {
                            printWriter.println();
                        }
                        printWriter.println("panel" + collectionName + log);
                        printWriter.println("zoom " + wp.getYAxisLowValue() + " " + wp.getYAxisHighValue() + " " + wp.getMinXAxis() + " " + wp.getMaxXAxis());
                        Signal<?> signalInX = ww.xAxisSignalAll;
                        if (!ww.xAxisLocked) {
                            signalInX = wp.getXAxisSignal();
                        }
                        if (signalInX != null) {
                            printWriter.println("x-axis " + signalInX.getFullName());
                        }
                    }
                    Color color = ws.getColor();
                    printWriter.println("signal " + sigName + " " + color.getRed() + "," + color.getGreen() + "," + color.getBlue());
                }
            }
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error writing configuration");
            return;
        }
        System.out.println("Wrote " + configurationFileName);
    }

    public static void restoreConfiguration() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        WaveformWindow ww = WaveformWindow.findWaveformWindow(cell);
        if (ww == null) {
            System.out.println("There is no waveform window to restore");
            return;
        }
        String configurationFileName = OpenFile.chooseInputFile(FileType.TEXT, "Waveform Configuration File", null);
        if (configurationFileName == null) {
            return;
        }
        ww.clearAllPanels();
        URL url = TextUtils.makeURLToFile(configurationFileName);
        Panel curPanel = null;
        try {
            String buf;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            while ((buf = lineReader.readLine()) != null) {
                Signal<?> sig;
                Stimuli sd;
                SignalCollection sc;
                String[] keywords = buf.split(" ");
                if (keywords.length == 0) continue;
                if (keywords[0].equals("panel")) {
                    boolean xLog = false;
                    boolean yLog = false;
                    for (int i = 1; i < keywords.length; ++i) {
                        if (keywords[i].equals("xlog")) {
                            xLog = true;
                            continue;
                        }
                        if (!keywords[i].equals("ylog")) continue;
                        yLog = true;
                    }
                    int height = User.getWaveformDigitalPanelHeight();
                    if (ww.getSimData().isAnalog()) {
                        height = User.getWaveformAnalogPanelHeight();
                    }
                    curPanel = new Panel(ww, height);
                    if (xLog) {
                        if (ww.isXAxisLocked()) {
                            ww.togglePanelXAxisLock();
                        }
                        curPanel.setPanelLogarithmicHorizontally(true);
                    }
                    if (!yLog) continue;
                    curPanel.setPanelLogarithmicVertically(true);
                    continue;
                }
                if (keywords[0].equals("zoom")) {
                    if (curPanel == null) continue;
                    double lowYValue = TextUtils.atof(keywords[1]);
                    double highYValue = TextUtils.atof(keywords[2]);
                    double lowXValue = TextUtils.atof(keywords[3]);
                    double highXValue = TextUtils.atof(keywords[4]);
                    curPanel.setXAxisRange(lowXValue, highXValue);
                    curPanel.setYAxisRange(lowYValue, highYValue);
                    continue;
                }
                if (keywords[0].equals("x-axis")) {
                    Signal<?> sig2;
                    Stimuli sd2;
                    SignalCollection sc2;
                    if (curPanel == null || (sc2 = (sd2 = ww.getSimData()).getSignalCollections().next()) == null || (sig2 = WaveformWindow.findSignalForNetwork(sc2, keywords[1])) == null) continue;
                    if (ww.isXAxisLocked()) {
                        ww.togglePanelXAxisLock();
                    }
                    curPanel.setXAxisSignal(sig2);
                    continue;
                }
                if (!keywords[0].equals("signal") || curPanel == null || (sc = (sd = ww.getSimData()).getSignalCollections().next()) == null || (sig = WaveformWindow.findSignalForNetwork(sc, keywords[1])) == null) continue;
                String[] colorNames = keywords[2].split(",");
                int red = TextUtils.atoi(colorNames[0]);
                int green = TextUtils.atoi(colorNames[1]);
                int blue = TextUtils.atoi(colorNames[2]);
                Color color = new Color(red, green, blue);
                WaveSignal ws = new WaveSignal(curPanel, sig);
                ws.setColor(color);
            }
            lineReader.close();
            for (Panel panel : ww.wavePanels) {
                panel.repaintWithRulers();
            }
            ww.saveSignalOrder();
        }
        catch (IOException e) {
            System.out.println("Error reading " + configurationFileName);
            return;
        }
    }

    public void saveSignalOrder() {
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (Panel wp : this.wavePanels) {
            boolean first = true;
            for (WaveSignal ws : wp.getSignals()) {
                String sigName = ws.getSignal().getFullName();
                if (first) {
                    sb.append("\t");
                    Signal<?> signalInX = this.xAxisSignalAll;
                    if (!this.xAxisLocked) {
                        signalInX = wp.getXAxisSignal();
                    }
                    first = false;
                    if (signalInX != null) {
                        sb.append("(" + signalInX.getFullName() + ")");
                    }
                }
                sb.append("\t");
                sb.append(sigName);
                Color color = ws.getColor();
                sb.append(" {" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "}");
            }
            sb.append("\n");
        }
        savedSignalOrder.put(cell.getId(), sb.toString());
    }

    public static void preserveSignalOrder() {
        Pref.delayPrefFlushing();
        for (Map.Entry<CellId, String> e : savedSignalOrder.entrySet()) {
            CellId cellId = e.getKey();
            String savedOrder = e.getValue();
            Preferences libPrefs = Pref.getLibraryPreferences(cellId.libId);
            String key = "SavedSignalsForCell" + cellId.cellName.getName();
            if (savedOrder.length() == 0) {
                libPrefs.remove(key);
                continue;
            }
            libPrefs.put(key, savedOrder);
        }
        Pref.resumePrefFlushing();
    }

    public static String[] getSignalOrder(Cell cell) {
        int endCh;
        String key;
        Preferences libPrefs;
        CellId cellId = cell.getId();
        String savedOrder = savedSignalOrder.get(cellId);
        if (savedOrder == null && (savedOrder = (libPrefs = Pref.getLibraryPreferences(cellId.libId)).get(key = "SavedSignalsForCell" + cellId.cellName.getName(), "")).length() == 0) {
            return new String[0];
        }
        ArrayList<String> panels = new ArrayList<String>();
        int startPos = 0;
        while ((endCh = savedOrder.indexOf(10, startPos)) >= 0) {
            String panel = savedOrder.substring(startPos, endCh);
            panels.add(panel);
            startPos = endCh + 1;
        }
        String[] ret = new String[panels.size()];
        int i = 0;
        for (String s2 : panels) {
            ret[i++] = s2;
        }
        return ret;
    }

    public Font getFont() {
        return this.waveWindowFont;
    }

    public FontRenderContext getFontRenderContext() {
        return this.waveWindowFRC;
    }

    public Color getOffStrengthColor() {
        return this.offStrengthColor;
    }

    public Color getNodeStrengthColor() {
        return this.nodeStrengthColor;
    }

    public Color getGateStrengthColor() {
        return this.gateStrengthColor;
    }

    public Color getPowerStrengthColor() {
        return this.powerStrengthColor;
    }

    public void toggleShowPoints() {
        this.linePointMode = (this.linePointMode + 1) % 3;
        switch (this.linePointMode) {
            case 0: {
                this.showPoints.setIcon(iconLineOnPointOff);
                break;
            }
            case 1: {
                this.showPoints.setIcon(iconLineOnPointOn);
                break;
            }
            case 2: {
                this.showPoints.setIcon(iconLineOffPointOn);
            }
        }
        for (Panel wp : this.wavePanels) {
            wp.repaintWithRulers();
        }
    }

    public int getLinePointMode() {
        return this.linePointMode;
    }

    public void toggleGridPoints() {
        this.showGrid = !this.showGrid;
        for (Panel wp : this.wavePanels) {
            wp.repaintWithRulers();
        }
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void addSignal(Signal<?> sig) {
        Signal<?> as = sig;
        boolean found = false;
        if (!sig.isDigital()) {
            for (Panel wp : this.wavePanels) {
                if (!wp.isSelected()) continue;
                WaveSignal.addSignalToPanel(sig, wp, null);
                if (this.getMainHorizRuler() != null) {
                    this.getMainHorizRuler().repaint();
                }
                found = true;
                break;
            }
        }
        if (!found) {
            Panel wp = this.makeNewPanel(-1);
            wp.fitToSignal(as);
            if (!this.xAxisLocked) {
                wp.setXAxisRange(as.getMinTime(), as.getMaxTime());
            }
            WaveSignal.addSignalToPanel(sig, wp, null);
            if (this.getMainHorizRuler() != null) {
                this.getMainHorizRuler().repaint();
            }
        }
        this.overall.validate();
        this.saveSignalOrder();
    }

    public void deleteSelectedSignals() {
        for (Panel wp : this.wavePanels) {
            if (!wp.isSelected()) continue;
            boolean removedSingleStimuli = false;
            for (WaveSignal ws : wp.getSignals()) {
                if (ws.getSelectedControlPoints() == null || this.sd.getEngine() == null || !this.sd.getEngine().removeSelectedStimuli()) continue;
                removedSingleStimuli = true;
            }
            if (removedSingleStimuli) break;
            this.deleteSignalFromPanel(wp);
            break;
        }
    }

    public static void fillInX() {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Must select a Waveform window first");
            return;
        }
        WaveformWindow ww = (WaveformWindow)content;
        ww.fillWaveform(1);
    }

    public static void fillInY() {
        WindowFrame current = WindowFrame.getCurrentWindowFrame();
        WindowContent content = current.getContent();
        if (!(content instanceof WaveformWindow)) {
            System.out.println("Must select a Waveform window first");
            return;
        }
        WaveformWindow ww = (WaveformWindow)content;
        ww.fillWaveform(2);
    }

    @Override
    public void fillScreen() {
        this.fillWaveform(3);
    }

    private void fillWaveform(int how) {
        double leftEdge = 0.0;
        double rightEdge = 0.0;
        HashMap<Panel, Double> panelLefts = new HashMap<Panel, Double>();
        HashMap<Panel, Double> panelRights = new HashMap<Panel, Double>();
        for (Panel wp : this.wavePanels) {
            double panelLeft = 0.0;
            double panelRight = 0.0;
            for (WaveSignal ws : wp.getSignals()) {
                double minX = ws.getSignal().getMinTime();
                double maxX = ws.getSignal().getMaxTime();
                if (wp.getXAxisSignal() == ws.getSignal()) {
                    minX = ws.getSignal().getMinValue();
                    maxX = ws.getSignal().getMaxValue();
                }
                if (panelLeft == panelRight) {
                    panelLeft = minX;
                    panelRight = maxX;
                    continue;
                }
                panelLeft = Math.min(panelLeft, minX);
                panelRight = Math.max(panelRight, maxX);
            }
            panelLefts.put(wp, new Double(panelLeft));
            panelRights.put(wp, new Double(panelRight));
            if (leftEdge == rightEdge) {
                leftEdge = panelLeft;
                rightEdge = panelRight;
                continue;
            }
            leftEdge = Math.min(leftEdge, panelLeft);
            rightEdge = Math.max(rightEdge, panelRight);
        }
        if (this.xAxisLocked && this.xAxisSignalAll != null) {
            leftEdge = this.xAxisSignalAll.getMinValue();
            rightEdge = this.xAxisSignalAll.getMaxValue();
        }
        for (Panel wp : this.wavePanels) {
            if (!this.xAxisLocked && !wp.isSelected()) continue;
            double useLeft = leftEdge;
            double useRight = rightEdge;
            if (!this.xAxisLocked) {
                useLeft = (Double)panelLefts.get(wp);
                useRight = (Double)panelRights.get(wp);
            }
            if ((how & 2) != 0) {
                wp.fitToSignal(null);
            }
            if (useLeft == useRight || wp.getMinXAxis() == useLeft && wp.getMaxXAxis() == useRight || (how & 1) == 0) continue;
            wp.setXAxisRange(useLeft, useRight);
            wp.repaintWithRulers();
        }
    }

    @Override
    public void zoomOutContents() {
        for (Panel wp : this.wavePanels) {
            if (!this.xAxisLocked && !wp.isSelected()) continue;
            boolean timeInXAxis = true;
            if (this.xAxisLocked) {
                if (this.xAxisSignalAll != null) {
                    timeInXAxis = false;
                }
            } else if (wp.getXAxisSignal() != null) {
                timeInXAxis = false;
            }
            double range2 = wp.getMaxXAxis() - wp.getMinXAxis();
            wp.setXAxisRange(wp.getMinXAxis() - range2 / 2.0, wp.getMaxXAxis() + range2 / 2.0);
            if (wp.getMinXAxis() < 0.0 && timeInXAxis) {
                wp.setXAxisRange(0.0, wp.getMaxXAxis() - wp.getMinXAxis());
            }
            wp.repaintWithRulers();
        }
    }

    @Override
    public void zoomInContents() {
        for (Panel wp : this.wavePanels) {
            if (!this.xAxisLocked && !wp.isSelected()) continue;
            double range2 = wp.getMaxXAxis() - wp.getMinXAxis();
            wp.setXAxisRange(wp.getMinXAxis() + range2 / 4.0, wp.getMaxXAxis() - range2 / 4.0);
            wp.repaintWithRulers();
        }
    }

    @Override
    public void focusOnHighlighted() {
        double minXPosition;
        double maxXPosition;
        double size2;
        if (this.mainXPosition == this.extXPosition) {
            return;
        }
        if (this.mainXPosition > this.extXPosition) {
            size2 = (this.mainXPosition - this.extXPosition) / 20.0;
            maxXPosition = this.mainXPosition + size2;
            minXPosition = this.extXPosition - size2;
        } else {
            size2 = (this.extXPosition - this.mainXPosition) / 20.0;
            maxXPosition = this.extXPosition + size2;
            minXPosition = this.mainXPosition - size2;
        }
        for (Panel wp : this.wavePanels) {
            if (!this.xAxisLocked && !wp.isSelected() || wp.getMinXAxis() == minXPosition && wp.getMaxXAxis() == maxXPosition) continue;
            if (wp.getMinXAxis() > wp.getMaxXAxis()) {
                wp.setXAxisRange(maxXPosition, minXPosition);
            } else {
                wp.setXAxisRange(minXPosition, maxXPosition);
            }
            wp.repaintWithRulers();
        }
    }

    public boolean isWaveWindowLogarithmic() {
        return this.mainHorizRulerPanelLogarithmic;
    }

    public void setWaveWindowLogarithmic(boolean logarithmic) {
        this.mainHorizRulerPanelLogarithmic = logarithmic;
        this.mainHorizRulerPanel.repaint();
    }

    private static Signal<?> getSignalFromName(String[] sigNames, WaveformWindow ww, StringBuffer signalCollectionName) {
        if (sigNames.length != 1) {
            Job.getUserInterface().showErrorMessage("Only one signal can be dragged to a ruler", "Too Much Selected");
            return null;
        }
        Signal<?> sSig = null;
        if (sigNames[0].startsWith("PANEL ")) {
            int sigPos = Math.max(sigNames[0].indexOf("MOVEBUTTON "), sigNames[0].indexOf("COPYBUTTON "));
            if (sigPos >= 0) {
                int panelNumber = TextUtils.atoi(sigNames[0].substring(6));
                Panel sourcePanel = ww.getPanelFromNumber(panelNumber);
                String signalName = sigNames[0].substring(sigPos + 11);
                for (WaveSignal ws : sourcePanel.getSignals()) {
                    if (!ws.getSignal().getFullName().equals(signalName)) continue;
                    sSig = ws.getSignal();
                    break;
                }
                signalCollectionName.replace(0, signalCollectionName.length(), sSig.getSignalCollection().getName());
            }
        } else {
            SignalCollection sc = ww.getSimData().findSignalCollection(signalCollectionName.toString());
            if (sc == null) {
                System.out.println("Cannot find " + signalCollectionName.toString() + " data");
                return null;
            }
            sSig = ww.findSignal(sigNames[0], sc);
        }
        return sSig;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    public static void refreshSimulationData(Stimuli sd, WaveformWindow ww) {
        ww.setSimData(sd);
    }

    /*
     * WARNING - void declaration
     */
    public static void showSimulationDataInNewWindow(Stimuli sd) {
        WaveformWindow ww = null;
        Iterator<SignalCollection> scIt = sd.getSignalCollections();
        if (!scIt.hasNext()) {
            System.out.println("ERROR: No simulation data found: waveform window not shown");
            return;
        }
        SignalCollection sc = scIt.next();
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        ww = (WaveformWindow)wf.getContent();
        if (sd.getCell() != null) {
            void var8_14;
            String[] signalNames = WaveformWindow.getSignalOrder(sd.getCell());
            boolean showedSomething = false;
            boolean wantUnlockedTime = false;
            boolean bl = false;
            while (var8_14 < signalNames.length) {
                int tabPos;
                String signalName = signalNames[var8_14];
                Signal<?> xAxisSignal = null;
                int start = 0;
                if (signalName.startsWith("\t")) {
                    int openPos = signalName.indexOf(40);
                    int tabPos2 = signalName.indexOf(9, 1);
                    start = tabPos2 + 1;
                    if (openPos >= 0) {
                        tabPos2 = openPos;
                    }
                }
                Panel wp = null;
                boolean firstSignal = true;
                do {
                    Signal<?> sSig;
                    tabPos = signalName.indexOf(9, start);
                    String sigName = null;
                    if (tabPos < 0) {
                        sigName = signalName.substring(start);
                    } else {
                        sigName = signalName.substring(start, tabPos);
                        start = tabPos + 1;
                    }
                    Color sigColor = null;
                    int colorPos = sigName.indexOf(" {");
                    if (colorPos >= 0) {
                        String[] colorNames = sigName.substring(colorPos + 2).split(",");
                        int red = TextUtils.atoi(colorNames[0]);
                        int green = TextUtils.atoi(colorNames[1]);
                        int blue = TextUtils.atoi(colorNames[2]);
                        sigColor = new Color(red, green, blue);
                        sigName = sigName.substring(0, colorPos);
                    }
                    if ((sSig = WaveformWindow.findSignalForNetwork(sc, sigName)) == null) continue;
                    if (firstSignal) {
                        firstSignal = false;
                        int height = User.getWaveformDigitalPanelHeight();
                        if (sd.isAnalog()) {
                            height = User.getWaveformAnalogPanelHeight();
                        }
                        wp = new Panel(ww, height);
                        if (xAxisSignal != null) {
                            wp.setXAxisSignal(xAxisSignal);
                        }
                        wp.makeSelectedPanel(-1, -1);
                        showedSomething = true;
                    }
                    WaveSignal ws = new WaveSignal(wp, sSig);
                    if (sigColor == null) continue;
                    ws.setColor(sigColor);
                } while (tabPos >= 0);
                ++var8_14;
            }
            if (showedSomething) {
                if (wantUnlockedTime) {
                    ww.togglePanelXAxisLock();
                    Iterator<Panel> iterator2 = ww.getPanels();
                    while (iterator2.hasNext()) {
                        Panel panel = iterator2.next();
                        panel.makeSelectedPanel(-1, -1);
                        ww.fillScreen();
                    }
                } else {
                    ww.fillScreen();
                }
                return;
            }
        }
        if (sc == null) {
            System.out.println("ERROR: No simulation data found: waveform window not shown");
            return;
        }
        if (sd.isAnalog()) {
            int height = User.getWaveformAnalogPanelHeight();
            Panel wp = new Panel(ww, height);
            wp.makeSelectedPanel(-1, -1);
        } else {
            int numSignals = 0;
            Collection<Signal<?>> allSignals = sc.getSignals();
            WaveformWindow.makeBussedSignals(sc, sd);
            for (Signal signal : allSignals) {
                Signal sDSig = signal;
                if (sDSig.getSignalContext() != null || sDSig.getSignalName().indexOf(64) >= 0) continue;
                int height = User.getWaveformDigitalPanelHeight();
                Panel wp = new Panel(ww, height);
                wp.makeSelectedPanel(-1, -1);
                new WaveSignal(wp, sDSig);
                if (++numSignals <= 15) continue;
                break;
            }
        }
        ww.getPanel().validate();
        ww.fillScreen();
    }

    private static void makeBussedSignals(SignalCollection sc, Stimuli sd) {
        Collection<Signal<?>> signalsi = sc.getSignals();
        ArrayList<Signal> signals = new ArrayList<Signal>();
        for (Signal signal : signalsi) {
            signals.add(signal);
        }
        for (int i = 0; i < signals.size(); ++i) {
            Signal nextSig;
            int nextBracketPos;
            int j;
            Signal signal = (Signal)signals.get(i);
            int thisBracketPos = signal.getSignalName().indexOf(91);
            if (thisBracketPos < 0) continue;
            String prefix = signal.getSignalName().substring(0, thisBracketPos);
            for (j = i + 1; j < signals.size() && (nextBracketPos = (nextSig = (Signal)signals.get(j)).getSignalName().indexOf(91)) >= 0 && thisBracketPos == nextBracketPos && prefix.equals(nextSig.getSignalName().substring(0, nextBracketPos)) && !(signal.getSignalContext() == null ^ nextSig.getSignalContext() == null) && (signal.getSignalContext() == null || signal.getSignalContext().equals(nextSig.getSignalContext())); ++j) {
            }
            int numSignals = j - i;
            if (numSignals <= 1) continue;
            DigitalSample.createSignal(sc, sd, prefix, signal.getSignalContext());
            i = j - 1;
        }
    }

    public static Signal<?> findSignalForNetwork(SignalCollection sc, String netName) {
        for (Signal<?> sSig : sc.getSignals()) {
            String signalName = sSig.getFullName();
            if (netName.equalsIgnoreCase(signalName)) {
                return sSig;
            }
            if (signalName.length() + 1 == netName.length() && netName.charAt(signalName.length()) == ']') {
                signalName = signalName + "_";
            }
            if (signalName.length() != netName.length() || signalName.indexOf(95) < 0) continue;
            boolean matches = true;
            for (int i = 0; i < signalName.length(); ++i) {
                char sigChar = signalName.charAt(i);
                char netChar = netName.charAt(i);
                if (TextUtils.isLetterOrDigit(sigChar) != TextUtils.isLetterOrDigit(netChar)) {
                    matches = false;
                    break;
                }
                if (!TextUtils.isLetterOrDigit(sigChar) || TextUtils.canonicChar(sigChar) == TextUtils.canonicChar(netChar)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return sSig;
        }
        return null;
    }

    public static List<Signal<?>> getSignalsFromExtractedNet(SignalCollection sc, Signal<?> ws) {
        String sigName = ws.getFullName();
        ArrayList ret = new ArrayList();
        if (sigName == null) {
            return ret;
        }
        sigName = TextUtils.canonicString(sigName);
        sigName = ws.getBaseNameFromExtractedNet(sigName);
        for (Signal<?> s2 : sc.getSignals()) {
            if (!ws.getBaseNameFromExtractedNet(TextUtils.canonicString(s2.getFullName())).equals(sigName)) continue;
            ret.add(s2);
        }
        return ret;
    }

    private static class WaveComponentListener
    implements ComponentListener {
        private JPanel panel;

        public WaveComponentListener(JPanel panel) {
            this.panel = panel;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.panel.repaint();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private class WaveformWindowHighlightListener
    implements HighlightListener {
        private WaveformWindowHighlightListener() {
        }

        @Override
        public void highlightChanged(Highlighter which) {
            if (WaveformWindow.this.freezeWaveformHighlighting) {
                return;
            }
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                EditWindow wnd;
                WindowFrame highWF = it.next();
                if (!(highWF.getContent() instanceof EditWindow) || (wnd = (EditWindow)highWF.getContent()).getHighlighter() != which) continue;
                WaveformWindow.this.crossProbeEditWindowToWaveform(wnd, which);
                break;
            }
        }

        @Override
        public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        }
    }

    public static class Locator {
        private WaveformWindow ww;
        private VarContext context;

        public Locator(EditWindow wnd) {
            Cell cellInWindow = wnd.getCell();
            VarContext curContext = wnd.getVarContext();
            this.ww = null;
            Stack<Nodable> contextStack = new Stack<Nodable>();
            while (true) {
                Nodable no;
                this.ww = WaveformWindow.findWaveformWindow(cellInWindow);
                if (this.ww != null || (no = curContext.getNodable()) == null) break;
                contextStack.push(no);
                cellInWindow = no.getParent();
                curContext = curContext.pop();
            }
            this.context = VarContext.globalContext;
            while (!contextStack.isEmpty()) {
                this.context = this.context.push((Nodable)contextStack.pop());
            }
        }

        public Locator(EditWindow wnd, WaveformWindow wantWW) {
            Cell cellInWindow = wnd.getCell();
            VarContext curContext = wnd.getVarContext();
            this.ww = null;
            Stack<Nodable> contextStack = new Stack<Nodable>();
            while (true) {
                if (wantWW.getCell() == cellInWindow) {
                    this.ww = wantWW;
                    break;
                }
                Nodable no = curContext.getNodable();
                if (no == null) break;
                contextStack.push(no);
                cellInWindow = no.getParent();
                curContext = curContext.pop();
            }
            this.context = VarContext.globalContext;
            while (!contextStack.isEmpty()) {
                this.context = this.context.push((Nodable)contextStack.pop());
            }
        }

        public WaveformWindow getWaveformWindow() {
            return this.ww;
        }

        public VarContext getContext() {
            return this.context;
        }
    }

    private static class WaveFormDropTarget
    implements DropTargetListener {
        private WaveFormDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Panel panel;
            Object data = null;
            try {
                dtde.acceptDrop(0x40000000);
                data = dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (data == null) {
                    dtde.dropComplete(false);
                    return;
                }
            }
            catch (Throwable t) {
                ActivityLogger.logException(t);
                dtde.dropComplete(false);
                return;
            }
            if (!(data instanceof String)) {
                dtde.dropComplete(false);
                return;
            }
            String sigNameData = (String)data;
            String[] sigNames = sigNameData.split("\n");
            StringBuffer signalCollectionName = new StringBuffer();
            for (int i = 0; i < sigNames.length; ++i) {
                String collectionName = "SIGNALS";
                String aSigName = sigNames[i];
                if (aSigName.startsWith("TRANS ")) {
                    sigNames[i] = aSigName.substring(6);
                    collectionName = "TRANS SIGNALS";
                } else if (aSigName.startsWith("MEASUREMENTS ")) {
                    sigNames[i] = aSigName.substring(12);
                    collectionName = "MEASUREMENTS";
                } else if (aSigName.startsWith("AC ")) {
                    sigNames[i] = aSigName.substring(3);
                    collectionName = "AC SIGNALS";
                } else if (aSigName.startsWith("DC ")) {
                    sigNames[i] = aSigName.substring(3);
                    collectionName = "DC SIGNALS";
                }
                if (signalCollectionName.length() == 0) {
                    signalCollectionName.append(collectionName);
                    continue;
                }
                if (signalCollectionName.equals(collectionName)) continue;
                Job.getUserInterface().showErrorMessage("All signals must be the same type", "Incorrect Signal Selection");
                dtde.dropComplete(false);
                return;
            }
            if (signalCollectionName.length() == 0) {
                dtde.dropComplete(false);
                return;
            }
            DropTarget dt = (DropTarget)dtde.getSource();
            if (dt.getComponent() instanceof HorizRuler) {
                if (sigNames.length != 1) {
                    Job.getUserInterface().showErrorMessage("Only one signal can be dragged to a ruler", "Too Much Selected");
                    dtde.dropComplete(false);
                    return;
                }
                HorizRuler hr = (HorizRuler)dt.getComponent();
                panel = hr.getPanel();
                WaveformWindow ww = hr.getWaveformWindow();
                Signal sSig = WaveformWindow.getSignalFromName(sigNames, ww, signalCollectionName);
                if (sSig == null) {
                    dtde.dropComplete(false);
                    return;
                }
                if (panel == null) {
                    ww.xAxisSignalAll = sSig;
                    for (Panel wp : ww.wavePanels) {
                        wp.setXAxisRange(sSig.getMinValue(), sSig.getMaxValue());
                    }
                    ww.redrawAllPanels();
                } else {
                    panel.setXAxisSignal(sSig);
                    panel.setXAxisRange(sSig.getMinValue(), sSig.getMaxValue());
                    panel.repaintContents();
                }
                hr.repaint();
                ww.saveSignalOrder();
                dtde.dropComplete(false);
                return;
            }
            WaveformWindow ww = null;
            panel = null;
            if (dt.getComponent() instanceof Panel) {
                panel = (Panel)dt.getComponent();
                ww = panel.getWaveWindow();
            }
            if (dt.getComponent() instanceof OnePanel) {
                OnePanel op = (OnePanel)dt.getComponent();
                ww = op.getWaveformWindow();
                panel = op.getPanel();
            }
            if (dt.getComponent() instanceof WaveTable) {
                HorizRuler hr;
                Object obj;
                OnePanel op;
                WaveTable table = (WaveTable)dt.getComponent();
                ww = table.ww;
                int row = table.rowAtPoint(dtde.getLocation());
                if (row != -1 && (panel = (op = (OnePanel)(obj = ww.tableModel.getValueAt(row, 0))).getPanel()).getHorizRuler() != null && (hr = panel.getHorizRuler()).getBounds().contains(dtde.getLocation())) {
                    Signal sSig = WaveformWindow.getSignalFromName(sigNames, ww, signalCollectionName);
                    if (sSig != null) {
                        panel.setXAxisSignal(sSig);
                        panel.setXAxisRange(sSig.getMinValue(), sSig.getMaxValue());
                        panel.repaintContents();
                    }
                    dtde.dropComplete(false);
                    return;
                }
            }
            if (panel == null) {
                dtde.dropComplete(false);
                return;
            }
            if (sigNames[0].startsWith("PANEL ")) {
                int panelNumber = TextUtils.atoi(sigNames[0].substring(6));
                Panel sourcePanel = ww.getPanelFromNumber(panelNumber);
                if (sourcePanel == panel) {
                    dtde.dropComplete(false);
                    return;
                }
                int sigMovePos = sigNames[0].indexOf("MOVEBUTTON ");
                int sigCopyPos = sigNames[0].indexOf("COPYBUTTON ");
                if (sigMovePos < 0 && sigCopyPos < 0) {
                    ww.stopEditing();
                    ww.wavePanels.remove(sourcePanel);
                    int destIndex = ww.wavePanels.indexOf(panel);
                    if (dtde.getLocation().y > panel.getBounds().height / 2) {
                        ++destIndex;
                    }
                    ww.wavePanels.add(destIndex, sourcePanel);
                    ww.reloadTable();
                    ww.table.repaint();
                    ww.getPanel().validate();
                    dtde.dropComplete(true);
                    ww.saveSignalOrder();
                    return;
                }
                int sigPos = Math.max(sigMovePos, sigCopyPos);
                String signalName = sigNames[0].substring(sigPos + 11);
                Signal<?> sSig = null;
                Color oldColor = null;
                for (WaveSignal ws : sourcePanel.getSignals()) {
                    if (!ws.getSignal().getFullName().equals(signalName)) continue;
                    sSig = ws.getSignal();
                    oldColor = ws.getColor();
                    if (sigCopyPos >= 0) break;
                    sourcePanel.removeHighlightedSignal(ws, true);
                    sourcePanel.removeSignal(ws.getButton());
                    break;
                }
                if (sSig != null) {
                    sourcePanel.getSignalButtons().validate();
                    sourcePanel.getSignalButtons().repaint();
                    sourcePanel.repaintContents();
                    WaveSignal.addSignalToPanel(sSig, panel, oldColor);
                }
                ww.saveSignalOrder();
                dtde.dropComplete(true);
                return;
            }
            SignalCollection sc = ww.getSimData().findSignalCollection(signalCollectionName.toString());
            if (sc == null) {
                System.out.print("Error: could not find signal collection '" + signalCollectionName.toString() + "' (existing collections: ");
                boolean others = false;
                Iterator<SignalCollection> it = ww.getSimData().getSignalCollections();
                while (it.hasNext()) {
                    SignalCollection sCol = it.next();
                    if (others) {
                        System.out.print(", ");
                    }
                    others = true;
                    System.out.print(sCol.getName());
                }
                System.out.println(")");
                return;
            }
            for (int i = 0; i < sigNames.length; ++i) {
                Signal sSig = ww.findSignal(sigNames[i], sc);
                if (sSig == null) {
                    dtde.dropComplete(false);
                    return;
                }
                if (panel != null) {
                    WaveSignal.addSignalToPanel(sSig, panel, null);
                    panel.makeSelectedPanel(-1, -1);
                    continue;
                }
                panel = ww.makeNewPanel(-1);
                panel.fitToSignal(sSig);
                new WaveSignal(panel, sSig);
            }
            ww.overall.validate();
            panel.repaintContents();
            panel.getWaveWindow().saveSignalOrder();
            dtde.dropComplete(true);
        }
    }

    public static class OnePanel
    extends JPanel {
        Panel panel;
        WaveformWindow ww;

        public OnePanel(Panel panel, WaveformWindow ww) {
            this.panel = panel;
            this.ww = ww;
        }

        public Panel getPanel() {
            return this.panel;
        }

        public WaveformWindow getWaveformWindow() {
            return this.ww;
        }
    }

    private static class CompSignals
    implements Comparator<Signal<?>> {
        private CompSignals() {
        }

        @Override
        public int compare(Signal<?> s1, Signal<?> s2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(s1.getFullName(), s2.getFullName());
        }
    }

    public static class SignalsByName
    implements Comparator<Signal<?>> {
        @Override
        public int compare(Signal<?> s1, Signal<?> s2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(s1.getFullName(), s2.getFullName());
        }
    }

    private class TableMouseListener
    implements MouseListener,
    MouseMotionListener {
        private int mouseXOffset;
        private int mouseYOffset;
        private int resizingRow;
        private TableColumn resizingColumn;
        private JTable table;

        public TableMouseListener(JTable table) {
            this.table = table;
            table.addMouseListener(this);
            table.addMouseMotionListener(this);
        }

        private TableColumn getResizingColumn(Point p) {
            int columnIndex;
            int column = this.table.columnAtPoint(p);
            if (column == -1) {
                return null;
            }
            int row = this.table.rowAtPoint(p);
            if (row == -1) {
                return null;
            }
            Rectangle r = this.table.getCellRect(row, column, true);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return null;
            }
            int midPoint = r.x + r.width / 2;
            int n = columnIndex = p.x < midPoint ? column - 1 : column;
            if (columnIndex == -1) {
                return null;
            }
            return this.table.getTableHeader().getColumnModel().getColumn(columnIndex);
        }

        private int getResizingRow(Point p) {
            int row = this.table.rowAtPoint(p);
            if (row == -1) {
                return -1;
            }
            int col = this.table.columnAtPoint(p);
            if (col == -1) {
                return -1;
            }
            Rectangle r = this.table.getCellRect(row, col, true);
            r.grow(0, -3);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.y + r.height / 2;
            int rowIndex = p.y < midPoint ? row - 1 : row;
            return rowIndex;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.forwardEventToPanel(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.table.getTableHeader().setResizingColumn(null);
            Point p = e.getPoint();
            this.resizingColumn = this.getResizingColumn(p);
            if (this.resizingColumn != null) {
                this.resizingRow = -1;
                this.table.getTableHeader().setResizingColumn(this.resizingColumn);
                this.mouseXOffset = p.x - this.resizingColumn.getWidth();
                return;
            }
            this.resizingRow = this.getResizingRow(p);
            if (this.resizingRow >= 0) {
                this.mouseYOffset = p.y - this.table.getRowHeight(this.resizingRow);
                return;
            }
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.getResizingColumn(e.getPoint()) != null) {
                this.table.setCursor(resizeColumnCursor);
                return;
            }
            if (this.getResizingRow(e.getPoint()) >= 0) {
                this.table.setCursor(resizeRowCursor);
                return;
            }
            this.table.setCursor(null);
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.resizingColumn != null) {
                this.resizingColumn.setWidth(e.getX() - this.mouseXOffset);
                if (WaveformWindow.this.mainHorizRulerPanel != null) {
                    WaveformWindow.this.mainHorizRulerPanel.repaint();
                }
                return;
            }
            if (this.resizingRow >= 0) {
                int newHeight = e.getY() - this.mouseYOffset;
                if (newHeight < 24) {
                    newHeight = 24;
                }
                this.table.setRowHeight(this.resizingRow, newHeight);
                if (this.resizingRow < WaveformWindow.this.wavePanels.size()) {
                    Panel wp = (Panel)WaveformWindow.this.wavePanels.get(this.resizingRow);
                    wp.updatePanelTitle();
                }
                return;
            }
            this.forwardEventToPanel(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.resizingColumn != null) {
                this.table.getTableHeader().setResizingColumn(null);
                return;
            }
            this.forwardEventToPanel(e);
        }

        public void forwardEventToPanel(MouseEvent e) {
            Point p = e.getPoint();
            int row = this.table.rowAtPoint(p);
            int col = this.table.columnAtPoint(p);
            if (row < 0 || col < 0) {
                return;
            }
            JPanel panel = (JPanel)this.table.getValueAt(row, col);
            MouseEvent panelEvent = SwingUtilities.convertMouseEvent(this.table, e, panel);
            panel.dispatchEvent(panelEvent);
            this.table.repaint();
        }
    }

    static class WaveCellEditor
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private Component lastOne;

        public WaveCellEditor(JTable table, int column) {
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.getColumn(column).setCellRenderer(this);
            columnModel.getColumn(column).setCellEditor(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (Component)table.getValueAt(row, column);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.lastOne = (Component)table.getValueAt(row, column);
            return this.lastOne;
        }

        @Override
        public Object getCellEditorValue() {
            return this.lastOne;
        }
    }

    private class WaveTableModel
    extends DefaultTableModel {
        private WaveTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            int numVisPanels = 0;
            for (Panel wp : WaveformWindow.this.wavePanels) {
                if (wp.isHidden()) continue;
                ++numVisPanels;
            }
            return numVisPanels;
        }

        @Override
        public Object getValueAt(int row, int col) {
            int rowNo = 0;
            for (Panel panel : WaveformWindow.this.wavePanels) {
                if (panel.isHidden()) continue;
                if (rowNo == row) {
                    if (col == 0) {
                        return panel.getLeftHalf();
                    }
                    return panel.getRightHalf();
                }
                ++rowNo;
            }
            return null;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return JPanel.class;
        }
    }

    private class WaveTable
    extends JTable {
        private WaveformWindow ww;

        WaveTable(TableModel model, WaveformWindow ww) {
            super(model);
            this.ww = ww;
        }
    }
}

