#! /usr/bin/gtypist
#
# Russian touch typing course for GNU Typist.
#
# Copyright (C) 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011,
#               2012, 2013, 2014, 2016, 2017, 2018, 2019, 2020
#               Dimitry Rutsky	<rutsky@school.ioffe.rssi.ru>
# Copyright (C) 2021, 2022, 2023 Felix Natter, Mihai Gătejescu
#
# GNU Typist is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# GNU Typist is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Typist.  If not, see <http://www.gnu.org/licenses/>.
#

#
# Original of this file uses KOI8-R encoding.  If you're using different
# encoding in your terminal, you have to convert the file appropriately.
# For example, to convert this file to DOS CP866, you may do it with the
# following command (if you have `iconv' utility which is installed along
# with the GNU C Library):
#
# iconv -f KOI8-R -t CP866 /usr/share/gtypist/ru.typ > ru_CP866.typ
#
# If this file is in /usr/share/gtypist this will create CP866-encoded
# `ru_CP866.typ' script file in current directory.
#

B: Добро пожаловать!
T:
 :Этот небольшой набор упражнений с комментариями поможет вам освоить слепую
 :печать.  Поскольку вы читаете сейчас это сообщение, вам, вероятно, уже
 :известна суть этого метода хотя бы в общих чертах, а также преимущества,
 :которые он может обеспечить.  Если нет --- не волнуйтесь, в следующем меню
 :есть пункт "помощь", в котором подробно изложена суть метода и основные
 :рекомендации, причём так, что они будут понятны кому угодно.  Там же приведена
 :прочая информация, которая может оказаться полезной на случай если вы
 :испытываете сложности с этим и другими курсами слепой печати, а также
 :некоторые сведения о проекте GNU Typist и этих уроках.
 :
 :Этот курс ещё достаточно "сырой" и наверняка содержит различные ошибки и
 :странности.  Не стесняйтесь высказывать автору свои замечания!
 :----------------------------------------------------------------------------
 :
 :    Авторское право на данную работу принадлежит Дмитрию Владимировичу Руцкому,
 :Copyright (C)  2003  Dmitry Rutsky  <rutsky@school.ioffe.rssi.ru>.
 :Все права защищены.  Этот сценарий считается программой,
 :и распространяется по лицензии GNU General Public License, версии 2 или выше.
 :Детали распространения и использования оригинала и изменённых копий смотрите
 :в лицензии.  В частности запрещено использовать этот курс или любую его
 :часть в коммерческих программах без соответствующего разрешения.
*:START
B:Русскоязычный курс слепой печати
M: "Выбирайте:"
 :__HOME_ROW	"  Основы: "домашний" ряд клавиш, пробел, "ввод" "
 :__INDEX_FS	"             Указательные пальцы                "
 :__CAPS_DOT	"Прописные буквы и общеупотребительная пунктуация"
 :__MID_FS	"         Средние и безымянные пальцы            "
 :__LIT_FS	"                    Мизинцы                     "
 :__TESTS	"           Тесты скорости и качества            "
# :__EXTRA	"               Приложения к курсу               "
 :__HELP	"                Помощь и справка                "
G:START

*:__HOME_ROW
B:Самые основы
M: "Первые упражнения:"
 :HR_AO		"    `А' и `О'     "
 :HR_VL		"    `В' и `Л'     "
 :HR_YD		"    `Ы' и `Д'     "
 :HR_FG		"    `Ф' и `Ж'     "
 :HR_PR		"    `П' и `Р'     "
 :HR_E		"       `Э'        "
 :HR_TEST	"Проверочная работа"

*:HR_AO
B:Поехали!
T:
 :    Итак, это первое упражнение в курсе.  Понятно ли вам, как его нужно
 :выполнять?  Если нет, то лучше сперва узнать это в разделе "помощь и справка",
 :это может сэкономить значительное время и усилия.  Первое упражнение может
 :показаться слишком лёгким (и это хорошо), но следующие будут становится всё
 :сложнее и сложнее.  Будьте внимательны и аккуратны с самого начала!
 :
 :    Клавиши `А' и `О' в основной позиции нажимаются указательными пальцами
 :левой и правой рук соответственно.  Они расположены в самом удобном для этого
 :положении, и нажимать их легко, но постарайтесь отработать мягкое и лёгкое
 :нажатие.  Не забывайте держать кисть прямо и свободно, слегка опираясь на
 :клавиатуру кончиками пальцев и ощущая клавиши.  Постоянно следите за этим, и
 :это удобное положение когда-нибудь станет для вас привычным.  Не смотрите на
 :клавиатуру!
 :
 :    Не забывайте про пробелы и "ввод", который нужно нажимать в конце каждой
 :строки.  Нажимайте пробел пальцем той руки, которая только что отдыхала.
 :Выполняйте упражнения ритмично.  Не переходите к следующему упражнению, пока
 :не вполне освоились с предыдущими.

B:`О'
I:Отрабатываем нажатие клавиши `О'.  Нажимайте её правым указательным пальцем,
 :немного приподнимая его и мягко (но упруго) нажимая на клавишу.
D:о о ооо оооо оо
I:Ещё одно такое упражнение.
 :оо оо о о оо оо о
B:`А'
I:Отрабатываем нажатие клавиши `А'.  Используйте для этого указательный палец
 :левой руки, так же немного приподнимая и мягко давя.
D:а а ааа аааа аа
I:И ещё немного.
D:ааа а а аааа а
B:`О' и `А' поочерёдно
I:Теперь вместе.  Старайтесь нажимать пробел правильной рукой.
D:о а о а оа оа а о а о ао ао
I:Ещё:
D:оаоаоаоа аоаоаоао оаоаоаоа аоаоаоао
B:`О' и `А' в разных сочетаниях
I:Если вы освоились с предыдущими упражнениями, вам будет нетрудно выполнить
 :оставшиеся.
D:аоа оао оаоооао ооа ооо аааоооо
I:Не забывайте нажимать "ввод" в конце каждой строки, и в конце пустой строки
 :тоже.
D:оооаооооаааоааааооооооооааааа а
 :ааааааааоооооооооооаооооаааоа а
 :
 :оаоаааааооооааааоаоаааааоа о
 :оооаооааоооааааааоооаоаоаоаоао о
I:И ещё немного:
D:ааа а ооо о ооо о а а
 :ооо о ааа а аоа о а а
 :оао о аоа а ааа о о а
 :ооо о ааа а оао о а а
B:Первые успехи
T:
 :    Поздравляю!  Вы дошли до конца первой серии упражнений.
 :
 :    Не думайте, что все упражнения такие лёгкие и скучные.  Впереди ещё много
 :трудной и занимательной работы...
Q:Перейти к следующему занятию? [Д/Н]
N:__HOME_ROW

*:HR_VL
B:Летим...
T:
 :    Клавиши `В' и `Л' нажимаются средними пальцами левой и правой руки
 :соответственно.  Средние пальцы примерно так же удобны, как и указательные,
 :но если вы не будете внимательно следить за этим, ваша кисть может зажаться.
 :Допускать этого не стоит.  Поставьте кисть руки в основную позицию и
 :попробуйте плавно приподнимать средний палец над клавиатурой и так же плавно
 :опускать его, оставляя всю остальную кисть расслабленной.  Не удивляйтесь,
 :если сначала у вас не будет это получаться.  Нужно обязательно приобрести
 :необходимую для этого гибкость кисти!
 :
 :    Не забывайте также и про остальные элементы хорошей техники слепой печати.
 :Не смотрите на клавиатуру!  Учитесь использовать максимум возможностей,
 :которые у вас есть.

B:`Л'
I:Используйте средний палец правой руки для нажатия клавиши `Л'.
D:л л ллл лллл лл
B:`В'
I:Нажимайте клавишу `В' средним пальцем левой руки.  Следите за гибкостью!
D:в в ввв вввв вв
B:`В' и `Л' в разных сочетаниях
I:Потренируйтесь использовать свои средние пальцы.
D:в л ввл л в ллв влв лвл
 :ллв ллл ввл ввв
 :лвлв лллл влвл вввв
 :
 :лвлвлвлвлвлвлвлв влвлвлвлвлвлвлвл
 :ллвллвввлввл лллввввввллл
B:Четыре буквы вместе
I:Научиться управлять сразу четырьмя клавишами "на ощупь" может оказаться
 :нелегко, но со временем вы можете овладеть всеми пятидесятью!
D:о в л а
 :ов оа ав аа лл ла ал оо
 :вв во лв ва ао ол ло вл
 :
 :овла овла лвао лвао оавл оавл воавл
 :ааво ллоа ввов ааоа ввва ллло ввлло
B:Несколько слов
I:Эти сочетания букв встречаются на практике:
D:вал вал лава лава овал овал вова вова
 :олово олово лов лов вол вол
Q:Перейти к следующему занятию? [Д/Н]
N:__HOME_ROW

*:HR_YD
B:`Ы' и `Д'
T:
 :    Сейчас будут упражнения на освоение клавиш `Ы' и `Д', которые нажимаются
 :безымянными пальцами левой и правой руки соответственно.  Научиться гибко
 :использовать эти пальцы сложнее всего (они меньше всего развиты, особенно
 :если вы не пианист), и вам понадобится много внимания, чтобы не зажимать руку.
 :Сразу поднять их над клавиатурой вы сможете только если вы обладаете удачным
 :строением кисти, но чуть-чуть приподнять при полностью расслабленной и
 :собранной руке особого труда не составляет -- потренируйтесь правильно
 :делать это.
 :
 :    Однако для быстрого письма, если гибкость этих пальцев у вас только
 :оставляет желать лучшего, можно пользоваться другим приёмом:  немного
 :приподнимайте всю кисть над клавиатурой (все пальцы поднимаются вместе с
 :кистью), выставляйте нужный палец вперёд и опускайте всю руку, как если бы она
 :была одним этим пальцем.  Этот приём был единственно верным на механических
 :пишущих машинах, но на современной удобной клавиатуре его следует по
 :возможности избегать.

B:`Д'
I:Нажимайте клавишу `Д' безымянным пальцем правой руки.  Отучились ли вы уже от
 :привычки смотреть на клавиатуру?
D:д д ддд дддд дд
B:`Ы'
I:Нажимайте клавишу `Ы' безымянным пальцем левой руки.  Следите за
 :расслабленностью и собранностью кисти, как и за мягкостью нажатия.
D:ы ы ыыы ыыыы ыы
B:`Д' и `Ы'
I:Как и раньше, потренируйтесь использовать эти пальцы.
D:ы д ыд д ы ды ыд ыд ды ды дд ыы ыды дыд дыдыды дддд
 :ыыд ыыыд ыдыыд ыыыдыдыд дыдыдыыд ыдыды дыдыд ыыыыы
B:Скромное хозяйство
I:Управлять шестью пальцами заметно сложнее, чем четырьмя.
D:ыва авы олд дло лод ыав лав ыод
 :
 :довы довы вода вода ылод ылод дала дала
 :лад лад дол дол лодвы лодвы авло авло
 :два два олва алва ода ода дао дао
 :овод овод довод довод выла выла
 :вывод вывод вовы вовы выло выло
 :оалвды ыдвлао
Q:Перейти к следующему занятию? [Д/Н]
N:__HOME_ROW

*:HR_FG
B:Последние пальцы
T:
 :    Сейчас будет несколько упражнений, которые помогут вам начать осваиваться
 :с мизинцами.  Несмотря на то, что эти пальцы короткие, пользоваться ими
 :достаточно удобно из правильного положения --- когда палец в основной позиции
 :спокойно лежит на клавишах.  Старайтесь при их использовании не делать
 :большого замаха и не напрягать тем самым кисть, делайте ровно столько
 :движения, сколько нужно для чёткого нажатия клавиши.
B:`Ж'
I:Используйте мизинец правой руки для нажатия клавиши `Ж'.
D:ж ж жжж жжжж жж
B:`Ф'
I:Используйте мизинец левой руки для нажатия клавиши `Ф'.
D:ф ф ффф фффф фф
B:`Ж' и `Ф'
I:Упражнение привычного типа.
D:ф ж ж ф фж фж жф жф ффж ффф жжж жжф жф фж жф жф фж жф
 :жжжжфффф жжжффжжжж жжжжфффф ффффжжжж фжжфффффжфжжжжфж
 :ж ф ж ф ж ф
B:Все пальцы вместе
I:А теперь поупражняйтесь использовать все десять пальцев:
D:фыва фыва ждло ждло фоылвдаж жфдылвоа
 :фд лв ао до жл ыо аф ыв дж ло ал жф ыд ла лл ды ол
 :
 :лажа лажа жало жало вожжа вожжа жал жал дофаж дофаж вафла вафла ловаж ловаж
 :жовал жовал ложа ложа жловод жловод воложод воложод фажовод фажовод
 :водофаж водофаж ждал ждал жыл жыл фавал фавал дважды дважды

Q:Перейти к следующему занятию? [Д/Н]
N:__HOME_ROW
*:HR_PR
B:Начинаем осваивать "соседние" клавиши
T:
 :    Не все клавиши домашнего ряда, как вы уже, наверное, заметили, расположены
 :под пальцами в основной позиции.  Три клавиши расположены рядом с некоторыми
 :вашими пальцами, и чтобы их нажимать, нужно проделывать чуть более сложные
 :движения, чем просто приподнимать палец и опускать его на то место, где он
 :только что стоял.  Следующие упражнения помогут вам освоиться с клавишами,
 :расположенными посередине клавиатуры --- `П' и `Р'.
 :
 :    Эти клавиши нажимаются указательными пальцами левой и правой руки
 :соответственно.  Для этого нужно немного приподнять палец и плавным
 :дугообразным движением мягко нажать соответствующую клавишу, тем же самым
 :движением вернув палец на своё место в основной позиции.  Кисть при этом
 :должна быть пластичной, и не мешать движению пальца.  Можно "скользыить"
 :по поверхности клавиатуры, нащупывая клавишу, и этот приём тоже стоит
 :использовать в самом начале, когда вам сложно найти и правильно нажать
 :соответствующую клавишу на ощупь, но от него потом придётся отказаться.
B:`Р'
I:Нажимайте клавишу `Р' указательным пальцем правой руки, нажимая клавишу
 :слева от той, на которой он стоит.  Не смотрите на клавиатуру!
D:ррр р рррр рр р р ррр рр
B:`П'
I:Нажимайте клавишу `П' указательным пальцем левой руки.  Не забывайте
 :возвращать его в исходное положение после каждого нажатия.
D:ппп п п пппп п п ппп пп п
B:`П' и `Р'
I:Потренируйтесь чередовать эти движения.
D:п п р р пппп рррр пр пр рп рп прпр рпрпрп
 :ппппрррр ппппрррр ррррпппп ррррпппп пппррппппррррп
B:Всё вместе
I:Теперь вы должны уметь использовать десять клавиш на ощупь.  Это уже не так
 :мало, и если всё пока хорошо, то вы должны гордиться собой.
D:фывапролдж жфдылвоапр рдлоыпролопрфрпдж пжпжплпдп папапыпвпфпып
 :рордрлрдржрд рфрырврарврырра
 :
 :жара жара дар дар рада рада дрова дрова права права правы правы
 :прожрал прожрал жрала жрала арфа арфа правда правда пар пар двор двор
 :попал попал водопровод водопровод подвал подвал пропадал пропадал
 :вправо вправо поплыла поплыла прорвало прорвало попала попала падал падал
 :дрофа дрофа ров ров подвода подвода выдра выдра радовала радовала
 :правда правда пропала пропала провода провода вар вар фарфор фарфор
 :фара фара
B:Это вы уже можете
I:Попробуйте свои силы на этих относительно осмысленных фразах.  Если вы хорошо
 :поработали, они не представят для вас особых трудностей.
S:водопровод прорвало
 :вол порвал провода
 :двор радовала жара
 :дрофа попала в вар
 :прорва воров врала в лад
Q:Перейти к следующему занятию? [Д/Н]
N:__HOME_ROW
*:HR_E
B:Последняя клавиша домашнего ряда
T:
 :    Следующим шагом на пути овладения клавиатурой в нашем курсе будет
 :клавиша `Э'.  Она нажимается мизинцем правой руки, примерно так же, как
 :`П' и `Р' указательными пальцами.  Постарайтесь поменьше двигать кисть,
 :понажимайте эту клавишу сначала вовсе не сдвигая кисть с места (но не зажимая
 :её).  Делайте это мягко и плавно, следя за расслабленностью руки.
B:`Э'
I:Нажимайте клавишу `Э' мизинцем правой руки.  Следите за расслабленностью кисти!
D:эээ ээ э эээ ээ э ээ э
B:Всё вместе
I:Поупражняйтесь немного.
D:э а э в э л э д э р э п э ф
 :эждлорпавыф фывапролджэ фэыдвлаопр рпаовлыдфжэ
 :рэж эрфа фээ эээж эфдо олдэ ыэалэд ыаэлэвэ эфэ эрэ эпэ
 :
 :эва эва эфа эфа эра эра
Q:Перейти к проверочной работе? [Д/Н]
N:__HOME_ROW
*:HR_TEST
B:Контрольная работа
T:
 :    К этому моменту вы должны были немного освоиться с клавишами домашнего
 :ряда, и пришла пора проверить приобретённые навыки.  Вы должны набрать
 :следуюие фразы, и решить, стоит ли вам двигаться дальше.  Добейтесь
 :удовлетворительных для себя результатов на этом тесте.  Разумеется, вы должны
 :уметь легко и без ошибок набрать это, не глядя на клавиатуру.
I:Проверьте, на что вы уже способны:
S:эра арфы радовала дар лада
 :лава вара дрофы рождала жар
 :право арапа дрожало дважды
 :выдра водопада воровала дрова
Q:Вас удовлетворяет ваш результат? [Д/Н]
N:__HOME_ROW

*:__INDEX_FS
B:Указательные пальцы
M: "Работа над указательными пальцами:"
 :IF_EN		"     `Е' и `Н'    "
 :IF_KG		"     `К' и `Г'    "
 :IF_MT		"     `М' и `Т'    "
 :IF_Ib		" `И' и мягкий знак"
 :IF_TEST	"Проверочная работа"

*:IF_EN
B:Продолжаем осваивать клавиатуру
T:
 :    Указательные пальцы нажимают 12 буквенных клавиш (и три цифровые), с двумя
 :из которых вы уже должны были освоиться --- это больше трети алфавита.
 :Выбраны и расположены буквы на этих клавишах достаточно продуманно, как,
 :впрочем, и все остальные, но точное их использование всё же требует некоторой
 :тренировки.  Вам придётся использовать эти пальцы при печати чаще всего,
 :поэтому вы освоитесь с ними лучше и быстрее, чем с прочими.  Сейчас же следует
 :уделить большое внимание правильности и точности движений.
 :
 :    Клавиши `Е' и `Н' нажимаются (как, конечно, и многие другие) лёгкими
 :дугообразными движениями.  Расстояние достаточно велико, но будьте экономны.
 :Старайтесь нажимать все клавиши перпендикулярно их поверхности и по центру.
 :При этом пальцы должны быть полусогнутыми (но не прямыми).  Для каждой клавиши
 :потренируйтесь доставать её наиболее удобным движением.
B:`Н'
I:Нажимайте клавишу `Н' указательным пальцем правой руки.
D:н н нн ннн нн н
B:`Е'
I:Нажимайте клавишу `Е' указательным пальцем левой руки.
D:е е ее еее ее е
B:`Н' и `Е'
I:Следите за точностью и лёгкостью движений.
D:не е ене нее ее нен нне еен
 :ннн еее неен еннене енеееннне
B:Всё вместе
I:Эти движения легко запомнить, но легко ли применять их на ощупь и вместе с
 :остальными?
D:невод невод нева нева ева ева дерево дерево
 :фенол фенол лоно лоно жена жена лена лена
 :невежа невежа женева женева венера венера дева дева
 :вена вена наверное наверное венера венера не вера не вера
 :родне родне арена арена проныра проныра ранена ранена
 :неравна неравна нерод нерод еда еда нерв нерв
Q:Перейти к следующему занятию? [Д/Н]
N:__INDEX_FS
*:IF_KG
B:`К' и `Г'
T:
 :    Клавиши `К' и `Г' нажимаются короткими движениями указательных пальцев
 :вперёд, при этом кисть может оставаться совершенно неподвижной даже для
 :маленьких рук.  Указательному пальцу левой руки при этом может мешать средний,
 :в таком случае нужно немного наклонить его в сторону (но не убирать с
 :клавиши).  То же самое придётся делать в остальных подобных случаях, но это
 :совсем несложно для достаточно гибких и свободных рук.
B:`K'
I:Используйте указательный палец левой руки для нажатия клавиши `К'.  Следите
 :чтобы средний палец вам не мешал.
D:кк к кк к кккк ккк к
B:`Г'
I:Используйте указательный палец правой руки для нажатия клавиши `Г'.
D:гг г гг г гггг ггг гг г
B:`К', `Е', `Н' и `Г'
I:А теперь поупражняйтесь со всеми четырьмя клавишами верхнего ряда, нажимаемыми
 :указательными пальцами.
D:к г е н ек ег ен ке кг кн гн гк ге нк не нг
 :кген негк кнег гнке нгке егкн нкег ннге
 :ген ген кен кен
B:Всё вместе.
I:А теперь всё вместе.  Чувствуйте и наслаждайтесь, как с прибытием новых букв в
 :ваш арсенал слепой печати расширяются ваши возможности!
D:гнев гнев нега нега каган каган гон гон нога нога
 :ковры ковры рывок рывок рок рок напор напор порок порок
 :факел факел геракл геракл калека калека река река нырок нырок горка горка
 :гора гора коневод коневод град град когор когор
Q:Перейти к следующему занятию? [Д/Н]
N:__INDEX_FS
*:IF_MT
B:`М' и `Т'
T:
 :    Клавиши `М' и `Т' принадлежат нижнему ряду, и для их нажатия указательные
 :пальцы нужно перемещать по направлению к себе.  Остальные пальцы можно
 :оставлять при этом на своих местах, если у вас хватает гибкости, и в любом
 :случае начинать их освоение стоит именно с этого способа, следя за
 :расслабленностью руки.  Запястье при этом будет немного подниматься вверх,
 :и естественно возвращаться в своё прежнее положение после нажатия, если рука
 :полностью свободна, но вам не хватает растяжения между указательными и
 :средними пальцами.  Следите за тем, чтобы большие пальцы вам не мешали, если
 :вы не поднимаете кисть.
B:`Т'
I:Нажимайте клавишу `Т' указательным пальцем правой руки.  Следите за точностью
 :нажатия и возврата к прежнему положению.
D:т т тт тттт тт
B:`М'
I:Нажимайте клавишу `М' указательным пальцем левой руки.  Не зажимайте кисть.
D:м м мм мммм мм м
B:Шесть клавиш для указательных пальцев
I:Осваивайтесь с новыми движениями.
D:м т н к мен мен нем нем тен тен тмег тмег
 :мтгн тмке тмгн тмке гкне гмтн гмтн тмгм мтгт ктмт гмкм
B:Всё вместе
I:Семнадцать клавиш --- уже больше половины алфавита, причём эта половина
 :содержит наиболее употребительные буквы.
D:омон омон неман неман мама мама монро монро роман роман
 :тем тем терем терем трам трам вата вата товар товар ратовал ратовал
 :вот вот крот крот в рот в рот ток ток катод катод молоток молоток
 :токовод токовод водоток водоток котовод котовод трое трое ретро ретро
 :мрак мрак рама рама морок морок корма корма мокрота моркота морока морока
 :кроме мрака кроме мрака морок каркал морок каркал теремок теремок
 :форма форма фома фома мороз мороз мымра мымра эмма эмма мэр мэр жмот жмот
Q:Перейти к следующему занятию? [Д/Н]
N:__INDEX_FS
*:IF_Ib
B:Последние клавиши основных рядов для указательных пальцев
T:
 :    Теперь пришла пора освоиться с последними клавишами основных рядов для
 :указательных пальцев --- `И' и мягким знаком.  Расстояние до `И' из основной
 :позиции самое большое, и с этим движением освоиться довольно непросто.
 :Нажимается `И' указательным пальцем левой руки;  хотя до указательного пальца
 :правой руки так же далеко, причина выбора левой руки кроется в симметрии.
 :Гибкая рука способна и в этом случае никуда не перемещать кисть, и можно
 :посоветовать использовать тот же приём, что и для `М':  оставляйте остальные
 :пальцы на своих местах, и можно немного приподнимать кисть.  Впрочем, если
 :гибкости не хватает, лучше перемещать всю руку, оставляя только мизинец на
 :месте, и так же возвращать её на место, этот способ почти так же хорош.
 :
 :    Мягкий знак нажимать так же просто, как и `М'.
B:`И'
I:Потренируйтесь нажимать клавишу `И' точно и на ощупь, используя для этого
 :указательный палец левой руки и её гибкость.
D:и и ии ииии иии ии и
 :иии иииииии и и ии и и
I:Потренируйтесь нажимать ту же клавишу в различных сочетаниях с другими.
D:и а иа и в ив и ы иы и ф иф фиыивиаи ифиыивиа
 :иоилидиж оилидижи
 :
 :и он и мы и рад и дорога
B:Мягкий знак
I:Нажимайте мягкий знак указательным пальцем правой руки.  Не смотрите на
 :клавиатуру!
D:ь ь ььь ьььь ьь
B:Указательные пальцы на средних рядах
I:Поупражняйтесь со всеми "средними" клавишами.
D:и ь иь ьи
 :пир пир рать рать тир тир тиран тиран ирак ирак инть нить тина тина
 :пример пример тьма тьма мир мир тени тени имена имена гореть гореть
 :греть греть именинник именинник микрон микрон темь темь треть треть
 :трение трение накипь накипь пика пика копи копи гипер гипер кипа кипа
 :тип тип пороки пороки перепонки перепонки кит кит тик тик некротик некторик
B:Всё вместе
I:Теперь в вашем распоряжении должно быть девятнадцать наиболее употребительных
 :клавиш, поупражняйтесь в их полном совместном использовании!
D:ни пера ни пера нить горела нить горела эти рати эти рати жрать не в мере
 :жрать не в мере пир недолог пир недолог гниль противна гниль противна
 :море в мире море в мире мраки в ноте мраки в ноте никон молил никон молил
 :эдип породил эдип породил греть не надо греть не надо дома мыло дома мыло
 :мании томимы мании томимы дар не тир дар не тир жарить да пожарить
 :жарить да пожарить эфа пилила эфа пилила ива гонима ива гонима
 :нервы ранимы нервы ранимы тмин и аминь тмин и аминь
Q:Перейти к проверочной работе? [Д/Н]
N:__INDEX_FS
*:IF_TEST
I:Проверьте свои силы и навыки.
S:в раннем мире фраер парил над домами и молил о надменном даре
 :эти равные отроки драли три дородные полные дорогие девы
 :рената долго доила неповоротливые ранние дола молотом
 :не нам много гнить когда гнев не порок
 :коленопреклонение нарекало должные томительные неги
 :кентавр не мог верно ратовать жадным томным фиамам
 :марать линии венков терновыми волнами давно не модно
Q:Вы довольны? [Д/Н]
N:__HOME_ROW

*:__CAPS_DOT
B:Богата наша орфография!
M: "Выберите тему:"
 :CD_CAPS	"            Прописные буквы           "
 :CD_DC		"     Запятая, точка, многоточие...    "
 :CD_EQ		"Вопросительный и восклицательный знаки"
 :CD_CS		"       Двоеточие и точка с запятой    "
 :CD_DT		"             Тире и дефис             "
 :CD_Q		"               Кавычки                "
 :CD_PS		"                Скобки                "
 :CD_TEST	"          Проверочная работа          "

*:CD_CAPS
B:Бывают буквы большие и маленькие
T:
 :    Эта серия упражнений поможет вам овладеть использованием прописных букв
 :наравне со строчными, и помещена она в середине нашего основного курса, как
 :и знаки пунктуации, для того, чтобы сделать последующие упражнения интереснее
 :и "реалистичнее", ведь монотонный набор фраз и сочетаний букв утомляет больше,
 :чем нечто, похожее на тексты, с которыми вам нужно работать, хотя это,
 :возможно, и несколько "непоследовательно".
 :
 :    Итак, прописные ("большие") буквы печатаются теми же движениями, что и
 :соответствующие им строчные ("маленькие"), но при этом до нажатия буквы
 :свободная рука нажимает одну из двух клавиш верхнего регистра ("Shift"),
 :и после нажатия освобождает её.  Таким образом, последовательно выполняются
 :три движения:  1) мизинец свободной руки нажимает и держит клавишу верхнего
 :регистра, 2) другая рука нажимает нужную клавишу как если бы была нужна
 :строчная буква, и 3) мизинец свободной руки отпускает клавишу верхнего
 :регистра и эта рука возвращается в основное положение.  Если у вас возникают
 :сложности, можно вначале выполнять все эти действия в упражнениях ритмично
 :на счёт "раз-два-три".  Со временем необходимость в этом отпадёт.
 :
 :    Потренируйтесь на ощупь и точно нажимать клавиши верхних регистров
 :мизинцами.  При этом оставляйте указательные пальцы лежать на своей позиции,
 :не перемещайте руку.  При достаточной гибкости можно нажимать "Shift" той же
 :рукой, которой нажимается буквенная клавиша, но это плохая привычка вначале.
B:Учимся использовать клавишу верхнего регистра
I:Не смотрите на клавиатуру.  Это упражнение поможет вам выработать ритмичность
 :и точность движений.
D:О а А о ф Ж д Ф в Л ы Д П р Р К
 :м Т и Ь М т И ь К н Г е н Е г К
 :Ф к Э г Ы и Д м В ь Л е А н О т П р Э
I:Теперь проверим все доступные пока движения.  Не используйте замок верхнего
 :регистра ("CAPS LOCK").
D:МТИЬФОЫЛВДАЖПЭРГКНЕ
I:Поупражняйтесь выделять первые буквы слов и целые слова прописными буквами.
D:Ванна Кино Кот Некто Жанна Феофан Галина Гном МЫЛО Эмма Пальто
 :Жаклин Енот Николаев Ирод ПЕК Дмитрием МЕЛ Рогонот Пироман Алина ЛОПАТА
 :ВЕДРО Колокол Карнавал МАТЬ ТЕНЬ Желание Вера Надежда ЛАК ТКАНЬ Копор
 :Кунак Рогенда Тимон Перепел ФАРФОР Молоток Нала ЭРАТОМАН Витани Валентин
 :Жако Парад Радиан Километр Деление Антрополог Терапевт
I:А теперь проверьте себя.
S:Тень от двери Гене не в деле
 :Рад и млад тропе наград
 :В под диваном дали клопов давили Ольга и Натали
 :Где он ни пропадал, Владимир не роптал
 :Когда Вано пролетает в окно в доме тепло
 :Говорил Олег про побег да не в век
 :Этот Егор жалко и нежно молил про фарфор
Q:Довольны результатами? [Д/Н]
N:__CAPS_DOT

*:CD_DC
B:Точка и запятая
T:
 :    Знаки препинания являются важным средством выразительности письменной
 :речи, и без них было бы сложно разбирать написанные тексты.  Поэтому мы сейчас
 :же приступим к их освоению, хотя это может показаться довольно
 :непоследовательным.  В "живом" интернет-общении этими "тонкостями"
 :(как, впрочем, и заглавными буквами) редко пользуются, но сообщения
 :электронной почты всё же являются текстами, а не репликами.  К тому же, освоив
 :эти "тонкости" письменной речи в слепой печати, они станут для вас такими
 :же естественными, как паузы и акценты --- в устной.
 :
 :    К сожалению, хотя на пишущих машинах знаки препинания находятся в
 :утверждённых стандартом местах, и в режиме латинских букв клавиатуре
 :компьютера тоже, в режиме кириллицы в разных раскладках они могут находиться
 :в самых разных местах, и обычно не там, где нарисовано на клавиатуре!  Причина
 :здесь, конечно, в составителях раскладок, которые не захотели сделать свои
 :раскладки по отечественному стандарту.  Microsoft (tm) поставила точку и
 :запятую там, где в стандартной раскладке располагалась буква `ё', а `ё'
 :обычно можно найти на месте тильды `~', и теперь этой раскладкой пользуются
 :уже много лет любители операционных систем от Microsoft (tm), причём без
 :возражений, как обычно.  Но не стоит огорчаться, с опытом вы легко сможете
 :подстраиваться почти под любые раскладки.  Пока же научитесь на ощупь из
 :основной позиции нажимать вашу точку и запятую соответствующим схеме
 :распределения клавиш пальцем.
B:Точка
I:Потренируйтесь набирать точку вслепую.
D:. . ... .... ..
B:Запятая
I:Потренируйтесь набирать запятую.
D:, , ,,, ,,,,,, ,, ,,, ,
B:Точка и запятая
I:Небольшое, но полезное упражнение на чередование точки и запятой.
D:. , . , ..,, ..,,,,.., ,,.,.,.,,... ., ,. ,, ..
B:Точка и запятая в тексте
T:
 :    Следует отметить, что для красивой печати нужно оставлять между
 :запятой и словом, которое следует за ним на той же строке, один пробел,
 :а между точкой и началом следующего предложения на той же строке --- два.
 :Конечно, у вас могут быть другие представления и требования к этой детали
 :оформления текстов, но во всех последующих упражнениях мы будем упорно
 :придерживаться этого правила.
 :
 :    Многоточие во все времена содержало три точки, и после него следует
 :тоже оставлять два пробела, если им заканчивается предложение, но один, если
 :предложение им не заканчивается.  Например, "Пасмурно... тихо.", но
 :"Пасмурно...  Тихо."
B:Всё вместе
I:Научитесь использовать точку и запятую в печати на ощупь.
D:а,к о.д л,а ф.ы
 :
 :Поел.  Попил.  Поколотил.
 :Рано, рано, пил он рано.  Нирвана.  Прана, прана.
 :Когда Гена одел дрова, на дровне древенели дрофы, долгие и длинные.
 :Галка летом приодета, не жива и не мила.
 :Веник... лопата.  Темно...  Жарко...
Q:Перейти к следующему занятию? [Д/Н]
N:__CAPS_DOT

*:CD_EQ
B:Знаки вопрошения и восклицания
T:
 :    Скорее всего восклицательный знак находится у вас на клавише `1', но
 :вопросительный может находиться где угодно.  Сейчас мы немного потренируемся
 :использовать их при слепой печати.  Это наиболее выразительные знаки в
 :пунктуации, но не злоупотребляйте ими!
 :
 :    После этих знаков следует оставлять два пробела перед словом на той же
 :строчке --- они, как и точка, обычно завершают предложение.  Если после
 :какого-либо из этих знаков идёт многоточие, в нём должно быть не три точки, а
 :две, например, "Какого?..".
B:Вопросительный знак
I:Потренируйтесь нажимать знак вопроса на ощупь.
D:??? ???? ?? ?
B:Восклицательный знак
I:Потренируйтесь набирать восклицательный знак на ощупь.
D:!!! !!!! !! ! !
B:Вопросительный и восклицательный знаки
I:Потренируйтесь использовать вопросительный и восклицательный знаки в слепой
 :печати.  Не смотрите на клавиатуру!
D:?! !? ??! !!? !?!?!!?!? ????!??!?!?!?
B:Всё вместе
I:Потренируйтесь использовать новые знаки в конце предложения.
D:А?  А!  Аааа!
 :О!  О??  Оооооооооо...
 :Ы?  А!  Э?!  Е!!
 :Поел?  Попил?  Выпил вина??
 :Выпил водки!  Поел сытно!  И не голоден!!
Q:Перейти к следующему занятию? [Д/Н]
N:__CAPS_DOT

*:CD_CS
B:Перечисления и отделения
T:
 :    Двоеточие и точка с запятой в нашем курсе будут отделяться двумя пробелами
 :от следующего слова в той же строке, даже если это слово из того же
 :предложения.  В "реальных" текстах придерживаться этих правил необязательно,
 :это дело вкуса, но так лучше визуально прослеживается структура текста.
 :
 :    Как обычно, вам придётся самим найти эти клавиши и научиться нажимать их
 :на ощупь соответствующим пальцем.
B:Двоеточие
I:Научитесь набирать двоеточие вслепую.
D::::: ::: ::::: :: :: :
B:Точка с запятой
I:Научитесь набирать точку с запятой вслепую.
D:;;;; ;;; ;; ; ; ;;; ;; ;; ;
B:Двоеточие и похожая на него точка с запятой
I:Потренируйтесь использовать и различать эти знаки в слепой печати.
D:: ; : ; ::; ;:: :;: ;:; ;: :; ;;; :::
B:Всё вместе
I:Теперь всё вместе, как обычно.
D:Провожали:  Марина, Валентин, Игорь.  Встречали:  те же самые.
 :Доел;  допил;  допинал.  Недоел или недопил, и уже допинал;  таков финал.
Q:Перейти к следующему занятию? [Д/Н]
N:__CAPS_DOT

*:CD_DT
B:Дефис и тире
T:
 :    Дефис служит для связывания отдельных слов, и в большей части случаев
 :его можно было бы заменить пробелом без искажения смысла.  Среди многих
 :распространённых орфографических ошибок особенно часто встречается
 :неправильное его применение или не применение после приставок и перед
 :частицами, например "повидимому", "было-бы", "либо-же" и "вряд-ли".
 :Будем надеяться, что вы лучше знакомы с правилами русского языка на практике.
 :
 :    Дефис, он же минус, нажимается мизинцем правой руки;  расположен он правее
 :нуля.  Найдите удобный и рациональный способ его набора.
B:Дефис, он же минус
I:Потренируйтесь в наборе минуса-дефиса.
D:- - --- -- ---- ----- -- -
I:Теперь несколько странных слов с дефисами.
D:Овод-летник, невод-водник.
 :Иди!  Не-а...
 :А-а-а-а!..  О-о-о-о-о?..
B:Тире
T:
 :    Тире в обычном тексте состоит из нескольких минусов, набранных подряд.  В
 :графических текстовых редакторах обычно достаточно поставить пробел после
 :дефиса, чтобы он превратился в тире, но мы будем набирать его как три минуса
 :подряд, отделённые слева и справа от остального текста (если он есть в этой
 :строчке) одним пробелом.  Вы уже видели не раз, как выглядит такое тире в
 :объяснениях перед упражнениями, а также в разделе "помощь и справка".  Обычно,
 :впрочем, слева и справа как раз не оставляют никаких пробелов, и в тире делают
 :два дефиса подряд, и можно рассматривать эти тире как причуды данного курса,
 :но они имеют такое же право на существование, как и остальные;  к тому же,
 :LaTeX (известная система подготовки документов) использует на входе тоже тире
 :из трёх дефисов, а два дефиса подряд обозначают нечто более короткое.
 :
 :    Тире тоже не следует злоупотреблять, как и многоточием, очень редко они
 :усиливают ясность текста.
I:Поупражняйтесь использовать тире.
D:Галка --- палка.  Волк --- толк.  Лодка --- водка.  Рифма --- нимфа.
 :Город --- ворот.  Кол --- пол.  Кот --- рот.  Веник --- фени.  Венера ---
 :фанера.  Телегин --- Онегин.  Гонка --- коронка.  Фраер --- раем.
Q:Перейти к следующему занятию? [Д/Н]
N:__CAPS_DOT

*:CD_Q
B:Кавычки
T:
 :    Пара слов о пробелах:  между кавычками и тем, что в них заключено,
 :пробелов быть не должно, это же "содержимое" вместе с кавычками нужно
 :с точки зрения пробелов снаружи рассматривать как отдельное слово, то есть
 :слева перед словом в той же строчке должен быть пробел, если справа слово
 :из того же предложения, должен быть один пробел, если из уже другого --- два,
 :если знак препинания, то пробелов быть не должно.
 :
 :    Кавычками тоже не следует злоупотреблять, хотя чаще чувствуется их
 :недостаток.
I:Научитесь использовать кавычки на ощупь.  Не смотрите на клавиатуру.
D:""" "" " """" "" "
I:Поупражняйтесь использовать кавычки.
D:Галина говорила:  "мало".  Она "врала"?
 :Игорь "неодотрога".  "Радон" ловок.  Натали "томила" Митрофана.  Дмитрий
 :"материл" ментов.  Менты материли фраеров, "подонков"
 :на жаргоне, и готовили меры.
Q:Перейти к следующему занятию? [Д/Н]
N:__CAPS_DOT

*:CD_PS
B:Прячем лишнее в скобки
T:
 :    Скобки тоже являются важной частью письменной речи, хотя в "живом"
 :интернет-общении их используют реже всего.  В скобки часто можно "спрятать",
 :стилистически ничего не портя, множество подсказок и пояснений.  Однако
 :длинные пояснения в скобках в середине предложения могут значительно
 :осложнить его восприятие (тогда станет проще сначала прочитать его без
 :кавычек), так что не увлекайтесь ими.
 :
 :    Почти во всех раскладках скобки находятся на клавишах `9' и `0', и
 :набираются в верхнем регистре.  Для этого в слепом методе нужно использовать
 :средний и безымянный пальцы правой руки соответственно.
 :
 :    Пробелы вокруг скобок ставятся тем же манером, как и вокруг кавычек.
B:Левая скобка
I:Потренируйтесь набирать левую скобку на ощупь.
D:( ( (( ((( (((( (( ( (
B:Правая скобка
I:Поупражняйтесь набирать на ощупь правую скобку.
D:) ) )) )))) ))) )) ) ) )
B:Скобки
I:Теперь немного скобочных последовательностей.
D:() () (()()(())) (((()())())())
B:Всё вместе
I:Потренируйтесь использовать скобки в предложениях.
D:Рената (трепетно) пропела.  Антон (плотно) выпил.  Пеоны (фиалки)
 :как грани раны в поле.  Он (она) поел(а).  Кора (трепко) дрожала.
Q:Перейти к проверочной работе? [Д/Н]
N:__CAPS_DOT

*:CD_TEST
B:Проверьте себя!
T:
 :    В этой серии уроков было десять знаков, расположенных в довольно неудобных
 :для слепой печати местах, но вы научитесь печатать их почти так же быстро,
 :как и всё остальное, поскольку они постоянно будут попадаться вам в
 :последующих упражнениях, да и вообще они употребляются с большой регулярностью
 :в письменной речи.  Лучше всего на латинской раскладке клавиатуры умеют
 :употреблять их программисты, набирающие и редактирующие слепым методом
 :программы на богатых этими знаками языках программирования, но человеку,
 :набирающему простые тексты, некоторые знаки для набора попадаются всё же
 :значительно реже (восклицательный знак и точка с запятой, например), но вы
 :достаточно часто будете набирать в последующих сериях самые разные знаки из
 :"основной" пунктуации и орфографии, и, таким образом, у вас будет меньше
 :сложностей с ними.
 :
 :    Пока же проверьте, хорошо ли вы освоились с этими знаками.
I:Можете ли вы хотя бы медленно, но без ошибок, набрать всё это, ни разу не
 :взглянув на клавиатуру?
S:Горы дола!  Много молол?  --- Много!
 :Помните:  много еды вредно;  мало еды --- тоже.
 :"Товаром" давно торговали...  Но недолго.
 :Ели-пили (но не пиво), праны влили (криво)!
Q:Вы довольны своим владением знаками пунктуации? [Д/Н]
N:__HOME_ROW

*:__MID_FS
B:Средние и безымянные пальцы на основных рядах
M: "Серии упражнений для средних и безымянных пальцев:"
 :MF_USH	"    `У' и `Ш'     "
 :MF_SB		"    `С' и `Б'     "
 :MF_CSCH	"    `Ц' и `Щ'     "
 :MF_TCHJU	"    `Ч' и `Ю'     "
 :MF_TEST	"Проверочная работа"

*:MF_USH
B:Движемся дальше:  гудение и шипение
T:
 :    Буквенные клавиши, которые осталось освоить, используются реже чем те,
 :которые уже худо-бедно освоены, и они расположены в достаточно неудобных
 :местах, поэтому следует уделить им большое внимание.  Если вы хорошо
 :поработали с предыдущими занятиями, вы можете считать, что большая половина
 :пути к _начальному_ освоению клавиатуры уже пройдена, но не расслабляйтесь,
 :впереди ещё много работы!  Оценив время, затраченное на освоение предыдущего,
 :вы можете примерно оценить, сколько ещё осталось сделать.
 :
 :    Итак, клавиши `У' и `Ш' нажимаются средними пальцами левой и правой руки
 :соответственно, и нажимать их даже легче, чем `Г' и `К' указательными,
 :поскольку средние пальцы самые длинные.  При этом кисть и всё остальное
 :может и должно оставаться совершенно неподвижным, обеспечивая этому нажатию
 :ещё большую точность.  Конечно, кисть при этом должна быть свободной.
B:`Ш'
I:Нажимайте клавишу `Ш' средним пальцем правой руки.  Следите за лёгкостью
 :нажатия и не смотрите на клавиатуру.
D:шшшш шшш шш шш ш ш
 :Ш ш ШШш ШШшш Шш
B:`У'
I:Нажимайте клавишу `У' средним пальцем левой руки.  Не смотрите на клавиатуру!
D:уу у ууу уу у у уууу уу
 :Ууууу УуууУУуУууууу У
B:`У' и `Ш'
I:Поосваивайтесь немного с этими движениями:
D:у ш Шуу шушу ШуШу ууушшшшУУУШШШ
 :ушу уш шу Ушу уШ Шу У
B:Всё вместе
I:Теперь в словах и выражениях:
D:Шрам от шурупа:  много шарили.  "Швед" --- он и в Африке "швед".
 :Вора шатало от шторы.  У него ли кушал?  "А што", --- прошипело в ответ,
 :--- "шикарно поели!"  Шатрам дуло.  Широко дышала природа своим упоительным
 :шармом;  шорты тоже дышали.  Ноша не жала, и мы дошли до ниши.  "Упор нужен!"
 :--- утвердила Мышь, но это угнетало.  Жало уже шатало...
Q:Перейти к следующему занятию?  [Д/Н]
N:__MID_FS

*:MF_SB
B:Ещё пара клавиш из нижнего ряда
T:
 :    Другими клавишами, которые нажимаются средними пальцами и которых у нас
 :в упражнениях пока ещё не было, являются `С' и `Б'.  `Б' нажимается почти
 :так же легко, как и мягкий знак, и почти так же, как и `Ш' при правильном
 :положении кисти и её расслабленности.  С `С' всё, однако, не так просто.
 :Дело в том, что в то время как средний палец правоый руки для нажатия `Б'
 :естественно движется сонаправленно всей руке, средний палец левой руки для
 :нажатия `C' из основной позиции не перемещая руку, должен уклониться
 :в сторону на довольно значительное расстояние.  Не пытайтесь оставлять все
 :остальные пальцы левой руки на остальных местах, когда нажимаете `С',
 :указательный палец будет сильно мешать, и его лучше отвести в сторону
 :на момент этого нажатия, оставляя в то же время мизинец и безымянный пальцы
 :на месте и чуть поворачивая кисть относительно них против часовой стрелки.
 :Таким способом освоиться с этой клавишей на ощупь большого труда не составит.
 :Ещё раз напоминаем, что кисть должна быть совершенно свободной, но собранной.
B:`С'
I:Потренируйтесь использовать клавишу `С' на ощупь.  Если плохо получается,
 :вернитесь к предыдущему пояснению и изучите его ещё раз.
D:с с ссс сссс сс
 :Сс Сс СсС сСс ссСС СсссСсССсСс
B:`Б'
I:Научитесь нажимать клавишу `Б' вслепую.  Используйте для этого средний палец
 :правой руки.
D:б б ббб бббб бб б
 :Бб бБ ББб ББББббббБбБбББ
B:`Б' и `С'
I:Следите за свободой рук и чёткостью движений.
D:Сб Бс Сб Бс бсс сбб сбс бсб
 :бссбссбссбсс сббсббсббсбб сбсбббсбссбсбсссбсбббсбсббссс
B:Всё вместе
I:А теперь всё вместе.  Этих двух букв очень не хватало в предыдущих
 :упражнениях, не правда ли?
D:Боль была сурова, но бравура давала повод блефовать.  Баран особо не бурел
 :при виде бабок, и буркнул:  "пусть браковали, но боров не бросит".
 :
 :Борис подумал про Сибирь.  "В Сибири весьма не тепло", бормотнул кто-то.  Это
 :был Иван, он был в Сибири.  "Мне там было холодно как собаке!"  Снаружи было
 :сыро и страшно, совсем как в суровом лесу.  Острота ошеломила, и он сбавил
 :скорость мысли.  Великость и блеск баловали себе беспредельно.  Шатобриан
 :блистательно шершал блестевшими шершавыми брусками.
Q:Перейти к следующему занятию?  [Д/Н]
N:__MID_FS

*:MF_CSCH
B:Ещё немного шипящих согласных
T:
 :    Клавиши `Ц' и `Щ' нажимаются безымянными пальцами левой и правой руки
 :соответственно.  Как уже было сказано в пояснениях к певой серии упражнений,
 :безымянные пальцы обычно слабее всего развиты, и сейчас вам придётся немного
 :побороться с этой слабостью, чтобы добиться хороших результатов.  Если
 :гибкость этих пальцев у вас оставляет желать лучшего, стоит поупражняться
 :отдельно.  Свободно положите всю руку по локоть на стол (если там есть место),
 :держа пальцы в том же положении как если бы они лежали на клавиатуре в
 :основной позиции, сделайте безымянным пальцем "шаг вперёд", то есть
 :приподнимите его, и положите в выпрямленом состоянии, ничего больше другого
 :в этот момент в руке не напрягая.  Теперь, держась кончиком безымянного пальца
 :за стол, подтяните им вперёд всю руку, следя за тем, чтобы кисть при этом
 :только немного приподнималась, а все остальные пальцы чувствовали себя
 :свободно --- то есть, чтобы кисть пассивно "волочилась" вперёд усилием
 :безымянного пальца.  Повторяйте это упражнение много раз каждой рукой, и вам
 :будет легче использовать безымянные пальцы при слепой печати.
B:`Щ'
I:Нажимайте клавишу `Щ' безымянным пальцем правой руки.  Следите за свободой
 :кисти и точностью движений!
D:щ щ щщ щщщ щщщщ щщ щщ щ
 :Щщ Щщ щЩ щЩ ЩЩщщЩЩщщщ ЩЩЩщщЩЩЩщщЩщЩщ
B:`Ц'
I:Потренируйтесь нажимать клавишу `Ц' безымянным пальцем левой руки.  Возможно,
 :это самое трудное движение во всём курсе!
D:ц ц ццц цццц цц
 :Цц цЦ ЦцЦ ццЦцЦ цццЦцЦцЦЦ
B:`Щ' и `Ц'
I:Теперь обе этих клавиши:
D:Цщ Щц ЦЩ ЩЦ цщЦ ццщ щЦщ Щцц
 :ЦщцщЦщцщ ЩцщцЩцщц ЦщщцщцщцццщцЩЦцщщцЩщцЦЩцщц
B:Всё вместе
I:А теперь попробуем всё вместе.
D:Цветастым щебетом расщебеталась самка щегла.  "Конец роще", подумал Щукин.
 :Цапле щебет был как перец, ощетинившись, она целовала своего целого пока
 :щенка.  Щенок выцветал целыми щербинками своего шаловливого перцово-щенного
 :туловища.  Церебральным пращуром решено было ощенить лещика Вощу, кто,
 :оцепенев, бесцеремонно подцепил центнер роскошного супа от щуки;  одинадцать
 :цветов цвели на щебетной блуднице.
Q:Перейти к следующему занятию?  [Д/Н]
N:__MID_FS

*:MF_TCHJU
B:`Ч' и `Ю'
T:
 :    `Ч' и `Ю' тоже нажимаются безымянными пальцами левой и правой руки
 :соответственно, только они расположены на нижнем ряде клавиш, поэтому
 :нажимать их немного легче, чем `Ц' и `Щ'.  Все остальные пальцы в это время
 :могут и должны оставаться неподвижными.  Если средний палец на левой руке
 :мешает вам, наклоните его немного вправо во время нажатия `Ч'. Как обычно,
 :следите за свободой руки и кисти.
B:`Ч'
I:Нажимайте клавишу `Ч' безымянным пальцем левой руки.  Следите за гибкостью!
D:ч ч ччч чччч чч
 :ЧчччЧчччЧчЧЧчЧЧчЧчч чЧЧчЧчЧЧЧчЧч
B:`Ю'
I:Используйте безымянный палец правой руки дла нажатия клавиши `Ю'.
D:ююю юю ю юююю ю юю
 :Юююю юююЮю ЮюююЮюЮю юЮююЮю ЮЮЮюю
B:`Ю' и `Ч'
I:Потренируйтесь нажимать клавиши `Ч' и `Ю'.
D:ч ю Ч Ю Чючю юЧю юЧЧЮ чЮюю ючЮЧ ЧЮюю чЧЧЧ чЧюЮ
 :юч чю Юч чЮ юЧ Чю юЧ чЮ чюЧЮччююЧЧЮЮ
B:Всё вместе
I:Теперь всё вместе:
D:Человек человеку брат;  это черта может давать и радость и стыд.
 :Юла получила должную раскрутку, и теперь чертовски уютно юлит.
 :Чацким много кого нарекали впустую.  Танюша чванилась, когда жучка училась
 :причудливо юродить.  Парашютиста приютили и напоили чаем.  Чучундра ---
 :сказочное чучело.  Червь точил червоточину с южного бока Чудного дерева.
 :Через четыре часа Юра сочинил причудливое, но скучное сочинение.  "Четыре",
 :сказал учитель, "в юности всегда бывает чудно, но правильную речь надо
 :выуючить, а то много чудаков тут вчужую чванятся;  будь честен".  Чу!  Слышен
 :часто ночью шум.  Что, чисто?  Не чавкать! --- И не чавкаю!!! --- Молчать!!!
Q:Перейти к проверочной работе?  [Д/Н]
N:__MID_FS

*:MF_TEST
B:Проверочная работа
I:Проверьте, хорошо ли вы усвоили уже 27 буквенных клавиш и знаки препинания.
 :Не смотрите на клавиатуру!  (кстати, напечатать надо оба абзаца)
S:Двадцать семь клавиш с буквами, да почти дюжина прочего --- шутка ли дело?
 :Нужно было поработать на славу, чтобы вслепую овладеть ими, но ценою упорного
 :труда человек совершает и не такие подвиги.  Впрочем, не будем чинить почести,
 :печать на ощупь --- навык такого же сорта, как, например, чтение и письмо.
 :Его оттачивают с юности, и он служит мощным методом набора текстов.  Немногие
 :владеют им в совершенстве, но даже новичку, только преодолевшему первые
 :трудности, видно, что так печатать и лучше, и интереснее.  Вспомним лишь
 :философскую истину "красота в наилучшем соответствии цели", и мы вмиг увидим,
 :что печать на ощупь прекрасна, она имеет отличие от "тупого" метода примерно
 :такое же, как отличие неумелого лепета от крепкого и правильного слога;  как
 :преимущество, которое имеет глубокое понимание и натренированность от
 :дилетантского невежества.
 :
 :Вы подошли почти к концу курса.  Совсем немного --- и вы сможете печатать
 :качественно и быстро, как это только вам можно.  Но пока кое-что осталось
 :сделать, поэтому упорно идите дальше до победного конца, когда этот курс
 :станет вам уже ненужным.
Q:Как вам ваши результаты?  [просто зДорово/пока не очеНь]
N:__MID_FS

*:__LIT_FS
B:Использование мизинцев
M: "Последние наборы упражнений на освоение печати текстов:"
 :LF_ISZ	"    `Й' и `З'     "
 :LF_JAJIO	"    `Я' и `Ё'     "
 :LF_HAHS	"`Х' и твёрдый знак"
 :LF_TEST	"Проверочная работа"

*:LF_ISZ
B:`Й' и `З'
T:
 :    Клавиши `Й' и `З' нажимаются мизинцами левой и правой руки соответственно.
 :При этом всё остальное можно оставлять неподвижным, но если у вас короткие
 :мизинцы, вам придётся на момент нажатия немного подвинуть кисть вперёд.
 :Если у вас слабые мизинцы, вам стоит проделать с ними то же упражнение, что
 :рекомендовалось для безымянных пальцев в предыдущей серии занятий.  Мизинцы
 :на самом деле доволько сильные пальцы и они находятся в выгодном положении,
 :поэтому не пожалейте времени и научитесь свободно использовать их при слепой
 :печати.
B:`З'
I:Нажимайте клавишу `З' мизинцем правой руки.  Следите за лёгкостью движений.
D:ззз зз з ззз зз з
 :Зз зЗ ЗЗз зЗзззЗзЗзЗз зЗззЗзЗзЗз
B:`Й'
I:Нажимайте клавишу `Й' мизинцем левой руки.  Следите за гибкостью движений.
D:ййй йй й йййй ййй йй й й й
 :Йй ййЙ йЙйЙЙйЙййй йЙйЙйЙЙйЙЙЙйЙ
B:`Й' и `З'
I:Поупражняйтесь выполнять эти движения.
D:ЙЗ йз ЗЙ зй Йзй Зйз зйзйзййзЙзЙзЗйЗй
 :ййзййзЙЙзЙЙз ззйззйЗЗйЗЗй йзЙЗЙЙЗЗЙзйзЗйЙйЗ
B:Всё вместе
I:Теперь всё вместе.
D:Йоко здесь.  Зачем он здесь?  --- Никто не знает!  Его вой заливал здешнюю
 :залу каверзным образом...  Йена Заремовна призрачно зевнула, и ей стало завидно
 :возить злую трапезу по разным закоулкам.  Овидий поел мидий, и получил запор.
 :Завтракать и быть завтраком --- совсем разные вещи.  Желаний завтракать
 :заманчиво много, но нет желаний быть завтраком.  "Прийшли, прийшли!" ---
 :заорал Зарецкий.  Чацкий обладал незавидным разумом.  Заяц был пойман дедом
 :Мазаем.  Мазай любил зажаренного зайца.  Роза ойкнула под ризой и порозовела
 :ржавчиной.  Мазепа не был запутан заманчивой Евой.  Нейгаузу завидовали.
Q:Перейти к следующему занятию?  [Д/Н]
N:__LIT_FS

*:LF_JAJIO
B:`Я' и `Ё' --- наши однобуквенные дифтонги
T:
 :    Клавиши `Я' и `Ё' в стандартной раскладке должны нажиматься мизинцами
 :левой и правой руки соответственно.  Если `Я' в большинстве раскладок
 :расположена там, где надо, то `Ё' обычно не расположена где надо.  На
 :раскладке, совместимой с Microsoft, её можно найти на месте тильды `~'.
 :Надеемся, что вы будете правильно и точно нажимать её, где бы на вашей
 :раскладке она ни находилась.
 :
 :    Нажимать `Я' и `Ё' в стандартном расположении так же легко, как и любую
 :клавишу нижнего ряда (может быть, за исключением `И'), если не легче.  Немного
 :практики --- и вы будете управляться с мизинцем не хуже, чем с более длинными
 :пальцами вашей руки.
 :
 :    Ещё два слова про `Ё'.  Некоторые думают, что в русском алфавите на самом
 :деле 32 буквы, и `Е' можно употреблять везде, где должно быть `Ё'.  Это мнение
 :ошибочно, букву `Ё' пока ещё никто не отменял, и вряд ли её когда-нибудь
 :отменят.  Конечно, очень редко когда пренебрежение ей сказывается на
 :понятности написанного, но такой текст становится труднее читать вслух,
 :да и вообще опытные глаза очень цепляют такие пренебрежения.  Правильное
 :употребление буквы `Ё' тоже является частью культуры русской речи.
B:`Ё'
I:Поупражняйтесь набирать `Ё' на ощупь, где она у вас там находится.
D:ё ё ёёё ёёёё ёё
 :Ёё ёЁ ёЁёёЁёЁёЁЁЁёЁ ЁёёЁЁЁёЁё
B:`Я' --- как много в этом звуке!
I:Нажимайте клавишу `Я' мизинцем левой руки.  Следите за гибкостью движений.
D:я я яяя яяяя яя
 :Яя Яя ЯЯЯяяяЯЯЯяяЯяЯяЯЯяЯя Я Я Я Я Я я Я
B:`Ё' и `Я'
I:Теперь потренируйтесь выполнять оба движения на ощупь.  Не смотрите на
 :клавиатуру!
D:Ёя Ёя Яё Яё яёЯЁёяЁЯ яёёяяяяёяёяЁёяёяяяёяЯяёяЁяёяЁяЯ
 :ЯЯёЯЯёЁЁяЁЁя ЯЁёЯЁё ЁЯяЁЯя Я Ё
B:Всё вместе
I:А теперь всё вместе.  Не смотрите на клавиатуру!
 :Этих двух гласных тоже давно не хватало, не правда ли?
D:Я яростно порол её ежовым ёршиком, но Яна оконянно молчала, стиснув
 :янтарные зубы.  Ёж, петляя, привёл себя в состояние ярого ёрзания по ёлочной
 :проёмке.  "Ё-моё!", ёкнул Ёрик.  Ёмкость ёж-рыбы блестела от клеёнки и клея.
 :Ещё раз:  "Ё" --- важная буква в письменной речи, не избегайте её!  Причём
 :здесь "Ё"?  Уже печатая её, мы признаём её значение в явной форме.  Наша
 :письменная речь становится ещё яснее.
Q:Перейти к следующему занятию?  [Д/Н]
N:__LIT_FS

*:LF_HAHS
B:Последние буквы в нашем курсе
T:
 :    Сейчас будут последние упражнения на освоение слепого десятипальцевого
 :метода --- осталось научиться печатать `Х' и `Ъ' на ощупь.  На стандартной
 :раскладке они расположены рядом и нажимаются мизинцем правой руки, однако
 :на некоторых раскладках твёрдый знак зачем-то перенесён в другое место.
 :Необходимость в твёрдом знаке возникает очень редко, но мы надеемся, что
 :вы знаете, в каких случаях его нужно употреблять.
 :
 :    Нажимать клавишу `Х' мизинцем должно быть примерно так же легко, как `Е'
 :--- указательным пальцем левой руки.  Твёрдый знак в стандартной позиции
 :на ощупь нажимать сложнее, так как он ужалён на порядочное расстояние, но
 :вряд ли сложнее, чем нажимать `И' указательным пальцем левой руки --- конечно,
 :при должной гибкости.  Как обычно, если вам сложно дотятуться, кисть можно
 :немного повернуть относительно свободных покоящихся пальцев.  Не
 :расслабляйтесь, курс ещё не закончился!
B:`Х'
I:Нажимайте клавишу `Х' мизинцем правой руки.  Следите за точностью движений.
D:х х ххх хххх хх
 :Хх Хх ХХХ ХХх ххХхХХХхХхххХХхХх
B:Твёрдый знак
I:Нажимайте твёрдый знак где он у вас расположен, правильным движением
 :правильного пальца.
D:ъ ъ ъъъ ъъъъ ъъ
 :ЪъЪъъъЪъъъЪъ ЪъъЪЪЪъъЪъъЪъъъЪъЪъъЪъ ЪъЪъЪ
B:`Х' и твёрдый знак
I:Потренируйтесь нажимать эти клавиши на ощупь.
D:Хъ Хъ Ъъх Ъъх ХЪъ ХЪъ ХЪЪХхъъхХЪХЪъхъхХЪХЪХЪъХЪъхъХъХХхЪъ
B:Всё вместе
I:Это последнее упражнение в основном курсе, но не расслабляйтесь, пока
 :оно у вас не выйдет!  Радуйтесь приобретаемой свободе!
D:Характер у Хавроши был въедливым.  Пьеро хотел утихомирить свою похоть,
 :хотя у него это и плохо выходило.  "Субъект познания" находился в хорошем
 :положении, он нехотя и сухо хвалил хиреющий характер.  "Какого х..?!" ---
 :вскрикнул хозяин, въехавший в подъезд своей хаты и встретив там халифа,
 :ихтозно пахающего Хулию своим хоботом.  Адъютант хвастался, что ему впихнули
 :инъекцию против хвастовства.  Объект охранялся пъезоэлектрическими датчиками,
 :но хиреющая проволока лихо намекала на сверхъествественную надпись "Не влезай
 :--- убъёт!"  "Дизъюнкция" означает логическое "или".  Конъюктура хромала.
Q:Перейти к проверочной работе?  [Д/Н]
N:__LIT_FS

*:LF_TEST
B:Последняя проверочная работа
I:Проверьте, всё ли у вас хорошо, набрав этот текст.  Не смотрите на клавиатуру!
S:Наконец-то вы дошли до этого заветного места!  Сколько сил было потрачено для
 :преодоления возникающих трудностей, сколько раз вы упорно повторяли вновь и
 :вновь одни и те же скучные упражнения, добиваясь удовлетворительных
 :результатов!  Теперь вы набираете этот текст, возможно, с ошибками и медленно,
 :но наверняка с радостным чувством победы над собой.  Возможно, вы думаете;
 :"да, я сделал это и научился слепому десятипальцевому методу!", или просто
 :тихо гордитесь собой.  Объём проделанной работы уже может вызывать уважение,
 :даже если результат пока ещё не очень впечатляющ;  но "не всё сразу" (как
 :говорят слова народной мудрости) --- с этого момента, применяя ваши новые
 :знания и навыки каждый день, со временем вы добъётесь завидных результатов;
 :труд и старание сделают своё дело.  Автору этого курса тоже приятно знать, что
 :его собственный труд, этот курс, принёс кому-то пользу, радость, или даже
 :успех;  поделитесь с ним своей новой радостью, и ему будет ещё приятнее!
 :Если же вас не удовлетворил этот курс, ваши замечания могли бы быть очень
 :полезными.  Этот курс создавался непрофессионалом и не методистом, да ещё и
 :в большом недостатке времени, поэтому он не был достаточно продуман.  Ваши
 :замечания могли бы помочь улучшить его!
 :
 :Что делать теперь?  Если у вас хорошо получается набирать этот текст, то этот
 :курс вам уже не нужен.  Вы можете измерить свою скорость и проверить силы ещё
 :на нескольких тестах, а также повыполнять специальные упражнения, которые
 :прилагаются к курсу, если они вам нужны.  Счастливого пути!
Q:Перейти к тестам?  [Д/Н]
N:LIT_FS

*:__TESTS
B:Тесты скорости и качества "электронного" письма
M: "Выберите тему:"
 :T_NOTES	"                  Указания к тестам                    "
 :T_LIT		"Отрывки из произведений русской классической литературы"
 :T_TECH	"          Тексты по научным специальностям             "

*:T_NOTES
T:
 :    В этом приложении в качестве тестов скорости и качества письма приведены
 :отрывки из различных текстов, чтобы у вас был лёгкий способ измерять некоторые
 :параметры своего письма.  Не следует поэтому работать над ними так же, как
 :и над упражнениями, они для этого не предназначены;  это утомительное и
 :неблагодарное занятие, разве что только вас кто-то попросил добиться наилучших
 :результатов на данном конкретном тесте, или что-то в этом роде.
 :
 :    Все тексты тестов достаточно сложны и предполагают владение всеми
 :необходимыми навыками для их выполнения, прежде всего тем, чему посвящён
 :основной курс.  Тексты по различным техническим специальностям, кроме того,
 :предполагают владение символами, требуемыми для ввода формул (в LaTeXе),
 :а также всем латинским алфавитом.  Все эти требования исходят прежде всего
 :из практической надобности;  тексты по специальностям сделаны в как можно
 :большем соответствии с действительностью.
 :
 :    Однако следует учитывать, что никаких гарантий по поводу _содержания_
 :не предоставляется, и рассматривать эти тексты только как тексты для измерения
 :качеств письма --- даже в отрывках произведений русской литературы возможны
 :неточности (обязательно сообщайте нам о них), а некоторые детали оформления,
 :такие, как выделение слов курсивом и отступы, были временами проигнорированы
 :"на благо теста".
G:__TESTS

*:T_LIT
B:Тесты по классической русской литературе
M: "Выберите тему:"
 :T_L_PSK	"Пушкин А. С.  (1799 -- 1837)"

*:T_L_PSK
B:Александр Сергеевич Пушкин (1799 -- 1837)
M: "Выберите тест:"
 :T_L_PSK_PVO	"Песнь о вещем Олеге  (1822)"

*:T_L_PSK_PVO
B:ПЕСНЬ О ВЕЩЕМ ОЛЕГЕ
I:[пока только строфы 1 -- 6]
S:Как ныне сбирается вещий Олег
 :  Отмстить неразумным хазарам:
 :Их села и нивы за буйный набег
 :  Обрек он мечам и пожарам;
 :С дружиной своей, в цареградской броне,
 :Князь по полю едет на верном коне.
 :
 :Из темного леса навстречу ему
 :  Идет вдохновенный кудесник,
 :Покорный Перуну старик одному,
 :  Заветов грядущего вестник,
 :В мольбах и гаданьях проведший весь век.
 :И к мудрому старцу подъехал Олег.
 :
 :"Скажи мне, кудесник, любимец богов,
 :  Что сбудется в жизни со мною?
 :И скоро ль, на радость соседей-врагов,
 :  Могильной засыплюсь землею?
 :Открой мне всю правду, не бойся меня:
 :В награду любого возьмёшь ты коня".
S:"Волхвы не боятся могучих владык,
 :  А княжеский дар им не нужен;
 :Правдив и свободен их вещий язык
 :  И с волей небесною дружен.
 :Грядущие годы таятся во мгле;
 :Но вижу твой жребий на светлом челе.
 :
 :Запомни же ныне ты слово моё:
 :  Воителю слава --- отрада;
 :Победой прославлено имя твоё:
 :  Твой щит на вратах Цареграда;
 :И волны и суша покорны тебе;
 :Завидует недруг столь дивной судьбе.
 :
 :И синего моря обманчивый вал
 :  В часы роковой непогоды,
 :И пращ, и стрела, и лукавый кинжал
 :  Щадят победителя годы...
 :Под грозной бронёй ты не ведаешь ран;
 :Незримый хранитель могущему дан.
G:T_L_PSK

*:T_TECH
B:Тексты по научным специальностям
M: "Выберите тему:"
 :T_T_M	"Математика"

*:T_T_M
B:Тексты по математике
M: "Выберите тему:"
 :T_T_M_ST	"Теория множеств"

*:T_T_M_ST
B:Тексты по теории множеств
M: "Выберите тест:"
 :T_T_M_ST_I	"Из введения в теорию множеств"

*:T_T_M_ST_I
B:Из введения в теорию множеств
S:Современное понятие множества постепенно формировалось в течение долгого
 :времени, и в настоящий момент оно является прочной основой для обширной части
 :математики, являясь универсальным средством описания самых различных объектов.
 :Можно работать со многими объектами и не ссылаясь на понятие множества, но при
 :этом, по сравнению с теоретико-множественными описаниями они будут более
 :сложными и запутанными в глазах математиков.
 :
 :Итак, что такое множество?  Неформальным языком можно было бы сказать, что
 :это некоторое "собрание", "набор" каких-то объектов.  Напрамер, числа 1, 2, 3,
 :4 образуют множество, все слова русского языка, все буквы греческого алфавита,
 :и вообще всё, что содержит в себе известные элементы и только их является
 :множеством.  Строгим языком же множество определяется как некоторый объект,
 :удовлетворяющий некоторым свойствам.  Сейчас мы подробно рассмотрим их, но
 :сначала введём важное обозначение.  Для любого множества $M$ и чего бы то ни
 :было $x$ верно одно из двух утверждений:  "$M$ содержит $x$" или "$M$ не
 :содержит $x$".  Обозначаются они $x \in M$ и $x \notin M$ соответственно.
 :\begin{property} Два множества $M$ и $N$ называются равными друг другу тогда
 :и только тогда, когда для любого элемента $x$ из $M$ $x \in N$ и наоборот:
 :для любого $x$ из $N$ $x \in M$.
 :\end {property}
 :Это свойство выделяет полноту определения множества:  два множества равны
 :тогда и только тогда, когда они содержат одни и те же элементы.
G:T_T_M_ST

*:__EXTRA
B:Дополнительные главы курса
M: "Что вам будет угодно изучить?"
# :E_MULTILANG	"Использование нескольких языков в текстах"
# :E_OTHSYM	"Использование дополнительных символов"
 :E_SPOKEN	"  "Разговорные" элементы выразительности "

*:E_SPOKEN
B:"Разговорные" элементы выразительности
M: "Выберите серию упражнений:"
 :ES_SMILES	"                "Смайлики"                  "
# :ES_HL		""Подчёркивание" и "выделение жирным шрифтом""

*:ES_SMILES
B:"Смайлики"
T:
 :    В этой серии упражнений вы можете научиться эффективным приёмам, нужным
 :главным образом для интернет-общения с помощью обычного текста.  Чтобы
 :передавать обычным текстом всё, что хочется передавать в "живом" общении,
 :со временем появилось много приёмов и способов.  Часто несколько символов
 :с успехом экономят несколько фраз, хотя нередко они вносят элемент
 :непонятности и "глупости" в письменную речь, и их нужно использовать умело.
 :
 :    Широко распространены "смайлики".  Это знаки, изображающие в очень
 :символическом виде черты лица.  Например, ":-)" или ":)" обозначает улыбку,
 :радость, а ":-(" или ":(" --- досаду, обиду, или ещё подобные чувства.  Сейчас
 :встречается множество вариаций этих знаков, хотя по-настоящему первого,
 :приведённого в примере, хватает на все случаи жизни.  Эти упражнения помогут
 :вам научиться быстро набирать самые различные смайлики в русской раскладке.
 :Если вам немного нужно, можете ограничиться первым упражнением;  в
 :последующих понадобится умение набирать специальные символы, вроде "$" и "<",
 :и их можно пропустить.
 :
 :    Вообще же эти упражнения были добавлены чтобы показать, какие ещё
 :оригинальные упражнения можно добавить в приложения к этому курсу.
I:Потренируйтесь набирать простые смайлики.
D::-) :) :-) :) :) :-) :-) :)
 ::-( :( :-( :( :-( :( :( :-(
 :;-) ;) ;-) ;) ;) ;-) ;-) ;-)
I:Теперь попробуйте вместе с предложениями.
D:Я тебя узнал :-)  Долго ли мы не виделись?
 :"Непонятные символы?" ;-)  Ну и грызи свою сушку :-(
 :
 ::-) обозначает улыбку и радость, :-( --- противоположные эмоции, а ;-) ---
 :намёк.  Минус "-" можно опускать, но тогда смайлики будут "куцыми", наподобие
 ::), :( и ;).  Такие смайлики легче набирать, но сложнее воспринимать.
B:"Продвинутые" или "выпендрёжные" смайлики
I:Фантазия и нескромность помогут "точнее" передавать свои эмоции %-}
D:%-) %) %-) %) %) %-) :-D :D
 :%\ %-\ %\ %-\ %-\ %-\
 :&^) &) &^) &^) &) &> &} &] &-> &-} &-]
 :$-) $) $-) $-) $) $-) $-> $-} $-] $} $] $>
 ::-> :> :> :-> :->
 :;< ;^< ;^< ;< ;< ;^<
 :`_' `_' `v' =^-^= -()_()- ~/@-@\~ -%\/%- ~<@>u<@>~
I:Теперь попробуйте вместе со словами.
S:В смайликах "%" вместо двоеточия может означать перекошенное лицо, напиример,
 :от выпитого или узнанного;  "\" (реже "/") означает перекошенный рот.  "Ну и
 :фраза %-\"  Апострофы ("`" или "'") вместо двоеточия могут означать
 :"подмигивание" --- тонкий намёк или кокетство.  Прочие символы вместо ":",
 :вроде "$" и "&", обычно означают самодовольство и гордый взгляд, хотя вообще
 :могут означать всё что угодно.  Чёрточка "-", обозначающая нос, нередко
 :выгибается в сторону ("^" или "v"), или даже идёт волной ("~").  Иногда вместо
 :неё ставят двойную чёрточку "=" (знак равенства), но выглядят такие смайлики
 :довольно своеобразно, и хочется думать, что автор просто поленился или забыл
 :нажать клавишу верхнего регистра, набирая минус.  Вместо обычных скобок "()"
 :можно применять фигурные, угловые, или даже квадратные;  обычно это
 :подчёркивает смайлик, делая его более гротескным.  Сравните ":-)" с ":->",
 :":}" и ":-]".  Изредка на месте скобок применяются и другие символы, например
 :"@" и "#", могущие обозначать оскал или ещё какие-нибудь характерные гримасы.
 :Нельзя не упомянуть про "очень широкую улыбку", кое-где символ весьма
 :распространённый, ":-D" или ":D".  Впрочем, он может обозначать и оскал.
 :
 :Нередко применяют "горизонтальные" смайлики, и такое псевдографическое
 :творчество имеет отношение больше к ascii-арту.  Выглядят они все обычно очень
 :эффектно, сравните "~<@>u<@>~" с ":-)", и отличаются большим многообразием,
 :но в "официальной" письменной речи они используются крайне редко.
G:E_SPOKEN

*:__HELP
B:Помощь и справка
M: "Выберите тему:"
 :WTF		"Что такое слепая печать и зачем она нужна?"
 :HDETAILS	"             Немного истории              "
 :BASES		"    Основы эффективности слепой печати    "
 :HOWTO		"          О работе с этим курсом          "
 :GTP		"           О проекте GNU Typist           "
 :ABOUT		"          О создании этих уроков          "

*:WTF
B:Без клавиатуры никуда
T:
 :    С тех пор, как появились технические средства обработки текстовой
 :информации, возникла проблема эффективного ввода текстовой информации в
 :различные устройства.  Первоначально это были пишущие машинки и устройства для
 :типографского набора, затем появились компьютеры, и в настоящее время с
 :этой проблемой сталкиваются почти все, потому что почти каждая работа (за
 :исключением особого ряда специальностей, таких как уборщики или грузчики)
 :включает в себя работу с компьютером.  Даже общение уже сложно представить без
 :интернета и почты, а там основной обмен информацией происходит именно
 :текстом.  Конечно, уже есть неплохо действующие средства распознавания речи и
 :напечатанных текстов, но вряд ли обычная клавиатура в умелых руках
 :уступит когда-нибудь в ближайшее время другому методу свои основные позиции.
 :Эффективное её использование должно входить в набор умений, составляющих
 :основную грамотность пользователя компьютера.
 :
 :    Чтобы понять, какое это имеет значение конкретно для вас прикиньте,
 :сколько информации вы вводите с клавиатуры для выполнения работы, обмена
 :почтой, и других повседневных занятий.  Возможно, вы не замечали этого раньше.
 :Рационально ли вы используете клавиатуру?  Если вы используете "интуитивный"
 :метод, то сильно ли вы устаёте от его использования?  Не утомляетесь ли вы
 :от постоянных взглядов на клавиши?  Не устают ли ваши руки от
 :постоянного блуждания по клавиатуре?
B:Свободное владение клавиатурой
T:
 :    Основной результат слепого десятипальцевого метода --- свободная работа
 :с клавиатурой.  Это означает, что вы совершенно автоматически и без
 :каких-либо затруднений набираете почти любой текст, так же, как, например,
 :произносили бы его вслух.  Вот его основные идеи:
 :
 :    * Минимизация движений.  Чем меньше вы делаете движений, тем быстрее вы
 :печатаете и тем меньше вы устаёте.  Минимизация движений подразумевает, что вы
 :используете все потенциальные возможности ваших рук, в частности, работаете
 :всеми десятью пальцами.
 :
 :    * Полный автоматизм в работе с клавиатурой.  Вы не отвлекаетесь на этот
 :процесс, и думаете только о том, что вы сейчас печатаете.  В частности, это
 :предполагает, что вам не нужно смотреть на клавиатуру вообще.  Вы в это время
 :можете смотреть куда угодно!
 :
 :    Эти идеи выглядят просто и банально, но как же сложно их реализовать!
 :Только упорная систематическая работа над упражнениями помогает достигнуть
 :удовлетворительных результатов...
G:__HELP
*:BASES
B: Сначала ползать --- потом ходить!
T:
 :    Больше всего результат зависит от правильности организации работы,
 :неважно какой.  "Лучше улитка, правильно организующая свой труд, чем муравей,
 :тупо ползающий весь день".  [TODO:  узнать источник и привести точный вид этой
 :поговорки].  Поэтому подумайте, можете ли вы регулярно заниматься изучением
 :нового для себя метода?  Учтите:  если вы новичок в этом деле, то сначала
 :будет трудно.  Чудес не бывает, и пройдёт немало времени, прежде чем вы
 :сможете эффективно использовать свой новый навык, а сколько именно --- зависит
 :в основном от вас, имеющегося в вашем распоряжении времени и вашей воли.
 :Но результат стоит усилий;  думайте об этом, и стремитись к нему!
 :
 :    Последовательно выполняйте все упражнения, добиваясь в каждом из них общих
 :целей --- минимизации движений и автоматизма приминительно к конкретным
 :задачам, которые ставит перед вами каждое задание.  С самого начала приучитесь
 :не подглядывать на клавиатуру во время выполнения упражнений.  На клавиатуру
 :можно смотреть, когда вы пытаетесь понять и попробовать основные движения, но
 :если вы будете всё время поглядывать на неё, это просто сведёт на нет усилия
 :по достижению второй цели --- автоматизма.  В лучшем случае вы научитесь
 :автоматически поглядывать.
B:Развиваем кисти рук!
T:
 :    Чтобы эффективно использовать все десять пальцев ваших рук, они должны
 :обладать достаточной степенью гибкости, какой обладают, например, руки
 :пианистов.  Если вы учились играть на фортепиано, то вам будет легко овладеть
 :основными движениями в совершенстве;  если нет --- придётся порабоать
 :над этим.  Так или иначе, для того, чтобы печатать быстро и легко, нужна
 :гибкость и точная координация движений.  Сама по себе слепая десятипальцевая
 :печать развивает эти качества, но ещё лучше было бы использовать специальную
 :гимнастику для кистей и пальцев.  [TODO:  привести здесь набор упражнений
 :для гимнастики рук.]
 :
 :    У обычного человека пальцы развиты неодинаково.  У правшей лучше развита
 :правая рука, у левшей --- левая.  При том, что большие, указательные, и
 :средние пальцы обычно достаточно гибкие и подвижные, этого нельзя сказать о
 :безымянном и мизинце, и для многих развитие этих пальцев обычно представляет
 :значительные сложности.  Они обычно бывают вызваны зажатостью руки, и
 :её обязательно нужно освободить для достижения положительных результатов.
 :Облегчить эту задачу мог бы опытный преподаватель.
B:Посадка за клавиатурой и постановка рук
T:
 :    По возможности сидите прямо и ровно.  Монитор должен находиться перед вами
 :(по центру, но не близко), клавиатура должна устойчиво лежать, желательно на
 :уровне ваших локтей или чуть ниже так, чтобы ваш взгляд на неё упирался в
 :клавиши "G" и "H" ("П" и "Р").  Сидеть лучше на чём-нибудь жёстком, и движения
 :ваших локтей ничто не должно стеснять.
 :
 :    Проверьте, удобно ли вы сидите.  Полностью расслабьте кисти рук, и плавно
 :опустите их на клавиатуру так, чтобы указательные пальцы касались клавиш "F"
 :и "J" ("А" и "О"), большие пальцы лежали на пробеле, а остальные естественно
 :находились на клавишах среднего ряда.  Держите кисть руки на весу, чуть
 :опираясь на пальцы.  Всё должно быть расслаблено.  Эта позиция называется
 :основной.
 :
 :    Вы должны научиться чувствовать клавиатуру.  Нащупайте указательными
 :пальцами небольшие выступы на клавишах.  Эти выступы помогут вам находить
 :основную позицию не глядя на клавиатуру.  Попробуйте плавным движением
 :поднять расслабленную руку над клавиатурой (чтобы расслабленные пальцы держались
 :на клавишах до последнего, пока кисть не унесёт их), потом так же плавно
 :опустить и найти основную позицию на ощупь.  Научитесь на ощупь находить
 :эту позицию, вынося руки из-под стола.  Проверяйте себя, нажимая пробел,
 :"G" и "H" в другой консоли.
B:Правильные движения
T:
 :    Все движения нужно выполнять из основной позиции, и возвращаться в неё
 :после каждого движения.  Это правило поможет вам сначала, но когда у вас будет
 :больше опыта, вы будете объединять отдельные движения.  Кисти рук должны быть
 :расслаблены и слегка опираться на клавиши.  Запястья лучше держать на весу, но
 :если вам сложно, вы можете использовать специальную подставку или положить их
 :на стол.  Многие подставки стесняют движения, а запястье на столе просто почти
 :целиком лишает кисть подвижности, поэтому для максимальной скорости и качества
 :нужно держать руки на весу.
 :
 :    Ваши руки во время выполнения движений должны работать настолько мягко и
 :нежно, насколько возможно, и затрачивать только те усилия, которые необходимы
 :для перемещения пальцев и нажатие на клавиши.  Кисть не должна твёрдо стоять на
 :месте, мешая пальцам;  она должна быть расслабленной, и перемещаться только
 :тогда, когда это действительно необходимо.  То есть она не должна постоянно
 :"гулять" по клавиатуре, основную работу делают пальцы.
 :
 :    Каждое основное движение следует отрабатывать до достижения
 :удовлетворительного автоматизма и свободы.  Первоначальное освоение движений
 :будет напрягать вас, но вы должны добиваться удовлетворительных результатов.
 :Первые упражнения для выполнения новых задач предназначены именно для освоения
 :новых движений.
B:Пробел
T:
 :    Для того, чтобы не смотреть на клавиатуру во время выполнения упражнений,
 :вам придётся с самого начала научиться нажимать клавиши "ввод" ("Enter") и
 :пробел на ощупь.  Эти клавиши заслуживают особого внимания.
 :
 :    Пробел нажимается одним из двух больших пальцев.  Вам придётся самим
 :определить, каким именно вам в каждом случае удобнее нажимать его.  Некоторые
 :руководства рекомендуют нажимать его всё время одним пальцем, так как при этом
 :легче всего добиться автоматизма.  На пишущих машинках рекомендовалось
 :ударять его пальцем той руки, которая не печатала последний введённый перед
 :пробелами символ, нагрузка при этом примерно равномерно распределяется по
 :пальцам.  Ещё один подход состоит в нажатии пробелов последовательно обеими
 :пальцами:  если предыдущий пробел был нажат левым пальцем, то этот нужно
 :нажать правым, и наоборот.  Понятно, что первый метод следовало бы назвать
 :"девятипальцевым", так как один из больших пальцев не используется вообще.
 :Второй метод был лучшим для пишущих машин, потому что там кисть проделывала
 :больше движений и рука больше напрягалась для удара по клавишам, поэтому нужно
 :было равномерно распределять нагрузку по всем пальцам.  Третий метод
 :единственно эффективен, когда нужно набрать несколько пробелов подряд, но
 :точно следовать ему сложно.  С практикой вы приобретёте эффективную для себя
 :технику работы с пробелами, но лучше следить за этим с самого начала.
B:Ввод
T:
 :    "Ввод" нужно нажимать мизинцем правой руки.  Попробуйте делать это
 :расслабленной и собранной рукой, оставляя все прочие пальцы лежать на своих
 :местах, перекидывая мизинец лёгким дугообразным движением с клавиши `Ж'
 :на "ввод", нажимая его и тотчас возвращая мизинец на место.  Кисть при этом
 :слегка повернётся по часовой стрелке относительно лежащих пальцев и
 :возвратится в исходное положение вместе с мизинцем.  Если вам сложно научиться
 :делать так с самого начала, вы можете попробовать не поворачивать кисть,
 :а перемещать её вправо, оставляя указательный палец легко держаться за
 :клавишу, а остальным позволяя сдвинуться со своих мест и вернуть их после
 :обратно.  Этот способ сначала может оказаться легче, поскольку он требует
 :меньшей гибкости и точности, но он более громоздок, и вы когда-нибудь
 :сможете отказаться от него, пересматривая свои навыки печати на ощупь.
 :
 :    Учтите, что хотя все современные редакторы обычно сами переносят слова, и
 :вы набираете текст так, словно каждый абзац расположен в отдельной строчке,
 :не всё, во что вам придётся набирать текст, будет текстовым редактором.
 :Клавишей "ввод" нужно уметь пользоваться не хуже, чем остальными.  Поэтому,
 :если вы видите конец строки, не нажимайте там пробел, это будет засчитано
 :как ошибка.  Так же не пользуйтесь кнопкой Backspace, продолжайте печатать
 :упражнение дальше, и постарайтесь при повторении не делать ту же ошибку.
 :Целью занятий является автоматический и безошибочный ввод!
B:Удачи!
T:
 :    Удачи в работе!  Если вы испытываете сложности, и вам кажется что этот
 :курс (равно как и эти замечания) можно сделать лучше, не колебайтесь и
 :пишите тому, кто поддерживает его в настоящий момент.  Этим вы поможете
 :остальным в освоении этого трудного дела.
 :
 :    Если вы решили серьёзно заниматься, и вам нравится учитывать ваши
 :достижения, вы можете сейчас выполнить один или несколько тестов из раздела
 :"тесты" старым методом, и записать где-нибудь ваши результаты, чтобы
 :впоследствии сравнить их с результатами после курса и теми, которые вы сможете
 :получить после длительного повседневного использования метода.  Если вы хорошо
 :позанимались, вторые будут отличаться от первых примерно на порядок, а третьи
 :будут ещё больше!
G:__HELP

*:HOWTO
B:Как и почему устроен этот курс
T:
 :    Курс разбит на несколько основных разделов, которые должны осваиваться
 :последовательно.  Каждый раздел, в свою очередь разбит на небольшие занятия,
 :задачей каждого из которых является освоение одного или нескольких новых
 :клавиш и приёмов, а также проверочную работу, которая завершает каждый
 :раздел.  Каждое занятие обычно начинается с пояснительного текста, за которым
 :идёт упражнение на первоначальное освоение нового элемента и содержащее только
 :его.  Затем идут упражнения, дающие возможность освоиться с новым элементом
 :на ощупь, последние из которых обычно несут заголовок "всё вместе" и могут
 :содержать в себе всё, что было в курсе до этого момента.  Предполагается, что
 :в выполнении каждого упражнения будет достигнута возможно более полная
 :свобода, прежде чем обучающийся перейдёт к следующему, так как при том, что
 :первые упражнения занятия служат для первоначального освоения новых элементов
 :и только для этого, последующие могут включать в себя весь становящийся обширным
 :к концу курса бывший до этого материал, в котором сконцентрирован новый
 :элемент, что даёт возможность сильнее увязать его с предыдущими в единую
 :систему, которая и называется слепым десятипальцевым методом.  Многие
 :упражнения покажутся скучными и трудными, но проявите терпение и упорство
 :для преодоления трудностей, которые у вас возникают --- и ваши (правильные)
 :усилия не пропадут даром!
T:
 :    Ещё несколько советов по работе над курсом.  Главное, помните о задачах,
 :которые вы хотите разрешить с его помощью, и занимайтесь целенаправленно.
 :Не пытайтесь достигнуть виртуозной скорости;  "тише едешь --- дальше будешь",
 :по словам народной мудрости.  Скорость придёт вам с опытом, и к тому же,
 :пальцы не должны работать быстрее, чем голова.  Работайте в первую очередь
 :над качеством:  точностью и ритмичностью движений, устранению их избытка
 :и придания им лёгкости.  Если у вас подолгу не получается какое-то упражнение,
 :попытайтесь найти этому причину.  Может быть, стоит перечитать рекомендации,
 :данные в этом и других разделах курса.
 :
 :    Пара слов о различии упражнений и практики:  "упражнения" сложнее.  Дело в
 :том, что при работе над упражнениями вы именно работаете над упражнениями,
 :добиваясь решения текущих задач, и поэтому вы должны быть собраны и
 :внимательны;  такая работа быстрее утомляет и подчас нелегко даётся.  Зато
 :когда вы применяете полученные навыки на практике, вы набираете свои
 :собственные мысли, и это значительно легче, чем набирать упражнение или
 :скоростной тест.  Но зато "тяжело в учении --- легко в бою", и чем лучше вы
 :работали над упражнениями, тем легче вам будет на практике применять
 :полученные навыки.  Не раздражайтесь поэтому, если какое-то упражнение
 :покажется вам особенно скучным или противным.
T:
 :    При создании этого курса была поставлена задача сделать его наилучшим
 :образом способствующим освоению слепого десятипальцевого метода печати.  Эта
 :задача неразрешима в общем виде, поскольку наилучшим всегда будет
 :индивидуальный подход, но всё же в силу своей постепенности и достаточной
 :подробности этот курс должен быть доступен и эффективен для всех, кто задался
 :целью изучить слепой десятипальцевый метод для русской клавиатуры, включая
 :детей.  Дети должны быть особенно способны к освоению подобного рода навыков,
 :в то время как и взрослый человек при желании может многого добиться.
G:__HELP

*:HDETAILS
B:Когда-то давно...
T:
 :    Слепой десятипальцевый метод печати появился в конце девятнадцатого века,
 :с широким распространением пишущих машинок и повсеместным использованием их
 :в деловой практике.  Секретаршам нужно было уметь (да и сейчас это необходимо)
 :печатать текст под диктовку, а для этого обычный способ явно не годится.
 :(Вы можете вспомнить прекрасное место на эту тему в романе братьев Стругацких
 :"Понедельник начинается в субботу". [TODO:  привести лучшее место в литературе
 :на эту тему в качестве примера нерационального подхода к набору текста.])
 :Название, по-видимому, произошло из-за того, что вначале обучавшимся
 :завязывали глаза и учили находить их клавиши в таком положении.  Затем стали
 :ставить перегородку между клавиатурой и глазами с той же целью, но сейчас так
 :уже не делают (впрочем, есть один хороший способ отучить от подсматривания ---
 :перемешайте клавиши на клавиатуре).
 :
 :    Современная клавиатура переняла свой вид у пишущих машинок.  Русская
 :раскладка "ЙЦУКЕН" была разработана очень давно и с учётом частоты различных
 :букв и их сочетаний в русских текстах, поэтому большая часть всей работы по
 :набору в среднем приходится на указательный и средний пальцы, а также клавиши
 :среднего ряда, что облегчает её усвоение и использование.
 :
 :    [TODO:  привести подробные исторические сведения]
G:__HELP

*:GTP
B:GNU's not UNIX!
T:
 :    GNU Typist --- проект свободной программы для помощи в освоении слепой
 :печати на разных языках и с различными целями, с которой вы сейчас работаете.
 :Загляните на домашнюю страницу проекта http://www.gnu.org/software/gtypist/,
 :если вам хочется познакомиться с ним поближе.
 :
 :    Если у вас есть время и желание, подумайте над тем, чтобы помочь проекту.
 :Тем, что вы используете эту программу, вы уже поддерживаете её;  если она вам
 :понравилась, порекомендуйте её заинтересованным лицам.  Если вы считаете, что
 :слепая печать является важным навыком, и вы работаете в учебном заведении,
 :попробуйте поднять вопрос о включении её в программу в качестве части обучения
 :навыкам работы с компьютером.  Если вы заметили ошибку или неточность в
 :уроках, или у вас есть здоровые идеи, как их можно улучшить, обязательно
 :сообщите нам!
 :
 :    Вы даже можете составлять собственные сценарии уроков или изменять
 :существующие.  Если ваши упражнения могут быть полезны кому-то ещё, вы можете
 :послать их нам, для включения в фонд наших свободных  уроков.  Он уже содержит
 :множество сценариев на разных языках и большое количество уроков на английском,
 :представляя тем самым уникальную программу для обучения слепой печати.
T:
 :    Поскольку GNU Typist --- свободная программа, её исходные тексты полностью
 :доступны для всех желающих покопаться в них.  Вы даже можете использовать их в
 :любых нуждах и распространять свои создания при условии, что вы соблюдаете
 :условия лицензии GPL.  Практически это означает, что работы, основанные на этой
 :программе, должны распространяться по условиям той же самой лицензии --- то
 :есть тоже быть свободными.  Эта свобода охраняется международным законом об
 :авторском праве.  Читайте текст лицензии, чтобы узнать больше.  Важным
 :следствием открытых исходников является то, что вы можете почти как угодно
 :использовать программу в личных или общественных целях (но не коммерческих).
 :
 :    Если вы программист, вы можете принять участие в разработке и улучшении
 :самой программы.  Сейчас идёт достаточно вялая разработка графического
 :интерфейса, и ваша умелая помощь могла бы оказаться очень ценной.
 :Разработка программ --- очень интересное занятие, почти такое же интересное,
 :как их сопровождение.  В любом случае даже ваши ценные идеи и предложения
 :могут оказаться полезными, даже если вы сами не можете или не хотите их
 :воплотить.
G:__HELP

*:ABOUT
B:Курс слепой печати на русском языке для проекта GNU Typist
T:
 :    Немного комментариев для интересующихся от автора этого курса относительно
 :целей и истории его создания.  Целью создания было восполнить недостаток в
 :свободном, подробном и постепенном курсе для желающих изучить слепую печать
 :на русском языке, а также проверить свои силы на этом интересном деле и
 :получить возможно более полное представление о том, какой должна быть
 :следующая версия программы GNU Typist, ведь автор является одним из её
 :разработчиков.  Конечно, существовало и существует множество курсов, некоторые
 :довольно неплохи, а также есть современные печатные пособия, но многим из них
 :не хватает достаточной целостности.  Автор попытался сделать этот курс как
 :можно более подробным и последовательным.
T:
 :    Создавать курс было и утомительно и интересно.  Все упражнения в курсе
 :оригинальны, автор лишь изредка обращался за помощью при подборе слов к
 :учебникам машинописи и орфографическим словарям.  При создании курса автор
 :основывался прежде всего на своём собственном опыте и на представлениях, этим
 :путём полученных.  Достаточно вразумительной литературы по этой теме найти не
 :удалось, а существующие курсы обычно ограничивались поверхностными
 :практическими рекомендациями;  автору этот путь казался неприемлемым.
 :
 :    Курс по изложению материала получился несколько оригинальным --- обычно не
 :останавливаются подробно на каждой клавише, и изучают печать целыми рядами
 :клавиатуры --- "домашний", нижний, верхний, четвёртый, а знаки пунктуации
 :не идут все сразу в середине курса.  Автор полагает, что эта вольность
 :оправдана.  Впрочем, он может ошибаться.
G:__HELP
