/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.OutPort;
import gnu.text.Path;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class BinaryOutPort
extends OutPort {
    OutputStream strm;

    public OutputStream getOutputStream() {
        this.flushBuffer();
        return this.strm;
    }

    public BinaryOutPort(OutputStream strm, Path path) {
        this(strm, new OutputStreamWriterLatin1(strm), path);
    }

    private BinaryOutPort(OutputStream strm, OutputStreamWriterLatin1 out, Path path) {
        super((Writer)out, path);
        out.port = this;
        this.strm = strm;
    }

    public static BinaryOutPort openFile(Object fname) throws IOException {
        return (BinaryOutPort)OutPort.openFile(fname, Boolean.FALSE);
    }

    public void writeBytes(byte[] buf, int off, int len) throws IOException {
        this.flushBuffer();
        this.strm.write(buf, off, len);
    }

    public void writeByte(int b) throws IOException {
        this.flushBuffer();
        this.strm.write(b);
    }

    public static OutputStream asOutputStream(Object obj) {
        if (obj instanceof BinaryOutPort) {
            return ((BinaryOutPort)obj).getOutputStream();
        }
        return (OutputStream)obj;
    }

    public int getColumnNumber() {
        return -1;
    }

    public static class OutputStreamWriterLatin1
    extends Writer {
        OutputStream strm;
        BinaryOutPort port;

        public OutputStreamWriterLatin1(OutputStream strm) {
            this.strm = strm;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                int ch = cbuf[off + i];
                this.strm.write(ch <= 255 ? ch : 63);
            }
        }

        public void write(int ch) throws IOException {
            this.strm.write(ch <= 255 ? ch : 63);
        }

        public void write(String str, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                int ch = str.charAt(off + i);
                this.strm.write(ch <= 255 ? ch : 63);
            }
        }

        public void flush() throws IOException {
            this.strm.flush();
        }

        public void close() throws IOException {
            this.strm.close();
        }
    }
}

