/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.brl;

import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.kawa.brl.BRLRead;
import gnu.kawa.brl.BRLReaderString;
import gnu.kawa.brl.Prompter;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.lispexpr.ReadTable;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.SimpleEnvironment;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.xml.XMLPrinter;
import java.io.Writer;
import kawa.standard.Scheme;

public class BRL
extends Scheme {
    static final BRL krl_instance;
    static final BRL brl_instance;
    static final Object emptyForm;
    protected static final SimpleEnvironment brlEnvironment;
    static BRLReaderString brlReader;
    boolean brlCompatible = false;

    protected BRL(Environment environment) {
        super(environment);
    }

    void initBRL() {
        ModuleBody.setMainPrintValues(true);
        try {
            this.loadClass("gnu.brl.stringfun");
            this.loadClass("gnu.kawa.brl.progfun");
            this.loadClass("gnu.kawa.slib.HTTP");
        }
        catch (Throwable throwable) {
            System.err.println("caught " + throwable);
        }
    }

    public static Language getInstance(boolean bl) {
        return bl ? BRL.getBrlInstance() : BRL.getBrlInstance();
    }

    public static BRL getKrlInstance() {
        return krl_instance;
    }

    public static BRL getBrlInstance() {
        return brl_instance;
    }

    public boolean isBrlCompatible() {
        return this.brlCompatible;
    }

    public void setBrlCompatible(boolean bl) {
        this.brlCompatible = bl;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        Compilation.defaultCallConvention = 2;
        BRLRead bRLRead = new BRLRead(inPort, sourceMessages);
        bRLRead.setBrlCompatible(this.isBrlCompatible());
        return bRLRead;
    }

    public Consumer getOutputConsumer(Writer writer) {
        if (this.isBrlCompatible()) {
            return super.getOutputConsumer(writer);
        }
        return new XMLPrinter(writer, false);
    }

    public static void registerEnvironment() {
        Language.setDefaults(BRL.getKrlInstance());
    }

    public Expression makeBody(Expression[] expressionArray) {
        if (this.isBrlCompatible()) {
            return super.makeBody(expressionArray);
        }
        return new ApplyExp(AppendValues.appendValues, expressionArray);
    }

    public ReadTable createReadTable() {
        ReadTable readTable = super.createReadTable();
        readTable.setBracketMode(1);
        readTable.set(93, brlReader);
        return readTable;
    }

    public Procedure getPrompter() {
        return new Prompter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        emptyForm = new FString();
        brlEnvironment = Environment.make("brl-environment", Scheme.kawaEnvironment);
        brlReader = new BRLReaderString();
        krl_instance = new BRL(brlEnvironment);
        brl_instance = new BRL(brlEnvironment);
        brl_instance.setBrlCompatible(true);
        CallContext callContext = CallContext.getInstance();
        Environment environment = callContext.getEnvironmentRaw();
        try {
            callContext.setEnvironmentRaw(brlEnvironment);
            krl_instance.initBRL();
        }
        finally {
            callContext.setEnvironmentRaw(environment);
        }
    }
}

