/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.kawa.servlet.KawaServlet;
import gnu.kawa.servlet.ServletCallContext;
import gnu.mapping.CallContext;
import gnu.mapping.InPort;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KawaPageServlet
extends KawaServlet {
    private static long LAST_MODIFIED_CACHE_TIME = 1000L;
    private static Map procedureCache = new WeakHashMap();
    private ServletContext context;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
    }

    public void run(CallContext callContext) throws Throwable {
        ServletCallContext servletCallContext = (ServletCallContext)callContext;
        HttpServletRequest httpServletRequest = servletCallContext.request;
        HttpServletResponse httpServletResponse = servletCallContext.response;
        boolean bl = httpServletRequest.getParameter("qexo-save-class") != null;
        String string = httpServletRequest.getServletPath();
        ModuleBody moduleBody = this.getModule(servletCallContext, string, bl);
        if (moduleBody != null) {
            moduleBody.run(servletCallContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleBody getModule(ServletCallContext servletCallContext, String string, boolean bl) throws Exception {
        URL uRL = this.context.getResource(string);
        if (uRL == null) {
            servletCallContext.response.reset();
            servletCallContext.response.sendError(404, string);
            return null;
        }
        Map map2 = procedureCache;
        synchronized (map2) {
            CacheEntry cacheEntry = this.getCacheEntry(string, uRL);
            if (cacheEntry.proc == null || bl) {
                Object object2;
                Compilation compilation;
                InputStream inputStream = uRL.openStream();
                InPort inPort = new InPort(inputStream, string.substring(string.lastIndexOf(47) + 1));
                Language language = Language.getInstanceFromFilenameExtension(string);
                Language.setDefaultLanguage(language);
                SourceMessages sourceMessages = new SourceMessages();
                try {
                    compilation = language.parse(inPort, sourceMessages, 1);
                    object2 = string.substring(string.lastIndexOf(47) + 1, string.indexOf(46));
                    compilation.getModule().setName((String)object2);
                }
                catch (SyntaxException syntaxException) {
                    if (syntaxException.getMessages() != sourceMessages) {
                        throw syntaxException;
                    }
                    compilation = null;
                }
                if (sourceMessages.seenErrors()) {
                    servletCallContext.response.reset();
                    object2 = servletCallContext.response.getOutputStream();
                    object2.print(sourceMessages.toString(20));
                    return null;
                }
                object2 = ModuleExp.evalToClass(compilation);
                if (bl) {
                    compilation.outputClass(this.context.getRealPath("WEB-INF/classes") + '/');
                }
                cacheEntry.proc = (ModuleBody)((Class)object2).newInstance();
            }
            return cacheEntry.proc;
        }
    }

    private CacheEntry getCacheEntry(String string, URL uRL) throws IOException {
        CacheEntry cacheEntry = (CacheEntry)procedureCache.get(string);
        long l = System.currentTimeMillis();
        if (cacheEntry != null && l - cacheEntry.lastCheck < LAST_MODIFIED_CACHE_TIME) {
            return cacheEntry;
        }
        long l2 = uRL.openConnection().getLastModified();
        if (cacheEntry != null) {
            if (cacheEntry.lastModified != l2) {
                cacheEntry.proc = null;
            }
        } else {
            cacheEntry = new CacheEntry();
            procedureCache.put(string, cacheEntry);
        }
        cacheEntry.lastCheck = l;
        cacheEntry.lastModified = l2;
        return cacheEntry;
    }

    static class CacheEntry {
        long lastCheck;
        long lastModified;
        ModuleBody proc;

        CacheEntry() {
        }
    }
}

