/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.Type;
import gnu.expr.BeginExp;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.ThisExp;
import gnu.kawa.functions.Convert;
import gnu.kawa.lispexpr.LangObjType;
import gnu.lists.Consumer;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.text.SourceLocator;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.TemplateScope;
import kawa.lang.Translator;
import kawa.standard.object;

public class Lambda
extends Syntax {
    public Object optionalKeyword;
    public Object restKeyword;
    public Object keyKeyword;
    public static final Keyword nameKeyword = Keyword.make("name");
    public Expression defaultDefault = QuoteExp.falseExp;

    public void setKeywords(Object object2, Object object3, Object object4) {
        this.optionalKeyword = object2;
        this.restKeyword = object3;
        this.keyKeyword = object4;
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        Expression expression = this.rewrite(pair.getCdr(), translator);
        Translator.setLine(expression, (Object)pair);
        return expression;
    }

    public Expression rewrite(Object object2, Translator translator) {
        if (!(object2 instanceof Pair)) {
            return translator.syntaxError("missing formals in lambda");
        }
        int n = translator.getMessages().getErrorCount();
        LambdaExp lambdaExp = new LambdaExp();
        Pair pair = (Pair)object2;
        Translator.setLine(lambdaExp, (Object)pair);
        this.rewrite(lambdaExp, pair.getCar(), pair.getCdr(), translator, null);
        if (translator.getMessages().getErrorCount() > n) {
            return new ErrorExp("bad lambda expression");
        }
        return lambdaExp;
    }

    public void rewrite(LambdaExp lambdaExp, Object object2, Object object3, Translator translator, TemplateScope templateScope) {
        this.rewriteFormals(lambdaExp, object2, translator, templateScope);
        if (object3 instanceof PairWithPosition) {
            lambdaExp.setFile(((PairWithPosition)object3).getFileName());
        }
        object3 = this.rewriteAttrs(lambdaExp, object3, translator);
        this.rewriteBody(lambdaExp, object3, translator);
    }

    public void rewriteFormals(LambdaExp lambdaExp, Object object2, Translator translator, TemplateScope templateScope) {
        Object object3;
        Pair pair;
        Object object4;
        int n;
        Object object5;
        if (lambdaExp.getSymbol() == null) {
            object5 = lambdaExp.getFileName();
            n = lambdaExp.getLineNumber();
            if (object5 != null && n > 0) {
                lambdaExp.setSourceLocation((String)object5, n);
            }
        }
        object5 = object2;
        n = -1;
        int n2 = -1;
        int n3 = -1;
        while (true) {
            if (object5 instanceof SyntaxForm) {
                object4 = (SyntaxForm)object5;
                object5 = ((SyntaxForm)object4).form;
            }
            if (!(object5 instanceof Pair)) break;
            pair = (Pair)object5;
            object4 = pair.getCar();
            if (object4 instanceof SyntaxForm) {
                object4 = ((SyntaxForm)object4).form;
            }
            if (object4 == this.optionalKeyword) {
                if (n >= 0) {
                    translator.syntaxError("multiple " + this.optionalKeyword + " in parameter list");
                    return;
                }
                if (n2 >= 0 || n3 >= 0) {
                    translator.syntaxError(this.optionalKeyword.toString() + " after " + this.restKeyword + " or " + this.keyKeyword);
                    return;
                }
                n = 0;
            } else if (object4 == this.restKeyword) {
                if (n2 >= 0) {
                    translator.syntaxError("multiple " + this.restKeyword + " in parameter list");
                    return;
                }
                if (n3 >= 0) {
                    translator.syntaxError(this.restKeyword.toString() + " after " + this.keyKeyword);
                    return;
                }
                n2 = 0;
            } else if (object4 == this.keyKeyword) {
                if (n3 >= 0) {
                    translator.syntaxError("multiple " + this.keyKeyword + " in parameter list");
                    return;
                }
                n3 = 0;
            } else if (translator.matches(pair.getCar(), "::") && pair.getCdr() instanceof Pair) {
                pair = (Pair)pair.getCdr();
            } else if (n3 >= 0) {
                ++n3;
            } else if (n2 >= 0) {
                ++n2;
            } else if (n >= 0) {
                ++n;
            } else {
                ++lambdaExp.min_args;
            }
            object5 = pair.getCdr();
            object5 = pair.getCdr();
        }
        if (object5 instanceof Symbol) {
            if (n >= 0 || n3 >= 0 || n2 >= 0) {
                translator.syntaxError("dotted rest-arg after " + this.optionalKeyword + ", " + this.restKeyword + ", or " + this.keyKeyword);
                return;
            }
            n2 = 1;
        } else if (object5 != LList.Empty) {
            translator.syntaxError("misformed formals in lambda");
            return;
        }
        if (n2 > 1) {
            translator.syntaxError("multiple " + this.restKeyword + " parameters");
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        lambdaExp.max_args = n2 > 0 ? -1 : lambdaExp.min_args + n + 2 * n3;
        if (n + n3 > 0) {
            lambdaExp.defaultArgs = new Expression[n + n3];
        }
        if (n3 > 0) {
            lambdaExp.keywords = new Keyword[n3];
        }
        object5 = object2;
        n = 0;
        n3 = 0;
        object4 = null;
        while (true) {
            Object object6;
            if (object5 instanceof SyntaxForm) {
                object3 = (SyntaxForm)object5;
                object5 = ((SyntaxForm)object3).form;
                templateScope = ((SyntaxForm)object3).scope;
            }
            object3 = templateScope;
            if (!(object5 instanceof Pair)) break;
            pair = (Pair)object5;
            Object object7 = pair.getCar();
            if (object7 instanceof SyntaxForm) {
                object6 = (SyntaxForm)object7;
                object7 = ((SyntaxForm)object6).form;
                object3 = ((SyntaxForm)object6).scope;
            }
            if (object7 == this.optionalKeyword || object7 == this.restKeyword || object7 == this.keyKeyword) {
                object4 = object7;
            } else {
                Object object8;
                Pair pair2;
                object6 = translator.pushPositionOf(pair);
                Object object9 = null;
                Object object10 = this.defaultDefault;
                Pair pair3 = null;
                if (translator.matches(object7, "::")) {
                    translator.syntaxError("'::' must follow parameter name");
                    return;
                }
                if ((object7 = translator.namespaceResolve(object7)) instanceof Symbol) {
                    object9 = object7;
                    if (pair.getCdr() instanceof Pair && translator.matches((pair2 = (Pair)pair.getCdr()).getCar(), "::")) {
                        if (!(pair.getCdr() instanceof Pair)) {
                            translator.syntaxError("'::' not followed by a type specifier (for parameter '" + object9 + "')");
                            return;
                        }
                        pair3 = pair2 = (Pair)pair2.getCdr();
                        pair = pair2;
                    }
                } else if (object7 instanceof Pair) {
                    pair2 = (Pair)object7;
                    if ((object7 = pair2.getCar()) instanceof SyntaxForm) {
                        object8 = (SyntaxForm)object7;
                        object7 = ((SyntaxForm)object8).form;
                        object3 = ((SyntaxForm)object8).scope;
                    }
                    if ((object7 = translator.namespaceResolve(object7)) instanceof Symbol && pair2.getCdr() instanceof Pair) {
                        object9 = object7;
                        if (translator.matches((pair2 = (Pair)pair2.getCdr()).getCar(), "::")) {
                            if (!(pair2.getCdr() instanceof Pair)) {
                                translator.syntaxError("'::' not followed by a type specifier (for parameter '" + object9 + "')");
                                return;
                            }
                            pair3 = pair2 = (Pair)pair2.getCdr();
                            if (pair2.getCdr() instanceof Pair) {
                                pair2 = (Pair)pair2.getCdr();
                            } else if (pair2.getCdr() == LList.Empty) {
                                pair2 = null;
                            } else {
                                translator.syntaxError("improper list in specifier for parameter '" + object9 + "')");
                                return;
                            }
                        }
                        if (pair2 != null && object4 != null) {
                            object10 = pair2.getCar();
                            if (pair2.getCdr() instanceof Pair) {
                                pair2 = (Pair)pair2.getCdr();
                            } else if (pair2.getCdr() == LList.Empty) {
                                pair2 = null;
                            } else {
                                translator.syntaxError("improper list in specifier for parameter '" + object9 + "')");
                                return;
                            }
                        }
                        if (pair2 != null) {
                            if (pair3 != null) {
                                translator.syntaxError("duplicate type specifier for parameter '" + object9 + '\'');
                                return;
                            }
                            pair3 = pair2;
                            if (pair2.getCdr() != LList.Empty) {
                                translator.syntaxError("junk at end of specifier for parameter '" + object9 + '\'' + " after type " + pair2.getCar());
                                return;
                            }
                        }
                    }
                }
                if (object9 == null) {
                    translator.syntaxError("parameter is neither name nor (name :: type) nor (name default): " + pair);
                    return;
                }
                if (object4 == this.optionalKeyword || object4 == this.keyKeyword) {
                    lambdaExp.defaultArgs[n++] = new LangExp(object10);
                }
                if (object4 == this.keyKeyword) {
                    lambdaExp.keywords[n3++] = Keyword.make(object9 instanceof Symbol ? ((Symbol)object9).getName() : object9.toString());
                }
                object8 = new Declaration(object9);
                Translator.setLine((Declaration)object8, object5);
                if (pair3 != null) {
                    ((Declaration)object8).setType(translator.exp2Type(pair3));
                    ((Declaration)object8).setFlag(8192);
                } else if (object4 == this.restKeyword) {
                    ((Declaration)object8).setType(LangObjType.listType);
                }
                ((Declaration)object8).noteValue(null);
                Lambda.addParam((Declaration)object8, (ScopeExp)object3, lambdaExp, translator);
                translator.popPositionOf(object6);
            }
            object5 = pair.getCdr();
        }
        if (object5 instanceof SyntaxForm) {
            object3 = (SyntaxForm)object5;
            object5 = ((SyntaxForm)object3).form;
            templateScope = ((SyntaxForm)object3).scope;
        }
        if (object5 instanceof Symbol) {
            object3 = new Declaration(object5);
            ((Declaration)object3).setType(LangObjType.listType);
            ((Declaration)object3).noteValue(null);
            Lambda.addParam((Declaration)object3, templateScope, lambdaExp, translator);
        }
    }

    private static void addParam(Declaration declaration, ScopeExp scopeExp, LambdaExp lambdaExp, Translator translator) {
        if (scopeExp != null) {
            declaration = translator.makeRenamedAlias(declaration, scopeExp);
        }
        lambdaExp.addDeclaration(declaration);
        if (scopeExp != null) {
            declaration.context = scopeExp;
        }
    }

    public Object rewriteAttrs(LambdaExp lambdaExp, Object object2, Translator translator) {
        ReferenceExp[] referenceExpArray = null;
        ReferenceExp[] referenceExpArray2 = null;
        int n = 0;
        int n2 = 0;
        SyntaxForm syntaxForm = null;
        while (true) {
            Object object3;
            Object object4;
            if (object2 instanceof SyntaxForm) {
                syntaxForm = (SyntaxForm)object2;
                object2 = syntaxForm.form;
                continue;
            }
            if (!(object2 instanceof Pair)) break;
            Pair pair = (Pair)object2;
            Object object5 = Translator.stripSyntax(pair.getCar());
            Object object6 = pair.getCdr();
            while (object6 instanceof SyntaxForm) {
                syntaxForm = (SyntaxForm)object6;
                object6 = syntaxForm.form;
            }
            if (!(object6 instanceof Pair)) break;
            Pair pair2 = (Pair)object6;
            if (translator.matches(object5, "::")) {
                object5 = null;
            } else if (!(object5 instanceof Keyword)) break;
            if (object5 == null) {
                Expression expression = translator.rewrite_car(pair2, syntaxForm);
                if (lambdaExp.isClassMethod() && "*init*".equals(lambdaExp.getName())) {
                    translator.error('e', "explicit return type for '*init*' method");
                } else {
                    object4 = translator.getLanguage().getTypeFor(expression);
                    if (object4 != null) {
                        lambdaExp.setReturnType((Type)object4);
                    }
                }
            } else if (object5 == object.accessKeyword) {
                Expression expression = translator.rewrite_car(pair2, syntaxForm);
                if (!(expression instanceof QuoteExp) || !((object3 = ((QuoteExp)expression).getValue()) instanceof SimpleSymbol) && !(object3 instanceof CharSequence)) {
                    translator.error('e', "access: value not a constant symbol or string");
                } else if (lambdaExp.nameDecl == null) {
                    translator.error('e', "access: not allowed for anonymous function");
                } else {
                    object4 = object3.toString();
                    if ("private".equals(object4)) {
                        n = 0x1000000;
                    } else if ("protected".equals(object4)) {
                        n = 0x2000000;
                    } else if ("public".equals(object4)) {
                        n = 0x4000000;
                    } else if ("package".equals(object4)) {
                        n = 0x8000000;
                    } else {
                        translator.error('e', "unknown access specifier");
                    }
                    if (referenceExpArray != null && object4 != null) {
                        translator.error('e', "duplicate access specifiers - " + (String)referenceExpArray + " and " + (String)object4);
                    }
                    referenceExpArray = object4;
                }
            } else if (object5 == object.allocationKeyword) {
                Expression expression = translator.rewrite_car(pair2, syntaxForm);
                if (!(expression instanceof QuoteExp) || !((object3 = ((QuoteExp)expression).getValue()) instanceof SimpleSymbol) && !(object3 instanceof CharSequence)) {
                    translator.error('e', "allocation: value not a constant symbol or string");
                } else if (lambdaExp.nameDecl == null) {
                    translator.error('e', "allocation: not allowed for anonymous function");
                } else {
                    object4 = object3.toString();
                    if ("class".equals(object4) || "static".equals(object4)) {
                        n2 = 2048;
                    } else if ("instance".equals(object4)) {
                        n2 = 4096;
                    } else {
                        translator.error('e', "unknown allocation specifier");
                    }
                    if (referenceExpArray2 != null && object4 != null) {
                        translator.error('e', "duplicate allocation specifiers - " + (String)referenceExpArray2 + " and " + (String)object4);
                    }
                    referenceExpArray2 = object4;
                }
            } else if (object5 == object.throwsKeyword) {
                object3 = pair2.getCar();
                int n3 = Translator.listLength(object3);
                if (n3 < 0) {
                    translator.error('e', "throws: not followed by a list");
                } else {
                    object4 = new ReferenceExp[n3];
                    SyntaxForm syntaxForm2 = syntaxForm;
                    for (int i = 0; i < n3; ++i) {
                        while (object3 instanceof SyntaxForm) {
                            syntaxForm2 = (SyntaxForm)object3;
                            object3 = syntaxForm2.form;
                        }
                        Pair pair3 = (Pair)object3;
                        Expression expression = translator.rewrite_car(pair3, syntaxForm2);
                        if (expression instanceof ReferenceExp) {
                            object4[i] = (ReferenceExp)expression;
                        } else {
                            Object object7 = translator.pushPositionOf(pair3);
                            translator.error('e', "throws not followed by a classname");
                            translator.popPositionOf(object7);
                        }
                        object3 = pair3.getCdr();
                    }
                    lambdaExp.setExceptions((ReferenceExp[])object4);
                }
            } else if (object5 == nameKeyword) {
                Expression expression = translator.rewrite_car(pair2, syntaxForm);
                if (expression instanceof QuoteExp) {
                    lambdaExp.setName(((QuoteExp)expression).getValue().toString());
                }
            } else {
                translator.error('w', "unknown procedure property " + object5);
            }
            object2 = pair2.getCdr();
        }
        if ((n |= n2) != 0) {
            lambdaExp.nameDecl.setFlag(n);
        }
        if (syntaxForm != null) {
            object2 = syntaxForm.fromDatumIfNeeded(object2);
        }
        return object2;
    }

    public Object skipAttrs(LambdaExp lambdaExp, Object object2, Translator translator) {
        Pair pair;
        while (object2 instanceof Pair && (pair = (Pair)object2).getCdr() instanceof Pair) {
            Object object3 = pair.getCar();
            if (translator.matches(object3, "::")) {
                object3 = null;
            } else if (!(object3 instanceof Keyword)) break;
            object2 = ((Pair)pair.getCdr()).getCdr();
        }
        return object2;
    }

    public void rewriteBody(LambdaExp lambdaExp, Object object2, Translator translator) {
        Object object3;
        int n;
        Expression[] expressionArray;
        SourceLocator sourceLocator;
        int n2 = 0;
        if (translator.curMethodLambda == null && lambdaExp.nameDecl != null && translator.getModule().getFlag(65536)) {
            translator.curMethodLambda = lambdaExp;
        }
        translator.pushScope(lambdaExp);
        Declaration declaration = null;
        int n3 = lambdaExp.keywords == null ? 0 : lambdaExp.keywords.length;
        int n4 = lambdaExp.defaultArgs == null ? 0 : lambdaExp.defaultArgs.length - n3;
        int n5 = 0;
        int n6 = 0;
        for (sourceLocator = lambdaExp.firstDecl(); sourceLocator != null; sourceLocator = ((Declaration)sourceLocator).nextDecl()) {
            if (((Declaration)sourceLocator).isAlias()) {
                expressionArray = Translator.getOriginalRef((Declaration)sourceLocator).getBinding();
                lambdaExp.replaceFollowing(declaration, (Declaration)expressionArray);
                expressionArray.context = lambdaExp;
                translator.pushRenamedAlias((Declaration)sourceLocator);
                ++n2;
                sourceLocator = expressionArray;
            }
            declaration = sourceLocator;
            if (n5 >= lambdaExp.min_args && (n5 < lambdaExp.min_args + n4 || lambdaExp.max_args >= 0 || n5 != lambdaExp.min_args + n4)) {
                lambdaExp.defaultArgs[n6] = translator.rewrite(lambdaExp.defaultArgs[n6]);
                ++n6;
            }
            ++n5;
            translator.lexical.push((Declaration)sourceLocator);
        }
        if (lambdaExp.isClassMethod() && !lambdaExp.nameDecl.getFlag(2048)) {
            lambdaExp.add(null, new Declaration(ThisExp.THIS_NAME));
        }
        sourceLocator = translator.curLambda;
        translator.curLambda = lambdaExp;
        lambdaExp.body = translator.rewrite_body(object2);
        translator.curLambda = sourceLocator;
        if (lambdaExp.body instanceof BeginExp && (n = (expressionArray = ((BeginExp)lambdaExp.body).getExpressions()).length) > 1 && (expressionArray[0] instanceof ReferenceExp || (object3 = expressionArray[0].valueIfConstant()) instanceof Type || object3 instanceof Class)) {
            Expression expression = expressionArray[0];
            if (--n == 1) {
                lambdaExp.body = expressionArray[1];
            } else {
                Expression[] expressionArray2 = new Expression[n];
                System.arraycopy(expressionArray, 1, expressionArray2, 0, n);
                lambdaExp.body = BeginExp.canonicalize(expressionArray2);
            }
            Convert.setCoercedReturnValue(lambdaExp, expression, translator.getLanguage());
        } else {
            lambdaExp.setCoercedReturnType(lambdaExp.returnType);
        }
        translator.pop(lambdaExp);
        lambdaExp.countDecls();
        translator.popRenamedAlias(n2);
        lambdaExp.countDecls();
        if (translator.curMethodLambda == lambdaExp) {
            translator.curMethodLambda = null;
        }
    }

    public void print(Consumer consumer) {
        consumer.write("#<builtin lambda>");
    }
}

