#!/bin/sh
#TeTeX install script
echo "Have you read the README? (y or n)"
read response
if [ $response == "y" ]; then
	echo "Excellent! You may proceed"
else
	echo "Tsk Tsk!"
	exit 0
fi
echo "Checking for bzip2 installation..."
if [ -f /boot/home/config/bin/bzip2 ]; then
	echo "bzip2 installed..OK"
else
	echo "bzip2 is not installed. You can get it from http://www.bebits.com/app/3218"
	exit 0
fi
echo "Checking for previous installation of TeTeX"
if [ -d /boot/home/config/teTeX ]; then
	echo "Moving previous TeTeX Installation to Trash"
	echo "You can empty the trash after this script finishes"
	mv /boot/home/config/teTeX /boot/home/Desktop/Trash
fi
echo "Checking for tetex-texmf-2.0.2.tar.gz...."
if [ -f tetex-texmf-2.0.2.tar.gz ]; then
	echo "Extracting tetex-texmf-2.0.2.tar.gz...This will take a long time..Please be patient :-)"
	mkdir -p /boot/home/config/teTeX/share/texmf
	tar xzvf tetex-texmf-2.0.2.tar.gz -C /boot/home/config/teTeX/share/texmf/
else
	echo "You absolutely need tetex-texmf-2.0.2.tar.gz for tetex to work. It contains all the fonts and everything else. See the README for details on where to get it from!"
	exit 0
fi
if [ -f teTeX.tar.bz2 ]; then
	echo "Extracting TeTeX Binaries for BeOS...(teTeX.tar.bz2)"
	bzip2 -d teTeX.tar.bz2 && tar xvf teTeX.tar -C /boot/home/config/
	echo "Adding environment variables to ~/.profile"
	echo "export TETEXDIR=/boot/home/config/teTeX/bin/i586-pc-beos" >> ~/.profile
	echo "export PATH=\$PATH:\$TETEXDIR" >> ~/.profile
	echo "DONE"
else
	echo "tetex.tar.bz2 not found!"
	exit 0
fi