#! /usr/bin/env python

# installation program for TexConv.py Lyx to OpenOffice conversion suite

import  getopt  #for command-line param parsing
import  sys     #for above and general fns like exit()
import  os      #for operating system functions like getcwd()
import  stat    #for S_IEXEC
import  pickle
import  popen2
from popen2 import *
from Tkinter import *   #GUI support module
import Tix
from Tix import *       #must do this as well as above import (!!)

class globalVars:
  root=None
  GUIresult=''
  fsd=None
  ff=None
  homeDir=None
  delim=None
  cwd=None
  csd=None
  cv=None
  delm=['/','\\','/']

gv=globalVars()

def Close():
  gv.root.destroy()

def confirm(s):
  "confirm action"
  gv.root = Tix.Tk()
  gv.root.geometry(newGeometry='+300+20')
  gv.GUIresult=0
  class Application(Frame):

    def conf(self):
        gv.GUIresult=1
        Close()

    def createWidgets(self):
        self.txt = Label(self,fg='blue',text=s)
        self.txt['font']=('courier','12')
        self.txt.pack()

        self.NO = Button(self)
        self.NO["text"] = "NO"
        self.NO["fg"]   = "red"
        self.NO["command"] =  Close
        self.NO.pack({"side": "right"})

        self.OK = Button(self)
        self.OK["text"] = "YES",
        self.OK["fg"]   = "green"
        self.OK["command"] = self.conf

        self.OK.pack(side="left")
        self.ABORT = Button(self)
        self.ABORT["text"] = "ABORT CONFIGURATION"
        self.ABORT["fg"]   = "red"
        self.ABORT["command"] =  sys.exit
        self.ABORT.pack({"side": "bottom"})

    def __init__(self, master=gv.root,geometry='200x200+100+20'):
        Frame.__init__(self, master)
        self.createWidgets()
        self.pack()

  app = Application()
  app.master.title("ACCEPT RESULT")
  app.mainloop()
  return gv.GUIresult
  #confirm

def set_res(n):
  "for dirySEL return result"
  gv.GUIresult=gv.fsd.cget("value")

def dirySEL(title):
  "select a directory"
  gv.GUIresult=''
  gv.root = Tix.Tk()
  gv.fsd = DirList(gv.root,command=set_res,takefocus='1',)
  gv.root.geometry(newGeometry='300x500+300+20')
  gv.fsd.pack(fill='both',expand='1')
  gv.root.title(title)
  gv.fsd.mainloop()
  return gv.GUIresult
  #dirySEL

def textGUI(s):
  "display text in window"
  gv.root = Tix.Tk()
  gv.fsd = ScrolledText(gv.root)
  gv.root.geometry(newGeometry='650x200+200+20')
  gv.fsd.text["wrap"]='word'
  gv.fsd.text["font"]=('Courier','12')
  gv.fsd.text['fg']='blue'
  gv.fsd.pack(side='right')
  gv.fsd.text.insert("end",s)
  gv.fsd.mainloop()
  #textGUI

def rb_sel():
  gv.GUIresult=gv.cv.get()

def selDelim():
  "select file path delimiter"
  gv.root = Tix.Tk()
  gv.root.geometry(newGeometry='+300+20')
  gv.GUIresult=0
  class Application(Frame):

    def createWidgets(self):
        self.txt = Label(self,fg='red',text='Select Platform')
        self.txt['font']=('courier','12')
        self.txt.pack(side='top')

        rfont=('courier','12')
        gv.cv=IntVar()
        self.rb1=Radiobutton(self,text='Linux  ',variable=gv.cv,value=0,
                command=rb_sel,font=rfont,fg="blue").pack()
        self.rb2=Radiobutton(self,text='Windows',variable=gv.cv,value=1,
                command=rb_sel,font=rfont,fg="blue").pack()
        self.rb3=Radiobutton(self,text='Mac    ',variable=gv.cv,value=2,
                command=rb_sel,font=rfont,fg="blue").pack()

    def __init__(self, master=gv.root,geometry='200x200+100+20'):
        Frame.__init__(self, master)
        self.createWidgets()
        self.pack()

  app = Application()
  app.master.title("CONFIG")
  app.mainloop()
  return gv.delm[gv.GUIresult]
  #selDelim

def set_paths():
  "set default file paths"
  s='Welcome to the Tex-to-OpenOffice conversion suite.\n\n'
  s=s+'This program will set up your configuration files.\n'
  s=s+'A sequence of file dialogues will be presented for you to specify\n'
  s=s+'  the default directories for the program.\n'
  s=s+'In each case select and double-click on the required path and then\n'
  s=s+'  close the widget.\n'
  s=s+'The path to be set will be shown as the window name.\n'
  s=s+'If an operation fails its dialogue will be re-presented.\n'
  textGUI(s)
  s=['Path for temporary files','Your default tex source path',
        'Your default graphics path']
  i=0
  CTP=''
  CTC=''
  for t in s:
    z=''
    while z == '':
      z=dirySEL(t)
      if z:
        if not confirm(t+'\n'+z):
          z=''
      else:
        if not confirm('Try Again?'): sys.exit()
    if i == 0:
      CTP=z+'\n'
      CTP=CTP+z+gv.delim+'TexError\n'
      CTP=CTP+z+gv.delim+'officeXML'+gv.delim+'\n'
      CTP=CTP+z+gv.delim+'pythonTmp\n'
      CTP=CTP+gv.csd+gv.delim+'Dictionaries'+gv.delim+'\n'+gv.delim+'\n/\n/\n'
      CTC=gv.homeDir+'\n'
    else:
      CTC=CTC+z+gv.delim+'\n'
    i=i+1

  gv.ff=open('ConvTexPaths','wt')
  gv.ff.write(CTP)
  gv.ff.close()
  gv.ff=open('ConvTexConfig','wt')
  gv.ff.write(CTC)
  gv.ff.write('VQH+/0tQcmludGVyAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAU0dFTlBSVAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAWAAMAmwAAAAAA//8BAAhSAAAEdAAASm9iRGF0YSAxCnByaW50ZXI9S1ByaW50ZXIKb3JpZW50YXRpb249UG9ydHJhaXQKY29waWVzPTEKc2NhbGU9MAptYXJnaW5kYWp1c3RtZW50PTAsMCwwLDAKY29sb3JkZXB0aD0yNApwc2xldmVsPTAKY29sb3JkZXZpY2U9MApQUERDb250ZXhEYXRhClBhZ2VTaXplOkE0AAA=\n')
  gv.ff.close()
  #set_paths

gv.cwd=os.getcwd()
if gv.cwd[0] == '/':
  gv.delim='/'                                  #path delimiter: / for Linux
else:
  if gv.cwd.find('\\'):
    gv.delim='\\'
  else:
   gv.delim=selDelim()
i=gv.cwd[:-1].rfind(gv.delim)
i=gv.cwd[:i-1].rfind(gv.delim)
gv.csd=gv.cwd[i+1:]                             # sub-folder in home folder
gv.homeDir=gv.cwd[:i+1]                         # home folder
set_paths()                                     # interactive path set-up
s='Configuration finished.\n\n'
if gv.delim == '/':
  fn='ConvTex'                                  # is Linux
  z='#!/bin/sh\n\ncd '+gv.cwd+'\n./TexConv.py\n'
  gv.ff=open(fn,'wt')                             # create script file
  gv.ff.write(z)
  gv.ff.close()
  os.chmod(fn,stat.S_IRWXU)                       # make it executable
  s=s+'The script \''+fn+'\' has been created to execute TexConv.py.\n'
  s=s+'It may be relocated or a link to it may be placed on the desktop.\n\n'
s=s+'The configuration files \'ConvTexConfig\' and \'ConvTexPaths\' have'
s=s+' been created which contain defaults for your platform;\n'
s=s+'  you may edit them cautiously if necessary.'
textGUI(s)
