#--------------------------------
# Metafile to EPS Converter
# Version 1.5 - November 2008

Name "Metafile to EPS Converter 1.5"
OutFile "metafile2eps.exe"
InstallDir "$PROGRAMFILES\Metafile to EPS Converter"
InstallDirRegKey HKLM "Software\Metafile to EPS Converter" ""

!define MULTIUSER_EXECUTIONLEVEL Admin
!include MUI2.nsh
!include MultiUser.nsh
!include LogicLib.nsh
!include WinVer.nsh

!define MUI_ICON "..\Icons\metafile2eps.ico"
!define MUI_UNICON "..\Icons\metafile2eps.ico"

!define MUI_WELCOMEFINISHPAGE_BITMAP "..\Icons\metafile2eps.bmp"
!define MUI_UNWELCOMEFINISHPAGE_BITMAP "..\Icons\metafile2eps.bmp"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!define MUI_FINISHPAGE_RUN "$INSTDIR\metafile2eps.exe"
!define MUI_FINISHPAGE_SHOWREADME
!define MUI_FINISHPAGE_SHOWREADME_NOTCHECKED
!define MUI_FINISHPAGE_SHOWREADME_FUNCTION CreateDesktopShortcut
!define MUI_FINISHPAGE_SHOWREADME_TEXT "Create desktop shortcut"
!define MUI_PAGE_CUSTOMFUNCTION_SHOW CheckDesktopShortcut
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_WELCOME  
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

!insertmacro MUI_LANGUAGE English

Var PrinterConf

!define SHORTCUT '"$INSTDIR\metafile2eps.exe" "" "$INSTDIR\metafile2eps.exe" "" "" "" "Converts Windows metafiles (EMF/WMF) to encapsulated PostScript images (EPS)"'
!define REGKEY_UNINSTALL "Software\Microsoft\Windows\CurrentVersion\Uninstall\Metafile to EPS Converter"

!macro OS_INIT

  ${If} ${AtLeastWinVista}
    StrCpy $PrinterConf "printui.exe"
  ${Else}
    StrCpy $PrinterConf "rundll32.exe printui.dll,PrintUIEntry"
  ${EndIf}

!macroend

Function .onInit

  ${IfNot} ${IsNT}
  ${OrIfNot} ${AtLeastWin2000}
    MessageBox MB_OK|MB_ICONSTOP "The Metafile to EPS Converter requires Windows 2000 or later."
    Quit
  ${EndIf} 

  !insertmacro MULTIUSER_INIT
  !insertmacro OS_INIT
FunctionEnd

Function un.onInit
  !insertmacro MULTIUSER_UNINIT
  !insertmacro OS_INIT  
FunctionEnd

Function CheckDesktopShortcut
  ${If} ${FileExists} "$DESKTOP\Metafile to EPS Converter.lnk"
    SendMessage $mui.FinishPage.ShowReadme ${BM_SETCHECK} ${BST_CHECKED} 0
  ${endif}
FunctionEnd

Function CreateDesktopShortcut
  SetOutPath $INSTDIR
  CreateShortCut "$DESKTOP\Metafile to EPS Converter.lnk" ${SHORTCUT}
FunctionEnd

Section
  SetOutPath $INSTDIR
  RMDir /r $INSTDIR\PSPrinter

  File "..\metafile2eps.exe"
  File "..\metafile2eps.dat"  
  
  WriteUninstaller $INSTDIR\Uninstall.exe
  
  SetOutPath $INSTDIR
  CreateShortCut "$SMPROGRAMS\Metafile to EPS Converter.lnk" ${SHORTCUT}

  # Delete printer
  ExecWait '$PrinterConf /q /dl /n "Metafile to EPS Converter"'
  # Install printer and driver
  ExecWait '$PrinterConf /if /f "$WINDIR\inf\ntprint.inf" /b "Metafile to EPS Converter" /r "FILE:" /m "MS Publisher Imagesetter"'
  # Restore DEVMODE with proper settings
  ExecWait '$PrinterConf /q /Sr /n "Metafile to EPS Converter" /a "$INSTDIR\metafile2eps.dat" g'

  WriteRegStr HKLM "Software\InkNote Selector" "" $INSTDIR
  
  WriteRegStr HKLM "${REGKEY_UNINSTALL}" "UninstallString" "$\"$INSTDIR\Uninstall.exe$\""
  WriteRegStr HKLM "${REGKEY_UNINSTALL}" "InstallLocation" "$\"$INSTDIR$\""
  WriteRegStr HKLM "${REGKEY_UNINSTALL}" "DisplayName" "Metafile to EPS Converter"  
  WriteRegStr HKLM "${REGKEY_UNINSTALL}" "DisplayIcon" "$\"$INSTDIR\metafile2eps.exe$\",0"
  WriteRegStr HKLM "${REGKEY_UNINSTALL}" "Publisher" "Joost Verburg"
SectionEnd

Section Uninstall
  # Delete printer
  ExecWait '$PrinterConf /q /dl /n "Metafile to EPS Converter"'
  
  Delete "$INSTDIR\mteafile2eps.exe"
  Delete "$INSTDIR\metafile2eps.dat"
  Delete "$INSTDIR\Uninstall.exe"
  RMDir "$INSTDIR"
  
  Delete "$SMPROGRAMS\Metafile to EPS Converter.lnk"
  Delete "$DESKTOP\Metafile to EPS Converter.lnk"
  DeleteRegKey HKLM "Software\Metafile to EPS Converter"
  DeleteRegKey HKLM "${REGKEY_UNINSTALL}"
SectionEnd
