/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.queryparser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.CompassMultiFieldQueryParser;
import org.apache.lucene.queryParser.CompassQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassMappingAware;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.SearchEngineFactoryAware;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.engine.SearchEngineQueryParseException;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParser;
import org.compass.core.lucene.engine.queryparser.QueryHolder;
import org.compass.core.mapping.CompassMapping;

public class DefaultLuceneQueryParser
implements LuceneQueryParser,
CompassMappingAware,
SearchEngineFactoryAware,
CompassConfigurable {
    private static Log log = LogFactory.getLog(DefaultLuceneQueryParser.class);
    private CompassMapping mapping;
    private SearchEngineFactory searchEngineFactory;
    private boolean allowLeadingWildcard;
    private boolean allowConstantScorePrefixQuery;
    private float fuzzyMinSimilarity;
    private int fuzzyPrefixLength;
    private QueryParser.Operator defaultOperator;

    public void configure(CompassSettings settings) throws CompassException {
        this.allowLeadingWildcard = settings.getSettingAsBoolean("allowLeadingWildcard", true);
        this.allowConstantScorePrefixQuery = settings.getSettingAsBoolean("allowConstantScorePrefixQuery", true);
        this.fuzzyMinSimilarity = settings.getSettingAsFloat("fuzzyMinSimilarity", 0.5f);
        this.fuzzyPrefixLength = settings.getSettingAsInt("fuzzyPrefixLength", 0);
        String sDefaultOperator = settings.getSetting("defaultOperator", "AND");
        if ("and".equalsIgnoreCase(sDefaultOperator)) {
            this.defaultOperator = QueryParser.Operator.AND;
        } else if ("or".equalsIgnoreCase(sDefaultOperator)) {
            this.defaultOperator = QueryParser.Operator.OR;
        } else {
            throw new ConfigurationException("Defualt query string operator [" + sDefaultOperator + "] not recognized.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Query Parser configured with allowLeadingWildcard [" + this.allowLeadingWildcard + "] and allowConstantScorePrefixQuery [" + this.allowConstantScorePrefixQuery + "]"));
        }
    }

    public void setCompassMapping(CompassMapping mapping) {
        this.mapping = mapping;
    }

    public void setSearchEngineFactory(SearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }

    public QueryHolder parse(String property, QueryParser.Operator operator, Analyzer analyzer, boolean forceAnalyzer, String queryString) throws SearchEngineQueryParseException {
        CompassQueryParser queryParser = this.createQueryParser(property, analyzer, forceAnalyzer);
        queryParser.setDefaultOperator(this.getOperator(operator));
        queryParser.setAllowLeadingWildcard(this.allowLeadingWildcard);
        queryParser.setAllowConstantScorePrefixQuery(this.allowConstantScorePrefixQuery);
        queryParser.setFuzzyMinSim(this.fuzzyMinSimilarity);
        queryParser.setFuzzyPrefixLength(this.fuzzyPrefixLength);
        try {
            Query query = queryParser.parse(queryString);
            QueryHolder queryHolder = new QueryHolder(query, queryParser.isSuggestedQuery());
            return queryHolder;
        }
        catch (ParseException e) {
            throw new SearchEngineQueryParseException(queryString, e);
        }
        catch (IllegalArgumentException e) {
            throw new SearchEngineQueryParseException(queryString, e);
        }
        finally {
            queryParser.close();
        }
    }

    public QueryHolder parse(String[] properties, QueryParser.Operator operator, Analyzer analyzer, boolean forceAnalyzer, String queryString) throws SearchEngineQueryParseException {
        CompassMultiFieldQueryParser queryParser = this.createMultiQueryParser(properties, analyzer, forceAnalyzer);
        queryParser.setDefaultOperator(this.getOperator(operator));
        queryParser.setAllowLeadingWildcard(this.allowLeadingWildcard);
        queryParser.setAllowConstantScorePrefixQuery(this.allowConstantScorePrefixQuery);
        queryParser.setFuzzyMinSim(this.fuzzyMinSimilarity);
        queryParser.setFuzzyPrefixLength(this.fuzzyPrefixLength);
        try {
            Query query = queryParser.parse(queryString);
            QueryHolder queryHolder = new QueryHolder(query, queryParser.isSuggestedQuery());
            return queryHolder;
        }
        catch (ParseException e) {
            throw new SearchEngineQueryParseException(queryString, e);
        }
        catch (IllegalArgumentException e) {
            throw new SearchEngineQueryParseException(queryString, e);
        }
        finally {
            queryParser.close();
        }
    }

    private QueryParser.Operator getOperator(QueryParser.Operator operator) {
        if (operator == null) {
            return this.defaultOperator;
        }
        return operator;
    }

    protected CompassMapping getMapping() {
        return this.mapping;
    }

    protected SearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    protected CompassQueryParser createQueryParser(String property, Analyzer analyzer, boolean forceAnalyzer) {
        return new CompassQueryParser(property, analyzer, this.mapping, this.searchEngineFactory, forceAnalyzer);
    }

    protected CompassMultiFieldQueryParser createMultiQueryParser(String[] properties, Analyzer analyzer, boolean forceAnalyzer) {
        return new CompassMultiFieldQueryParser(properties, analyzer, this.mapping, this.searchEngineFactory, forceAnalyzer);
    }
}

