/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.util;

import de.fzj.unicore.uas.util.AnnotationsStateMachine;
import de.fzj.unicore.uas.util.State;
import eu.unicore.util.Log;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class StateMover<T>
implements Callable<State<T>> {
    protected final Logger log = Log.getLogger("unicore", StateMover.class);
    protected final State<T> initalState;
    protected final T target;
    protected State<T> currentState;
    protected boolean stop = false;
    protected boolean asyncMode = false;

    public StateMover(State<T> initalState, T target, boolean asyncMode) {
        this.initalState = initalState;
        this.target = target;
        this.currentState = initalState;
        this.asyncMode = asyncMode;
    }

    public StateMover(State<T> initalState, T target) {
        this(initalState, target, false);
    }

    public StateMover(T target, boolean asyncMode) {
        this(new AnnotationsStateMachine<T>(null, target).getInitialState(), target, asyncMode);
    }

    public StateMover(T target) {
        this(target, false);
    }

    @Override
    public State<T> call() throws Exception {
        do {
            boolean pausable;
            block12: {
                pausable = this.currentState.isPausable();
                int retryCount = this.currentState.getNumberOfRetries();
                int retryDelay = this.currentState.getRetryDelay();
                int attempts = 0;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Processing state " + this.currentState.getName() + " on " + this.target.getClass().getName());
                    }
                    boolean retry = true;
                    while (retry) {
                        retry = attempts < retryCount;
                        ++attempts;
                        try {
                            this.currentState = this.currentState.next(this.target);
                            retry = false;
                        }
                        catch (Exception ex) {
                            if (!retry) {
                                throw ex;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Error: " + Log.getDetailMessage(ex) + " in state " + this.currentState.getName() + " on " + this.target.getClass().getName() + ", will retry in " + retryDelay + " ms.");
                            }
                            Thread.sleep(retryDelay);
                        }
                    }
                    if (this.log.isDebugEnabled() && this.currentState != null) {
                        this.log.debug("Entering state " + this.currentState.getName() + " on " + this.target.getClass().getName());
                    }
                }
                catch (Exception ex) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Handling error in state " + this.currentState.getName() + " on " + this.target.getClass().getName());
                    }
                    this.currentState = this.currentState.onError(this.target, ex);
                    if (!this.log.isDebugEnabled() || this.currentState == null) break block12;
                    this.log.debug("Entering state " + this.currentState.getName() + " on " + this.target.getClass().getName());
                }
            }
            if (this.asyncMode) {
                this.stop = pausable;
                continue;
            }
            boolean bl = this.stop = this.currentState == null;
        } while (!this.stop);
        return this.currentState;
    }

    public State<T> getCurrentState() {
        return this.currentState;
    }

    public boolean isAsyncMode() {
        return this.asyncMode;
    }

    public void setAsyncMode(boolean asyncMode) {
        this.asyncMode = asyncMode;
    }
}

