/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.CollectionResponse;
import com.hazelcast.collection.operations.RemoveAllOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PortableCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class RemoveAllRequest
extends CollectionKeyBasedRequest
implements InitializingObjectRequest {
    int threadId = -1;

    public RemoveAllRequest() {
    }

    public RemoveAllRequest(CollectionProxyId proxyId, Data key, int threadId) {
        super(proxyId, key);
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new RemoveAllOperation(this.proxyId, this.key, this.threadId);
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("t", this.threadId);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.threadId = reader.readInt("t");
        super.readPortable(reader);
    }

    @Override
    protected Object filter(Object response) {
        if (response instanceof CollectionResponse) {
            Collection coll = ((CollectionResponse)response).getCollection();
            if (coll == null) {
                return new PortableCollection();
            }
            ArrayList<Data> collection = new ArrayList<Data>(coll.size());
            for (CollectionRecord record : coll) {
                collection.add(this.getClientEngine().toData(record.getObject()));
            }
            return new PortableCollection(collection);
        }
        return super.filter(response);
    }
}

