/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.keycloak.admin.client.token.TokenManager;

public class BearerAuthFilter
implements ClientRequestFilter,
ClientResponseFilter {
    public static final String AUTH_HEADER_PREFIX = "Bearer ";
    private final String tokenString;
    private final TokenManager tokenManager;

    public BearerAuthFilter(String tokenString) {
        this.tokenString = tokenString;
        this.tokenManager = null;
    }

    public BearerAuthFilter(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
        this.tokenString = null;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        String authHeader;
        String string = authHeader = this.tokenManager != null ? this.tokenManager.getAccessTokenString() : this.tokenString;
        if (!authHeader.startsWith(AUTH_HEADER_PREFIX)) {
            authHeader = AUTH_HEADER_PREFIX + authHeader;
        }
        requestContext.getHeaders().add((Object)"Authorization", (Object)authHeader);
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (responseContext.getStatus() == 401 && this.tokenManager != null) {
            List authHeaders = (List)requestContext.getHeaders().get((Object)"Authorization");
            if (authHeaders == null) {
                return;
            }
            for (Object authHeader : authHeaders) {
                String headerValue;
                if (!(authHeader instanceof String) || !(headerValue = (String)authHeader).startsWith(AUTH_HEADER_PREFIX)) continue;
                String token = headerValue.substring(AUTH_HEADER_PREFIX.length());
                this.tokenManager.invalidate(token);
            }
        }
    }
}

