/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.cluster.OutputParser;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSFOutputParser
implements OutputParser {
    private static final Logger logger = LoggerFactory.getLogger(LSFOutputParser.class);

    public String parseJobSubmission(String rawOutput) throws GFacException {
        logger.debug(rawOutput);
        if (rawOutput.indexOf("<") >= 0) {
            return rawOutput.substring(rawOutput.indexOf("<") + 1, rawOutput.indexOf(">"));
        }
        return null;
    }

    public boolean isJobSubmissionFailed(String rawOutput) {
        return false;
    }

    public JobStatus parseJobStatus(String jobID, String rawOutput) throws GFacException {
        boolean jobFount = false;
        logger.debug(rawOutput);
        return null;
    }

    public void parseJobStatuses(String userName, Map<String, JobStatus> statusMap, String rawOutput) throws GFacException {
        logger.debug(rawOutput);
        String[] info = rawOutput.split("\n");
        for (String jobID : statusMap.keySet()) {
            String jobName = jobID.split(",")[1];
            boolean found = false;
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].contains(jobName.substring(0, 8))) continue;
                logger.info(info[i]);
                String correctLine = info[i];
                String[] columns = correctLine.split(" ");
                ArrayList<String> columnList = new ArrayList<String>();
                for (String s : columns) {
                    if ("".equals(s)) continue;
                    columnList.add(s);
                }
                try {
                    statusMap.put(jobID, new JobStatus(JobState.valueOf((String)((String)columnList.get(2)))));
                }
                catch (IndexOutOfBoundsException e) {
                    statusMap.put(jobID, new JobStatus(JobState.valueOf((String)"U")));
                }
                found = true;
                break;
            }
            if (found) continue;
            logger.error("Couldn't find the status of the Job with JobName: " + jobName + "Job Id: " + jobID.split(",")[0]);
        }
    }

    public String parseJobId(String jobName, String rawOutput) throws GFacException {
        String regJobId = "jobId";
        Pattern pattern = Pattern.compile("(?=(?<" + regJobId + ">\\d+)\\s+\\w+\\s+" + jobName + ")");
        if (rawOutput != null) {
            Matcher matcher = pattern.matcher(rawOutput);
            if (matcher.find()) {
                return matcher.group(regJobId);
            }
            logger.error("No match is found for JobName");
            return null;
        }
        logger.error("Error: RawOutput shouldn't be null");
        return null;
    }

    public static void main(String[] args) {
        String test = "Job <2477982> is submitted to queue <short>.";
        System.out.println(test.substring(test.indexOf("<") + 1, test.indexOf(">")));
        String test1 = "JOBID   USER    STAT  QUEUE      FROM_HOST   EXEC_HOST   JOB_NAME   SUBMIT_TIME\n2636607 lg11w   RUN   long       ghpcc06     c11b02      *069656647 Mar  7 00:58\n2636582 lg11w   RUN   long       ghpcc06     c02b01      2134490944 Mar  7 00:48";
        HashMap<String, JobStatus> statusMap = new HashMap<String, JobStatus>();
        statusMap.put("2477983,2134490944", new JobStatus(JobState.UNKNOWN));
        LSFOutputParser lsfOutputParser = new LSFOutputParser();
        try {
            lsfOutputParser.parseJobStatuses("cjh", statusMap, test1);
        }
        catch (GFacException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        System.out.println(statusMap.get("2477983,2134490944"));
    }
}

