/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dataaccess;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.dataaccess.ClusterLock;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.utils.DBUtils;

public class JDBCClusterLock
implements ClusterLock {
    private static final Log log = LogFactory.getLog(JDBCClusterLock.class);
    private static final Object lockObject = new Object();
    private static final int lockWaitTime = 5000;
    private static final String defaultClusterLockTableStatement = "CREATE TABLE REG_CLUSTER_LOCK (REG_LOCK_NAME VARCHAR (20),REG_LOCK_STATUS VARCHAR (20),PRIMARY KEY (REG_LOCK_NAME))";
    private static final String initRow = "INSERT INTO REG_CLUSTER_LOCK (REG_LOCK_NAME, REG_LOCK_STATUS) VALUES ('INITIALIZE', 'UNLOCKED')";
    private static final String LOCK_ROW_CHECK = "SELECT COUNT(REG_LOCK_NAME) FROM REG_CLUSTER_LOCK WHERE REG_LOCK_NAME='INITIALIZE'";
    private static ThreadLocal<DataSource> dataSource = new ThreadLocal<DataSource>(){

        @Override
        protected DataSource initialValue() {
            return null;
        }
    };

    private static DataSource getDataSource() {
        return dataSource.get();
    }

    private static void setDataSource(DataSource input) {
        dataSource.set(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DataAccessManager dataAccessManager, String clusterLockTableStatement) throws RegistryException {
        Object object = lockObject;
        synchronized (object) {
            block58: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Initializing cluster wide database locks");
                }
                if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
                    String msg = "Failed to get logs. Invalid data access manager.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                JDBCClusterLock.setDataSource(((JDBCDataAccessManager)dataAccessManager).getDataSource());
                String clusterLockTable = clusterLockTableStatement != null ? clusterLockTableStatement : defaultClusterLockTableStatement;
                Connection conn = null;
                try {
                    conn = JDBCClusterLock.getDataSource().getConnection();
                    DatabaseMetaData metaData = conn.getMetaData();
                    ResultSet result = metaData.getTables(null, null, DBUtils.getConvertedAutoGeneratedColumnName((String)metaData.getDatabaseProductName(), (String)"REG_CLUSTER_LOCK"), null);
                    boolean lockTableCreated = false;
                    try {
                        if (result.next()) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"Cluster lock table is already created in the Registry database.");
                            }
                            lockTableCreated = true;
                        }
                    }
                    finally {
                        if (result != null) {
                            result.close();
                        }
                    }
                    if (!lockTableCreated) {
                        PreparedStatement ps1 = conn.prepareStatement(clusterLockTable);
                        try {
                            ps1.executeUpdate();
                        }
                        finally {
                            if (ps1 != null) {
                                ps1.close();
                            }
                        }
                    }
                    int rowCount = 0;
                    PreparedStatement psRowCheck = conn.prepareStatement(LOCK_ROW_CHECK);
                    try {
                        ResultSet rowCheckResults = psRowCheck.executeQuery();
                        try {
                            if (rowCheckResults.next()) {
                                rowCount = rowCheckResults.getInt(1);
                            }
                        }
                        finally {
                            if (rowCheckResults != null) {
                                rowCheckResults.close();
                            }
                        }
                    }
                    finally {
                        if (psRowCheck != null) {
                            psRowCheck.close();
                        }
                    }
                    conn.setAutoCommit(false);
                    if (rowCount == 0) {
                        PreparedStatement ps2 = conn.prepareStatement(initRow);
                        try {
                            ps2.executeUpdate();
                        }
                        finally {
                            if (ps2 != null) {
                                ps2.close();
                            }
                        }
                    }
                    conn.commit();
                }
                catch (SQLException e) {
                    String msg = "Attempt create the cluster lock table is unsuccessful. Examining the reasons to failure. (Ignore the below error log if this Registry instance is running in a cluster).";
                    log.error((Object)msg, (Throwable)e);
                    boolean clusterLockTableCreated = false;
                    if (conn != null) {
                        try {
                            DatabaseMetaData metaData = conn.getMetaData();
                            ResultSet result = metaData.getTables(null, null, DBUtils.getConvertedAutoGeneratedColumnName((String)metaData.getDatabaseProductName(), (String)"REG_CLUSTER_LOCK"), null);
                            try {
                                if (result.next()) {
                                    clusterLockTableCreated = true;
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)"Cluster lock table is created by another node in the cluster. Cluster lock table creation is successful.");
                                    }
                                }
                            }
                            finally {
                                if (result != null) {
                                    result.close();
                                }
                            }
                        }
                        catch (SQLException e1) {
                            String msg1 = "Failed to check the existence of the cluster lock table. Caused by: " + e1.getMessage();
                            log.error((Object)msg1, (Throwable)e1);
                        }
                        if (clusterLockTableCreated) break block58;
                        String msg1 = "Failed to create the cluster lock table. Cluster lock table is not created by any other node. Caused by: " + e.getMessage();
                        log.fatal((Object)msg1, (Throwable)e);
                        try {
                            conn.rollback();
                        }
                        catch (SQLException e1) {
                            String msg2 = "Failed to rollback the database operation after failing the cluster lock table creation. Caused by: " + e1.getMessage();
                            log.error((Object)msg2, (Throwable)e1);
                        }
                        throw new RegistryException(msg1, e);
                    }
                    String msg1 = "Failed to obtain database connection to create the cluster lock table. Caused by: " + e.getMessage();
                    log.error((Object)msg1, (Throwable)e);
                    throw new RegistryException(msg1, e);
                }
                finally {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("Failed to close the database connection. Caused by: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cluster wide database locks initialized successfully.");
            }
        }
    }

    @Override
    public void lock(String lockName) throws RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to obtain cluster wide database lock " + lockName + "."));
        }
        boolean lockObtained = JDBCClusterLock.obtainLock(lockName);
        while (!lockObtained) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Shared database lock is obtained by some other node. Waiting for lock to be released.");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                String msg = "Failed to suspend the thread till shared database lock is obtained. Caused by: " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
            }
            lockObtained = JDBCClusterLock.obtainLock(lockName);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cluster wide database lock " + lockName + " obtained successfully."));
        }
    }

    @Override
    public void unlock(String lockName) throws RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to release cluster wide database lock " + lockName + "."));
        }
        Connection conn = null;
        try {
            conn = JDBCClusterLock.getDataSource().getConnection();
            String lockRow = "UPDATE REG_CLUSTER_LOCK SET REG_LOCK_STATUS='UNLOCKED' WHERE REG_LOCK_NAME=? AND REG_LOCK_STATUS='LOCKED'";
            PreparedStatement ps2 = conn.prepareStatement(lockRow);
            ps2.setString(1, lockName);
            ps2.executeUpdate();
            ps2.close();
        }
        catch (SQLException e) {
            String msg = "Error occurred while trying to release the shared database lock: " + lockName + ". Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cluster wide database lock " + lockName + " released successfully."));
        }
    }

    private static boolean obtainLock(String lockName) throws RegistryException {
        boolean lockObtained = false;
        Connection conn = null;
        try {
            conn = JDBCClusterLock.getDataSource().getConnection();
            String lockRow = "UPDATE REG_CLUSTER_LOCK SET REG_LOCK_STATUS='LOCKED' WHERE REG_LOCK_NAME=? AND REG_LOCK_STATUS='UNLOCKED'";
            PreparedStatement ps2 = conn.prepareStatement(lockRow);
            ps2.setString(1, lockName);
            int updatedRows = ps2.executeUpdate();
            ps2.close();
            if (updatedRows > 0) {
                lockObtained = true;
            }
            boolean bl = lockObtained;
            return bl;
        }
        catch (SQLException e) {
            String msg = "Error occurred while trying to obtain a shared database lock: " + lockName + ". Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

