/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit.junit3;

import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.ant.antunit.AntUnitExecutionNotifier;
import org.apache.ant.antunit.AntUnitScriptRunner;
import org.apache.ant.antunit.ProjectFactory;
import org.apache.ant.antunit.junit3.AntUnitTestCase;
import org.apache.ant.antunit.junit3.ErrorTestCase;
import org.apache.ant.antunit.junit3.JUnitNotificationAdapter;
import org.apache.ant.antunit.junit3.MultiProjectDemuxOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntUnitSuite
extends TestSuite {
    private final AntUnitScriptRunner antScriptRunner;
    private final MultiProjectDemuxOutputStream stderr;
    private final MultiProjectDemuxOutputStream stdout;
    private final ErrorTestCase initializationReportingTest;

    public AntUnitSuite(File scriptFile, Class rootClass) {
        this.setName(rootClass.getName());
        AntUnitScriptRunner createdScriptRunner = null;
        try {
            MyProjectFactory prjFactory = new MyProjectFactory(scriptFile);
            createdScriptRunner = new AntUnitScriptRunner(prjFactory);
        }
        catch (BuildException e) {
            this.antScriptRunner = null;
            this.stdout = null;
            this.stderr = null;
            this.initializationReportingTest = new ErrorTestCase(e);
            this.addTest((Test)this.initializationReportingTest);
            return;
        }
        this.antScriptRunner = createdScriptRunner;
        this.initializationReportingTest = null;
        this.stdout = new MultiProjectDemuxOutputStream(this.antScriptRunner, false);
        this.stderr = new MultiProjectDemuxOutputStream(this.antScriptRunner, true);
        List testTargets = this.antScriptRunner.getTestTartgets();
        Iterator it = testTargets.iterator();
        while (it.hasNext()) {
            String target = (String)it.next();
            AntUnitTestCase tc = new AntUnitTestCase(this, scriptFile, target);
            this.addTest((Test)tc);
        }
    }

    AntUnitSuite(AntUnitTestCase singleTc, File scriptFile) throws BuildException {
        MyProjectFactory prjFactory = new MyProjectFactory(scriptFile);
        this.antScriptRunner = new AntUnitScriptRunner(prjFactory);
        this.initializationReportingTest = null;
        this.stdout = new MultiProjectDemuxOutputStream(this.antScriptRunner, false);
        this.stderr = new MultiProjectDemuxOutputStream(this.antScriptRunner, true);
        this.setName(this.antScriptRunner.getName() + "[" + scriptFile + "]");
        this.addTest((Test)singleTc);
    }

    public void run(TestResult testResult) {
        if (this.initializationReportingTest != null) {
            this.initializationReportingTest.run(testResult);
        } else {
            List testTartgets = this.antScriptRunner.getTestTartgets();
            JUnitNotificationAdapter notifier = new JUnitNotificationAdapter(testResult, this.tests());
            this.runInContainer(testTartgets, notifier);
        }
    }

    public void runTest(Test test, TestResult result) {
        if (this.initializationReportingTest != null) {
            this.initializationReportingTest.run(result);
        } else {
            String targetName = ((AntUnitTestCase)test).getTarget();
            List<String> singleTargetList = Collections.singletonList(targetName);
            JUnitNotificationAdapter notifier = new JUnitNotificationAdapter(result, this.tests());
            this.runInContainer(singleTargetList, notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInContainer(List targetList, AntUnitExecutionNotifier notifier) {
        PrintStream savedErr = System.err;
        PrintStream savedOut = System.out;
        try {
            System.setOut(new PrintStream(this.stdout));
            System.setErr(new PrintStream(this.stderr));
            this.antScriptRunner.runSuite(targetList, notifier);
        }
        finally {
            System.setOut(savedOut);
            System.setErr(savedErr);
        }
    }

    public boolean hasAntInitError() {
        return this.initializationReportingTest != null;
    }

    public BuildException getAntInitialisationException() {
        return this.hasAntInitError() ? this.initializationReportingTest.getAntScriptError() : null;
    }

    private static class MyProjectFactory
    implements ProjectFactory {
        private final File scriptFile;
        private final PrintStream realStdErr = System.err;
        private final PrintStream realStdOut = System.out;

        public MyProjectFactory(File scriptFile) {
            this.scriptFile = scriptFile;
        }

        public Project createProject() {
            ProjectHelper prjHelper = ProjectHelper.getProjectHelper();
            Project prj = new Project();
            DefaultLogger logger = new DefaultLogger();
            logger.setMessageOutputLevel(2);
            logger.setErrorPrintStream(this.realStdErr);
            logger.setOutputPrintStream(this.realStdOut);
            prj.addBuildListener((BuildListener)logger);
            String absolutePath = this.scriptFile.getAbsolutePath();
            prj.setUserProperty("ant.file", absolutePath);
            prj.addReference("ant.projectHelper", (Object)prjHelper);
            prj.init();
            prjHelper.parse(prj, (Object)this.scriptFile);
            return prj;
        }
    }
}

