/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.aries.blueprint.plugin.FilteredClassFinder;
import org.apache.aries.blueprint.plugin.Generator;
import org.apache.aries.blueprint.plugin.model.Context;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;

public class GenerateMojo
extends AbstractMojo {
    protected MavenProject project;
    protected List<String> scanPaths;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String buildDir = this.project.getBuild().getDirectory();
            String generatedDir = buildDir + "/generated-resources";
            Resource resource = new Resource();
            resource.setDirectory(generatedDir);
            this.project.addResource(resource);
            ClassFinder finder = this.createProjectScopeFinder();
            File file = new File(generatedDir, "OSGI-INF/blueprint/autowire.xml");
            file.getParentFile().mkdirs();
            System.out.println("Generating blueprint to " + file);
            Set<Class<?>> classes = FilteredClassFinder.findClasses(finder, this.scanPaths);
            Context context = new Context(classes);
            context.resolve();
            new Generator(context, new FileOutputStream(file)).generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building commands help", e);
        }
    }

    private ClassFinder createProjectScopeFinder() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        for (Object artifactO : this.project.getArtifacts()) {
            Artifact artifact = (Artifact)artifactO;
            File file = artifact.getFile();
            if (file == null) continue;
            urls.add(file.toURI().toURL());
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        return new ClassFinder((ClassLoader)loader, urls);
    }
}

