/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputSinkOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.join.NestedLoopJoin;

public class NestedLoopJoinOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int JOIN_CACHE_ACTIVITY_ID = 0;
    private static final int NL_JOIN_ACTIVITY_ID = 1;
    private static final long serialVersionUID = 1L;
    private final ITuplePairComparatorFactory comparatorFactory;
    private final int memSize;
    private final IPredicateEvaluatorFactory predEvaluatorFactory;
    private final boolean isLeftOuter;
    private final IMissingWriterFactory[] nullWriterFactories1;

    public NestedLoopJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, ITuplePairComparatorFactory comparatorFactory, RecordDescriptor recordDescriptor, int memSize, boolean isLeftOuter, IMissingWriterFactory[] nullWriterFactories1) {
        this(spec, comparatorFactory, recordDescriptor, memSize, null, isLeftOuter, nullWriterFactories1);
    }

    public NestedLoopJoinOperatorDescriptor(IOperatorDescriptorRegistry spec, ITuplePairComparatorFactory comparatorFactory, RecordDescriptor recordDescriptor, int memSize, IPredicateEvaluatorFactory predEvalFactory, boolean isLeftOuter, IMissingWriterFactory[] nullWriterFactories1) {
        super(spec, 2, 1);
        this.comparatorFactory = comparatorFactory;
        this.outRecDescs[0] = recordDescriptor;
        this.memSize = memSize;
        this.predEvaluatorFactory = predEvalFactory;
        this.isLeftOuter = isLeftOuter;
        this.nullWriterFactories1 = nullWriterFactories1;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        ActivityId jcaId = new ActivityId(this.getOperatorId(), 0);
        ActivityId nljAid = new ActivityId(this.getOperatorId(), 1);
        JoinCacheActivityNode jc = new JoinCacheActivityNode(jcaId, nljAid);
        NestedLoopJoinActivityNode nlj = new NestedLoopJoinActivityNode(nljAid);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)jc);
        builder.addSourceEdge(1, (IActivity)jc, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)nlj);
        builder.addSourceEdge(0, (IActivity)nlj, 0);
        builder.addTargetEdge(0, (IActivity)nlj, 0);
        builder.addBlockingEdge((IActivity)jc, (IActivity)nlj);
    }

    private class NestedLoopJoinActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public NestedLoopJoinActivityNode(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
                private JoinCacheTaskState state;
                boolean failed = false;

                public void open() throws HyracksDataException {
                    this.writer.open();
                    this.state = (JoinCacheTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(NestedLoopJoinOperatorDescriptor.this.getOperatorId(), 0), partition));
                    this.state.joiner.setComparator(NestedLoopJoinOperatorDescriptor.this.comparatorFactory.createTuplePairComparator(ctx));
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    this.state.joiner.join(buffer, this.writer);
                }

                public void close() throws HyracksDataException {
                    if (this.failed) {
                        try {
                            this.state.joiner.closeCache();
                        }
                        finally {
                            this.writer.close();
                        }
                        return;
                    }
                    try {
                        try {
                            this.state.joiner.completeJoin(this.writer);
                        }
                        finally {
                            this.state.joiner.releaseMemory();
                        }
                    }
                    catch (Exception e) {
                        this.state.joiner.closeCache();
                        this.writer.fail();
                        throw e;
                    }
                    finally {
                        this.writer.close();
                    }
                }

                public void fail() throws HyracksDataException {
                    this.failed = true;
                    this.writer.fail();
                }
            };
        }
    }

    private class JoinCacheActivityNode
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;
        private final ActivityId nljAid;

        public JoinCacheActivityNode(ActivityId id, ActivityId nljAid) {
            super(id);
            this.nljAid = nljAid;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
            IMissingWriter[] nullWriters1;
            final IHyracksJobletContext jobletCtx = ctx.getJobletContext();
            final RecordDescriptor rd0 = recordDescProvider.getInputRecordDescriptor(this.nljAid, 0);
            final RecordDescriptor rd1 = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0);
            final IPredicateEvaluator predEvaluator = NestedLoopJoinOperatorDescriptor.this.predEvaluatorFactory != null ? NestedLoopJoinOperatorDescriptor.this.predEvaluatorFactory.createPredicateEvaluator() : null;
            IMissingWriter[] iMissingWriterArray = nullWriters1 = NestedLoopJoinOperatorDescriptor.this.isLeftOuter ? new IMissingWriter[NestedLoopJoinOperatorDescriptor.this.nullWriterFactories1.length] : null;
            if (NestedLoopJoinOperatorDescriptor.this.isLeftOuter) {
                for (int i = 0; i < NestedLoopJoinOperatorDescriptor.this.nullWriterFactories1.length; ++i) {
                    nullWriters1[i] = NestedLoopJoinOperatorDescriptor.this.nullWriterFactories1[i].createMissingWriter();
                }
            }
            return new AbstractUnaryInputSinkOperatorNodePushable(){
                private JoinCacheTaskState state;

                public void open() throws HyracksDataException {
                    this.state = new JoinCacheTaskState(jobletCtx.getJobId(), new TaskId(JoinCacheActivityNode.this.getActivityId(), partition));
                    this.state.joiner = new NestedLoopJoin(jobletCtx, new FrameTupleAccessor(rd0), new FrameTupleAccessor(rd1), NestedLoopJoinOperatorDescriptor.this.memSize, predEvaluator, NestedLoopJoinOperatorDescriptor.this.isLeftOuter, nullWriters1);
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    ByteBuffer copyBuffer = jobletCtx.allocateFrame(buffer.capacity());
                    FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)copyBuffer);
                    this.state.joiner.cache(copyBuffer);
                }

                public void close() throws HyracksDataException {
                    this.state.joiner.closeCache();
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void fail() throws HyracksDataException {
                }
            };
        }
    }

    public static class JoinCacheTaskState
    extends AbstractStateObject {
        private NestedLoopJoin joiner;

        private JoinCacheTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }
    }
}

