/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.misc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOpenableDataWriter;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.dataflow.std.base.IOpenableDataWriterOperator;
import org.apache.hyracks.dataflow.std.util.DeserializedOperatorNodePushable;

public class SplitVectorOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final int COLLECT_ACTIVITY_ID = 0;
    private static final int SPLIT_ACTIVITY_ID = 1;
    private static final long serialVersionUID = 1L;
    private final int splits;

    public SplitVectorOperatorDescriptor(IOperatorDescriptorRegistry spec, int splits, RecordDescriptor recordDescriptor) {
        super(spec, 1, 1);
        this.splits = splits;
        this.outRecDescs[0] = recordDescriptor;
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        CollectActivity ca = new CollectActivity(new ActivityId(this.odId, 0));
        SplitActivity sa = new SplitActivity(new ActivityId(this.odId, 1));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)ca);
        builder.addSourceEdge(0, (IActivity)ca, 0);
        builder.addActivity((IOperatorDescriptor)this, (IActivity)sa);
        builder.addTargetEdge(0, (IActivity)sa, 0);
        builder.addBlockingEdge((IActivity)ca, (IActivity)sa);
    }

    private class SplitActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public SplitActivity(ActivityId id) {
            super(id);
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            IOpenableDataWriterOperator op = new IOpenableDataWriterOperator(){
                private IOpenableDataWriter<Object[]> writer;
                private CollectTaskState state;

                @Override
                public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
                    if (index != 0) {
                        throw new IllegalArgumentException();
                    }
                    this.writer = writer;
                }

                public void open() throws HyracksDataException {
                    this.state = (CollectTaskState)ctx.getStateObject((Object)new TaskId(new ActivityId(SplitVectorOperatorDescriptor.this.getOperatorId(), 0), partition));
                }

                public void close() throws HyracksDataException {
                }

                public void writeData(Object[] data) throws HyracksDataException {
                    int n = this.state.buffer.size();
                    int step = (int)Math.floor((float)n / (float)SplitVectorOperatorDescriptor.this.splits);
                    this.writer.open();
                    for (int i = 0; i < SplitVectorOperatorDescriptor.this.splits; ++i) {
                        this.writer.writeData(this.state.buffer.get(step * (i + 1) - 1));
                    }
                    this.writer.close();
                }

                public void fail() throws HyracksDataException {
                    this.writer.fail();
                }

                public void flush() throws HyracksDataException {
                    this.writer.flush();
                }
            };
            return new DeserializedOperatorNodePushable(ctx, op, recordDescProvider.getOutputRecordDescriptor(this.getActivityId(), 0));
        }
    }

    private class CollectActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public CollectActivity(ActivityId id) {
            super(id);
        }

        @Override
        public ActivityId getActivityId() {
            return this.id;
        }

        public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) {
            IOpenableDataWriterOperator op = new IOpenableDataWriterOperator(){
                private CollectTaskState state;

                @Override
                public void setDataWriter(int index, IOpenableDataWriter<Object[]> writer) {
                    throw new IllegalArgumentException();
                }

                public void open() throws HyracksDataException {
                    this.state = new CollectTaskState(ctx.getJobletContext().getJobId(), new TaskId(CollectActivity.this.getActivityId(), partition));
                    this.state.buffer = new ArrayList();
                }

                public void close() throws HyracksDataException {
                    ctx.setStateObject((IStateObject)this.state);
                }

                public void writeData(Object[] data) throws HyracksDataException {
                    this.state.buffer.add(data);
                }

                public void fail() throws HyracksDataException {
                }

                public void flush() throws HyracksDataException {
                }
            };
            return new DeserializedOperatorNodePushable(ctx, op, recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0));
        }
    }

    public static class CollectTaskState
    extends AbstractStateObject {
        private ArrayList<Object[]> buffer;

        public CollectTaskState() {
        }

        private CollectTaskState(JobId jobId, TaskId taskId) {
            super(jobId, taskId);
        }

        @Override
        public void toBytes(DataOutput out) throws IOException {
        }

        @Override
        public void fromBytes(DataInput in) throws IOException {
        }
    }
}

