/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.IClusterManagementWorkResponse;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.hyracks.bootstrap.ClusterWorkExecutor;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.cluster.AddNodeWork;
import org.apache.asterix.metadata.cluster.AddNodeWorkResponse;
import org.apache.asterix.metadata.cluster.RemoveNodeWork;
import org.apache.asterix.metadata.cluster.RemoveNodeWorkResponse;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterLifecycleListener
implements IClusterLifecycleListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ICcApplicationContext appCtx;
    private final LinkedBlockingQueue<Set<IClusterManagementWork>> workRequestQueue = new LinkedBlockingQueue();
    private final ClusterWorkExecutor eventHandler;
    private final List<IClusterManagementWorkResponse> pendingWorkResponses = new ArrayList<IClusterManagementWorkResponse>();

    public ClusterLifecycleListener(ICcApplicationContext appCtx) {
        this.appCtx = appCtx;
        this.eventHandler = new ClusterWorkExecutor(this.workRequestQueue);
        Thread t = new Thread(this.eventHandler);
        LOGGER.info("Starting cluster event handler");
        t.start();
    }

    public void notifyNodeJoin(String nodeId, Map<IOption, Object> ncConfiguration) throws HyracksException {
        LOGGER.info("NC: {} joined", (Object)nodeId);
        IClusterStateManager csm = this.appCtx.getClusterStateManager();
        csm.notifyNodeJoin(nodeId, ncConfiguration);
        if (!csm.isMetadataNodeActive()) {
            MetadataManager.INSTANCE.rebindMetadataNode();
        }
        HashSet<String> nodeAddition = new HashSet<String>();
        nodeAddition.add(nodeId);
        this.updateProgress(IClusterLifecycleListener.ClusterEventType.NODE_JOIN, nodeAddition);
    }

    public void notifyNodeFailure(Collection<String> deadNodeIds) throws HyracksException {
        for (String deadNode : deadNodeIds) {
            LOGGER.info("NC: {} left", (Object)deadNode);
            IClusterStateManager csm = this.appCtx.getClusterStateManager();
            csm.notifyNodeFailure(deadNode);
            if (csm.isMetadataNodeActive()) continue;
            MetadataManager.INSTANCE.rebindMetadataNode();
        }
        this.updateProgress(IClusterLifecycleListener.ClusterEventType.NODE_FAILURE, deadNodeIds);
        HashSet<IClusterManagementWork> work = new HashSet<IClusterManagementWork>();
        if (!work.isEmpty()) {
            this.executeWorkSet(work);
        }
    }

    private void updateProgress(IClusterLifecycleListener.ClusterEventType eventType, Collection<String> nodeIds) {
        ArrayList<IClusterManagementWorkResponse> completedResponses = new ArrayList<IClusterManagementWorkResponse>();
        boolean isComplete = false;
        for (IClusterManagementWorkResponse resp : this.pendingWorkResponses) {
            switch (eventType) {
                case NODE_FAILURE: {
                    isComplete = ((RemoveNodeWorkResponse)resp).updateProgress(nodeIds);
                    if (!isComplete) break;
                    resp.setStatus(IClusterManagementWorkResponse.Status.SUCCESS);
                    resp.getWork().getSourceSubscriber().notifyRequestCompletion(resp);
                    completedResponses.add(resp);
                    break;
                }
                case NODE_JOIN: {
                    isComplete = ((AddNodeWorkResponse)resp).updateProgress(nodeIds.iterator().next());
                    if (!isComplete) break;
                    resp.setStatus(IClusterManagementWorkResponse.Status.SUCCESS);
                    resp.getWork().getSourceSubscriber().notifyRequestCompletion(resp);
                    completedResponses.add(resp);
                }
            }
        }
        this.pendingWorkResponses.removeAll(completedResponses);
    }

    private void executeWorkSet(Set<IClusterManagementWork> workSet) {
        int nodesToAdd = 0;
        HashSet nodesToRemove = new HashSet();
        HashSet<AddNodeWork> nodeAdditionRequests = new HashSet<AddNodeWork>();
        HashSet<IClusterManagementWork> nodeRemovalRequests = new HashSet<IClusterManagementWork>();
        for (IClusterManagementWork w : workSet) {
            switch (w.getClusterManagementWorkType()) {
                case ADD_NODE: {
                    if (nodesToAdd < ((AddNodeWork)w).getNumberOfNodesRequested()) {
                        nodesToAdd = ((AddNodeWork)w).getNumberOfNodesRequested();
                    }
                    nodeAdditionRequests.add((AddNodeWork)w);
                    break;
                }
                case REMOVE_NODE: {
                    nodesToRemove.addAll(((RemoveNodeWork)w).getNodesToBeRemoved());
                    nodeRemovalRequests.add(w);
                    RemoveNodeWorkResponse response = new RemoveNodeWorkResponse((RemoveNodeWork)w, IClusterManagementWorkResponse.Status.IN_PROGRESS);
                    this.pendingWorkResponses.add((IClusterManagementWorkResponse)response);
                }
            }
        }
        ArrayList addedNodes = new ArrayList();
        for (AddNodeWork w : nodeAdditionRequests) {
            AddNodeWorkResponse response;
            int n = w.getNumberOfNodesRequested();
            ArrayList nodesToBeAddedForWork = new ArrayList();
            for (int i = 0; i < n && i < addedNodes.size(); ++i) {
                nodesToBeAddedForWork.add(addedNodes.get(i));
            }
            if (nodesToBeAddedForWork.isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Unable to satisfy request by " + w);
                }
                response = new AddNodeWorkResponse(w, nodesToBeAddedForWork);
                response.setStatus(IClusterManagementWorkResponse.Status.FAILURE);
                w.getSourceSubscriber().notifyRequestCompletion((IClusterManagementWorkResponse)response);
                continue;
            }
            response = new AddNodeWorkResponse(w, nodesToBeAddedForWork);
            this.pendingWorkResponses.add((IClusterManagementWorkResponse)response);
        }
    }
}

