/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public class IndexWithBuddyBulkLoader
implements IChainedComponentBulkLoader {
    private final IIndexBulkLoader bulkLoader;
    private final IIndexBulkLoader buddyBTreeBulkLoader;

    public IndexWithBuddyBulkLoader(IIndexBulkLoader bulkLoader, IIndexBulkLoader buddyBTreeBulkLoader) {
        this.bulkLoader = bulkLoader;
        this.buddyBTreeBulkLoader = buddyBTreeBulkLoader;
    }

    @Override
    public ITupleReference delete(ITupleReference tuple) throws HyracksDataException {
        block2: {
            try {
                this.buddyBTreeBulkLoader.add(tuple);
            }
            catch (HyracksDataException e) {
                if (e.getErrorCode() == 33) break block2;
                this.cleanupArtifacts();
                throw e;
            }
        }
        return tuple;
    }

    @Override
    public void cleanupArtifacts() throws HyracksDataException {
    }

    @Override
    public ITupleReference add(ITupleReference tuple) throws HyracksDataException {
        this.bulkLoader.add(tuple);
        return tuple;
    }

    @Override
    public void end() throws HyracksDataException {
        this.bulkLoader.end();
        this.buddyBTreeBulkLoader.end();
    }

    @Override
    public void abort() throws HyracksDataException {
        this.bulkLoader.abort();
        this.buddyBTreeBulkLoader.abort();
    }

    public void writeFailed(ICachedPage page, Throwable failure) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFailed() {
        return this.bulkLoader.hasFailed() || this.buddyBTreeBulkLoader.hasFailed();
    }

    public Throwable getFailure() {
        if (this.bulkLoader.hasFailed()) {
            return this.bulkLoader.getFailure();
        }
        if (this.buddyBTreeBulkLoader.hasFailed()) {
            return this.buddyBTreeBulkLoader.getFailure();
        }
        return null;
    }

    @Override
    public void force() throws HyracksDataException {
        this.bulkLoader.force();
        this.buddyBTreeBulkLoader.force();
    }
}

