/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;

public class LSMRTreeFileManager
extends AbstractLSMIndexFileManager {
    private final TreeIndexFactory<? extends ITreeIndex> rtreeFactory;
    private final TreeIndexFactory<? extends ITreeIndex> btreeFactory;
    private static final FilenameFilter btreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith("b");
    private static final FilenameFilter rtreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith("r");

    public LSMRTreeFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> rtreeFactory, TreeIndexFactory<? extends ITreeIndex> btreeFactory) {
        super(ioManager, file, null);
        this.rtreeFactory = rtreeFactory;
        this.btreeFactory = btreeFactory;
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String baseName = this.getNextComponentSequence(btreeFilter);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_r"), this.baseDir.getChild(baseName + "_b"), this.baseDir.getChild(baseName + "_f"));
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) {
        String baseName = IndexComponentFileReference.getMergeSequence((String)firstFileName, (String)lastFileName);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_r"), this.baseDir.getChild(baseName + "_b"), this.baseDir.getChild(baseName + "_f"));
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allRTreeFiles = new ArrayList();
        ArrayList allBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        this.cleanupAndGetValidFilesInternal(btreeFilter, this.btreeFactory, allBTreeFiles, this.btreeFactory.getBufferCache());
        HashSet<String> btreeFilesSet = new HashSet<String>();
        for (IndexComponentFileReference cmpFileName : allBTreeFiles) {
            btreeFilesSet.add(cmpFileName.getSequence());
        }
        this.validateFiles(btreeFilesSet, allRTreeFiles, rtreeFilter, this.rtreeFactory, this.btreeFactory.getBufferCache());
        this.validateFiles(btreeFilesSet, allBloomFilterFiles, BLOOM_FILTER_FILTER, null, this.btreeFactory.getBufferCache());
        if (allRTreeFiles.size() != allBTreeFiles.size() || allBTreeFiles.size() != allBloomFilterFiles.size()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.UNEQUAL_NUM_FILTERS_TREES, (Serializable[])new Serializable[]{this.baseDir});
        }
        if (allRTreeFiles.isEmpty()) {
            return validFiles;
        }
        if (allRTreeFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(((IndexComponentFileReference)allRTreeFiles.get(0)).getFileRef(), ((IndexComponentFileReference)allBTreeFiles.get(0)).getFileRef(), ((IndexComponentFileReference)allBloomFilterFiles.get(0)).getFileRef()));
            return validFiles;
        }
        Collections.sort(allRTreeFiles);
        Collections.sort(allBTreeFiles);
        Collections.sort(allBloomFilterFiles);
        ArrayList<IndexComponentFileReference> validComparableRTreeFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastRTree = (IndexComponentFileReference)allRTreeFiles.get(0);
        validComparableRTreeFiles.add(lastRTree);
        ArrayList<IndexComponentFileReference> validComparableBTreeFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastBTree = (IndexComponentFileReference)allBTreeFiles.get(0);
        validComparableBTreeFiles.add(lastBTree);
        ArrayList<IndexComponentFileReference> validComparableBloomFilterFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(0);
        validComparableBloomFilterFiles.add(lastBloomFilter);
        for (int i = 1; i < allRTreeFiles.size(); ++i) {
            IndexComponentFileReference currentRTree = (IndexComponentFileReference)allRTreeFiles.get(i);
            IndexComponentFileReference currentBTree = (IndexComponentFileReference)allBTreeFiles.get(i);
            IndexComponentFileReference currentBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(i);
            if (currentRTree.isMoreRecentThan(lastRTree) && currentBTree.isMoreRecentThan(lastBTree) && currentBloomFilter.isMoreRecentThan(lastBloomFilter)) {
                validComparableRTreeFiles.add(currentRTree);
                validComparableBTreeFiles.add(currentBTree);
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastRTree = currentRTree;
                lastBTree = currentBTree;
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentRTree.isWithin(lastRTree) && currentBTree.isWithin(lastBTree) && currentBloomFilter.isWithin(lastBloomFilter)) {
                this.delete(this.treeFactory.getBufferCache(), currentRTree.getFileRef());
                this.delete(this.treeFactory.getBufferCache(), currentBTree.getFileRef());
                this.delete(this.treeFactory.getBufferCache(), currentBloomFilter.getFileRef());
                continue;
            }
            throw HyracksDataException.create((ErrorCode)ErrorCode.FOUND_OVERLAPPING_LSM_FILES, (Serializable[])new Serializable[]{this.baseDir});
        }
        validComparableRTreeFiles.sort(this.recencyCmp);
        validComparableBTreeFiles.sort(this.recencyCmp);
        validComparableBloomFilterFiles.sort(this.recencyCmp);
        Iterator rtreeFileIter = validComparableRTreeFiles.iterator();
        Iterator btreeFileIter = validComparableBTreeFiles.iterator();
        Iterator bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        while (rtreeFileIter.hasNext() && btreeFileIter.hasNext()) {
            IndexComponentFileReference cmpRTreeFileName = (IndexComponentFileReference)rtreeFileIter.next();
            IndexComponentFileReference cmpBTreeFileName = (IndexComponentFileReference)btreeFileIter.next();
            IndexComponentFileReference cmpBloomFilterFileName = (IndexComponentFileReference)bloomFilterFileIter.next();
            validFiles.add(new LSMComponentFileReferences(cmpRTreeFileName.getFileRef(), cmpBTreeFileName.getFileRef(), cmpBloomFilterFileName.getFileRef()));
        }
        return validFiles;
    }
}

