/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.util;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOpenableDataWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameDeserializer;
import org.apache.hyracks.dataflow.common.comm.io.SerializingDataWriter;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.IOpenableDataWriterOperator;

public final class DeserializedOperatorNodePushable
extends AbstractUnaryInputOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final IOpenableDataWriterOperator delegate;
    private final FrameDeserializer deserializer;

    public DeserializedOperatorNodePushable(IHyracksTaskContext ctx, IOpenableDataWriterOperator delegate, RecordDescriptor inRecordDesc) {
        this.ctx = ctx;
        this.delegate = delegate;
        this.deserializer = inRecordDesc == null ? null : new FrameDeserializer(inRecordDesc);
    }

    public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
        this.delegate.setDataWriter(index, (IOpenableDataWriter<Object[]>)new SerializingDataWriter(this.ctx, recordDesc, writer));
    }

    public void close() throws HyracksDataException {
        this.delegate.close();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.deserializer.reset(buffer);
        while (!this.deserializer.done()) {
            this.delegate.writeData(this.deserializer.deserializeRecord());
        }
    }

    public void open() throws HyracksDataException {
        this.delegate.open();
    }

    public void fail() throws HyracksDataException {
        this.delegate.fail();
    }

    @Override
    public String getDisplayName() {
        return "Deserialized(" + this.delegate + ")";
    }

    public void flush() throws HyracksDataException {
        this.delegate.flush();
    }
}

