/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import java.io.IOException;
import org.apache.asterix.column.bytes.encoder.ParquetPlainFixedLengthValuesWriter;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.writer.AbstractColumnValuesWriter;
import org.apache.asterix.column.values.writer.filters.AbstractColumnFilterWriter;
import org.apache.asterix.column.values.writer.filters.DoubleColumnFilterWriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.bytes.BytesInput;

public final class FloatColumnValuesWriter
extends AbstractColumnValuesWriter {
    private final ParquetPlainFixedLengthValuesWriter floatWriter;

    public FloatColumnValuesWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef, int columnIndex, int level, boolean collection, boolean filtered) {
        super(columnIndex, level, collection, filtered);
        this.floatWriter = new ParquetPlainFixedLengthValuesWriter(multiPageOpRef);
    }

    @Override
    protected void addValue(ATypeTag tag, IValueReference value) throws IOException {
        float normalizedDouble = this.getValue(tag, value.getByteArray(), value.getStartOffset());
        this.floatWriter.writeFloat(normalizedDouble);
        this.filterWriter.addDouble(normalizedDouble);
    }

    private float getValue(ATypeTag typeTag, byte[] byteArray, int offset) {
        switch (typeTag) {
            case TINYINT: {
                return byteArray[offset];
            }
            case SMALLINT: {
                return ShortPointable.getShort((byte[])byteArray, (int)offset);
            }
            case INTEGER: {
                return IntegerPointable.getInteger((byte[])byteArray, (int)offset);
            }
            case BIGINT: {
                return LongPointable.getLong((byte[])byteArray, (int)offset);
            }
            case FLOAT: {
                return FloatPointable.getFloat((byte[])byteArray, (int)offset);
            }
            case DOUBLE: {
                return (float)DoublePointable.getDouble((byte[])byteArray, (int)offset);
            }
        }
        throw new IllegalAccessError(typeTag + "is not of floating type");
    }

    @Override
    protected void resetValues() throws HyracksDataException {
        this.floatWriter.reset();
    }

    @Override
    protected BytesInput getBytes() throws IOException {
        return this.floatWriter.getBytes();
    }

    @Override
    protected int getValuesEstimatedSize() {
        return this.floatWriter.getEstimatedSize();
    }

    @Override
    protected int calculateEstimatedSize(int length) {
        return this.floatWriter.calculateEstimatedSize(length);
    }

    @Override
    protected int getValuesAllocatedSize() {
        return this.floatWriter.getAllocatedSize();
    }

    @Override
    protected void addValue(IColumnValuesReader reader) throws IOException {
        float value = reader.getFloat();
        this.floatWriter.writeFloat(value);
        this.filterWriter.addDouble(value);
    }

    @Override
    protected AbstractColumnFilterWriter createFilter() {
        return new DoubleColumnFilterWriter();
    }

    @Override
    protected void closeValues() {
        this.floatWriter.close();
    }

    @Override
    protected ATypeTag getTypeTag() {
        return ATypeTag.FLOAT;
    }
}

