/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.filter.embedder;

import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.asterix.external.input.filter.embedder.EmbeddedValueBuilder;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public class ExternalFilterValueEmbedder
implements IExternalFilterValueEmbedder {
    private final ARecordType allPaths;
    private final Map<IAType, BitSet> setValues;
    private final EmbeddedValueBuilder builder;
    private final Stack<ARecordType> parents;
    private final int numberOfValues;
    private int level;
    private int numberOfSetValues;
    private IAType currentType;
    private BitSet currentSetValues;

    public ExternalFilterValueEmbedder(ARecordType allPaths, List<ProjectionFiltrationTypeUtil.RenamedType> leafs, ExternalDataPrefix prefix) {
        this.allPaths = allPaths;
        this.setValues = new HashMap<IAType, BitSet>();
        this.builder = new EmbeddedValueBuilder(allPaths, prefix, this.setValues);
        this.parents = new Stack();
        this.numberOfValues = leafs.size();
        this.reset();
    }

    @Override
    public void reset() {
        this.currentType = this.allPaths;
        this.numberOfSetValues = 0;
        this.currentSetValues = this.setValues.get(this.allPaths);
        this.currentSetValues.clear();
        this.parents.clear();
        this.parents.push(this.allPaths);
        this.level = 0;
    }

    @Override
    public void setPath(String path) throws HyracksDataException {
        this.builder.build(path);
    }

    @Override
    public boolean shouldEmbed(String fieldName, ATypeTag typeTag) {
        return this.shouldEmbed(fieldName, typeTag, false);
    }

    @Override
    public IValueReference getEmbeddedValue() {
        IValueReference value = this.builder.getValue(this.currentType);
        if (this.currentType.getTypeTag() != ATypeTag.OBJECT) {
            ++this.numberOfSetValues;
            this.currentType = (IAType)this.parents.peek();
        } else if (this.currentType != this.allPaths) {
            this.currentType = (IAType)this.parents.pop();
        }
        return value;
    }

    public boolean isMissingEmbeddedValues() {
        int numberOfFields;
        if (this.currentType.getTypeTag() == ATypeTag.MISSING) {
            return false;
        }
        int unsetValue = this.currentSetValues.nextClearBit(0);
        return unsetValue <= (numberOfFields = ((ARecordType)this.currentType).getFieldTypes().length) - 1;
    }

    public boolean isMissing(String fieldName) {
        ARecordType parent = (ARecordType)this.currentType;
        return !this.currentSetValues.get(parent.getFieldIndex(fieldName)) && this.shouldEmbed(fieldName, ATypeTag.ANY, true);
    }

    public String[] getEmbeddedFieldNames() {
        return ((ARecordType)this.currentType).getFieldNames();
    }

    @Override
    public void enterObject() {
        ++this.level;
        if (this.level != this.parents.size() && this.currentType != BuiltinType.AMISSING) {
            this.parents.push((ARecordType)this.currentType);
            this.currentType = BuiltinType.AMISSING;
        }
    }

    @Override
    public void exitObject() {
        if (this.currentType != this.allPaths && this.level == this.parents.size()) {
            this.currentType = (IAType)this.parents.pop();
            this.currentSetValues = this.setValues.get(this.currentType);
        }
        --this.level;
    }

    private boolean shouldEmbed(String fieldName, ATypeTag typeTag, boolean includeObjects) {
        if (this.currentType.getTypeTag() == ATypeTag.MISSING || this.numberOfSetValues == this.numberOfValues) {
            return false;
        }
        ARecordType recordType = (ARecordType)this.currentType;
        int index = recordType.getFieldIndex(fieldName);
        if (index < 0 || this.currentSetValues.get(index)) {
            return false;
        }
        this.currentSetValues.set(index);
        IAType fieldType = recordType.getFieldTypes()[index];
        if (fieldType.getTypeTag() == ATypeTag.OBJECT) {
            ARecordType newParent = (ARecordType)fieldType;
            this.parents.push(recordType);
            this.currentType = fieldType;
            this.currentSetValues = this.setValues.get(newParent);
            this.currentSetValues.clear();
            return includeObjects || typeTag != ATypeTag.OBJECT;
        }
        this.currentType = fieldType;
        return true;
    }
}

