/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.BuiltinTypeMap;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class Datatype
implements IMetadataEntity<Datatype> {
    private static final long serialVersionUID = 3L;
    private final String databaseName;
    private final DataverseName dataverseName;
    private final String datatypeName;
    private final IAType datatype;
    private final boolean isAnonymous;

    public Datatype(String databaseName, DataverseName dataverseName, String datatypeName, IAType datatype, boolean isAnonymous) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.dataverseName = dataverseName;
        this.datatypeName = datatypeName;
        this.datatype = datatype;
        this.isAnonymous = isAnonymous;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getDatatypeName() {
        return this.datatypeName;
    }

    public IAType getDatatype() {
        return this.datatype;
    }

    public boolean getIsAnonymous() {
        return this.isAnonymous;
    }

    @Override
    public Datatype addToCache(MetadataCache cache) {
        return cache.addDatatypeIfNotExists(this);
    }

    @Override
    public Datatype dropFromCache(MetadataCache cache) {
        return cache.dropDatatype(this);
    }

    public static IAType getTypeFromTypeName(MetadataNode metadataNode, TxnId txnId, String database, DataverseName dataverseName, String typeName) throws AlgebricksException {
        Datatype dt;
        BuiltinType type = BuiltinTypeMap.getBuiltinType((String)typeName);
        if (type == null && (dt = metadataNode.getDatatype(txnId, database, dataverseName, typeName)) != null) {
            type = dt.getDatatype();
        }
        return type;
    }
}

