/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.PrintWriter;
import org.apache.asterix.translator.ExecutionPlans;

public class ExecutionPlansHtmlPrintUtil {
    private static final String LOGICAL_PLAN_LBL = "Logical plan";
    private static final String EXPRESSION_TREE_LBL = "Expression tree";
    private static final String REWRITTEN_EXPRESSION_TREE_LBL = "Rewritten expression tree";
    private static final String OPTIMIZED_LOGICAL_PLAN_LBL = "Optimized logical plan";
    private static final String JOB_LBL = "Job";

    private ExecutionPlansHtmlPrintUtil() {
    }

    public static void print(PrintWriter output, ExecutionPlans plans) {
        ExecutionPlansHtmlPrintUtil.printNonNull(output, EXPRESSION_TREE_LBL, plans.getExpressionTree());
        ExecutionPlansHtmlPrintUtil.printNonNull(output, REWRITTEN_EXPRESSION_TREE_LBL, plans.getRewrittenExpressionTree());
        ExecutionPlansHtmlPrintUtil.printNonNull(output, LOGICAL_PLAN_LBL, plans.getLogicalPlan());
        ExecutionPlansHtmlPrintUtil.printNonNull(output, OPTIMIZED_LOGICAL_PLAN_LBL, plans.getOptimizedLogicalPlan());
        ExecutionPlansHtmlPrintUtil.printNonNull(output, JOB_LBL, plans.getJob());
    }

    private static void printNonNull(PrintWriter output, String lbl, String value) {
        if (value != null) {
            ExecutionPlansHtmlPrintUtil.printFieldPrefix(output, lbl);
            output.print(value);
            ExecutionPlansHtmlPrintUtil.printFieldPostfix(output);
        }
    }

    private static void printFieldPrefix(PrintWriter output, String lbl) {
        output.println();
        output.println("<h4>" + lbl + ":</h4>");
        switch (lbl) {
            case "Logical plan": {
                output.println("<pre class=query-plan>");
                break;
            }
            case "Optimized logical plan": {
                output.println("<pre class=query-optimized-plan>");
                break;
            }
            default: {
                output.println("<pre>");
            }
        }
    }

    private static void printFieldPostfix(PrintWriter output) {
        output.println("</pre>");
    }
}

