/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.cloud.AbstractCloudIOManager;
import org.apache.asterix.cloud.CloudFileHandle;
import org.apache.asterix.cloud.clients.IParallelDownloader;
import org.apache.asterix.common.api.INamespacePathResolver;
import org.apache.asterix.common.config.CloudProperties;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class EagerCloudIOManager
extends AbstractCloudIOManager {
    private static final Logger LOGGER = LogManager.getLogger();

    public EagerCloudIOManager(IOManager ioManager, CloudProperties cloudProperties, INamespacePathResolver nsPathResolver) throws HyracksDataException {
        super(ioManager, cloudProperties, nsPathResolver);
    }

    @Override
    protected void downloadPartitions(boolean metadataNode, int metadataPartition) throws HyracksDataException {
        IParallelDownloader downloader = this.cloudClient.createParallelDownloader(this.bucket, this.localIoManager);
        LOGGER.info("Downloading all files located in {}", (Object)this.partitionPaths);
        downloader.downloadDirectories(this.partitionPaths);
        LOGGER.info("Finished downloading {}", (Object)this.partitionPaths);
    }

    @Override
    protected void onOpen(CloudFileHandle fileHandle, IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) {
    }

    public boolean exists(FileReference fileRef) throws HyracksDataException {
        return this.localIoManager.exists(fileRef);
    }

    public void delete(FileReference fileRef) throws HyracksDataException {
        if (!"storage".equals(IoUtil.getFileNameFromPath((String)fileRef.getAbsolutePath()))) {
            File localFile = fileRef.getFile();
            Set<String> paths = localFile.exists() && localFile.isFile() ? Collections.singleton(fileRef.getRelativePath()) : this.list(fileRef).stream().map(FileReference::getRelativePath).collect(Collectors.toSet());
            this.cloudClient.deleteObjects(this.bucket, paths);
        }
        this.localIoManager.delete(fileRef);
    }

    public void overwrite(FileReference fileRef, byte[] bytes) throws HyracksDataException {
        this.cloudClient.write(this.bucket, fileRef.getRelativePath(), bytes);
        this.localIoManager.overwrite(fileRef, bytes);
    }
}

