/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.asterix.cloud.IWriteBufferProvider;

public class WriteBufferProvider
implements IWriteBufferProvider {
    private final BlockingQueue<ByteBuffer> writeBuffers;

    public WriteBufferProvider(int ioParallelism) {
        this.writeBuffers = new ArrayBlockingQueue<ByteBuffer>(ioParallelism);
    }

    @Override
    public void recycle(ByteBuffer buffer) {
        this.writeBuffers.offer(buffer);
    }

    @Override
    public ByteBuffer getBuffer() {
        ByteBuffer writeBuffer = (ByteBuffer)this.writeBuffers.poll();
        if (writeBuffer == null) {
            return ByteBuffer.allocate(0x500000);
        }
        return writeBuffer;
    }
}

