/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.SupportingPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.message.WSSecBase;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AsymmetricBindingBuilder
extends BindingBuilder {
    private static Log log = LogFactory.getLog(AsymmetricBindingBuilder.class);
    private static Log tlog = LogFactory.getLog((String)"org.apache.rampart.TIME");
    private WSSecEncryptedKey encrKey;
    private String encryptedKeyId;
    private byte[] encryptedKeyValue;
    private List<byte[]> signatureValues = new ArrayList<byte[]>();
    private Element encrTokenElement;
    private Element sigDKTElement;
    private Element encrDKTElement;
    private List<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
    private Element signatureElement;
    private Element refList;

    public void build(RampartMessageData rmd) throws RampartException {
        log.debug((Object)"AsymmetricBindingBuilder build invoked");
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isIncludeTimestamp()) {
            this.addTimestamp(rmd);
        }
        if (RampartUtil.encryptFirst(rpd)) {
            this.doEncryptBeforeSig(rmd);
        } else {
            this.doSignBeforeEncrypt(rmd);
        }
        log.debug((Object)"AsymmetricBindingBuilder build invoked : DONE");
    }

    private void doEncryptBeforeSig(RampartMessageData rmd) throws RampartException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        RampartConfig config = rpd.getRampartConfig();
        Element encrDKTokenElem = null;
        WSSecEncrypt encr = null;
        this.refList = null;
        WSSecDKEncrypt dkEncr = null;
        SecretKey symmetricKey = null;
        Token encryptionToken = null;
        encryptionToken = rmd.isInitiator() ? rpd.getRecipientToken() : rpd.getInitiatorToken();
        List<WSEncryptionPart> encrParts = RampartUtil.getEncryptedParts(rmd);
        this.sigParts = RampartUtil.getSignedParts(rmd);
        if (encryptionToken == null && encrParts.size() > 0) {
            throw new RampartException("encryptionTokenMissing");
        }
        if (encryptionToken != null && encrParts.size() > 0) {
            if (rpd.getRampartConfig() == null) {
                throw new RampartException("rampartConigMissing");
            }
            if (encryptionToken.isDerivedKeys()) {
                try {
                    this.setupEncryptedKey(rmd, encryptionToken);
                    dkEncr = new WSSecDKEncrypt(doc);
                    dkEncr.setTokenIdentifier(this.encryptedKeyId);
                    dkEncr.setDerivedKeyLength(rpd.getAlgorithmSuite().getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare(this.encryptedKeyValue);
                    this.encrDKTElement = dkEncr.getdktElement();
                    encrDKTokenElem = RampartUtil.appendChildToSecHeader(rmd, this.encrDKTElement);
                    this.refList = dkEncr.encryptForExternalRef(null, encrParts);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorCreatingEncryptedKey", e);
                }
                catch (Exception e) {
                    throw new RampartException("errorInDKEncr", e);
                }
            }
            try {
                WSSecHeader secHeader = new WSSecHeader(doc);
                secHeader.insertSecurityHeader();
                encr = new WSSecEncrypt(secHeader);
                KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)rpd.getAlgorithmSuite().getEncryption());
                symmetricKey = keyGen.generateKey();
                RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
                encr.setSymmetricEncAlgorithm(rpd.getAlgorithmSuite().getEncryption());
                RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)encr, encryptionToken);
                encr.setKeyEncAlgo(rpd.getAlgorithmSuite().getAsymmetricKeyWrap());
                encr.prepare(RampartUtil.getEncryptionCrypto(config, rmd.getCustomClassLoader()), symmetricKey);
                Element bstElem = encr.getBinarySecurityTokenElement();
                if (bstElem != null) {
                    RampartUtil.appendChildToSecHeader(rmd, bstElem);
                }
                this.encrTokenElement = encr.getEncryptedKeyElement();
                this.encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, this.encrTokenElement);
                this.refList = encr.encryptForRef(null, encrParts, symmetricKey);
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
            this.refList = RampartUtil.appendChildToSecHeader(rmd, this.refList);
            if (tlog.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            this.setInsertionLocation(this.encrTokenElement);
            RampartUtil.handleEncryptedSignedHeaders(encrParts, this.sigParts, doc);
            HashMap<Token, Object> sigSuppTokMap = null;
            HashMap<Token, Object> endSuppTokMap = null;
            HashMap<Token, Object> sgndEndSuppTokMap = null;
            HashMap<Token, Object> sgndEncSuppTokMap = null;
            HashMap<Token, Object> endEncSuppTokMap = null;
            HashMap<Token, Object> sgndEndEncSuppTokMap = null;
            if (this.timestampElement != null) {
                this.sigParts.add(RampartUtil.createEncryptionPart("Timestamp", RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
            }
            if (rmd.isInitiator()) {
                SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
                sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
                SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
                endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
                SupportingToken supportingToken = rpd.getSignedEndorsingSupportingTokens();
                sgndEndSuppTokMap = this.handleSupportingTokens(rmd, supportingToken);
                SupportingToken sgndEncryptedSuppTokens = rpd.getSignedEncryptedSupportingTokens();
                sgndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEncryptedSuppTokens);
                SupportingToken endorsingEncryptedSuppTokens = rpd.getEndorsingEncryptedSupportingTokens();
                endEncSuppTokMap = this.handleSupportingTokens(rmd, endorsingEncryptedSuppTokens);
                SupportingToken sgndEndEncSuppTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
                sgndEndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEndEncSuppTokens);
                List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
                for (SupportingToken supportingTok : supportingToks) {
                    this.handleSupportingTokens(rmd, supportingTok);
                }
                SupportingToken encryptedSupportingToks = rpd.getEncryptedSupportingTokens();
                this.handleSupportingTokens(rmd, encryptedSupportingToks);
                this.sigParts = this.addSignatureParts(sigSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEncSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEndSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEndEncSuppTokMap, this.sigParts);
            } else {
                this.addSignatureConfirmation(rmd, this.sigParts);
            }
            if (this.sigParts.size() > 0 && rmd.isInitiator() && rpd.getInitiatorToken() != null || !rmd.isInitiator() && rpd.getRecipientToken() != null) {
                this.doSignature(rmd);
            }
            if (rmd.isInitiator()) {
                if (endSuppTokMap != null) {
                    endSuppTokMap.putAll(endEncSuppTokMap);
                }
                List<byte[]> endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
                for (byte[] byArray : endSigVals) {
                    this.signatureValues.add(byArray);
                }
                sgndEndSuppTokMap.putAll(sgndEndEncSuppTokMap);
                List<byte[]> sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
                for (byte[] sigEndSigVal : sigEndSigVals) {
                    this.signatureValues.add(sigEndSigVal);
                }
            }
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
                tlog.debug((Object)("Encryption took :" + (t1 - t0) + ", Signature tool :" + (t2 - t1)));
            }
            if (rpd.isSignatureProtection() && this.mainSigId != null) {
                long t3 = 0L;
                long l = 0L;
                if (tlog.isDebugEnabled()) {
                    t3 = System.currentTimeMillis();
                }
                ArrayList<WSEncryptionPart> secondEncrParts = new ArrayList<WSEncryptionPart>();
                secondEncrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
                if (rmd.isInitiator()) {
                    for (String anEncryptedTokensIdList : this.encryptedTokensIdList) {
                        secondEncrParts.add(new WSEncryptionPart(anEncryptedTokensIdList, "Element"));
                    }
                }
                Element secondRefList = null;
                if (encryptionToken.isDerivedKeys()) {
                    try {
                        secondRefList = dkEncr.encryptForExternalRef(null, secondEncrParts);
                        RampartUtil.insertSiblingAfter(rmd, encrDKTokenElem, secondRefList);
                    }
                    catch (WSSecurityException e) {
                        throw new RampartException("errorCreatingEncryptedKey", e);
                    }
                }
                try {
                    secondRefList = encr.encryptForRef(null, secondEncrParts, symmetricKey);
                    this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.encrTokenElement, secondRefList));
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInEncryption", e);
                }
                if (tlog.isDebugEnabled()) {
                    l = System.currentTimeMillis();
                    tlog.debug((Object)("Signature protection took :" + (l - t3)));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doSignBeforeEncrypt(RampartMessageData rmd) throws RampartException {
        void var18_25;
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        HashMap<Token, Object> sigSuppTokMap = null;
        HashMap<Token, Object> endSuppTokMap = null;
        HashMap<Token, Object> sgndEndSuppTokMap = null;
        HashMap<Token, Object> sgndEncSuppTokMap = null;
        HashMap<Token, Object> endEncSuppTokMap = null;
        HashMap<Token, Object> sgndEndEncSuppTokMap = null;
        this.sigParts = RampartUtil.getSignedParts(rmd);
        if (this.timestampElement != null) {
            this.sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
        } else {
            this.setInsertionLocation(null);
        }
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (rmd.isInitiator()) {
            SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
            sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
            SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
            endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
            SupportingToken supportingToken = rpd.getSignedEndorsingSupportingTokens();
            sgndEndSuppTokMap = this.handleSupportingTokens(rmd, supportingToken);
            SupportingToken supportingToken2 = rpd.getSignedEncryptedSupportingTokens();
            sgndEncSuppTokMap = this.handleSupportingTokens(rmd, supportingToken2);
            SupportingToken endorsingEncryptedSuppTokens = rpd.getEndorsingEncryptedSupportingTokens();
            endEncSuppTokMap = this.handleSupportingTokens(rmd, endorsingEncryptedSuppTokens);
            SupportingToken sgndEndEncSuppTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
            sgndEndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEndEncSuppTokens);
            List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
            for (SupportingToken supportingTok : supportingToks) {
                this.handleSupportingTokens(rmd, supportingTok);
            }
            SupportingToken encryptedSupportingToks = rpd.getEncryptedSupportingTokens();
            this.handleSupportingTokens(rmd, encryptedSupportingToks);
            this.sigParts = this.addSignatureParts(sigSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEncSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEndSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEndEncSuppTokMap, this.sigParts);
        } else {
            this.addSignatureConfirmation(rmd, this.sigParts);
        }
        if (this.sigParts.size() > 0 && (rmd.isInitiator() && rpd.getInitiatorToken() != null || !rmd.isInitiator() && rpd.getRecipientToken() != null)) {
            this.doSignature(rmd);
        }
        List<SupportingPolicyData> supportingToks = rpd.getSupportingPolicyData();
        for (SupportingPolicyData supportingPolicyData : supportingToks) {
            List<WSEncryptionPart> list;
            if (supportingPolicyData == null || (list = RampartUtil.getSupportingSignedParts(rmd, supportingPolicyData)).size() <= 0 || (!rmd.isInitiator() || rpd.getInitiatorToken() == null) && (rmd.isInitiator() || rpd.getRecipientToken() == null)) continue;
            this.doSupportingSignature(rmd, list, supportingPolicyData);
        }
        if (rmd.isInitiator()) {
            if (endSuppTokMap != null) {
                endSuppTokMap.putAll(endEncSuppTokMap);
            }
            List<byte[]> endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
            for (byte[] byArray : endSigVals) {
                this.signatureValues.add(byArray);
            }
            if (sgndEndSuppTokMap != null) {
                sgndEndSuppTokMap.putAll(sgndEndEncSuppTokMap);
            }
            List<byte[]> list = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
            for (byte[] sigEndSigVal : list) {
                this.signatureValues.add(sigEndSigVal);
            }
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        List<WSEncryptionPart> encrParts = RampartUtil.getEncryptedParts(rmd);
        if (rpd.isSignatureProtection() && this.mainSigId != null) {
            encrParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.signatureElement), "Element"));
        }
        if (rmd.isInitiator()) {
            for (String string : this.encryptedTokensIdList) {
                encrParts.add(new WSEncryptionPart(string, "Element"));
            }
        }
        if (rmd.isInitiator()) {
            Token token = rpd.getRecipientToken();
        } else {
            Token token = rpd.getInitiatorToken();
        }
        if (var18_25 != null && encrParts.size() > 0) {
            Object var19_35 = null;
            AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
            if (var18_25.isDerivedKeys()) {
                try {
                    WSSecDKEncrypt dkEncr = new WSSecDKEncrypt(rmd.getSecHeader());
                    if (this.encrKey == null) {
                        this.setupEncryptedKey(rmd, (Token)var18_25);
                    }
                    dkEncr.setTokenIdentifier(this.encryptedKeyId);
                    dkEncr.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    dkEncr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    dkEncr.setDerivedKeyLength(algorithmSuite.getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare(this.encryptedKeyValue);
                    this.encrDKTElement = this.encrTokenElement != null ? RampartUtil.insertSiblingAfter(rmd, this.encrTokenElement, dkEncr.getdktElement()) : RampartUtil.insertSiblingBefore(rmd, this.sigDKTElement, dkEncr.getdktElement());
                    Element element = dkEncr.encryptForExternalRef(null, encrParts);
                    RampartUtil.insertSiblingAfter(rmd, this.encrDKTElement, element);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInDKEncr", e);
                }
                catch (Exception e) {
                    throw new RampartException("errorInDKEncr", e);
                }
            }
            try {
                WSSecEncrypt encr = new WSSecEncrypt(doc);
                RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)encr, (Token)var18_25);
                RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
                encr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                encr.setKeyEncAlgo(algorithmSuite.getAsymmetricKeyWrap());
                KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)rpd.getAlgorithmSuite().getEncryption());
                SecretKey symmetricKey = keyGen.generateKey();
                encr.prepare(RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()), symmetricKey);
                if (this.timestampElement != null) {
                    this.setInsertionLocation(this.timestampElement);
                } else {
                    this.setInsertionLocation(null);
                }
                if (encr.getBSTTokenId() != null) {
                    this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encr.getBinarySecurityTokenElement()));
                }
                Element encryptedKeyElement = encr.getEncryptedKeyElement();
                Element element = encr.encryptForRef(null, encrParts, symmetricKey);
                encryptedKeyElement.appendChild(element);
                this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encryptedKeyElement));
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
        }
        List<SupportingPolicyData> list = rpd.getSupportingPolicyData();
        for (SupportingPolicyData policyData : list) {
            if (policyData == null) continue;
            Token supportingEncrToken = policyData.getEncryptionToken();
            List<WSEncryptionPart> supoortingEncrParts = RampartUtil.getSupportingEncryptedParts(rmd, policyData);
            if (supportingEncrToken == null || supoortingEncrParts.size() <= 0) continue;
            this.doEncryptionWithSupportingToken(rpd, rmd, supportingEncrToken, doc, supoortingEncrParts);
        }
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
            tlog.debug((Object)("Signature took :" + (t1 - t0) + ", Encryption took :" + (t2 - t1)));
        }
    }

    private void doSupportingSignature(RampartMessageData rmd, List<WSEncryptionPart> supportingSigParts, SupportingPolicyData supportingData) throws RampartException {
        Token supportingSigToken;
        long t0 = 0L;
        long t1 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (!((supportingSigToken = supportingData.getSignatureToken()) instanceof X509Token)) {
            return;
        }
        WSSecSignature supportingSig = this.getSignatureBuilder(rmd, supportingSigToken, ((X509Token)supportingSigToken).getUserCertAlias());
        Element bstElem = supportingSig.getBinarySecurityTokenElement();
        if (bstElem != null) {
            bstElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), bstElem);
            this.setInsertionLocation(bstElem);
        }
        if (rmd.getPolicyData().isTokenProtection() && supportingSig.getBSTTokenId() != null) {
            supportingSigParts.add(new WSEncryptionPart(supportingSig.getBSTTokenId()));
        }
        try {
            supportingSig.setDigestAlgo(rmd.getPolicyData().getAlgorithmSuite().getDigest());
            List referenceList = supportingSig.addReferencesToSign(supportingSigParts);
            supportingSig.computeSignature(referenceList, false, this.getInsertionLocation());
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
        this.signatureValues.add(supportingSig.getSignatureValue());
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
            tlog.debug((Object)("Signature took :" + (t1 - t0)));
        }
    }

    private void doSignature(RampartMessageData rmd) throws RampartException {
        Token sigToken;
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        long t0 = 0L;
        long t1 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if ((sigToken = rmd.isInitiator() ? rpd.getInitiatorToken() : rpd.getRecipientToken()).isDerivedKeys()) {
            if (this.encrKey == null) {
                this.setupEncryptedKey(rmd, sigToken);
            }
            WSSecDKSign dkSign = new WSSecDKSign(rmd.getSecHeader());
            dkSign.setTokenIdentifier(this.encryptedKeyId);
            dkSign.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
            dkSign.setDerivedKeyLength(rpd.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            try {
                dkSign.prepare(this.encryptedKeyValue);
                if (rpd.isTokenProtection()) {
                    this.sigParts.add(new WSEncryptionPart(this.encrKey.getId()));
                }
                List referenceList = dkSign.addReferencesToSign(this.sigParts);
                if (this.refList == null) {
                    this.sigDKTElement = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), dkSign.getdktElement());
                    this.setInsertionLocation(this.sigDKTElement);
                    dkSign.computeSignature(referenceList, false, this.getInsertionLocation());
                } else {
                    this.sigDKTElement = RampartUtil.insertSiblingBefore(rmd, this.refList, dkSign.getdktElement());
                    this.setInsertionLocation(this.sigDKTElement);
                    dkSign.computeSignature(referenceList, true, this.getInsertionLocation());
                }
                if (RampartUtil.encryptFirst(rpd)) {
                    this.setInsertionLocation(dkSign.getSignatureElement());
                } else {
                    this.setInsertionLocation(this.timestampElement);
                }
                this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)dkSign.getSignatureElement());
                this.signatureValues.add(dkSign.getSignatureValue());
                this.signatureElement = dkSign.getSignatureElement();
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
            catch (Exception e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        WSSecSignature sig = this.getSignatureBuilder(rmd, sigToken);
        Element bstElem = sig.getBinarySecurityTokenElement();
        if (bstElem != null) {
            bstElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), bstElem);
            this.setInsertionLocation(bstElem);
        }
        if (rmd.getPolicyData().isTokenProtection() && sig.getBSTTokenId() != null) {
            this.sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
        }
        try {
            sig.setDigestAlgo(rpd.getAlgorithmSuite().getDigest());
            List referenceList = sig.addReferencesToSign(this.sigParts);
            if (this.refList == null) {
                sig.computeSignature(referenceList, false, this.getInsertionLocation());
            } else {
                sig.computeSignature(referenceList, true, this.refList);
            }
            this.signatureElement = sig.getSignatureElement();
            this.setInsertionLocation(this.signatureElement);
            this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)this.signatureElement);
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
        this.signatureValues.add(sig.getSignatureValue());
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
            tlog.debug((Object)("Signature took :" + (t1 - t0)));
        }
    }

    private void doEncryptionWithSupportingToken(RampartPolicyData rpd, RampartMessageData rmd, Token encrToken, Document doc, List<WSEncryptionPart> encrParts) throws RampartException {
        Element refList = null;
        try {
            if (!(encrToken instanceof X509Token)) {
                return;
            }
            WSSecEncrypt encr = new WSSecEncrypt(doc);
            RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)encr, encrToken);
            RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr, ((X509Token)encrToken).getEncryptionUser());
            encr.setSymmetricEncAlgorithm(rpd.getAlgorithmSuite().getEncryption());
            encr.setKeyEncAlgo(rpd.getAlgorithmSuite().getAsymmetricKeyWrap());
            KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)rpd.getAlgorithmSuite().getEncryption());
            SecretKey symmetricKey = keyGen.generateKey();
            encr.prepare(RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()), symmetricKey);
            if (this.timestampElement != null) {
                this.setInsertionLocation(this.timestampElement);
            } else {
                this.setInsertionLocation(null);
            }
            if (encr.getBSTTokenId() != null) {
                this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encr.getBinarySecurityTokenElement()));
            }
            Element encryptedKeyElement = encr.getEncryptedKeyElement();
            refList = encr.encryptForRef(null, encrParts, symmetricKey);
            encryptedKeyElement.appendChild(refList);
            this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encryptedKeyElement));
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInEncryption", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupEncryptedKey(RampartMessageData rmd, Token token) throws RampartException {
        if (!rmd.isInitiator() && token.isDerivedKeys()) {
            if (this.encryptedKeyId != null && this.encryptedKeyValue != null) {
                return;
            }
            List resultsObj = (List)rmd.getMsgContext().getProperty("RECV_RESULTS");
            if (resultsObj == null) throw new RampartException("noSecurityResults");
            this.encryptedKeyId = RampartUtil.getRequestEncryptedKeyId(resultsObj);
            this.encryptedKeyValue = RampartUtil.getRequestEncryptedKeyValue(resultsObj);
            if (this.encryptedKeyId != null || this.encryptedKeyValue != null) return;
            this.createEncryptedKey(rmd, token);
            return;
        } else {
            this.createEncryptedKey(rmd, token);
        }
    }

    private void createEncryptedKey(RampartMessageData rmd, Token token) throws RampartException {
        KeyGenerator keyGen;
        try {
            keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
            return;
        }
        SecretKey symmetricKey = keyGen.generateKey();
        this.encrKey = this.getEncryptedKeyBuilder(rmd, token, symmetricKey);
        Element bstElem = this.encrKey.getBinarySecurityTokenElement();
        if (bstElem != null) {
            RampartUtil.appendChildToSecHeader(rmd, bstElem);
        }
        this.encrTokenElement = this.encrKey.getEncryptedKeyElement();
        this.encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, this.encrTokenElement);
        this.encryptedKeyValue = symmetricKey.getEncoded();
        this.encryptedKeyId = this.encrKey.getId();
        try {
            org.apache.rahas.Token tok = new org.apache.rahas.Token(this.encryptedKeyId, (OMElement)this.encrTokenElement, null, null);
            tok.setSecret(this.encryptedKeyValue);
            rmd.getTokenStorage().add(tok);
        }
        catch (TrustException e) {
            throw new RampartException("errorInAddingTokenIntoStore", e);
        }
    }
}

