// File generated by specialize. Do not edit.

// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package stats

import (
	"fmt"
	"reflect"
)

func findSumFn(t reflect.Type) interface{} {
	switch t.String() {
	case "int":
		return sumIntFn
	case "int8":
		return sumInt8Fn
	case "int16":
		return sumInt16Fn
	case "int32":
		return sumInt32Fn
	case "int64":
		return sumInt64Fn
	case "uint":
		return sumUintFn
	case "uint8":
		return sumUint8Fn
	case "uint16":
		return sumUint16Fn
	case "uint32":
		return sumUint32Fn
	case "uint64":
		return sumUint64Fn
	case "float32":
		return sumFloat32Fn
	case "float64":
		return sumFloat64Fn
	default:
		panic(fmt.Sprintf("Unexpected number type: %v", t))
	}
}

func sumIntFn(x, y int) int {
	return x + y
}

func sumInt8Fn(x, y int8) int8 {
	return x + y
}

func sumInt16Fn(x, y int16) int16 {
	return x + y
}

func sumInt32Fn(x, y int32) int32 {
	return x + y
}

func sumInt64Fn(x, y int64) int64 {
	return x + y
}

func sumUintFn(x, y uint) uint {
	return x + y
}

func sumUint8Fn(x, y uint8) uint8 {
	return x + y
}

func sumUint16Fn(x, y uint16) uint16 {
	return x + y
}

func sumUint32Fn(x, y uint32) uint32 {
	return x + y
}

func sumUint64Fn(x, y uint64) uint64 {
	return x + y
}

func sumFloat32Fn(x, y float32) float32 {
	return x + y
}

func sumFloat64Fn(x, y float64) float64 {
	return x + y
}
