/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.io.PrintStream;
import org.ops4j.pax.logging.FqcnIgnoringPaxLogger;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxMarker;
import org.osgi.framework.Bundle;

public class DefaultServiceLog
extends FqcnIgnoringPaxLogger {
    public static final String[] levels = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    public static final int TRACE = 0;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static final int NONE = 6;
    private static int threshold;
    private Bundle m_bundle;
    private String m_categoryName;
    private PaxContext m_context = new PaxContext();

    DefaultServiceLog(Bundle bundle, String categoryName) {
        this.m_bundle = bundle;
        this.m_categoryName = categoryName;
    }

    @Override
    public boolean isTraceEnabled() {
        return threshold <= 0;
    }

    @Override
    public boolean isDebugEnabled() {
        return threshold <= 1;
    }

    @Override
    public boolean isInfoEnabled() {
        return threshold <= 2;
    }

    @Override
    public boolean isWarnEnabled() {
        return threshold <= 3;
    }

    @Override
    public boolean isErrorEnabled() {
        return threshold <= 4;
    }

    @Override
    public boolean isFatalEnabled() {
        return threshold <= 5;
    }

    @Override
    public boolean isTraceEnabled(PaxMarker marker) {
        return threshold <= 0;
    }

    @Override
    public boolean isDebugEnabled(PaxMarker marker) {
        return threshold <= 1;
    }

    @Override
    public boolean isInfoEnabled(PaxMarker marker) {
        return threshold <= 2;
    }

    @Override
    public boolean isWarnEnabled(PaxMarker marker) {
        return threshold <= 3;
    }

    @Override
    public boolean isErrorEnabled(PaxMarker marker) {
        return threshold <= 4;
    }

    @Override
    public boolean isFatalEnabled(PaxMarker marker) {
        return threshold <= 5;
    }

    @Override
    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.output(levels[0], message, t);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.output(levels[1], message, t);
        }
    }

    @Override
    public void inform(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.output(levels[2], message, t);
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.output(levels[3], message, t);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.output(levels[4], message, t);
        }
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.output(levels[5], message, t);
        }
    }

    @Override
    public void trace(PaxMarker marker, String message, Throwable t) {
        this.trace(message, t);
    }

    @Override
    public void debug(PaxMarker marker, String message, Throwable t) {
        this.debug(message, t);
    }

    @Override
    public void inform(PaxMarker marker, String message, Throwable t) {
        this.inform(message, t);
    }

    @Override
    public void warn(PaxMarker marker, String message, Throwable t) {
        this.warn(message, t);
    }

    @Override
    public void error(PaxMarker marker, String message, Throwable t) {
        this.error(message, t);
    }

    @Override
    public void fatal(PaxMarker marker, String message, Throwable t) {
        this.fatal(message, t);
    }

    @Override
    public int getLogLevel() {
        return threshold;
    }

    public static int getStaticLogLevel() {
        return threshold;
    }

    public static void setLogLevel(String level) {
        threshold = DefaultServiceLog.convertLevel(level);
    }

    @Override
    public String getName() {
        return this.m_categoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void output(String levelName, String message, Throwable t) {
        DefaultServiceLog defaultServiceLog = this;
        synchronized (defaultServiceLog) {
            this.output(System.out, levelName, message, t);
        }
    }

    protected final void output(PrintStream out, String levelName, String message, Throwable t) {
        if (this.m_bundle != null) {
            out.print(this.m_bundle.getSymbolicName());
            out.print(" ");
        }
        out.print("[");
        out.print(this.m_categoryName);
        out.print("] ");
        out.print(levelName);
        out.print(" ");
        out.print(": ");
        out.println(message);
        if (t != null) {
            t.printStackTrace(out);
        }
    }

    private static int convertLevel(String levelName) {
        if ("TRACE".equalsIgnoreCase(levelName) || "FINER".equalsIgnoreCase(levelName)) {
            return 0;
        }
        if ("DEBUG".equalsIgnoreCase(levelName) || "FINE".equalsIgnoreCase(levelName)) {
            return 1;
        }
        if ("INFO".equalsIgnoreCase(levelName) || "CONFIG".equalsIgnoreCase(levelName) || "CONF".equalsIgnoreCase(levelName)) {
            return 2;
        }
        if ("WARN".equalsIgnoreCase(levelName) || "WARNING".equalsIgnoreCase(levelName)) {
            return 3;
        }
        if ("ERROR".equalsIgnoreCase(levelName) || "SEVERE".equalsIgnoreCase(levelName)) {
            return 4;
        }
        if ("FATAL".equalsIgnoreCase(levelName)) {
            return 5;
        }
        if ("NONE".equalsIgnoreCase(levelName) || "OFF".equalsIgnoreCase(levelName) || "DISABLED".equalsIgnoreCase(levelName)) {
            return 6;
        }
        return 1;
    }

    @Override
    public PaxContext getPaxContext() {
        return this.m_context;
    }
}

