/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Changeable;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.collections.QuorumCheck;

public interface AbstractGroup
extends Entity,
Group,
Changeable {
    public static final AttributeSensor<Collection<Entity>> GROUP_MEMBERS = Sensors.newSensor(new TypeToken<Collection<Entity>>(){}, "group.members", "Members of the group");
    @Deprecated
    public static final AttributeSensor<Entity> FIRST = Sensors.newSensor(Entity.class, "cluster.first.entity", "The first member of the cluster");
    @Deprecated
    public static final ConfigKey<Boolean> MEMBER_DELEGATE_CHILDREN = ConfigKeys.newBooleanConfigKey("group.members.delegate", "Deprecated: Add delegate child entities for members of the group", Boolean.FALSE);
    @Deprecated
    public static final ConfigKey<String> MEMBER_DELEGATE_NAME_FORMAT = ConfigKeys.newStringConfigKey("group.members.delegate.nameFormat", "Deprecated: Delegate members name format string (Use %s for the original entity display name)", "%s");
    public static final ConfigKey<QuorumCheck> UP_QUORUM_CHECK = ConfigKeys.newConfigKeyWithDefault(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.UP_QUORUM_CHECK, "Up check, applied by default to members, requiring at least one present and up", QuorumCheck.QuorumChecks.atLeastOne());
    public static final ConfigKey<QuorumCheck> RUNNING_QUORUM_CHECK = ConfigKeys.newConfigKeyWithDefault(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.RUNNING_QUORUM_CHECK, "Problems check from children actual states (lifecycle), applied by default to members and children, not checking upness, but requiring by default that none are on-fire", QuorumCheck.QuorumChecks.all());

    public void setMembers(Collection<Entity> var1);

    public void setMembers(Collection<Entity> var1, Predicate<Entity> var2);

    public static Entity getFirst(Group g) {
        Collection members = (Collection)g.sensors().get(GROUP_MEMBERS);
        if (!members.isEmpty()) {
            return (Entity)members.iterator().next();
        }
        return null;
    }
}

