/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.http;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.MaybeFunctions;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.math.NumberMath;

public class JsonFunctions {
    private JsonFunctions() {
    }

    @Deprecated
    private static Function<String, JsonElement> asJsonOld() {
        return new Function<String, JsonElement>(){

            public JsonElement apply(String input) {
                return new JsonParser().parse(input);
            }
        };
    }

    @Deprecated
    private static <T> Function<JsonElement, List<T>> forEachOld(final Function<JsonElement, T> func) {
        return new Function<JsonElement, List<T>>(){

            public List<T> apply(JsonElement input) {
                JsonArray array = (JsonArray)input;
                ArrayList result = Lists.newArrayList();
                for (int i = 0; i < array.size(); ++i) {
                    result.add(func.apply((Object)array.get(i)));
                }
                return result;
            }
        };
    }

    @Deprecated
    private static Function<JsonElement, JsonElement> walkOld(final Iterable<String> elements) {
        return new Function<JsonElement, JsonElement>(){

            public JsonElement apply(JsonElement input) {
                JsonElement curr = input;
                for (String element : elements) {
                    JsonObject jo = curr.getAsJsonObject();
                    if ((curr = jo.get(element)) != null) continue;
                    throw new NoSuchElementException("No element '" + element + " in JSON, when walking " + elements);
                }
                return curr;
            }
        };
    }

    @Deprecated
    private static Function<JsonElement, JsonElement> walkNOld(final Iterable<String> elements) {
        return new Function<JsonElement, JsonElement>(){

            public JsonElement apply(JsonElement input) {
                JsonElement curr = input;
                for (String element : elements) {
                    if (curr == null) {
                        return null;
                    }
                    JsonObject jo = curr.getAsJsonObject();
                    curr = jo.get(element);
                }
                return curr;
            }
        };
    }

    @Deprecated
    private static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkMOld(final Iterable<String> elements) {
        return new Function<Maybe<JsonElement>, Maybe<JsonElement>>(){

            public Maybe<JsonElement> apply(Maybe<JsonElement> input) {
                Maybe curr = input;
                for (String element : elements) {
                    if (curr.isAbsent()) {
                        return curr;
                    }
                    JsonObject jo = ((JsonElement)curr.get()).getAsJsonObject();
                    JsonElement currO = jo.get(element);
                    if (currO == null) {
                        return Maybe.absent((String)("No element '" + element + " in JSON, when walking " + elements));
                    }
                    curr = Maybe.of((Object)currO);
                }
                return curr;
            }
        };
    }

    @Deprecated
    private static <T> Function<JsonElement, T> getPathOld(final String path) {
        return new Function<JsonElement, T>(){

            public T apply(JsonElement input) {
                String jsonString = input.toString();
                Object rawElement = JsonPath.read((String)jsonString, (String)path, (Predicate[])new Predicate[0]);
                return rawElement;
            }
        };
    }

    @Deprecated
    private static <T> Function<JsonElement, T> castOld(final Class<T> expected) {
        return new Function<JsonElement, T>(){

            public T apply(JsonElement input) {
                return JsonFunctions.doCast(input, expected);
            }
        };
    }

    @Deprecated
    private static <T> Function<Maybe<JsonElement>, T> castMOld(final Class<T> expected, final T defaultValue) {
        return new Function<Maybe<JsonElement>, T>(){

            public T apply(Maybe<JsonElement> input) {
                if (input.isAbsent()) {
                    return defaultValue;
                }
                return JsonFunctions.cast(expected).apply(input.get());
            }
        };
    }

    public static Function<String, JsonElement> asJson() {
        return new AsJson();
    }

    public static <T> Function<JsonElement, List<T>> forEach(Function<JsonElement, T> func) {
        return new ForEach<T>(func);
    }

    public static Function<JsonElement, JsonElement> walk(String elementOrDotSeparatedElements) {
        return JsonFunctions.walk(Splitter.on((char)'.').split((CharSequence)elementOrDotSeparatedElements));
    }

    public static Function<JsonElement, JsonElement> walk(String ... elements) {
        return JsonFunctions.walk(Arrays.asList(elements));
    }

    public static Function<JsonElement, JsonElement> walk(Iterable<String> elements) {
        return new Walk(elements);
    }

    public static Function<JsonElement, JsonElement> walkN(@Nullable String elements) {
        return JsonFunctions.walkN(Splitter.on((char)'.').split((CharSequence)elements));
    }

    public static Function<JsonElement, JsonElement> walkN(String ... elements) {
        return JsonFunctions.walkN(Arrays.asList(elements));
    }

    public static Function<JsonElement, JsonElement> walkN(Iterable<String> elements) {
        return new WalkN(elements);
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(@Nullable String elements) {
        return JsonFunctions.walkM(Splitter.on((char)'.').split((CharSequence)elements));
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(String ... elements) {
        return JsonFunctions.walkM(Arrays.asList(elements));
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(Iterable<String> elements) {
        return new WalkM(elements);
    }

    public static <T> Function<JsonElement, T> getPath(String path) {
        return new GetPath(path);
    }

    public static <T> Function<JsonElement, T> cast(Class<T> expected) {
        return new Cast<T>(expected);
    }

    protected static <T> T doCast(JsonElement input, Class<T> expected) {
        return JsonFunctions.doCast(input, TypeToken.of(expected));
    }

    protected static <T> T doCast(JsonElement input, TypeToken<T> expectedType) {
        if (input == null) {
            return null;
        }
        if (input.isJsonNull()) {
            return null;
        }
        Class expected = expectedType.getRawType();
        Function handlePrimitive = fn -> {
            if (Object.class.equals((Object)expected) && input.isJsonPrimitive()) {
                return (Boolean)fn.apply((Object)((JsonPrimitive)input));
            }
            return false;
        };
        if (expected == Boolean.TYPE || expected == Boolean.class || ((Boolean)handlePrimitive.apply(JsonPrimitive::isBoolean)).booleanValue()) {
            return (T)Boolean.valueOf(input.getAsBoolean());
        }
        if (expected == Character.TYPE || expected == Character.class) {
            return (T)Character.valueOf(input.getAsCharacter());
        }
        if (expected == Byte.TYPE || expected == Byte.class) {
            return (T)Byte.valueOf(input.getAsByte());
        }
        if (expected == Short.TYPE || expected == Short.class) {
            return (T)Short.valueOf(input.getAsShort());
        }
        if (expected == Integer.TYPE || expected == Integer.class) {
            return (T)Integer.valueOf(input.getAsInt());
        }
        if (expected == Long.TYPE || expected == Long.class) {
            return (T)Long.valueOf(input.getAsLong());
        }
        if (expected == Float.TYPE || expected == Float.class) {
            return (T)Float.valueOf(input.getAsFloat());
        }
        if (expected == Double.TYPE || expected == Double.class) {
            return (T)Double.valueOf(input.getAsDouble());
        }
        if (expected == BigDecimal.class) {
            return (T)input.getAsBigDecimal();
        }
        if (expected == BigInteger.class) {
            return (T)input.getAsBigInteger();
        }
        if (Number.class.isAssignableFrom(expected) || ((Boolean)handlePrimitive.apply(JsonPrimitive::isNumber)).booleanValue()) {
            Number result = input.getAsNumber();
            Number r2 = new NumberMath(result, Number.class).asTypeForced(Number.class);
            if (r2 == null) {
                r2 = result;
            }
            return (T)r2;
        }
        if (expected == String.class || ((Boolean)handlePrimitive.apply(JsonPrimitive::isString)).booleanValue()) {
            return (T)input.getAsString();
        }
        if (JsonElement.class.isAssignableFrom(expected)) {
            return (T)input;
        }
        if (Iterable.class.isAssignableFrom(expected) || expected.isArray()) {
            TypeToken componentType;
            JsonArray array = input.getAsJsonArray();
            MutableList ml = MutableList.of();
            if (expectedType.getComponentType() != null) {
                componentType = expectedType.getComponentType();
            } else {
                TypeToken[] params = TypeTokens.getGenericParameterTypeTokens(expectedType);
                TypeToken typeToken = componentType = params != null && params.length == 1 ? params[0] : TypeToken.of(Object.class);
            }
            if (JsonElement.class.isAssignableFrom(componentType.getRawType())) {
                ml.addAll((Iterable)array);
            } else {
                array.forEach((T a) -> ml.add(JsonFunctions.doCast(a, componentType)));
            }
            if (expected.isAssignableFrom(MutableList.class)) {
                return (T)ml;
            }
            if (expected.isAssignableFrom(MutableSet.class)) {
                return (T)MutableSet.copyOf((Iterable)ml);
            }
            if (expected.isArray()) {
                return (T)ml.toArray((Object[])Array.newInstance(componentType.getRawType(), 0));
            }
        }
        if (Map.class.isAssignableFrom(expected)) {
            TypeToken value;
            JsonObject jo = input.getAsJsonObject();
            TypeToken[] params = TypeTokens.getGenericParameterTypeTokens(expectedType);
            if (params != null && params.length == 1) {
                value = params[0];
            } else if (params != null && params.length == 2) {
                value = params[1];
                TypeToken key = params[0];
                if (!TypeTokens.isAssignableFromRaw((TypeToken)key, String.class)) {
                    throw new IllegalArgumentException("Keys of type " + key + " not supported when deserializing JSON");
                }
            } else {
                value = TypeToken.of(Object.class);
            }
            MutableMap mm = MutableMap.of();
            jo.entrySet().forEach(arg_0 -> JsonFunctions.lambda$doCast$2((Map)mm, value, arg_0));
            if (expected.isAssignableFrom(MutableMap.class)) {
                return (T)mm;
            }
        }
        if (Object.class.equals((Object)expected)) {
            if (input.isJsonObject()) {
                return (T)JsonFunctions.doCast(input, Map.class);
            }
            if (input.isJsonArray()) {
                return (T)JsonFunctions.doCast(input, List.class);
            }
        }
        throw new IllegalArgumentException("Cannot cast json element to type " + expected);
    }

    public static <T> Function<Maybe<JsonElement>, T> castM(Class<T> expected) {
        return Functionals.chain((Function)MaybeFunctions.get(), JsonFunctions.cast(expected));
    }

    public static <T> Function<Maybe<JsonElement>, T> castM(Class<T> expected, T defaultValue) {
        return new CastM<T>(expected, defaultValue);
    }

    private static /* synthetic */ void lambda$doCast$2(Map mm, TypeToken value, Map.Entry jos) {
        mm.put(jos.getKey(), JsonFunctions.doCast((JsonElement)jos.getValue(), value));
    }

    protected static class CastM<T>
    implements Function<Maybe<JsonElement>, T> {
        private final Class<T> expected;
        private final T defaultValue;

        public CastM(Class<T> expected, T defaultValue) {
            this.expected = expected;
            this.defaultValue = defaultValue;
        }

        public T apply(Maybe<JsonElement> input) {
            if (input.isAbsent()) {
                return this.defaultValue;
            }
            return (T)JsonFunctions.cast(this.expected).apply(input.get());
        }
    }

    protected static class Cast<T>
    implements Function<JsonElement, T> {
        private final Class<T> expected;

        public Cast(Class<T> expected) {
            this.expected = expected;
        }

        public T apply(JsonElement input) {
            return JsonFunctions.doCast(input, this.expected);
        }
    }

    protected static class GetPath<T>
    implements Function<JsonElement, T> {
        private final String path;

        public GetPath(String path) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
        }

        public T apply(JsonElement input) {
            if (input == null) {
                return null;
            }
            String jsonString = input.toString();
            Object rawElement = JsonPath.read((String)jsonString, (String)this.path, (Predicate[])new Predicate[0]);
            return (T)rawElement;
        }
    }

    protected static class WalkM
    implements Function<Maybe<JsonElement>, Maybe<JsonElement>> {
        private final Iterable<String> elements;

        public WalkM(Iterable<String> elements) {
            this.elements = elements;
        }

        public Maybe<JsonElement> apply(Maybe<JsonElement> input) {
            Maybe curr = input;
            for (String element : this.elements) {
                if (curr.isAbsent()) {
                    return curr;
                }
                JsonObject jo = ((JsonElement)curr.get()).getAsJsonObject();
                JsonElement currO = jo.get(element);
                if (currO == null) {
                    return Maybe.absent((String)("No element '" + element + " in JSON, when walking " + this.elements));
                }
                curr = Maybe.of((Object)currO);
            }
            return curr;
        }
    }

    protected static class WalkN
    implements Function<JsonElement, JsonElement> {
        private final Iterable<String> elements;

        public WalkN(Iterable<String> elements) {
            this.elements = elements;
        }

        public JsonElement apply(JsonElement input) {
            JsonElement curr = input;
            for (String element : this.elements) {
                if (curr == null) {
                    return null;
                }
                JsonObject jo = curr.getAsJsonObject();
                curr = jo.get(element);
            }
            return curr;
        }
    }

    protected static class Walk
    implements Function<JsonElement, JsonElement> {
        private final Iterable<String> elements;

        public Walk(Iterable<String> elements) {
            this.elements = elements;
        }

        public JsonElement apply(JsonElement input) {
            JsonElement curr = input;
            for (String element : this.elements) {
                JsonObject jo = curr.getAsJsonObject();
                if ((curr = jo.get(element)) != null) continue;
                throw new NoSuchElementException("No element '" + element + " in JSON, when walking " + this.elements);
            }
            return curr;
        }
    }

    protected static class ForEach<T>
    implements Function<JsonElement, List<T>> {
        private final Function<JsonElement, T> func;

        public ForEach(Function<JsonElement, T> func) {
            this.func = func;
        }

        public List<T> apply(JsonElement input) {
            JsonArray array = (JsonArray)input;
            ArrayList result = Lists.newArrayList();
            for (int i = 0; i < array.size(); ++i) {
                result.add(this.func.apply((Object)array.get(i)));
            }
            return result;
        }
    }

    protected static class AsJson
    implements Function<String, JsonElement> {
        protected AsJson() {
        }

        public JsonElement apply(String input) {
            return input != null ? new JsonParser().parse(input) : null;
        }
    }
}

