/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.zookeeper;

import com.google.common.base.Supplier;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperEnsemble;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;
import org.apache.brooklyn.util.guava.Suppliers;

public class ZooKeeperEnsembleImpl
extends DynamicClusterImpl
implements ZooKeeperEnsemble {
    protected EntitySpec<?> getMemberSpec() {
        EntitySpec spec = (EntitySpec)this.getConfig(MEMBER_SPEC, EntitySpec.create(ZooKeeperNode.class));
        spec.configure(ZooKeeperNode.MY_ID, ((Supplier)this.config().get(ZooKeeperEnsemble.NODE_ID_SUPPLIER)).get());
        return spec;
    }

    @Override
    public String getClusterName() {
        return (String)this.getAttribute((AttributeSensor)CLUSTER_NAME);
    }

    protected void initEnrichers() {
        super.initEnrichers();
        EnricherSpec zks = ((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(ZooKeeperNode.ZOOKEEPER_ENDPOINT).publishing(ZOOKEEPER_SERVERS).fromMembers()).build();
        EnricherSpec zke = ((Enrichers.JoinerBuilder)((Enrichers.JoinerBuilder)((Enrichers.JoinerBuilder)Enrichers.builder().joining(ZOOKEEPER_SERVERS).publishing(ZOOKEEPER_ENDPOINTS)).quote(Boolean.valueOf(false))).separator(",")).build();
        this.enrichers().add(zks);
        this.enrichers().add(zke);
    }

    @Deprecated
    private static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        private final Object[] mutex = new Object[0];

        private MemberTrackingPolicy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void onEntityAdded(Entity member) {
            if (member.config().get(ZooKeeperNode.MY_ID) != null) return;
            Object[] objectArray = this.mutex;
            synchronized (this.mutex) {
                Supplier id = (Supplier)this.entity.config().get(ZooKeeperEnsemble.NODE_ID_SUPPLIER);
                if (id == null) {
                    id = Suppliers.incrementing();
                    this.entity.config().set(ZooKeeperEnsemble.NODE_ID_SUPPLIER, (Object)id);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                member.config().set(ZooKeeperNode.MY_ID, id.get());
                return;
            }
        }
    }
}

