/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.changeset;

import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.lifecycle.changeset.ChangeSet;
import org.apache.cayenne.lifecycle.changeset.GenericChangeSet;
import org.apache.cayenne.query.Query;

public class ChangeSetFilter
implements DataChannelFilter {
    private static final ThreadLocal<ChangeSet> PRE_COMMIT_CHANGE_SET = new ThreadLocal();

    public static ChangeSet preCommitChangeSet() {
        return PRE_COMMIT_CHANGE_SET.get();
    }

    public void init(DataChannel channel) {
    }

    public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
        return filterChain.onQuery(originatingContext, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
        try {
            PRE_COMMIT_CHANGE_SET.set(new GenericChangeSet(changes));
            GraphDiff graphDiff = filterChain.onSync(originatingContext, changes, syncType);
            return graphDiff;
        }
        finally {
            PRE_COMMIT_CHANGE_SET.set(null);
        }
    }
}

