/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import org.apache.cayenne.swing.BindingBase;

public class ItemEventBinding
extends BindingBase {
    protected AbstractButton boundItem;

    public ItemEventBinding(AbstractButton boundItem, String expression) {
        super(expression);
        this.boundItem = boundItem;
        boundItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ItemEventBinding.this.updateModel();
            }
        });
    }

    @Override
    public Component getView() {
        return this.boundItem;
    }

    @Override
    public void updateView() {
        Object value = this.getValue();
        boolean b = false;
        if (value != null) {
            if (value instanceof Boolean) {
                b = (Boolean)value;
            } else if (value instanceof Number) {
                b = ((Number)value).intValue() != 0;
            }
        }
        this.modelUpdateDisabled = true;
        try {
            this.boundItem.setSelected(b);
        }
        finally {
            this.modelUpdateDisabled = false;
        }
    }

    protected void updateModel() {
        this.setValue(this.boundItem.isSelected() ? Boolean.TRUE : Boolean.FALSE);
    }
}

