/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;

public abstract class BaseProperty
implements PropertyDescriptor {
    protected ClassDescriptor owner;
    protected Accessor accessor;
    final String name;

    public BaseProperty(ClassDescriptor owner, Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException("Null accessor");
        }
        this.accessor = accessor;
        this.owner = owner;
        this.name = accessor.getName();
    }

    @Override
    public Object readProperty(Object object) throws PropertyException {
        return this.readPropertyDirectly(object);
    }

    @Override
    public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyException {
        this.writePropertyDirectly(object, oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract boolean visit(PropertyVisitor var1);

    @Override
    public void injectValueHolder(Object object) throws PropertyException {
    }

    @Override
    public Object readPropertyDirectly(Object object) throws PropertyException {
        return this.accessor.getValue(object);
    }

    @Override
    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyException {
        this.accessor.setValue(object, newValue);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName()).append('@').append(System.identityHashCode(this)).append('[').append(this.name).append(']');
        return buffer.toString();
    }
}

